/* SCCS @(#)gel1d.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      gel1d.layout.c                                  */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   gel1d.layout.c                                      */
/*                                                                      */
/* DESCRIPTION  :   Gel1D Tool parameters                               */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "gel1d.layout.h"
#define MAX_ARGS 100

extern char *paneltabs[];

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for GEL1D_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_GEL1D_param_widget(morpho)
	Widget morpho;
{
	Widget GEL1D_param_widget;
	Widget first_label;
	Widget first_text;
	xs_struc_paramprepro *Paramprepro;
	char num[4];
	Arg args[MAX_ARGS];
	int i, j, n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating GEL1D_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,217); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,209); n++;

	GEL1D_param_widget = XmCreateForm(morpho,"GEL1D_param_widget",args,n);
	XtManageChild(GEL1D_param_widget);

	Paramprepro->parent = GEL1D_param_widget;

	/* Creating first_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[149],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;

	first_label = XmCreateLabel(GEL1D_param_widget,"first_label",args,n);
	XtManageChild(first_label);

	  /* Creating first_text Widget */ 

 	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,first_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,90); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	first_text = XmCreateText(GEL1D_param_widget,"first_text",args,n);
	XtManageChild(first_text);

	Paramprepro->alpha = first_text;

	return(Paramprepro);
}
