/* SCCS @(#)dissim.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          dissim.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   dissim.layout.c                                     */
/*                                                                      */
/* DESCRIPTION  :   Display_show image interface                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "dissim.layout.h"
#include "libwidgets/widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist; 
extern Widget gLabowidget;

/********************************************************
/   Creation Function for DISPLAY_show_image_widget 
/*******************************************************/

Widget
build_DISPLAY_show_image_widget(DISPLAY_show_image, numplans, type, message)
	Widget DISPLAY_show_image;
	int    numplans, type;
	char *message;
{
	Widget DISPLAY_show_image_widget;
	Widget DISPLAY_show_image_separator;
	Widget DISPLAY_show_image_command;
	Widget DISPLAY_show_image_CANCEL;
	Widget DISPLAY_show_image_OK;
	Widget DISPLAY_show_image_HELP;
	Widget DISPLAY_show_image_form1;
	Widget selectplaneinput;
	Arg args[MAX_ARGS];
	int n;

	/* Creating DISPLAY_show_image_widget Widget */ 

	n = 0;
	if (numplans == 1) {
	  XtSetArg(args[n],XmNheight,140); n++;
	  XtSetArg(args[n],XmNwidth,335); n++;  /*235*/
	}
	else {    
	  XtSetArg(args[n],XmNheight,255); n++;
	  XtSetArg(args[n],XmNwidth,355); n++;  /*255*/
	}
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,8); n++;
	XtSetArg(args[n],XmNy,5); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	DISPLAY_show_image_widget = 
	     XmCreateFormDialog(gLabowidget,"DISPLAY_show_image_widget",args,n);

	/* Creating DISPLAY_show_image_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	DISPLAY_show_image_command = 
		XmCreateForm(DISPLAY_show_image_widget,
			     "DISPLAY_show_image_command",args,n);
	XtManageChild(DISPLAY_show_image_command);

	/* Creating DISPLAY_show_image_CANCEL Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[398],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,68); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	DISPLAY_show_image_CANCEL = 
		XmCreatePushButton(DISPLAY_show_image_command,
				   "DISPLAY_show_image_CANCEL",args,n);
	XtManageChild(DISPLAY_show_image_CANCEL);

	/* Adding Callbacks for DISPLAY_show_image_CANCEL */ 

	XtAddCallback(DISPLAY_show_image_CANCEL,
		XmNactivateCallback,DISPLAY_show_image_CANCEL_callb, 
		      DISPLAY_show_image_widget);

	/* Creating DISPLAY_show_image_OK Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OK",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,32); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	DISPLAY_show_image_OK = 
	    XmCreatePushButton(DISPLAY_show_image_command,
			       "DISPLAY_show_image_OK",args,n);
	XtManageChild(DISPLAY_show_image_OK);

	/* Adding Callbacks for DISPLAY_show_image_OK */ 

	XtAddCallback(DISPLAY_show_image_OK,
		XmNactivateCallback,DISPLAY_show_image_OK_callb, type);

	/* Creating DISPLAY_show_image_HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,36); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	DISPLAY_show_image_HELP = 
		XmCreatePushButton(DISPLAY_show_image_command,
				   "DISPLAY_show_image_HELP",args,n);
	XtManageChild(DISPLAY_show_image_HELP);


	/* Creating DISPLAY_show_image_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, DISPLAY_show_image_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	DISPLAY_show_image_separator = 
		XmCreateSeparator(DISPLAY_show_image_widget,
				  "DISPLAY_show_image_separator",args,n);
	XtManageChild(DISPLAY_show_image_separator);


	/* Creating DISPLAY_show_image_form1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,DISPLAY_show_image_separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	DISPLAY_show_image_form1 = 
		XmCreateForm(DISPLAY_show_image_widget,
			     "DISPLAY_show_image_form1",args,n);
	XtManageChild(DISPLAY_show_image_form1);

	/* Creating selectplaneinput Widget */ 

	if (numplans == 1) 
	  if (type == 8)
	    selectplaneinput = 
	      build_SelectionPlane(DISPLAY_show_image_form1, 
				   DISPLAY_show_image_OK, 
				   paneltabs[105], 1);
	  else selectplaneinput = 
	    build_SelectionPlane(DISPLAY_show_image_form1, 
				 DISPLAY_show_image_OK, 
				 paneltabs[105], 0);
	else selectplaneinput = 
	  build_Selection3Planes(DISPLAY_show_image_form1, 
				 DISPLAY_show_image_OK,
				 paneltabs[74], paneltabs[75], paneltabs[76]);

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetValues(selectplaneinput, args, n);
	XtManageChild(selectplaneinput);

	return(DISPLAY_show_image_widget);
}
