/* SCCS @(#)voisin.c	1.1  12/2/92 */
/*****************************************************************************/
/* module voisin.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/* q : p_avant , r : p_col2 , s : p_apres */
/* A ou B ou C ou D mis a 1 + mise a jour des voisins */

A1_voisin(q,r)
short int *q,*r;
{
        *r = *r | 01;                /* A -> 1 */
        *(r-1) = *(r-1) | 0400;      /* bit 9 -> 1 */
        *q = *q | 02000;             /* bit 11 -> 1 */
        *(q-1) = *(q-1) | 020000;    /* bit 14 -> 1 */    
}

B1_voisin(q,r)
short int *q,*r;
{
      *r = *r | 02;                  /* B -> 1 */
      *(r+1) = *(r+1) | 0100;        /* bit 7 -> 1 */
      *q = *q | 04000;               /* bit 12 -> 1 */   
}

C1_voisin(r,s)
short int *r,*s;
{
     *r = *r | 04;                   /* c -> 1 */
     *(r-1) = *(r-1) | 010000;       /* bit 13 -> 1 */
     *s = *s | 020;                  /* bit 5 -> 1 */
}

D1_voisin(r,s)
short int *r,*s;
{
      *r = *r | 010;                 /* D -> 1 */
      *(r+1) = *(r+1) | 0200;        /* bit 8 -> 1 */
      *s = *s | 01000;               /* bit 10 -> 1 */
      *(s+1) = *(s+1) | 040;         /* bit 6 -> 1 */  
}

/*****************************************************************************/
/* q : p_avant , r : p_col2 , s : p_apres */
/* A ou B ou C ou D mis a 0 + mise a jour des voisins */

A_voisin(q,r)
short int *q,*r;
{
        *r = *r & ~01;                /* A -> 0 */
        *(r-1) = *(r-1) & ~0400;      /* bit 9 -> 0 */
        *q = *q & ~02000;             /* bit 11 -> 0 */
        *(q-1) = *(q-1) & ~020000;    /* bit 14 -> 0 */    
}

B_voisin(q,r)
short int *q,*r;
{
      *r = *r & ~02;                  /* B -> 0 */
      *(r+1) = *(r+1) & ~0100;        /* bit 7 -> 0 */
      *q = *q & ~04000;               /* bit 12 -> 0 */   
}

C_voisin(r,s)
short int *r,*s;
{
     *r = *r & ~04;                   /* c -> 0 */
     *(r-1) = *(r-1) & ~010000;       /* bit 13 -> 0 */
     *s = *s & ~020;                  /* bit 5 -> 0 */
}

D_voisin(r,s)
short int *r,*s;
{
      *r = *r & ~010;                 /* D -> 0 */
      *(r+1) = *(r+1) & ~0200;        /* bit 8 -> 0 */
      *s = *s & ~01000;               /* bit 10 -> 0 */
      *(s+1) = *(s+1) & ~040;         /* bit 6 -> 0 */  
}
