/* SCCS @(#)IOplans.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            IOplans.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   IOplans.layout.c                                    */
/*                                                                      */
/* DESCRIPTION  :   Interface for IO operations                         */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "libwidgets/widgetstructure.h"
#include "IOplans.layout.h"

#define MAX_ARGS 100

#define AUX_CONV_BIN -1
#define AUX_CONV_BYTE 0
#define AUX_CONV_SHORT 1
#define AUX_CONV_INT 2
#define AUX_CONV_FLOAT 3
#define AUX_CONV_COMPL 4
#define AUX_CONV_CART_POL 5
#define AUX_CONV_POL_CART 6
#define AUX_CONV_RGB_GRAY 7


#define AUX_ARITH_TWO_PLUS 10
#define AUX_ARITH_TWO_MIN 11
#define AUX_ARITH_TWO_MULT 12
#define AUX_ARITH_TWO_DIV 13

#define AUX_ARITH_ONEP_CONST_PLUS 14
#define AUX_ARITH_ONEP_CONST_MIN 15
#define AUX_ARITH_ONEP_CONST_MULT 16
#define AUX_ARITH_ONEP_CONST_DIV 17

#define AUX_ARITH_TWOP_CONST 20
#define AUX_ARITH_FOURP 21

#define AUX_LOGIC_AND 30
#define AUX_LOGIC_ANDMASK 31
#define AUX_LOGIC_OR 32
#define AUX_LOGIC_XOR 33
#define AUX_LOGIC_NOT 34

#define AUX_GEOM_ROT 40
#define AUX_GEOM_TRAN 41
#define AUX_GEOM_SCALS 42
#define AUX_GEOM_SCALF 43
#define AUX_GEOM_TRANP 44
#define AUX_GEOM_SYMX 45
#define AUX_GEOM_SYMY 46

#define AUX_MOD_ENL1 50
#define AUX_MOD_PADDCONS 51
#define AUX_MOD_PADDPRO 52
#define AUX_MOD_PADDPER 53
#define AUX_MOD_NOIUNI 54
#define AUX_MOD_NOIGAU 55
#define AUX_MOD_CUT 56

#define AUX_GEN_BAND8 60
#define AUX_GEN_BAND16 61
#define AUX_GEN_BAND32 62
#define AUX_GEN_BAND64 63

#define AUX_COPY 70
#define THRESH_SAVE 80
#define PIXELEDIT_SAVE 81
#define MAPEDIT_DISPLAY_SAVE 82
#define IMAGE_GENERATION_SAVE 83


extern XmFontList gFontlist; 
extern Widget gLabowidget;

/********************************************************
/   Creation Function for IOplans_widget 
/*******************************************************/

Widget
build_IOplans_widget(IOplans_options, option, message, data_display)
	Widget IOplans_options;
	int option;
	char *message;
	xs_struc_display_menu * data_display;
{
	Widget IOplans_widget;
	Widget IOplans_separator;
	Widget IOplans_command;
	Widget options_CANCEL;
	Widget options_OK;
	Widget options_HELP;
	Widget options_separator;
	Widget IOplans_form1;
	Widget selectplaneinput;
	Widget selectplaneinputb;
	Widget selectplaneoutput;
	xs_struc_paramprepro * AUX_param;
	xs_struc_paramsconversion *ParamsConversion;
	Arg args[MAX_ARGS];
	int n;

	/* Creating IOplans_widget Widget */ 

	n = 0;
        switch (option)
	{
	  case AUX_ARITH_ONEP_CONST_PLUS:
	  case AUX_ARITH_ONEP_CONST_MIN:
	  case AUX_ARITH_ONEP_CONST_MULT:
 	  case AUX_ARITH_ONEP_CONST_DIV:
 	  case AUX_GEOM_ROT:
 	  case AUX_GEOM_TRAN:
 	  case AUX_GEOM_SCALS:
 	  case AUX_GEOM_SCALF:
	  case AUX_MOD_PADDCONS:
	  case AUX_MOD_PADDPRO:
	  case AUX_MOD_PADDPER:
 	  case AUX_MOD_ENL1:
 	  case AUX_MOD_NOIUNI:
      	  case AUX_MOD_NOIGAU:
 	  case AUX_MOD_CUT:
	  case AUX_CONV_BIN:
	  case AUX_CONV_BYTE:
	  case AUX_CONV_SHORT:
	  case AUX_CONV_INT:
          case AUX_CONV_FLOAT:
	     XtSetArg(args[n],XmNwidth,560); n++;
	     break;
          case AUX_CONV_COMPL:
 	  case AUX_ARITH_TWOP_CONST:
	     XtSetArg(args[n],XmNwidth,580); n++;
	     break;
	  default:
	     XtSetArg(args[n],XmNwidth,350); n++;
	     break;
	}

	switch (option)
	{
	  case AUX_CONV_RGB_GRAY:
	    XtSetArg(args[n],XmNheight,400); n++;
	    break;
 	  case AUX_CONV_BIN:
 	  case AUX_CONV_BYTE:
 	  case AUX_CONV_SHORT:
 	  case AUX_CONV_INT:
 	  case AUX_CONV_FLOAT:
 	  case MAPEDIT_DISPLAY_SAVE:
	    XtSetArg(args[n],XmNheight,280); n++;
	    break;
 	  case AUX_CONV_COMPL:
 	  case AUX_ARITH_TWOP_CONST:
	    XtSetArg(args[n],XmNheight,380); n++;
	    break;
 	  case THRESH_SAVE:
 	  case PIXELEDIT_SAVE:
 	  case AUX_GEN_BAND8:
 	  case AUX_GEN_BAND16:
 	  case AUX_GEN_BAND32:
 	  case AUX_GEN_BAND64:
 	  case IMAGE_GENERATION_SAVE:
	    XtSetArg(args[n],XmNheight,150); n++;
	    break;
 	  case AUX_ARITH_FOURP:
	    XtSetArg(args[n],XmNheight,595); n++;
	    break;
	  default:
            XtSetArg(args[n],XmNheight,360); n++;
	     break;
	}
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,69); n++;
	XtSetArg(args[n],XmNy,124); n++;
	XtSetArg(args[n],XmNdialogTitle, 
	    XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	IOplans_widget =
		XmCreateFormDialog(gLabowidget,"IOplans_widget",args,n);

	/* Creating IOplans_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	IOplans_command = 
		XmCreateForm(IOplans_widget,"IOplans_command",args,n);
	XtManageChild(IOplans_command);

	/* Creating options_CANCEL Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[398],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,68); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	options_CANCEL = 
	    XmCreatePushButton(IOplans_command,"options_CANCEL",args,n);
	XtManageChild(options_CANCEL);

	/* Adding Callbacks for options_CANCEL */ 

	XtAddCallback(options_CANCEL,
		XmNactivateCallback,IOplans_CANCEL_callb,IOplans_widget);

	/* Creating options_OK Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OK",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,32); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	options_OK = 
	  XmCreatePushButton(IOplans_command,"options_OK",args,n);
	XtManageChild(options_OK);


	/* Creating options_HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,36); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	options_HELP = 
	  XmCreatePushButton(IOplans_command,"options_HELP",args,n);
	XtManageChild(options_HELP);


	/* Creating IOplans_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, IOplans_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	IOplans_separator = 
	   XmCreateSeparator(IOplans_widget,"IOplans_separator",args,n);

	XtManageChild(IOplans_separator);

	if  (((option >= AUX_ARITH_ONEP_CONST_PLUS) && 
	      (option <= AUX_ARITH_ONEP_CONST_DIV)) || 
	     (option == AUX_ARITH_TWOP_CONST)||
	     ((option >= AUX_GEOM_ROT) && (option <= AUX_GEOM_SCALF)) ||
	     (option == AUX_MOD_ENL1)  || (option == AUX_MOD_NOIUNI) ||
	     (option == AUX_MOD_NOIGAU) || (option == AUX_MOD_CUT) ||
	     (option == AUX_MOD_PADDCONS) || (option == AUX_MOD_PADDPRO) ||
	     (option == AUX_MOD_PADDPER) || (option == AUX_CONV_BIN) ||
	     (option == AUX_CONV_BYTE) || (option == AUX_CONV_SHORT) ||
	     (option == AUX_CONV_INT) || (option == AUX_CONV_FLOAT) || 
	     (option == AUX_CONV_COMPL))
	{
 
	  /* Creating options_separator Widget */ 

	   n = 0;
           XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	   XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	   XtSetArg(args[n],XmNbottomWidget,IOplans_separator); n++;
           XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	   XtSetArg(args[n],XmNleftPosition,54); n++;
           XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	   options_separator =  
		XmCreateSeparator(IOplans_widget,"options_separator",args,n);
	  XtManageChild(options_separator);
	 }


	/* Creating IOplans_form1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,IOplans_separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	IOplans_form1 = 
	XmCreateForm(IOplans_widget,"IOplans_form1",args,n);
	XtManageChild(IOplans_form1);

switch (option) {

  case AUX_CONV_BIN:
  case AUX_CONV_BYTE:
  case AUX_CONV_SHORT:
  case AUX_CONV_INT:
  case AUX_CONV_FLOAT:
  case AUX_CONV_COMPL:

  /* Creating ParamsConversion Widget */ 

  ParamsConversion = build_convert_widget(IOplans_form1, option);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(ParamsConversion->parent, args, n);
  XtManageChild(ParamsConversion->parent);

  ParamsConversion->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = build_SelectionPlane(IOplans_form1, options_OK, 
					  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  if (option == AUX_CONV_COMPL)
    selectplaneoutput = 
      build_Selection2Planesout(IOplans_form1, options_OK, 
				paneltabs[77], paneltabs[78]);
  else
    selectplaneoutput =
      build_SelectionPlaneout(IOplans_form1, options_OK, 
			      paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;


  case AUX_CONV_CART_POL:
  case AUX_CONV_POL_CART:

  /* Creating selectplaneinput Widget */ 

  if (option == AUX_CONV_CART_POL)
    selectplaneinput = 
       build_Selection2Planes(IOplans_form1, options_OK, paneltabs[77], 
			      paneltabs[78], 0);
  else
    selectplaneinput = 
       build_Selection2Planes(IOplans_form1, options_OK, paneltabs[79], 
			      paneltabs[80], 0);
  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  if (option == AUX_CONV_CART_POL)
    selectplaneoutput = 
      build_Selection2Planesout(IOplans_form1, options_OK, paneltabs[79], 
			       paneltabs[80]);
  else
    selectplaneoutput = 
      build_Selection2Planesout(IOplans_form1, options_OK, paneltabs[77], 
			       paneltabs[78]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case AUX_CONV_RGB_GRAY: 

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
     build_Selection3Planes(IOplans_form1, options_OK, paneltabs[74], 
			    paneltabs[75], paneltabs[76]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,65); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,66); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;


  case AUX_LOGIC_NOT:
  case AUX_GEOM_TRANP:
  case AUX_GEOM_SYMX:
  case AUX_GEOM_SYMY:
  case AUX_COPY:

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = build_SelectionPlane(IOplans_form1, options_OK, 
					  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = build_SelectionPlaneout(IOplans_form1, options_OK, 
					      paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case AUX_GEN_BAND8:
  case AUX_GEN_BAND16:
  case AUX_GEN_BAND32:
  case AUX_GEN_BAND64:

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = build_SelectionPlaneout(IOplans_form1, options_OK, 
					      paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case AUX_MOD_PADDCONS:
  case AUX_MOD_PADDPRO:
  case AUX_MOD_PADDPER:

  /* Creating AUX_param Widget */ 

  AUX_param = build_AUX_mod_paddcons_param(IOplans_form1, option-50);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = build_SelectionPlane(IOplans_form1, options_OK, 
					  paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = build_SelectionPlaneout(IOplans_form1, options_OK, 
					      paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case AUX_ARITH_TWO_PLUS: case AUX_ARITH_TWO_MIN:
  case AUX_ARITH_TWO_MULT: case AUX_ARITH_TWO_DIV:
  case AUX_LOGIC_AND: case AUX_LOGIC_ANDMASK:
  case AUX_LOGIC_OR: case AUX_LOGIC_XOR:

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
     build_Selection2Planes(IOplans_form1, options_OK, paneltabs[69], 
			    paneltabs[70], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case AUX_ARITH_ONEP_CONST_PLUS:
  case AUX_ARITH_ONEP_CONST_MIN:
  case AUX_ARITH_ONEP_CONST_MULT:
  case AUX_ARITH_ONEP_CONST_DIV:

  /* Creating AUX_param Widget */ 

  AUX_param = build_AUX_aop12pc_param_widget(IOplans_form1, 1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(IOplans_form1, options_OK, paneltabs[105], 0);


  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case AUX_ARITH_TWOP_CONST:

  /* Creating AUX_param Widget */ 

  AUX_param = build_AUX_aop12pc_param_widget(IOplans_form1, 2);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput =
  build_Selection2Planes(IOplans_form1, options_OK, paneltabs[77], 
			 paneltabs[78], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
     build_Selection2Planesout(IOplans_form1, options_OK, paneltabs[77], 
			       paneltabs[78]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case AUX_ARITH_FOURP:

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
    build_Selection2Planes(IOplans_form1, options_OK, paneltabs[81], 
			   paneltabs[82], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,32); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneinputb Widget */ 

  selectplaneinputb = 
      build_Selection2Planes(IOplans_form1, options_OK, paneltabs[83], 
			     paneltabs[84], 2);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition, 33); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,66); n++;
  XtSetValues(selectplaneinputb, args, n);
  XtManageChild(selectplaneinputb);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
      build_Selection2Planesout(IOplans_form1, options_OK, paneltabs[77], 
				paneltabs[78]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,67); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);

  break;

  case AUX_GEOM_ROT:

  /* Creating AUX_param Widget */ 

  AUX_param = build_AUX_geom_rot(IOplans_form1);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(IOplans_form1, options_OK, paneltabs[105], 0);


  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case AUX_GEOM_TRAN:
  case AUX_GEOM_SCALS:
  case AUX_GEOM_SCALF:

  /* Creating AUX_param Widget */ 

  AUX_param = build_AUX_geom_trans(IOplans_form1, option);

   n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 54); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(IOplans_form1, options_OK, paneltabs[105], 0);


  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;


  case AUX_MOD_ENL1: 
  case AUX_MOD_NOIUNI: 
  case AUX_MOD_NOIGAU: 
  case AUX_MOD_CUT:

  /* Creating AUX_param Widget */ 

  if (option == AUX_MOD_ENL1)
	AUX_param = build_AUX_modif_enlarg1(IOplans_form1);
  else if (option == AUX_MOD_NOIUNI)
	AUX_param = build_AUX_mod_noise_param(IOplans_form1, 0);
  else if (option == AUX_MOD_NOIGAU)
	AUX_param = build_AUX_mod_noise_param(IOplans_form1, 1);
  else  AUX_param = build_AUX_mod_cut_param(IOplans_form1);
  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNleftPosition, 55); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(AUX_param->parent, args, n);
  XtManageChild(AUX_param->parent);

  AUX_param->GenerParamparent = IOplans_widget;

  /* Creating selectplaneinput Widget */ 

  selectplaneinput = 
  build_SelectionPlane(IOplans_form1, options_OK, paneltabs[105], 0);


  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNbottomPosition,50); n++;
  XtSetValues(selectplaneinput, args, n);
  XtManageChild(selectplaneinput);

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNrightPosition, 53); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
  XtSetArg(args[n],XmNtopPosition,51); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case THRESH_SAVE:
  case PIXELEDIT_SAVE:
  case IMAGE_GENERATION_SAVE:

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_SelectionPlaneout(IOplans_form1, options_OK, paneltabs[105], 0);


  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  case MAPEDIT_DISPLAY_SAVE:

  /* Creating selectplaneoutput Widget */ 

  selectplaneoutput = 
  build_Selection3Planesout(IOplans_form1, options_OK, paneltabs[74], 
			    paneltabs[75], paneltabs[76]);

  n = 0;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
  XtSetValues(selectplaneoutput, args, n);
  XtManageChild(selectplaneoutput);
  break;

  default: break;
}

	/* Adding Callbacks for options_OK */ 

switch (option) {

  case AUX_CONV_BIN: 	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_bin_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_BYTE: 	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_byte_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_SHORT: 	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_short_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_INT: 	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_int_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_FLOAT:	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_float_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_COMPL:	XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_compl_OK_callb,ParamsConversion);
			break;
  case AUX_CONV_CART_POL: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_cart_pol_OK_callb,IOplans_widget);
			break;
  case AUX_CONV_POL_CART: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_pol_cart_OK_callb,IOplans_widget);
			break;
  case AUX_CONV_RGB_GRAY: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_conv_rgb_OK_callb,IOplans_widget);
			break;
  case AUX_ARITH_TWO_PLUS: 
     AUX_param = (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
     AUX_param->type_operation = 20;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_TWO_MIN: 
     AUX_param = (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
     AUX_param->type_operation = 21;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_TWO_MULT: 
     AUX_param = (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
     AUX_param->type_operation = 22;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_TWO_DIV: 
     AUX_param = (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
     AUX_param->type_operation = 23;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_ONEP_CONST_PLUS: 
     AUX_param->type_operation = 10;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb,AUX_param);
			break;
  case AUX_ARITH_ONEP_CONST_MIN: 
     AUX_param->type_operation = 11;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb,AUX_param);
			break;
  case AUX_ARITH_ONEP_CONST_MULT: 
     AUX_param->type_operation = 12;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb,AUX_param);
			break;
  case AUX_ARITH_ONEP_CONST_DIV: 
     AUX_param->type_operation = 13;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_TWOP_CONST: 
     AUX_param->type_operation = 41;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_ARITH_FOURP: 
     AUX_param = (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));
     AUX_param->type_operation = 40;
     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_arithm_OK_callb, AUX_param);
			break;
  case AUX_LOGIC_AND: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_logic_and_OK_callb,IOplans_widget);
			break;
  case AUX_LOGIC_ANDMASK: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_logic_andmask_OK_callb,IOplans_widget);
			break;
  case AUX_LOGIC_OR: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_logic_or_OK_callb,IOplans_widget);
			break;
  case AUX_LOGIC_XOR: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_logic_xor_OK_callb,IOplans_widget);
			break;
  case AUX_LOGIC_NOT: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_logic_not_OK_callb,IOplans_widget);
			break;
  case AUX_GEOM_ROT: AUX_param->type_operation = 0;
                     XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_OK_callb,AUX_param);
			break;
  case AUX_GEOM_TRAN: AUX_param->type_operation = 1;
                      XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_OK_callb,AUX_param);
			break;
  case AUX_GEOM_SCALS: AUX_param->type_operation = 2;
                       XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_OK_callb,AUX_param);
			break;
  case AUX_GEOM_SCALF: AUX_param->type_operation = 3;
                       XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_OK_callb,AUX_param);
			break;
  case AUX_GEOM_TRANP: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_tranp_OK_callb,IOplans_widget);
			break;
  case AUX_GEOM_SYMX: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_symx_OK_callb,IOplans_widget);
			break;
  case AUX_GEOM_SYMY: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_geom_symy_OK_callb,IOplans_widget);
			break;
  case AUX_MOD_ENL1: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_enl1_OK_callb,AUX_param);
			break;
  case AUX_MOD_PADDCONS: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_paddcons_OK_callb, AUX_param);
			break;
  case AUX_MOD_PADDPRO: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_paddpro_OK_callb, AUX_param);
			break;
  case AUX_MOD_PADDPER: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_paddper_OK_callb, AUX_param);
			break;
  case AUX_MOD_NOIUNI: AUX_param->type_operation = 0;
                       XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_noi_OK_callb,AUX_param);
			break;
  case AUX_MOD_NOIGAU: AUX_param->type_operation = 1;
                       XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_noi_OK_callb,AUX_param);
			break;
  case AUX_MOD_CUT: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mod_cut_OK_callb,AUX_param);
			break;
  case AUX_GEN_BAND8: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_gen_band_OK_callb, 8);
			break;
  case AUX_GEN_BAND16: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_gen_band_OK_callb, 16);
			break;
  case AUX_GEN_BAND32: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_gen_band_OK_callb, 32);
			break;
  case AUX_GEN_BAND64: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_gen_band_OK_callb, 64);
			break;
  case AUX_COPY: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_copyplane_OK_callb,IOplans_widget);
			break;
  case THRESH_SAVE: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_thres_save_OK_callb,data_display);
			break;
  case PIXELEDIT_SAVE: XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_pixeledit_save_OK_callb,data_display);
			break;
  case MAPEDIT_DISPLAY_SAVE:XtAddCallback(options_OK,
		XmNactivateCallback,IOplans_mapedit_display_save_OK_callb,data_display);
			break;
  case IMAGE_GENERATION_SAVE:XtAddCallback(options_OK,
		XmNactivateCallback,Image_generation_save_OK_callb, IOplans_widget);
			break;
  default: break;

}
	return(IOplans_widget);
}
