/* SCCS @(#)IOplans.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            IOplans.callback.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   IOplans.callback.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Interface for IO operations                         */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include <stdlib.h>
#include "libwidgets/widgetstructure.h"
#include "IOplans.layout.h"

#include "convert4.h"
#include "oparithm4.h"
#include "oplogic4.h"
#include "geometrie4.h"
#include "bruit4.h"
#include "lcount4.h"
#include "win4.h"
#include "urgent4.h"

extern void sauve_im_ds_plan();

extern Display *gDisplay;
extern Cursor  gWatchcursor;
extern Widget  gLabowidget;

extern unsigned char	mapedit_red[256] ;
extern unsigned char	mapedit_green[256] ;
extern unsigned char	mapedit_blue[256] ;

/******************************************************
/   activateCallback for Widget  IOplans_CANCEL 
/*****************************************************/

void
IOplans_CANCEL_callb(IOplans_widget_CANCEL, IOplans_widget, callData)
	Widget IOplans_widget_CANCEL;
	Widget IOplans_widget;
	caddr_t callData;
{
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_CANCEL))));
    XtUnmanageChild (IOplans_widget);
}


/******************************************************
/   activateCallback for Widget  IOplans_OK 
/*****************************************************/

void
IOplans_conv_bin_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imas, *imas2, *imageIn, *imageOut;

    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->mind = atoi (XmTextGetString (convertparam->Imu));

    sprintf (buf, mastertabs[34]);
    write_master (buf);
    sprintf(buf," %d --> %d ", index_image[0], index_image[1]);
    write_master (buf);
    sprintf(buf, "threshold %.2f\n", conv->mind);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		  XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;
 
    creer_image_bin(imageIn, type, colonne, ligne, mmin, mmax,
		   &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL)
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = -1;
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
}


void
IOplans_conv_byte_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imageIn, *imageOut;
    
    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->maxd = (float)atof (XmTextGetString (convertparam->Imax));
    conv->flag_maxd = FALSE;
    conv->mind = (float)atof (XmTextGetString (convertparam->Imin));
    conv->flag_mind = FALSE;
    conv->maxa = (float)atof (XmTextGetString (convertparam->Omax));
    conv->flag_maxa = FALSE;
    conv->mina = (float)atof (XmTextGetString (convertparam->Omin));
    conv->flag_mina = FALSE;
    
    sprintf (buf, mastertabs[26]);
    write_master (buf);

    sprintf(buf," %d --> %d ", index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;
    
    convert_byte (imageIn, type, colonne, ligne, mmin, mmax, 
		  &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL)
         free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].mmin = mmin2;
    dir_desc[index_image[1]].mmax = mmax2;
    dir_desc[index_image[1]].type = 0;
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));


    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
    free (conv);
}


void
IOplans_conv_short_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imageIn;
    short *imageOut;

    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->maxd = (float)atof (XmTextGetString (convertparam->Imax));
    conv->flag_maxd = FALSE;
    conv->mind = (float)atof (XmTextGetString (convertparam->Imin));
    conv->flag_mind = FALSE;
    conv->maxa = (float)atof (XmTextGetString (convertparam->Omax));
    conv->flag_maxa = FALSE;
    conv->mina = (float)atof (XmTextGetString (convertparam->Omin));
    conv->flag_mina = FALSE;

    sprintf (buf, mastertabs[27]);
    write_master (buf);

    sprintf(buf,"%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;

    convert_short (imageIn, type, colonne, ligne, mmin, mmax, 
		   &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].mmin = mmin2;
    dir_desc[index_image[1]].mmax = mmax2;
    dir_desc[index_image[1]].type = 1; 
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));


    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
    free (conv);
}


void
IOplans_conv_int_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imageIn;
    int *imageOut;

    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->maxd = (float)atof (XmTextGetString (convertparam->Imax));
    conv->flag_maxd = FALSE;
    conv->mind = (float)atof (XmTextGetString (convertparam->Imin));
    conv->flag_mind = FALSE;
    conv->maxa = (float)atof (XmTextGetString (convertparam->Omax));
    conv->flag_maxa = FALSE;
    conv->mina = (float)atof (XmTextGetString (convertparam->Omin));
    conv->flag_mina = FALSE;

    sprintf (buf, mastertabs[28]);
    write_master (buf);

    sprintf(buf,"%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;

    convert_integer (imageIn, type, colonne, ligne, mmin, mmax, 
		     &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].mmin = mmin2;
    dir_desc[index_image[1]].mmax = mmax2;
    dir_desc[index_image[1]].type = 2; 
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
    free (conv);
}


void
IOplans_conv_float_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne, taille, j;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imageIn;
    float *im, *imageOut;

    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->maxd = (float)atof (XmTextGetString (convertparam->Imax)); 
    conv->flag_maxd = FALSE;
    conv->mind = (float)atof (XmTextGetString (convertparam->Imin));
    conv->flag_mind = FALSE;
    conv->maxa = (float)atof (XmTextGetString (convertparam->Omax));
    conv->flag_maxa = FALSE;
    conv->mina = (float)atof (XmTextGetString (convertparam->Omin));
    conv->flag_mina = FALSE;

    if (flag_compl) sprintf (buf,mastertabs[29]);
    else sprintf (buf, mastertabs[30]);
    write_master (buf);

    if (flag_compl) 
      sprintf (buf,"%d --> (%d,%d)", index_image[0], 
	       index_image[1], index_image[3]);
    else
      sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		  XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;

    convert_float (imageIn, type, colonne, ligne, mmin, mmax, 
		   &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].mmin = mmin2;
    dir_desc[index_image[1]].mmax = mmax2;
    dir_desc[index_image[1]].type = 3; 
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    if (flag_compl)
    {
      taille = colonne * ligne;
      im = (float *) malloc (taille * 4);
      if (dir_image[index_image[3]].image != NULL)
        free (dir_image[index_image[3]].image);
      dir_image[index_image[3]].image = (unsigned char *) im;

      /* mise a 0 du plan imaginaire (ou argument) */
      for (j = 0; j < taille; j++)
      {
	*im = 0.0;
	im++;	
      }
      /* mise a jour des statistiques du plan imaginaire */
      dir_desc[index_image[3]] = dir_desc[index_image[0]];
      dir_desc[index_image[3]].type = 3;
      dir_desc[index_image[3]].mmin = 0;
      dir_desc[index_image[3]].mmax = 0;
      dir_desc[index_image[3]].mu = 0;
      dir_desc[index_image[3]].ecart = 0;
    }
    
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
    free (conv);
    flag_compl = FALSE;
}


void
IOplans_conv_compl_OK_callb(IOplans_widget_OK, convertparam, callData)
	Widget IOplans_widget_OK;
	xs_struc_paramsconversion * convertparam;
	caddr_t callData;
{
    int type, ligne, colonne, taille, j;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    unsigned char *imageIn;
    float *im, *imageOut;

    flag_compl = TRUE;
    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->maxd = (float)atof (XmTextGetString (convertparam->Imax)); 
    conv->flag_maxd = FALSE;
    conv->mind = (float)atof (XmTextGetString (convertparam->Imin));
    conv->flag_mind = FALSE;
    conv->maxa = (float)atof (XmTextGetString (convertparam->Omax));
    conv->flag_maxa = FALSE;
    conv->mina = (float)atof (XmTextGetString (convertparam->Omin));
    conv->flag_mina = FALSE;

    if (flag_compl) sprintf (buf,mastertabs[29]);
    else sprintf (buf, mastertabs[30]);
    write_master (buf);

    if (flag_compl) 
      sprintf (buf,"%d --> (%d,%d)", index_image[0], 
	       index_image[1], index_image[3]);
    else
      sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL)
    {
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, 
		XtWindow(XtParent(XtParent(IOplans_widget_OK))), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    type =  dir_desc[index_image[0]].type;
    imageIn = (unsigned char *)dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;

    convert_float (imageIn, type, colonne, ligne, mmin, mmax, 
		   &imageOut, &mmin2, &mmax2, conv);

    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].mmin = mmin2;
    dir_desc[index_image[1]].mmax = mmax2;
    dir_desc[index_image[1]].type = 3; 
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    if (flag_compl)
    {
      taille = colonne * ligne;
      im = (float *) malloc (taille * 4);
      if (dir_image[index_image[3]].image != NULL)
        free (dir_image[index_image[3]].image);
      dir_image[index_image[3]].image = (unsigned char *) im;

      /* mise a 0 du plan imaginaire (ou argument) */
      for (j = 0; j < taille; j++)
      {
	*im = 0.0;
	im++;	
      }
      /* mise a jour des statistiques du plan imaginaire */
      dir_desc[index_image[3]] = dir_desc[index_image[0]];
      dir_desc[index_image[3]].type = 3;
      dir_desc[index_image[3]].mmin = 0;
      dir_desc[index_image[3]].mmax = 0;
      dir_desc[index_image[3]].mu = 0;
      dir_desc[index_image[3]].ecart = 0;
    }
    
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (IOplans_widget_OK))));

    XtUnmanageChild (convertparam->GenerParamparent);
    free (conv);
    flag_compl = FALSE;
}


void
IOplans_conv_cart_pol_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    int ligne, colonne;
    unsigned char *imageIn1, *imageIn2;
    float *imageOut1, *imageOut2; 
    
    sprintf (buf, mastertabs[31]);
    write_master (buf);

    sprintf(buf,"(%d,%d)--> (%d,%d)\n", index_image[0], 
	    index_image[2], index_image[1], index_image[3]);
    write_master (buf);

    if (dir_desc[index_image[0]].nligne != dir_desc[index_image[2]].nligne ||
        dir_desc[index_image[0]].ncolonne!= dir_desc[index_image[2]].ncolonne){
      /* taille differente */
      write_erreur(2);
      return;
    }
    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      return;
    }
    else if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    imageIn1 = (unsigned char *)dir_image[index_image[0]].image;
    imageIn2 = (unsigned char *)dir_image[index_image[2]].image;

    convert_cart_en_pol(imageIn1, imageIn2, ligne, colonne, 
			&imageOut1, &imageOut2);
    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut1;

    if (dir_image[index_image[3]].image != NULL) 
        free(dir_image[index_image[3]].image);
    dir_image[index_image[3]].image = (unsigned char *)imageOut2;

    /* recopie globale des descripteurs */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[3]] = dir_desc[index_image[2]];

    /* calcul des statistiques pour le plan-norme */
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    /* calcul des statistiques pour le plan-argument */
    statis (dir_image[index_image[3]].image, 
	    dir_desc[index_image[3]].type, 
	    dir_desc[index_image[3]].nligne, 
	    dir_desc[index_image[3]].ncolonne,
	    &(dir_desc[index_image[3]].mmin), 
	    &(dir_desc[index_image[3]].mmax), 
	    &(dir_desc[index_image[3]].mu), 
	    &(dir_desc[index_image[3]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_conv_pol_cart_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    int ligne, colonne;
    unsigned char *imageIn1, *imageIn2;
    float *imageOut1, *imageOut2; 

    sprintf (buf, mastertabs[32]);
    write_master (buf);

    sprintf(buf, "(%d,%d)--> (%d,%d)\n", index_image[0], 
	    index_image[2], index_image[1], index_image[3]);
    write_master (buf);

    if (dir_desc[index_image[0]].nligne != dir_desc[index_image[2]].nligne ||
        dir_desc[index_image[0]].ncolonne!= dir_desc[index_image[2]].ncolonne){
      /* taille differente */
      write_erreur(2);
      return;
    }
    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      return;
    }
    else if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), gWatchcursor);
    XFlush(gDisplay);

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    imageIn1 = (unsigned char *)dir_image[index_image[0]].image;
    imageIn2 = (unsigned char *)dir_image[index_image[2]].image;

    convert_pol_en_cart(imageIn1, imageIn2, ligne, colonne, 
			&imageOut1, &imageOut2);

    if (dir_image[index_image[1]].image != NULL) 
        free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut1;

    if (dir_image[index_image[3]].image != NULL) 
        free(dir_image[index_image[3]].image);
    dir_image[index_image[3]].image = (unsigned char *)imageOut2;

    /* recopie globale des descripteurs */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[3]] = dir_desc[index_image[2]];

    /* calcul des statistiques pour le plan-reel */
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));
    /* calcul des statistiques pour le plan-imaginaire */
    statis (dir_image[index_image[3]].image, 
	    dir_desc[index_image[3]].type, 
	    dir_desc[index_image[3]].nligne, 
	    dir_desc[index_image[3]].ncolonne,
	    &(dir_desc[index_image[3]].mmin), 
	    &(dir_desc[index_image[3]].mmax), 
	    &(dir_desc[index_image[3]].mu), 
	    &(dir_desc[index_image[3]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}



/********************************************************/
/* anciennement proc_rgb_nivgris		       	*/
/*							*/
/* transforme une image RGB en une image a niveaux de   */
/* gris en conservant la luminance.			*/
/********************************************************/

void
IOplans_conv_rgb_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    unsigned char *imr, *img, *imb, *im;
    register int i, j;

    sprintf (buf, mastertabs[0]);
    write_master (buf);

    sprintf (buf, " %d %d %d -->  %d\n\0", index_image[0],
	     index_image[2], index_image[4], index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(4);
      return;
    }
    if (dir_image[index_image[2]].image == NULL){
      write_erreur(5);
      return;
    }
    if (dir_image[index_image[4]].image == NULL){
      write_erreur(6);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), gWatchcursor);
    XFlush(gDisplay);

    imr = dir_image[index_image[0]].image;
    img = dir_image[index_image[2]].image;
    imb = dir_image[index_image[4]].image;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 0;
    strcpy (dir_desc[index_image[1]].date, (char *) get_time()); 
    /* date et heure */
    im = (unsigned char *) malloc
         (dir_desc[index_image[1]].ncolonne*dir_desc[index_image[1]].nligne);
    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image); 
    dir_image[index_image[1]].image = im;
    for (j=0; j<dir_desc[index_image[1]].nligne; j++)
      for (i=0; i<dir_desc[index_image[1]].ncolonne; i++) {
	*im++ = (unsigned char)
	          rint(0.3 * (*imr++) + 0.59 * (*img++) + 0.11 * (*imb++));
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


/********************************************************/
/* anciennement proc_op_arithm 				*/
/********************************************************/

void 
IOplans_arithm_OK_callb(options_OK, AUX_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * AUX_param;
	caddr_t callData;
{
    int mode, type, type2, type4, type6, colonne, ligne, typearr;
    struct cte_cmplx  *cte;
    unsigned char *imageIn, *imageIn1i, *imageIn2r, *imageIn2i;
    unsigned char *imageOutr, *imageOuti;
    float *imageOut;
    
    sprintf (buf, mastertabs[186]);
    write_master (buf);

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    mode = AUX_param->type_operation;
  
    switch (mode) {
	case 10:    /* addition cte */
	case 11:    /* soustraction cte */
	case 12:    /* multiplication cte */
	case 13:    /* division cte */
           cte = (struct cte_cmplx *) malloc (sizeof (struct cte_cmplx));
           cte->reel = (float)atof (XmTextGetString (AUX_param->alpha));
           switch (mode){
	       case 10:  
	         sprintf (buf,mastertabs[187], 
			  index_image[0], cte->reel, index_image[1]);  break;
	       case 11:
		 sprintf (buf,mastertabs[188], 
			  index_image[0], cte->reel, index_image[1]);  break;
	       case 12:
		 sprintf (buf, mastertabs[189],
			  index_image[0], cte->reel, index_image[1]);  break;
	       case 13:
		 sprintf (buf, mastertabs[190],
			  index_image[0], cte->reel, index_image[1]);  break;
	    }
	   write_master (buf);
	   if (dir_image[index_image[0]].image == NULL){
	     write_erreur(1);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }

	   type = dir_desc[index_image[0]].type;
	   colonne = dir_desc[index_image[0]].ncolonne;
	   ligne = dir_desc[index_image[0]].nligne;
	   imageIn = dir_image[index_image[0]].image;
	   
	   /******* TRAITEMENT ********/
	   op_arithm_cte(mode, imageIn, type, colonne, ligne, cte->reel, 
			 &imageOut);
	   /***************************/

	   /* recopie globale du descripteur */
	   dir_desc[index_image[1]] = dir_desc[index_image[0]];
	   dir_desc[index_image[1]].type = 3;
           if (dir_image[index_image[1]].image != NULL) 
	         free (dir_image[index_image[1]].image);
	   dir_image[index_image[1]].image = (unsigned char *) imageOut;
	   statis (dir_image[index_image[1]].image, 
		   dir_desc[index_image[1]].type,
		   dir_desc[index_image[1]].nligne, 
		   dir_desc[index_image[1]].ncolonne,
		   &(dir_desc[index_image[1]].mmin), 
		   &(dir_desc[index_image[1]].mmax),
		   &(dir_desc[index_image[1]].mu), 
		   &(dir_desc[index_image[1]].ecart));
           free(cte);
	   break;

	case 20:    /* addition 2 plans */
	case 21:    /* soustraction 2 plans */
	case 22:    /* multiplication 2 plans */
	case 23:    /* division 2 plans */
	   switch (mode){
	       case 20:
	         sprintf (buf, mastertabs[191],
			 index_image[0], index_image[2], index_image[1]); break;
	       case 21:
		 sprintf (buf, mastertabs[192],
			 index_image[0], index_image[2], index_image[1]); break;
	       case 22:
		 sprintf (buf, mastertabs[193],
			 index_image[0], index_image[2], index_image[1]); break;
	       case 23:
		 sprintf (buf,mastertabs[194], 
			 index_image[0], index_image[2], index_image[1]); break;
	   }
	   write_master (buf);
	   if (dir_image[index_image[0]].image == NULL){
	     write_erreur(9);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   if (dir_image[index_image[2]].image == NULL){
	     write_erreur(10);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   colonne = dir_desc[index_image[0]].ncolonne;
	   ligne = dir_desc[index_image[0]].nligne;
	   
	   type = dir_desc[index_image[0]].type;
	   imageIn = dir_image[index_image[0]].image;
	   type2 = dir_desc[index_image[2]].type;
	   imageIn1i = dir_image[index_image[2]].image;

	   /******* TRAITEMENT ********/
	   op_arithm (mode, imageIn, type, imageIn1i, type2, colonne, ligne, 
		      &imageOutr, &typearr);
	   /***************************/

	   /* recopie globale du descripteur */
           dir_desc[index_image[1]] = dir_desc[index_image[0]];
	   dir_desc[index_image[1]].type = typearr;
           if (dir_image[index_image[1]].image != NULL) 
	         free (dir_image[index_image[1]].image);
	   dir_image[index_image[1]].image = (unsigned char *) imageOutr;	
	   statis (dir_image[index_image[1]].image, 
		   dir_desc[index_image[1]].type,
		   dir_desc[index_image[1]].nligne, 
		   dir_desc[index_image[1]].ncolonne,
		   &(dir_desc[index_image[1]].mmin), 
		   &(dir_desc[index_image[1]].mmax),
		   &(dir_desc[index_image[1]].mu), 
		   &(dir_desc[index_image[1]].ecart));
	   break;

	case 40:    /* multiplication 2 images complexes */

	   sprintf(buf,mastertabs[195],
		   index_image[0], index_image[2], index_image[4],
		   index_image[6], index_image[1], index_image[3]);
	   write_master (buf);
	   if (dir_image[index_image[0]].image == NULL){
	     write_erreur(9);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   if (dir_image[index_image[2]].image == NULL){
	     write_erreur(10);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   if (dir_image[index_image[4]].image == NULL){
	     write_erreur(9);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   if (dir_image[index_image[6]].image == NULL){
	     write_erreur(10);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   colonne = dir_desc[index_image[0]].ncolonne;
	   ligne = dir_desc[index_image[0]].nligne;
	   imageIn = dir_image[index_image[0]].image;
	   type = dir_desc[index_image[0]].type;
	   imageIn1i = dir_image[index_image[2]].image;
	   type2 = dir_desc[index_image[2]].type;
	   imageIn2r = dir_image[index_image[4]].image;
	   type4 = dir_desc[index_image[4]].type;
	   imageIn2i = dir_image[index_image[6]].image;
	   type6 = dir_desc[index_image[6]].type;
	   
	   /******* TRAITEMENT ********/
	   op_arithm_cmplx (imageIn, type, imageIn1i, type2, imageIn2r, type4,
			    imageIn2i, type6, colonne, ligne,
			    &imageOutr, &imageOuti, &typearr);
	   /***************************/

	   /* recopie globale du descripteur */
	   dir_desc[index_image[1]] = dir_desc[index_image[0]];
	   dir_desc[index_image[1]].type = typearr;
           if (dir_image[index_image[1]].image != NULL) 
	         free (dir_image[index_image[1]].image);
	   dir_image[index_image[1]].image = (unsigned char *) imageOutr;

	   /* recopie globale du descripteur */
	   dir_desc[index_image[3]] = dir_desc[index_image[1]];	   
           if (dir_image[index_image[3]].image != NULL) 
	         free (dir_image[index_image[3]].image);
	   dir_image[index_image[3]].image = (unsigned char *) imageOuti;

	   statis (dir_image[index_image[1]].image, 
		   dir_desc[index_image[1]].type,
		   dir_desc[index_image[1]].nligne, 
		   dir_desc[index_image[1]].ncolonne,
		   &(dir_desc[index_image[1]].mmin), 
		   &(dir_desc[index_image[1]].mmax),
		   &(dir_desc[index_image[1]].mu), 
		   &(dir_desc[index_image[1]].ecart));
	   statis (dir_image[index_image[3]].image, 
		   dir_desc[index_image[3]].type,
		   dir_desc[index_image[3]].nligne, 
		   dir_desc[index_image[3]].ncolonne,
		   &(dir_desc[index_image[3]].mmin), 
		   &(dir_desc[index_image[3]].mmax),
		   &(dir_desc[index_image[3]].mu), 
		   &(dir_desc[index_image[3]].ecart));
	   break;

	case 41:    /* multiplication image complexe * cte cmplx */
           cte = (struct cte_cmplx *) malloc (sizeof (struct cte_cmplx));
           cte->reel = (float)atof (XmTextGetString (AUX_param->alpha));
           cte->im = (float)atof (XmTextGetString (AUX_param->line));
	   sprintf (buf, mastertabs[196],
		    index_image[0], index_image[2], cte->reel, cte->im,
		    index_image[1], index_image[3]);
	   write_master (buf);
	   if (dir_image[index_image[0]].image == NULL){
	     write_erreur(9);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   if (dir_image[index_image[2]].image == NULL){
	     write_erreur(10);
	     XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	     XUndefineCursor(gDisplay, 
			     XtWindow(XtParent (XtParent (options_OK))));
	     return;
	   }
	   colonne = dir_desc[index_image[0]].ncolonne;
	   ligne = dir_desc[index_image[0]].nligne;
	   imageIn = dir_image[index_image[0]].image;
	   type = dir_desc[index_image[0]].type;
	   imageIn1i = dir_image[index_image[2]].image;
	   type2 = dir_desc[index_image[2]].type;

	   /******* TRAITEMENT ********/
	   op_arithm_cte_cmplx (imageIn, type, imageIn1i, type2, colonne, ligne,
				cte, &imageOutr, &imageOuti);
	   /***************************/

	   /* recopie globale du descripteur */
	   dir_desc[index_image[1]] = dir_desc[index_image[0]];
	   dir_desc[index_image[1]].type = 3;

           if (dir_image[index_image[1]].image != NULL) 
	         free (dir_image[index_image[1]].image);
	   dir_image[index_image[1]].image = (unsigned char *) imageOutr;

	   /* recopie globale du descripteur */
	   dir_desc[index_image[3]] = dir_desc[index_image[1]];	   
           if (dir_image[index_image[3]].image != NULL) 
	         free (dir_image[index_image[3]].image);
	   dir_image[index_image[3]].image = (unsigned char *) imageOuti;

	   statis (dir_image[index_image[1]].image, 
		   dir_desc[index_image[1]].type,
		   dir_desc[index_image[1]].nligne, 
		   dir_desc[index_image[1]].ncolonne,
		   &(dir_desc[index_image[1]].mmin), 
		   &(dir_desc[index_image[1]].mmax),
		   &(dir_desc[index_image[1]].mu), 
		   &(dir_desc[index_image[1]].ecart));
	   statis (dir_image[index_image[3]].image, 
		   dir_desc[index_image[3]].type,
		   dir_desc[index_image[3]].nligne, 
		   dir_desc[index_image[3]].ncolonne,
		   &(dir_desc[index_image[3]].mmin), 
		   &(dir_desc[index_image[3]].mmax),
		   &(dir_desc[index_image[3]].mu), 
		   &(dir_desc[index_image[3]].ecart));

	   free(cte);
	   break;
    }    

    free(AUX_param);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}


/*****************************************************************************/
/*  nom	    :	raster_op						     */
/*									     */
/*  fonction:	Applique un operateur (passe en parametre a la fonction)     */
/*		entre deux plans dont le deuxieme est de type binaire        */
/*              (masque).						     */
/*									     */
/*  entrees :	int	sel						     */
/*									     */
/*  globales:	dir_desc						     */
/*		dir_image						     */
/*		index_image						     */
/*									     */
/*  return  :	aucun							     */
/*									     */
/*  routines:	write_master						     */
/*		write_erreur						     */
/*		statis							     */
/*		element							     */
/*									     */
/*									     */
/*****************************************************************************/
static void raster_op(sel)   
    int	    sel;
{
    int	    plan_source, plan_masque, plan_arr;
    int	    type, lignearr, colonnearr;
    unsigned char *imageOut;
    
    sprintf (buf, mastertabs[200]);
    write_master (buf);

    switch (sel)
    {
    case AND: 
      sprintf(buf,mastertabs[201],
	      index_image[0], index_image[2], index_image[1]);
      break;
    case AND_BOUNDED:
      sprintf(buf,mastertabs[202],
	      index_image[0], index_image[2], index_image[1]);
      break;
    case OR :
      sprintf(buf,mastertabs[203],
	      index_image[0], index_image[2], index_image[1]);
      break;
    case XOR: 
      sprintf(buf,mastertabs[204],
	      index_image[0], index_image[2], index_image[1]);
      break;
    case NOT:
      sprintf(buf,mastertabs[205],
	      index_image[0], index_image[1]);
      break;
    default: break;
    }

    write_master (buf);    

    switch (sel)
    {
    case AND: 
    case AND_BOUNDED: 
    case OR: 
    case XOR:
/*		fromto (FROMTO, DEF21); */
      if (dir_image[index_image[0]].image == NULL){
	write_erreur(9);
	return;
      }
      if (dir_image[index_image[2]].image == NULL){
	write_erreur(10);
	return;
      }
      plan_source = index_image[0];
      plan_masque = index_image[2];
      plan_arr = index_image[1];
      break;

    case NOT:
/*	        fromto (FROMTO, DEFAUT); */
      if (dir_image[index_image[0]].image == NULL){
	write_erreur(1);
	return;
      }
      plan_source = index_image[0];
      plan_arr = index_image[1];
      break;
    }

    switch (sel)
      {

       /* Operation AND entre une image source de n'importe quel type     */
       /* et une image masque de type -1 c'est a dire binarisee ( 0-255). */
       /* Elles doivent etre de la meme taille                            */

       case AND:
         if (dir_desc[plan_masque].type != -1)
	   {
	     write_erreur(17);
	     return;
	   }
	 if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
	     || (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	   {
	     write_erreur(2);
	     return;
	   }

	 /* recopie globale du descripteur */
	 dir_desc[plan_arr] = dir_desc[plan_source];
	 type = dir_desc[plan_source].type;

	 op_logic(AND, dir_image[plan_source].image, type, 
		  dir_desc[plan_source].ncolonne,
		  dir_desc[plan_source].nligne,
		  dir_image[plan_masque].image, 
		  &imageOut, &colonnearr, &lignearr);

	 if (dir_image[plan_arr].image != NULL)
	   free(dir_image[plan_arr].image); 

	 dir_image[plan_arr].image = (unsigned char*) imageOut;    
       	 break;


       /* Operation AND restreinte a la bounding box du masque sur      */
       /* une image source de	n'importe quel type et une image masque   */
       /* de type -1 c'est a dire binarisee (0-255)                     */
       /* Elles doivent etre de la meme taille			  */

       case AND_BOUNDED :
	 if (dir_desc[plan_masque].type != -1)
	   {
	     write_erreur(17);
	     return;
	   }
	 if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
	     || (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	   {
	     write_erreur(2);
	     return;
	   }

	 /* recopie globale du descripteur */
	 dir_desc[plan_arr] = dir_desc[plan_source];
	 type = dir_desc[plan_source].type;

	 op_logic(AND_BOUNDED, dir_image[plan_source].image, type, 
		  dir_desc[plan_source].ncolonne,
		  dir_desc[plan_source].nligne,
		  dir_image[plan_masque].image, 
		  &imageOut, &colonnearr, &lignearr);

	 dir_desc[plan_arr].ncolonne = colonnearr;
	 dir_desc[plan_arr].nligne = lignearr;


	 if (dir_image[plan_arr].image != NULL)
	   free(dir_image[plan_arr].image); 
	 dir_image[plan_arr].image = (unsigned char*) imageOut;		 
	 break;


       /* Operation OR entre deux images de type masque.   */
       /* Elles doivent etre de la meme taille             */
	
       case OR : 
	 if (dir_desc[plan_source].type != -1)     /*=> pas de type byte*/
	   {
	     write_erreur(17);
	     return;
	   }
	 if (dir_desc[plan_masque].type != -1)
	   {
	     write_erreur(17);
	     return;
	   }
	 if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
	     || (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	   {
	     write_erreur(2);
	     return;
	   }

	 /* recopie globale du descripteur */
	 dir_desc[plan_arr] = dir_desc[plan_source];
	 type = dir_desc[plan_source].type;

	 op_logic(OR, dir_image[plan_source].image, type, 
		  dir_desc[plan_source].ncolonne,
		  dir_desc[plan_source].nligne,
		  dir_image[plan_masque].image, 
		  &imageOut, &colonnearr, &lignearr);

	 if (dir_image[plan_arr].image != NULL)
	   free(dir_image[plan_arr].image); 

	 dir_image[plan_arr].image = (unsigned char*) imageOut;    
	 break;


       /* Operation XOR entre deux images de type masque. */
       /* Elles doivent etre de la meme taille            */
	
       case XOR:
	 if (dir_desc[plan_source].type != -1)	/*=> pas de type byte "binaire"*/
	   {
	     write_erreur(17);
	     return;
	   }
	 if (dir_desc[plan_masque].type != -1)
	   {
	     write_erreur(17);
	     return;
	   }
	 if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
	     || (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	   {
	     write_erreur(2);
	     return;
	   }

	 /* recopie globale du descripteur */
	 dir_desc[plan_arr] = dir_desc[plan_source];
	    
	 type = dir_desc[plan_source].type;

	 op_logic(XOR, dir_image[plan_source].image, type, 
		  dir_desc[plan_source].ncolonne,
		  dir_desc[plan_source].nligne,
		  dir_image[plan_masque].image, 
		  &imageOut, &colonnearr, &lignearr);

	 if (dir_image[plan_arr].image != NULL)
	   free(dir_image[plan_arr].image); 

	 dir_image[plan_arr].image = (unsigned char*) imageOut; 
	 break;


       /* Operation NOT d'une image. */
       /* Elle doit etre de type binaire ou de type byte*/

       case NOT:
	 if (dir_desc[plan_source].type != 0 && 
	     dir_desc[plan_source].type != -1)   /*=> pas de type byte*/
	   {
	     write_erreur(16);
	     return;
	   }

	 /* recopie globale du descripteur */
	 dir_desc[plan_arr] = dir_desc[plan_source];
	 type = dir_desc[plan_source].type;

	 op_logic(NOT, dir_image[plan_source].image, type, 
		  dir_desc[plan_source].ncolonne,
		  dir_desc[plan_source].nligne,
		  dir_image[plan_masque].image, 
		  &imageOut, &colonnearr, &lignearr);

	 if (dir_image[plan_arr].image != NULL)
	   free(dir_image[plan_arr].image); 

	 dir_image[plan_arr].image = (unsigned char*) imageOut; 
	 break;
       }

    statis (dir_image[plan_arr].image,
	    dir_desc[plan_arr].type, 
	    dir_desc[plan_arr].nligne,
	    dir_desc[plan_arr].ncolonne,
	    &(dir_desc[plan_arr].mmin),
	    &(dir_desc[plan_arr].mmax), 
	    &(dir_desc[plan_arr].mu),
	    &(dir_desc[plan_arr].ecart));
}



void
IOplans_logic_and_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    raster_op(AND);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_logic_andmask_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    raster_op(AND_BOUNDED);    /* AND restreint a la bounding box du masque*/

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_logic_or_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    raster_op(OR);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_logic_xor_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    raster_op(XOR);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_logic_not_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    raster_op(NOT);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


/********************************************************/
/* anciennement proc_affin 				*/
/********************************************************/

void
IOplans_geom_OK_callb(options_OK, AUX_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * AUX_param;
	caddr_t callData;
{ 
    struct affin *affi;
    float   *image, *imageOut, t[3][2];
    int	    isx1, isy1, isx2, isy2, isw, mode, result;
    float   anglerad;

    sprintf (buf, mastertabs[85]);
    write_master (buf);
    sprintf (buf, "%d  --> %d ", index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    mode = AUX_param->type_operation;
    
    t[0][0] = t[0][1] = t[1][0] = t[1][1] = t[2][0] = t[2][1] = 0.0;

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        flag_conv = TRUE;
        image = (float *) conv_float (dir_image[index_image[0]].image,
				      dir_desc[index_image[0]].type,
				      dir_desc[index_image[0]].nligne,
				      dir_desc[index_image[0]].ncolonne);
        break;
      case 3: 
      case 4:
      case 5:
	flag_conv = FALSE;
        image = (float *)dir_image[index_image[0]].image;
        break;
    }

    switch (mode){  /* construction matrice+logfile */
      case 0:	{   /* rotation */
        affi = (struct affin *) malloc (sizeof (struct affin));
        affi->c1 = (float)atof (XmTextGetString (AUX_param->alpha));
	sprintf (buf, mastertabs[86],affi->c1);
	isx2 = dir_desc[index_image[0]].ncolonne;
	isy2 = dir_desc[index_image[0]].nligne;
	anglerad = affi->c1 / 180 * M_PI;		    
	t[0][0] = t[1][1] = cos(anglerad);
	t[0][1] = -sin(anglerad);
	t[1][0] = sin(anglerad);
	t[2][0] =(isx2+1)/2*(1-t[0][0])-(isy2+1)/2*t[1][0];
	t[2][1] = -(isx2+1)/2*t[0][1] + (isy2+1)/2*(1-t[1][1]);
	break;
      }
      case 1:	{   /* translation */
        affi = (struct affin *) malloc (sizeof (struct affin));
        affi->c1 = (float)atof (XmTextGetString (AUX_param->line));
        affi->c2 = (float)atof (XmTextGetString (AUX_param->colon));
	sprintf (buf, "  Translation x = %d y = %d\n",
		 (int)rint(affi->c1),(int)rint(affi->c2));
	isx2 = dir_desc[index_image[0]].ncolonne;
	isy2 = dir_desc[index_image[0]].nligne;
	t[0][0] = t[1][1] = 1;
	t[2][0] = affi->c1;
	t[2][1] = -affi->c2;
	break;
      }
      case 2:	{   /* scaling taille */
        affi = (struct affin *) malloc (sizeof (struct affin));
        affi->c1 = (float)atof (XmTextGetString (AUX_param->line));
        affi->c2 = (float)atof (XmTextGetString (AUX_param->colon));
	if ((affi->c1<1) || (affi->c2<1))
	{
	  write_erreur(107);
	  XmTextSetString (AUX_param->line, "");
	  XmTextSetString (AUX_param->colon, "");
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			  XtWindow(XtParent (XtParent (options_OK))));
	  return;
	}
	sprintf (buf, mastertabs[87], (int)rint(affi->c1),(int)rint(affi->c2));
	isx2 = (int)rint((double)affi->c1);
	isy2 = (int)rint((double)affi->c2);
	t[0][0]=affi->c1/dir_desc[index_image[0]].ncolonne;
	t[1][1] = affi->c2/dir_desc[index_image[0]].nligne;
	break;
      }
      case 3:	{   /* scaling facteur */
        affi = (struct affin *) malloc (sizeof (struct affin));
        affi->c1 = (float)atof (XmTextGetString (AUX_param->line));
        affi->c2 = (float)atof (XmTextGetString (AUX_param->colon));
	sprintf (buf, mastertabs[88], affi->c1,affi->c2);
	isx2 = (int)rint(dir_desc[index_image[0]].ncolonne * affi->c1);
	isy2 = (int)rint(dir_desc[index_image[0]].nligne * affi->c2);
	t[0][0] = affi->c1;
	t[1][1] = affi->c2;
	break;
      }
      }
    write_master (buf);
    isx1 = dir_desc[index_image[0]].ncolonne;
    isy1 = dir_desc[index_image[0]].nligne;
    isw = 1;

    /******* TRAITEMENT ********/
    result = AffineTransf(image, isx1, isy1, &imageOut, isx2, isy2, t, isw);
    /***************************/

    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
	   
    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].ncolonne = isx2;
    dir_desc[index_image[1]].nligne = isy2;
    dir_desc[index_image[1]].type = 3;
    if (flag_conv)
      {
	free (image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    free(affi);
    free(AUX_param);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}


/********************************************************/
/* anciennement proc_transpose 				*/
/********************************************************/

void
IOplans_geom_tranp_OK_callb(options_OK, IOplans_widget, callData)
	Widget options_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    short tf;
    float *image, *imageOut;
    int type, ligne, colonne, result;
    
    sprintf (buf, panel_titres[158]);
    write_master (buf);
    sprintf (buf, ": %d --> %d\n", index_image[0], index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
	flag_conv = FALSE;
        image = (float *)dir_image[index_image[0]].image;
        break;
    }

    type = dir_desc[index_image[0]].type;
    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    
    /******* TRAITEMENT ********/
    result = transpose (image, &imageOut, type, colonne, ligne);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (IOplans_widget);    
      return;
    }   
    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *) imageOut;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    tf = dir_desc[index_image[1]].ncolonne;
    dir_desc[index_image[1]].ncolonne=dir_desc[index_image[1]].nligne;
    dir_desc[index_image[1]].nligne = tf;

    if (flag_conv) 
    {
      free (image);
      flag_conv = FALSE;
    }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);    
}


/********************************************************/
/* anciennement proc_sym_x 				*/
/********************************************************/

void
IOplans_geom_symx_OK_callb(options_OK, IOplans_widget, callData)
	Widget options_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    float *image, *temp;
    int type, ligne, colonne, result;
    
    sprintf (buf, mastertabs[89]);
    write_master (buf);
    sprintf (buf, "%d --> %d\n", index_image[0], index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
	flag_conv = FALSE;
        image = (float *)dir_image[index_image[0]].image;
        break;
    }

    type = dir_desc[index_image[0]].type;
    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;

    /******* TRAITEMENT ********/
    result = sym_x (image, &temp, type, colonne, ligne);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (IOplans_widget);
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)temp;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];

    if (flag_conv) 
    {
      free (image);
      flag_conv = FALSE;
    }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);    
}


/********************************************************/
/* anciennement proc_sym_y 				*/
/********************************************************/

void
IOplans_geom_symy_OK_callb(options_OK, IOplans_widget, callData)
	Widget options_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    float *image, *temp;
    int type, result;

    sprintf (buf, mastertabs[90]);
    write_master (buf);
    sprintf (buf, "%d --> %d\n", index_image[0], index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
	flag_conv = FALSE;
        image = (float *)dir_image[index_image[0]].image;
        break;
    }

    type = dir_desc[index_image[0]].type;


    /******* TRAITEMENT ********/
    result = sym_y (image, &temp, type,
		  dir_desc[index_image[0]].ncolonne,
		  dir_desc[index_image[0]].nligne);
    /***************************/

    if (result != 0)
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (IOplans_widget); 
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)temp;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    if (flag_conv) 
    {
      free (image);
      flag_conv = FALSE;
    }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);    
}



/********************************************************/
/* anciennment proc_ordr1_interp 			*/
/********************************************************/

void
IOplans_mod_enl1_OK_callb(options_OK, AUX_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * AUX_param;
	caddr_t callData;
{
    float **bc, *bcr, *interp, *p, *im;
    int d, lin, col, nlin, ncol, stpoint, i, j, l, c, llm, clm;
    struct rayon_puissan *r_p;

    r_p = (struct rayon_puissan *) malloc (sizeof (struct rayon_puissan));
    r_p->n_point = atoi (XmTextGetString (AUX_param->alpha));

    sprintf (buf, mastertabs[298]);
    write_master (buf);
    sprintf (buf, "%d --> %d", index_image[0], index_image[1]);
    write_master (buf);
    sprintf (buf, ", fact= %d\n", r_p->n_point);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    if (r_p->n_point == 0)
    {
      write_erreur(97);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        flag_conv = TRUE;
        im = (float *) conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
        break;
      case 3: 
      case 4:
      case 5:
	flag_conv = FALSE;
        im = (float *)dir_image[index_image[0]].image;
        break;
    }
    d = r_p->n_point;
    lin = (int)dir_desc[index_image[0]].nligne;
    col = (int)dir_desc[index_image[0]].ncolonne;
    bc = (float **)calloc(lin, sizeof(float *));
    for (i = 0; i < lin; i++) {
      bc[i] = (float *)calloc(col, sizeof(float));
    }
    p = im;
    for (i = 0; i < lin; i++)
    for (j = 0; j < col; j++) {
      bc[i][j] = *p;
      p++;
    }

    nlin = lin * (d + 1);		    /* new lin */
    ncol = col * (d + 1);		    /* new col */
    bcr = (float *)calloc(nlin * ncol, sizeof(float));
    dir_image[index_image[1]].image = (unsigned char *)bcr;
    interp = (float *)calloc((d + 2) * (d + 2), sizeof(float)); 
			    /* buffer of interpolation */ 
    for (i = 0; i < lin - 1; i++) {
      for (j = 0; j < col - 1; j++) {
	stpoint = i * ncol * (d + 1) + j * (d + 1);
	p = interp;
	bilinear_interp(bc[i][j],
			bc[i][j + 1],
			bc[i + 1][j + 1],
			bc[i + 1][j],
			d + 1,
			d + 1,
			interp);	/* create one block */
	if (j == col - 2) clm = d + 2;
	else clm = d + 1;
	if (i == lin - 2) llm = d + 2;
	else llm = d + 1;
	for (l = 0; l < llm; l++) {	/* insert this block */
	  for (c = 0; c < clm; c++) {
	    bcr[stpoint + c] = *p;
	    p++; 
	  }
	  if (j != col - 2) p++;
	  stpoint = stpoint + ncol;
	}
      }
    }
    free(interp);
    for (i = 0; i < lin; i++)
      free(bc[i]);
    free(bc);

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = nlin;
    dir_desc[index_image[1]].ncolonne = ncol;
    dir_desc[index_image[1]].type = 3;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    if (flag_conv)
      {
	free (im);
	flag_conv = FALSE;
      }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}


/********************************************************/
/* anciennement proc_padding 				*/
/********************************************************/

void
IOplans_mod_paddcons_OK_callb(options_OK, Paramprepro, callData)
	Widget options_OK;
        xs_struc_paramprepro *Paramprepro;
	caddr_t callData;
{
    struct paddi *pad;
    int result, colonne, ligne, type;
    float *imageIn, *imageOut;
    
    pad = (struct paddi *) malloc (sizeof (struct paddi));
    pad->ligne = atoi (XmTextGetString (Paramprepro->line));
    pad->colonne = atoi (XmTextGetString (Paramprepro->colon));
    pad->valeur = (float)atof (XmTextGetString (Paramprepro->alpha));
    pad->flag_moy = FALSE;
    pad->methode = 1;

    sprintf (buf, mastertabs[210]);
    write_master(buf);
    sprintf (buf, mastertabs[213], index_image[0], index_image[1]);
    write_master (buf);

    sprintf(buf," (%d %d %f)\n",pad->ligne,pad->colonne,pad->valeur);
    write_master (buf);

    if ((pad->ligne == 0 ) ||  (pad->colonne == 0)){
      write_erreur(99);
      free(pad);
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    type = dir_desc[index_image[0]].type;

    switch (type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
        imageIn = (float *)dir_image[index_image[0]].image;
        break;
    }

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;

    /******* TRAITEMENT ********/
    result = padding_const (imageIn, colonne, ligne, type, 
			    &imageOut, pad);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
       free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = pad->ligne;
    dir_desc[index_image[1]].ncolonne = pad->colonne;
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
            dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
            &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
            &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    free(pad);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}



void
IOplans_mod_paddpro_OK_callb(options_OK, Paramprepro, callData)
	Widget options_OK;
        xs_struc_paramprepro *Paramprepro;
	caddr_t callData;
{
    struct paddi *pad;
    int result, colonne, ligne, type;
    float *imageIn, *imageOut;

    pad = (struct paddi *) malloc (sizeof (struct paddi));
    pad->ligne = atoi (XmTextGetString (Paramprepro->line));
    pad->colonne = atoi (XmTextGetString (Paramprepro->colon));
    pad->methode = 2;

    sprintf (buf, mastertabs[211]);
    write_master(buf);
    sprintf (buf, mastertabs[213], index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf," %d %d\n", pad->ligne, pad->colonne);
    write_master (buf);

    if ((pad->ligne == 0 ) ||  (pad->colonne == 0)){
      write_erreur(99);
      free(pad);
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    type = dir_desc[index_image[0]].type;

    switch (type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
        imageIn = (float *)dir_image[index_image[0]].image;
        break;
    }

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;

    /******* TRAITEMENT ********/
    result = padding_prolong (imageIn, colonne, ligne, type, 
			      &imageOut, pad);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (XtParent (XtParent (options_OK)));  
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
       free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = pad->ligne;
    dir_desc[index_image[1]].ncolonne = pad->colonne;
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
            dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
            &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
            &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    free(pad);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}



void
IOplans_mod_paddper_OK_callb(options_OK, Paramprepro, callData)
	Widget options_OK;
        xs_struc_paramprepro *Paramprepro;
	caddr_t callData;
{
    struct paddi *pad;
    int result, type, ligne, colonne;
    float *imageIn, *imageOut;
    
    pad = (struct paddi *) malloc (sizeof (struct paddi));
    pad->ligne = atoi (XmTextGetString (Paramprepro->line));
    pad->colonne = atoi (XmTextGetString (Paramprepro->colon));
    pad->methode = 3;

    sprintf (buf, mastertabs[212]);
    write_master(buf);
    sprintf (buf, mastertabs[213], index_image[0], index_image[1]);
    write_master (buf);

    sprintf (buf," %d %d\n", pad->ligne, pad->colonne);
    write_master (buf);

    if ((pad->ligne == 0 ) ||  (pad->colonne == 0)){
      write_erreur(99);
      free(pad);
      return;
    }
    
    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    type = dir_desc[index_image[0]].type;

    switch (type){
      case -1:
      case 0:
      case 1:
      case 2:
      case 3: 
      case 4:
      case 5:
        imageIn = (float *)dir_image[index_image[0]].image;
        break;
    }

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    
    /******* TRAITEMENT ********/
    result = padding_period (imageIn, colonne, ligne, type, 
			     &imageOut, pad);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
        free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = pad->ligne;
    dir_desc[index_image[1]].ncolonne = pad->colonne;
    statis (dir_image[index_image[1]].image, 
	    dir_desc[index_image[1]].type, 
            dir_desc[index_image[1]].nligne, 
	    dir_desc[index_image[1]].ncolonne,
            &(dir_desc[index_image[1]].mmin), 
	    &(dir_desc[index_image[1]].mmax), 
            &(dir_desc[index_image[1]].mu), 
	    &(dir_desc[index_image[1]].ecart));

    free(pad);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}


/********************************************************/
/* anciennement proc_bruit 				*/
/********************************************************/

void 
IOplans_mod_noi_OK_callb(options_OK, AUX_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * AUX_param;
	caddr_t callData;
{
    unsigned char *image;
    struct noise *noisy;
    int ligne, colonne, unif_gauss, result;
    unsigned char *imageOut;
    
    unif_gauss = AUX_param->type_operation;
    
    noisy = (struct noise *) malloc (sizeof (struct noise));
    noisy->esp = atof (XmTextGetString (AUX_param->line));
    noisy->var = atof (XmTextGetString (AUX_param->colon));

    if (unif_gauss) sprintf (buf,mastertabs[14]);
    else sprintf (buf,mastertabs[15]);
    write_master (buf);
    sprintf (buf,"Image %d --> Image %d :",index_image[0],index_image[1]); 
    write_master (buf);

    if (unif_gauss)      /* si unif_gauss <> 0 => bruit gaussien */
    {
      sprintf (buf, mastertabs[16], (int)rint(noisy->esp), 
	       (int) rint (noisy->var));
      write_master (buf);
    }	
    else                       /* bruit uniforme */
    {
      sprintf (buf,mastertabs[17],
	       (int) rint(noisy->esp),(int) rint (noisy->var));
      write_master (buf);
    }
    
    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    image = (unsigned char *) dir_image[index_image[0]].image;

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    
    /******* TRAITEMENT ********/
    result = gen_bruit (image, &imageOut, unif_gauss, 
			dir_desc[index_image[0]].type, colonne, ligne, noisy);
    /***************************/

    dir_image[index_image[1]].image = (unsigned char *) imageOut;

    /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = dir_desc[index_image[0]].nligne;
    dir_desc[index_image[1]].ncolonne = dir_desc[index_image[0]].ncolonne;
    if (dir_desc[index_image[0]].type <= 2)
      dir_desc[index_image[1]].type = 2;
    else
      dir_desc[index_image[1]].type =3;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &dir_desc[index_image[1]].mmin,
	    &dir_desc[index_image[1]].mmax,
	    &dir_desc[index_image[1]].mu,
	    &dir_desc[index_image[1]].ecart);
    free(noisy);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}


/********************************************************/
/* anciennement proc_cut 				*/
/********************************************************/

void 
IOplans_mod_cut_OK_callb(options_OK, AUX_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * AUX_param;
	caddr_t callData;
{
    struct cut_s   *ccut_s;
    int ZMin, ZMax, type, ligne, colonne, result;
    unsigned char *imageIn, *imageOut;

    sprintf(buf, mastertabs[119]);
    write_master(buf);

    sprintf(buf, "%d --> %d", index_image[0], index_image[1]);
    write_master(buf);

    ccut_s = (struct cut_s *) malloc (sizeof (struct cut_s));
    ccut_s->XMin = atoi (XmTextGetString (AUX_param->line));
    ccut_s->YMin = atoi (XmTextGetString (AUX_param->colon));
    ccut_s->XMax = atoi (XmTextGetString (AUX_param->alpha));
    ccut_s->YMax = atoi (XmTextGetString (AUX_param->diameter));

    sprintf(buf, mastertabs[120],
	    ccut_s->XMin, ccut_s->YMin,
	    ccut_s->XMax, ccut_s->YMax);
    write_master(buf);

    if (dir_desc[index_image[0]].type < 0)
    {
      write_erreur(910);
      return;
    }
    if (dir_desc[index_image[0]].type > 3)
    {
      write_erreur(911);
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    /******* TRAITEMENT ********/
    Order_Min_Max(&ccut_s->XMin,&ccut_s->XMax);
    /***************************/

    ccut_s->XMin = max(0, ccut_s->XMin);
    ccut_s->XMax = min(dir_desc[index_image[0]].ncolonne, ccut_s->XMax);

    /******* TRAITEMENT ********/
    Order_Min_Max(&ccut_s->YMin,&ccut_s->YMax);
    /***************************/

    ccut_s->YMin = max(0, ccut_s->YMin);
    ccut_s->YMax = min(dir_desc[index_image[0]].nligne, ccut_s->YMax);

   /* recopie globale du descripteur */
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].ncolonne = ccut_s->XMax - ccut_s->XMin;
    dir_desc[index_image[1]].nligne = ccut_s->YMax - ccut_s->YMin;

    imageIn = (unsigned char *)dir_image[index_image[0]].image;

    type = dir_desc[index_image[0]].type;
    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    
    /******* TRAITEMENT ********/
    result = ccut(imageIn, &imageOut, type, colonne, ligne, ccut_s);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }   
    if (dir_image[index_image[1]].image != NULL)
	free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;
    statis(dir_image[index_image[1]].image,
	   dir_desc[index_image[1]].type,
	   dir_desc[index_image[1]].nligne,
	   dir_desc[index_image[1]].ncolonne,
	   &(dir_desc[index_image[1]].mmin),
	   &(dir_desc[index_image[1]].mmax),
	   &(dir_desc[index_image[1]].mu),
	   &(dir_desc[index_image[1]].ecart));

    free(ccut_s);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));  
}


/********************************************************/
/* anciennement proc_bandes 				*/
/********************************************************/

void 
IOplans_gen_band_OK_callb(options_OK, nb_bandes, callData)
	Widget options_OK;
        int nb_bandes;
	caddr_t callData;
{
    unsigned char *image;
    int result;

    sprintf (buf, mastertabs[7], nb_bandes);
    write_master (buf);
    sprintf (buf, "--> %d\n", index_image[1]);
    write_master (buf);

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    /******* TRAITEMENT ********/
    result = gen_bandes (&image, nb_bandes);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));	
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));      
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;
    }
    
    if (dir_image[index_image[1]].image != NULL)
       free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = image;

    dir_desc[index_image[1]].type = 0;
    dir_desc[index_image[1]].nligne = dir_desc[index_image[1]].ncolonne = 256;
    strcpy (dir_desc[index_image[1]].date, "");
    sprintf (dir_desc[index_image[1]].filename, "-%d bandes-", nb_bandes);
    statis (dir_image[index_image[1]].image,
            dir_desc[index_image[1]].type,
            dir_desc[index_image[1]].nligne,
            dir_desc[index_image[1]].ncolonne,
            &(dir_desc[index_image[1]].mmin),
            &(dir_desc[index_image[1]].mmax),
            &(dir_desc[index_image[1]].mu),
            &(dir_desc[index_image[1]].ecart));


    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));    
}


/********************************************************/
/* anciennement proc_copie 				*/
/********************************************************/

void
IOplans_copyplane_OK_callb(IOplans_widget_OK, IOplans_widget, callData)
	Widget IOplans_widget_OK;
	Widget IOplans_widget;
	caddr_t callData;
{
    unsigned char *imdep, *imarr, *temp;
    int taille;
    register int i;

    sprintf (buf, mastertabs[6]);
    write_master (buf);

    sprintf (buf," %d --> %d\n\0",index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), gWatchcursor);
    XFlush(gDisplay);

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    taille = dir_desc[index_image[0]].ncolonne * 
               dir_desc[index_image[0]].nligne *
	       element(dir_desc[index_image[0]].type);
    temp = imarr = (unsigned char *) malloc (taille);
    imdep = dir_image[index_image[0]].image;
    for (i=0; i<taille; i++){
      *imarr = *imdep;
      imarr++;  imdep++;
    }
    if (dir_image[index_image[1]].image != NULL)
         free (dir_image[index_image[1]].image); 
    dir_image[index_image[1]].image = temp;

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}


void
IOplans_thres_save_OK_callb(IOplans_widget_OK, data_display, callData)
	Widget IOplans_widget_OK;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  XImage *xi;
  int ligne, colonne, taille, valthr;
  register int x, y;
  unsigned char *image, *debut;

  valthr = atoi (XmTextGetString (data_display->Thresh_text));

  sprintf(buf, mastertabs[316], valthr, index_image[1]);
  write_master(buf);

  XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
  XDefineCursor(gDisplay, 
		XtWindow(XtParent (XtParent (IOplans_widget_OK))), 
		gWatchcursor);
  XFlush(gDisplay);

  ligne = data_display->im_desc->nligne;
  colonne = data_display->im_desc->ncolonne;
  taille = ligne * colonne;
 
  xi = XGetImage(gDisplay, data_display->ret->pixmap, 0, 0, 
		 data_display->ret->width, data_display->ret->height, 
		 AllPlanes, ZPixmap);

  debut = image = (unsigned char *)malloc (taille);   

  for ( y = 0 ; y < ligne ; y++) 
    for ( x = 0 ; x < colonne; x++) {
      if (XGetPixel(xi, x, y)>= valthr ) *image = 255;
      else *image = 0;
      image++;
    }

  XDestroyImage(xi);

  if (dir_image[index_image[1]].image != NULL)
    free(dir_image[index_image[1]].image);
  dir_image[index_image[1]].image = debut;
  dir_desc[index_image[1]].nligne = ligne;
  dir_desc[index_image[1]].ncolonne = colonne;
  strcpy (dir_desc[index_image[1]].filename, data_display->im_desc->filename);
  strcpy (dir_desc[index_image[1]].comment, data_display->im_desc->comment);
  dir_desc[index_image[1]].type = -1;

  statis (dir_image[index_image[1]].image, 
	  dir_desc[index_image[1]].type, 
	  dir_desc[index_image[1]].nligne, 
	  dir_desc[index_image[1]].ncolonne,
	  &(dir_desc[index_image[1]].mmin), 
	  &(dir_desc[index_image[1]].mmax),
	  &(dir_desc[index_image[1]].mu),
	  &(dir_desc[index_image[1]].ecart));

  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
  XUndefineCursor(gDisplay, 
		  XtWindow(XtParent (XtParent (IOplans_widget_OK))));
  XtUnmanageChild (XtParent (XtParent (IOplans_widget_OK)));
}


void
IOplans_pixeledit_save_OK_callb(IOplans_widget_OK, data_display, callData)
	Widget IOplans_widget_OK;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  int x, y;
  XImage *xi;
  unsigned char *image_temp;

  sprintf (buf," --> %d\n\0", index_image[1]);
  write_master (buf);

  if (dir_image[index_image[1]].image != NULL)
         free (dir_image[index_image[1]].image); 

  dir_image[index_image[1]].image = (unsigned char *) malloc (data_display->ret->width * data_display->ret->height);
  strcpy(dir_desc[index_image[1]].filename, data_display->im_desc->filename);
  strcpy(dir_desc[index_image[1]].comment, data_display->im_desc->comment);
  dir_desc[index_image[1]].nligne = data_display->ret->height ;
  dir_desc[index_image[1]].ncolonne = data_display->ret->width ;
  dir_desc[index_image[1]].type = 0 ;	
	
  image_temp = dir_image[index_image[1]].image ;

  xi = XGetImage(gDisplay, data_display->ret->pixmap, 0, 0, 
		 data_display->ret->width, data_display->ret->height, 
		 AllPlanes, ZPixmap);

  for (y = 0 ; y < data_display->ret->height ; y++) 
    for (x = 0 ; x < data_display->ret->width ; x++)
    {
      *image_temp = XGetPixel(xi, x, y) ;
      image_temp++ ;
    }

  statis(dir_image[index_image[1]].image,
	 dir_desc[index_image[1]].type,
	 dir_desc[index_image[1]].nligne,
	 dir_desc[index_image[1]].ncolonne,
	 &(dir_desc[index_image[1]].mmin),  
	 &(dir_desc[index_image[1]].mmax),  
	 &(dir_desc[index_image[1]].mu),  
	 &(dir_desc[index_image[1]].ecart)) ;

  XtUnmanageChild (XtParent (XtParent (IOplans_widget_OK)));
  XDestroyImage(xi);
}



void
IOplans_mapedit_display_save_OK_callb(IOplans_widget_OK, data_display, callData)
	Widget IOplans_widget_OK;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  int x, y;
  XImage *xi;
  unsigned char value, *image_tempR, *image_tempG, *image_tempB;

  sprintf (buf," --> %d %d %d\n\0",
	   index_image[1],index_image[3], index_image[5]);
  write_master (buf);

  if (dir_image[index_image[1]].image != NULL)
         free (dir_image[index_image[1]].image); 
  if (dir_image[index_image[3]].image != NULL)
         free (dir_image[index_image[3]].image); 
  if (dir_image[index_image[5]].image != NULL)
         free (dir_image[index_image[5]].image); 

  dir_image[index_image[1]].image = (unsigned char *) malloc (data_display->ret->width * data_display->ret->height);
  dir_image[index_image[3]].image = (unsigned char *) malloc (data_display->ret->width * data_display->ret->height);
  dir_image[index_image[5]].image = (unsigned char *) malloc (data_display->ret->width * data_display->ret->height);

  dir_desc[index_image[1]].nligne = data_display->ret->height;
  dir_desc[index_image[1]].ncolonne = data_display->ret->width;
  dir_desc[index_image[1]].type = 0;	
  dir_desc[index_image[3]].nligne = data_display->ret->height;
  dir_desc[index_image[3]].ncolonne = data_display->ret->width;
  dir_desc[index_image[3]].type = 0;
  dir_desc[index_image[5]].nligne = data_display->ret->height;
  dir_desc[index_image[5]].ncolonne = data_display->ret->width;
  dir_desc[index_image[5]].type = 0;

  xi = XGetImage(gDisplay, data_display->ret->pixmap, 0, 0, 
		 data_display->ret->width, data_display->ret->height, 
		 AllPlanes, ZPixmap);

  image_tempR = dir_image[index_image[1]].image ;
  image_tempG = dir_image[index_image[3]].image ;
  image_tempB = dir_image[index_image[5]].image ;

  for (y = 0 ; y < data_display->ret->height ; y++) 
    for (x = 0 ; x < data_display->ret->width ; x++)
    {
      value = XGetPixel(xi, x, y);
      *image_tempR = mapedit_red[value];
      image_tempR++ ;
      *image_tempG = mapedit_green[value];
      image_tempG++ ;
      *image_tempB = mapedit_blue[value];
      image_tempB++ ;
    }

 /* Mapedit_colormap */

  statis(dir_image[index_image[1]].image,
	 dir_desc[index_image[1]].type,
	 dir_desc[index_image[1]].nligne,
	 dir_desc[index_image[1]].ncolonne,
	 &(dir_desc[index_image[1]].mmin),  
	 &(dir_desc[index_image[1]].mmax),  
	 &(dir_desc[index_image[1]].mu),  
	 &(dir_desc[index_image[1]].ecart)) ;
  statis(dir_image[index_image[3]].image,
	 dir_desc[index_image[3]].type,
	 dir_desc[index_image[3]].nligne,
	 dir_desc[index_image[3]].ncolonne,
	 &(dir_desc[index_image[3]].mmin),  
	 &(dir_desc[index_image[3]].mmax),  
	 &(dir_desc[index_image[3]].mu),  
	 &(dir_desc[index_image[3]].ecart)) ;
  statis(dir_image[index_image[5]].image,
	 dir_desc[index_image[5]].type,
	 dir_desc[index_image[5]].nligne,
	 dir_desc[index_image[5]].ncolonne,
	 &(dir_desc[index_image[5]].mmin),  
	 &(dir_desc[index_image[5]].mmax),  
	 &(dir_desc[index_image[5]].mu),  
	 &(dir_desc[index_image[5]].ecart)) ;

  XtUnmanageChild (XtParent (XtParent (IOplans_widget_OK)));
  XDestroyImage(xi);
}



void 
Image_generation_save_OK_callb(options_OK, IOplans_widget, callData)
	Widget options_OK;
        Widget IOplans_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(IOplans_widget), gWatchcursor);
    XFlush(gDisplay);

    sauve_im_ds_plan();
   
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(IOplans_widget));
    XtUnmanageChild (IOplans_widget);
}
