/* SCCS @(#)RegionInterestmenu.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   RegionInterestmenu.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   RegionInterestmenu.layout.c                         */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display ROI)                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "RegionInterestmenu.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern Pixel      gthistle;

extern char *roitabs[];


Widget
build_create(Interest_Menu)
    Widget Interest_Menu;
{
        Widget Frame_Type;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Type Widget */ 

	Frame_Type = XmCreateFrame(Interest_Menu,"Frame_Type", NULL, 0);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,2); n++;

	RadioBox = XmCreateRadioBox(Frame_Type,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;

	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);

	/* Adding Callbacks for RadioButton_1 */ 
	
	XtAddCallback(RadioButton_1,XmNvalueChangedCallback, Create_without_zone, NULL);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, Create_with_zone, NULL);

	XtManageChild(RadioButton_2);


	return (Frame_Type);
}



Widget
build_show(Interest_Menu, data_display)
    Widget Interest_Menu;
    xs_struc_display_menu * data_display;
{
        Widget Frame_Type;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Widget RadioButton_4;
	Widget RadioButton_5;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Type Widget */ 

	Frame_Type = XmCreateFrame(Interest_Menu,"Frame_Type",NULL, 0);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;
	XtSetArg(args[n],XmNnumColumns,2); n++;

	RadioBox = XmCreateRadioBox(Frame_Type,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[8],  
			XmSTRING_DEFAULT_CHARSET)); n++;
	
	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);


	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback,
			Show_image_mask_actcall,data_display);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[9],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);


	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
		      Show_image_actcall,data_display);

	XtManageChild(RadioButton_2);


	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox,"RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
		      Show_two_actcall,data_display);

	XtManageChild(RadioButton_3);


	/* Creating RadioButton_4 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_4 = XmCreateToggleButton(RadioBox,"RadioButton_4",args,n);

	/* Adding Callbacks for RadioButton_4 */ 

	XtAddCallback(RadioButton_4,XmNvalueChangedCallback,
		      Show_mask_actcall,data_display);

	XtManageChild(RadioButton_4);


	/* Creating RadioButton_5 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;

	RadioButton_5 = XmCreateToggleButton(RadioBox,"RadioButton_5",args,n);


	/* Adding Callbacks for RadioButton_5 */ 

	XtAddCallback(RadioButton_5,XmNvalueChangedCallback,
		      Show_original_actcall,data_display);

	XtManageChild(RadioButton_5);

	return (Frame_Type);
}


Widget
build_histogram(Interest_Menu)
    Widget Interest_Menu;
{
        Widget Frame_Type;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Type Widget */ 

	Frame_Type = XmCreateFrame(Interest_Menu,"Frame_Type",NULL,0);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,2); n++;

	RadioBox = XmCreateRadioBox(Frame_Type,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback, 
		      Show_histo_region_actcall, NULL);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[12],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, 
		      Show_histo_border_actcall, NULL);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[15],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox,"RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback, 
		      Show_histo_image_actcall, NULL);

	XtManageChild(RadioButton_3);


	return (Frame_Type);
}




Widget
build_stat(Interest_Menu)
    Widget Interest_Menu;
{
        Widget Frame_Type;
	Widget RadioBox;
	Widget RadioButton_1;
	Widget RadioButton_2;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_Type Widget */ 

	Frame_Type = XmCreateFrame(Interest_Menu,"Frame_Type",NULL,0);

	/* Creating RadioBox Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNnumColumns,2); n++;

	RadioBox = XmCreateRadioBox(Frame_Type,"RadioBox",args,n);

  	XtManageChild(RadioBox);

	/* Creating RadioButton_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_1 = XmCreateToggleButton(RadioBox,"RadioButton_1",args,n);

	/* Adding Callbacks for RadioButton_1 */ 

	XtAddCallback(RadioButton_1,XmNvalueChangedCallback, 
		      Pixrect_stat_region_actcall, NULL);

	XtManageChild(RadioButton_1);

	/* Creating RadioButton_2 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[12],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox,"RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, 
		      Pixrect_stat_border_actcall, NULL);

	XtManageChild(RadioButton_2);

	return (Frame_Type);
}



Widget
build_RegionInterest_Menu(RegionInterest, data_display)
	Widget RegionInterest;
	xs_struc_display_menu * data_display;
{
	Widget menuform;
	Widget Interest_Menu;
	Widget Interest_menu_label;
	Widget Separator_12;
	Widget Create;
	Widget Frame_create;
	Widget Show;
	Widget Frame_show;
	Widget Show_histo;
	Widget Frame_histogram;
	Widget Stat;
	Widget Frame_stat;
	Widget separator;
	Widget command;
	Widget LOAD;
	Widget SAVE;
	Widget QUIT;
        char titlewindow[50];
	Arg args[MAX_ARGS];
	int n;


	n = 0;
        sprintf(titlewindow, roitabs[0]);
        XtSetArg(args[n], XmNtitle, titlewindow); n++;
	XtSetArg(args[n], XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n], XmNwidth, 300);n++;
	XtSetArg(args[n], XmNheight, 350);n++;
	menuform = XmCreateFormDialog(RegionInterest, "menuform", args, n);

	/* Creating command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	command = XmCreateForm(menuform,"command",args,n);
	XtManageChild(command);

	/* Creating LOAD Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[16],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,28); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;

	LOAD = XmCreatePushButton(command, "LOAD",args,n);
	XtManageChild(LOAD);

	/* Adding Callbacks for LOAD */ 

	XtAddCallback(LOAD,
	   XmNactivateCallback,Read_zone_actcall, data_display);

	/* Creating SAVE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[14],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,37); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,63); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;

	SAVE = XmCreatePushButton(command, "SAVE",args,n);
	XtManageChild(SAVE);

	/* Adding Callbacks for SAVE */ 

	XtAddCallback(SAVE,
	   XmNactivateCallback, Save_display_actcall, data_display);


	/* Creating QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[17],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,72); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,98); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 20); n++;

	QUIT = XmCreatePushButton(command,"QUIT",args,n);
	XtManageChild(QUIT);

	/* Adding Callbacks for QUIT */ 

	XtAddCallback(QUIT,
	   XmNactivateCallback,QUIT_region_actcall, data_display);
	XtAddCallback(QUIT,
	   XmNactivateCallback, keep_sensitive_button, RegionInterest);

	/* Creating separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	separator = 
	  XmCreateSeparator(menuform, "separator",args,n);

	XtManageChild(separator);


	/* Creating Interest_Menu Widget */ 
	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNbottomWidget, separator);n++;
	Interest_Menu = XmCreateForm(menuform,"Interest_Menu",args, n);
	XtManageChild(Interest_Menu);

	/* Creating Interest_menu_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
        XtSetArg(args[n],XmNlabelString,
             XmStringLtoRCreate(data_display->im_desc->filename,
                        XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;

	Interest_menu_label = 
	  XmCreateLabel(Interest_Menu,"Interest_menu_label",args,n);
	XtManageChild(Interest_menu_label);

	/* Creating Separator_12 Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Interest_menu_label);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	Separator_12 = XmCreateSeparator(Interest_Menu,"Separator_12",args,n);
	XtManageChild(Separator_12);

	/* Creating Create Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNtopPosition, 12);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition, 29); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 2); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;

	Create = 
	    XmCreatePushButton(Interest_Menu,"Create",args,n);
	XtManageChild(Create);

	/* Adding Callbacks for Create */ 

	XtAddCallback(Create,
		XmNactivateCallback,Create_zone_actcall, data_display);

	Frame_create = build_create(Interest_Menu);

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Separator_12);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 31);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	XtSetValues(Frame_create,args,n);
	XtManageChild(Frame_create);
	
	/* Creating Show Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNtopPosition, 40);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition, 29);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 2); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	Show = XmCreateLabel(Interest_Menu,"Show",args,n);
	XtManageChild(Show);

	Frame_show = build_show(Interest_Menu, data_display);
	
	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Frame_create);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 31);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	XtSetValues (Frame_show,args,n);
	XtManageChild(Frame_show);

	/* Creating Show_histo Widget */ 

	n = 0;
	XtSetArg( args[n], XmNwidth, 130);n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[10],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNtopPosition, 64);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition, 29);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 2); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	Show_histo = XmCreatePushButton(Interest_Menu,"Show_histo",args,n);
	XtManageChild(Show_histo);

	/* Adding Callbacks for Show_histo */ 

	XtAddCallback(Show_histo,XmNactivateCallback,
		      Show_histo_actcall, data_display);

	Frame_histogram = build_histogram(Interest_Menu);
		
	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Frame_show);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 31);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	XtSetValues (Frame_histogram,args,n);
	XtManageChild(Frame_histogram);

	/* Creating Stat Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 130);n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(roitabs[13],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNtopPosition, 85);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition, 29);n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 2); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	Stat = XmCreatePushButton(Interest_Menu,"Stat",args,n);
	XtManageChild(Stat);

	/* Adding Callbacks for Stat */ 

	XtAddCallback(Stat, XmNactivateCallback, 
		      Pixrect_stat_actcall,data_display);

	Frame_stat = build_stat(Interest_Menu);
	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNtopWidget, Frame_histogram);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 31);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE);n++;
	XtSetValues (Frame_stat,args,n);
	XtManageChild(Frame_stat);
	
	return(menuform);
}
