;**************************************************************************
;** varenv.cl                                                            **
;**  Definition de variables d'environnement                             **
;**************************************************************************
(defvar *base-en-parallel* nil)
(defvar *psy-binding*)   ; binding courant
(defvar *psy-db*)        ; base courante
(defvar *psy-name-db*)   ; nom de la base courante


(defvar *psy-execreg*)   ; flag qui indique qu'on est en train d'executer 
                         ; une regle
(defvar *psy-halt*)      ; flag indiquant l'arret du systeme

(defvar *psy-just-point*)  ; pointeur vers la justification de la regle
                           ; qui vient d'etre execute
(defvar *psy-runbase*)     ; flag qui indique si on execute une base
(defvar *psy-autorun*)     ; flag= t indique que si on rentre un fait a la 
                           ; main le systeme tourne automatiquement, si 
                           ; non il faut taper (run)
(defvar *psy-paths*)       ; variable auxiliere
(defvar *psy-root*)        ; racine du reseau de la base courante
(defvar *psy-trace*)       ; flag qui indique si a une trace d'execution
(defvar *psy-var-env* )    ; variables d'environnement pour l'execution
                           ; en multitraitement
(defvar *psy-var-fen* nil) ; Cette variable indique si le systeme tourne
                           ; avec le systeme de fenetres ou non
(defvar *system-production-error* nil)

(setq *psy-var-env*  (list* (cons '*break-on-warnings* '*break-on-warnings*)
                            (cons '*RANDOM-STATE* `',*RANDOM-STATE*)
                            (cons '*standard-output* `',*standard-output*)
                            (cons '*standard-input* `',*standard-input*)
                            (cons '*readtable* `',*readtable*)
                            ()))
 

                            
                            
                            
 

(defun init-psycho()
   (setq *psy-autorun* nil
         *psy-db* nil
         *psy-root* nil
         *psy-trace* t
         *psy-halt* nil
         *psy-execreg* nil
         *psy-binding* nil
         *psy-runbase* nil)
      (setf (symbol-plist '*rules*) nil)
      (setf (symbol-plist '*psy-kb*) nil)
      (setf (symbol-plist '*psy-controle*) nil)
      (setf (symbol-plist '*psy-exec-para*) nil))


(require 'flavors)
(use-package :flavors)

