/* Date :17/11/93                                          */
/* Description of DLXMs Data-Path in C, for use with FPGEN */
/* Ordonnance des colonnes */
/* Ajout du exit 0 a la fin */
/* Changement pour que dpr passe ... ? moi je ne sais pas ce que c'est ! */

#include <genlib.h>
#include <fpgen.h>


main()
{

 DP_DEFLOFIG("dlxm_dpt",32,LSB_INDEX_ZERO,TERMINAL);

/* Interface Declaration */

/* Control Connectors of Registers PC, IAR, IR, DT, AD */

printf( "Interface\n" );

DP_LOCON ( "vdd",IN,"vdd",DEFAULT_SIDE);
DP_LOCON ( "vss",IN,"vss",DEFAULT_SIDE);


DP_LOCON ( "pc_test",IN,"pc_test",DEFAULT_SIDE );
DP_LOCON ( "ad_test",IN,"ad_test",DEFAULT_SIDE );
DP_LOCON ( "tvr_test",IN,"tvr_test",DEFAULT_SIDE );
DP_LOCON ( "iar_test",IN,"iar_test",DEFAULT_SIDE );
DP_LOCON ( "sr_test",IN,"sr_test",DEFAULT_SIDE );
DP_LOCON ( "ir_test",IN,"ir_test",DEFAULT_SIDE );
DP_LOCON ( "dt_test",IN,"dt_test",DEFAULT_SIDE );


/* Scan-Path Connectors */

DP_LOCON ( "pc_scin",IN,"pc_scin",DEFAULT_SIDE );
DP_LOCON ( "ad_scin",IN,"ad_scin",DEFAULT_SIDE );
DP_LOCON ( "tvr_scin",IN,"tvr_scin",DEFAULT_SIDE );
DP_LOCON ( "iar_scin",IN,"iar_scin",DEFAULT_SIDE );
DP_LOCON ( "sr_scin",IN,"sr_scin",DEFAULT_SIDE );
DP_LOCON ( "ir_scin",IN,"ir_scin",DEFAULT_SIDE );
DP_LOCON ( "dt_scin",IN,"dt_scin",DEFAULT_SIDE );
DP_LOCON ( "pc_scout",OUT,"pc_scout",DEFAULT_SIDE );
DP_LOCON ( "ad_scout",OUT,"ad_scout",DEFAULT_SIDE );
DP_LOCON ( "tvr_scout",OUT,"tvr_scout",DEFAULT_SIDE );
DP_LOCON ( "iar_scout",OUT,"iar_scout",DEFAULT_SIDE );
DP_LOCON ( "sr_scout",OUT,"sr_scout",DEFAULT_SIDE );
DP_LOCON ( "ir_scout",OUT,"ir_scout",DEFAULT_SIDE );
DP_LOCON ( "dt_scout",OUT,"dt_scout",DEFAULT_SIDE );

/* Clock Connectors */

DP_LOCON ( "pc_ck",IN,"pc_ck",DEFAULT_SIDE );
DP_LOCON ( "ad_ck",IN,"ad_ck",DEFAULT_SIDE );
DP_LOCON ( "tvr_ck",IN,"tvr_ck",DEFAULT_SIDE );
DP_LOCON ( "iar_ck",IN,"iar_ck",DEFAULT_SIDE );
DP_LOCON ( "sr_ck",IN,"sr_ck",DEFAULT_SIDE );
DP_LOCON ( "ir_ck",IN,"ir_ck",DEFAULT_SIDE );
DP_LOCON ( "dt_ck",IN,"dt_ck",DEFAULT_SIDE );

/* Write enable, active in normal mode ( enbl at '1' ) */

DP_LOCON ( "pc_wen",IN,"pc_wen",DEFAULT_SIDE );
DP_LOCON ( "ad_wen",IN,"ad_wen",DEFAULT_SIDE );
DP_LOCON ( "tvr_wen",IN,"tvr_wen",DEFAULT_SIDE );
DP_LOCON ( "iar_wen",IN,"iar_wen",DEFAULT_SIDE );
DP_LOCON ( "sr_wen",IN,"sr_wen",DEFAULT_SIDE );
DP_LOCON ( "ir_wen",IN,"ir_wen",DEFAULT_SIDE );
DP_LOCON ( "dt_wen",IN,"dt_wen",DEFAULT_SIDE );

/* Control Connectors of the register file */

DP_LOCON ( "rf_ck",IN,"rf_ck",NORTH_SIDE );
DP_LOCON ( "rf_wen",IN,"rf_wen",NORTH_SIDE );
DP_LOCON ( "rf_aw[4:0]",IN,"rf_aw[4:0]",NORTH_SIDE );
DP_LOCON ( "rf_ar[4:0]",IN,"rf_ar[4:0]",NORTH_SIDE );

/* Control connectors of the SR block and flags to write in SR from CTRL */

DP_LOCON ( "sr_mx",IN,"sr_mx",DEFAULT_SIDE );
DP_LOCON ( "sr_mode",OUT,"sr_mode",NORTH_SIDE );
DP_LOCON ( "sr_mask",OUT,"sr_mask",NORTH_SIDE );
DP_LOCON ( "sr_reset",IN,"sr_reset",NORTH_SIDE );
DP_LOCON ( "sr_iav",IN,"sr_iav",NORTH_SIDE );
DP_LOCON ( "sr_ico",IN,"sr_ico",NORTH_SIDE );
DP_LOCON ( "sr_dav",IN,"sr_dav",NORTH_SIDE );
DP_LOCON ( "sr_ovr",IN,"sr_ovr",NORTH_SIDE );
DP_LOCON ( "sr_it0",IN,"sr_it0",NORTH_SIDE );

DP_LOCON ( "sr_it1",IN,"sr_it1",NORTH_SIDE );
DP_LOCON ( "sr_it2",IN,"sr_it2",NORTH_SIDE );
DP_LOCON ( "sr_it3",IN,"sr_it3",NORTH_SIDE );

/* Control Connectors of X multiplexer and sign of X */

DP_LOCON ( "opx_ts4",IN,"opx_ts4",DEFAULT_SIDE );
DP_LOCON ( "opx_ts3",IN,"opx_ts3",DEFAULT_SIDE );
DP_LOCON ( "opx_ts2",IN,"opx_ts2",DEFAULT_SIDE );
DP_LOCON ( "opx_ts1",IN,"opx_ts1",DEFAULT_SIDE );
DP_LOCON ( "opx_ts0",IN,"opx_ts0",DEFAULT_SIDE );
DP_LOCON ( "opx_mx4",IN,"opx_mx4",DEFAULT_SIDE );
DP_LOCON ( "opx_mx3",IN,"opx_mx3",DEFAULT_SIDE );
DP_LOCON ( "opx_mx2",IN,"opx_mx2",DEFAULT_SIDE );
DP_LOCON ( "opx_mx1",IN,"opx_mx1",DEFAULT_SIDE );
DP_LOCON ( "opx_sign",OUT,"opx_sign",NORTH_SIDE );

/* Control Connectors of Y multiplexer and byte selection */

DP_LOCON ( "opy_ts4",IN,"opy_ts4",DEFAULT_SIDE );
DP_LOCON ( "opy_ts3",IN,"opy_ts3",DEFAULT_SIDE );
DP_LOCON ( "opy_ts2",IN,"opy_ts2",DEFAULT_SIDE );
DP_LOCON ( "opy_ts1",IN,"opy_ts1",DEFAULT_SIDE );
DP_LOCON ( "opy_mx4",IN,"opy_mx4",DEFAULT_SIDE );
DP_LOCON ( "opy_mx3",IN,"opy_mx3",DEFAULT_SIDE );
DP_LOCON ( "opy_mx2",IN,"opy_mx2",DEFAULT_SIDE );
DP_LOCON ( "opy_mx1",IN,"opy_mx1",DEFAULT_SIDE );

DP_LOCON ( "opy_byte",IN,"opy_byte",DEFAULT_SIDE );
DP_LOCON ( "opy_rb1",IN,"opy_rb1",DEFAULT_SIDE );
DP_LOCON ( "opy_rb0",IN,"opy_rb0",DEFAULT_SIDE );

/* FielDEFAULT_SLICE of the IR register */

DP_LOCON ( "opy_codop[5:0]",OUT,"opy_codop[5:0]",NORTH_SIDE );
DP_LOCON ( "opy_rs[4:0]",OUT,"opy_rs[4:0]",NORTH_SIDE );
DP_LOCON ( "opy_rdrt[4:0]",OUT,"opy_rdrt[4:0]",NORTH_SIDE );
DP_LOCON ( "opy_rd[4:0]",OUT,"opy_rd[4:0]",NORTH_SIDE );
DP_LOCON ( "opy_tvr",OUT,"opy_tvr",NORTH_SIDE );
DP_LOCON ( "opy_sr",OUT,"opy_sr",NORTH_SIDE );
DP_LOCON ( "opy_iar",OUT,"opy_iar",NORTH_SIDE );

/*  sign of Y operand ( opy_out[31] ) */

DP_LOCON ( "opy_sign",OUT,"opy_sign",NORTH_SIDE );

/* Main data bus input from rhe plots */

DP_LOCON ( "data_in_n[31:0]",IN,"data_in_n[31:0]",WEST_SIDE );

/* Control connectors of ALU multiplexer */

DP_LOCON ( "alu_mx4i0",IN,"alu_mx4i0",DEFAULT_SIDE );
DP_LOCON ( "alu_mx3i0",IN,"alu_mx3i0",DEFAULT_SIDE );
DP_LOCON ( "alu_mx2i1",IN,"alu_mx2i1",DEFAULT_SIDE );
DP_LOCON ( "alu_mx2i0",IN,"alu_mx2i0",DEFAULT_SIDE );
DP_LOCON ( "alu_mx1i2",IN,"alu_mx1i2",DEFAULT_SIDE );
DP_LOCON ( "alu_mx1i1",IN,"alu_mx1i1",DEFAULT_SIDE );
DP_LOCON ( "alu_mx1i0",IN,"alu_mx1i0",DEFAULT_SIDE );
DP_LOCON ( "alu_mx0i0",IN,"alu_mx0i0",DEFAULT_SIDE );

/* Auxilary ALU inputs/outputs*/

DP_LOCON ( "alu_byte",IN,"alu_byte",DEFAULT_SIDE );
DP_LOCON ( "alu_shrot",IN,"alu_shrot",DEFAULT_SIDE );
DP_LOCON ( "alu_test_n",IN,"alu_test_n",NORTH_SIDE );
DP_LOCON ( "alu_c31_n",OUT,"alu_c31_n",DEFAULT_SIDE );
DP_LOCON ( "alu_c30_n",OUT,"alu_c30_n",DEFAULT_SIDE );
DP_LOCON ( "alu_nul",OUT,"alu_nul",NORTH_SIDE );
DP_LOCON ( "alu_sign",OUT,"alu_sign",NORTH_SIDE );

/* Main data bus output */

DP_LOCON ( "data_out_n[31:0]",OUT,"data_out_n[31:0]",EAST_SIDE );

/*  Control connectors of ADROUT multiplexer */

DP_LOCON ( "out_mx0i0",IN,"out_mx0i0",DEFAULT_SIDE );

/* main adress bus output, to the plots. */

DP_LOCON ( "out_adr_n[31]",  OUT,"out_adr_n[31]",  NORTH_SIDE );
DP_LOCON ( "out_adr_n[30:2]",OUT,"out_adr_n[30:2]",WEST_SIDE );
DP_LOCON ( "out_adr_n[1:0]", OUT,"out_adr_n[1:0]", NORTH_SIDE );




/* Colonne no. 19 */
        DP_NMUX2CS(    "opy_byte_01_23", 16,
                        8,
                        "opy_rb1",
                        "data_in_n[15:8]", "data_in_n[7:0]",
                        "data_in_n[31:24]","data_in_n[23:16]",
                        "opy_byte_sel[15:0]", EOL );

printf( "Y Mux5\n" );
/* Colonne no. 21 */
        DP_NMUX2CS(    "opy_byte", 8,
                        12,
                        "opy_rb0",
                        "opy_byte_sel[7:0]",
                        "opy_byte_sel[15:8]",
                        "opy_dt_n[7:0]", EOL );

/* Colonne no. 54 */
        DP_CONST(       "byte_mask", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0xFFFFFFFF",
                        "byte_mask[31:0]", EOL );

/* Colonne no. 22 */
        DP_NMUX2CS(    "opy_dt_inv", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_byte",
                        "data_in_n[31:0]",
                        "byte_mask[31:8]","opy_dt_n[7:0]",
                        "opy_dt[31:0]", EOL );

/* Colonne no. 51 */
        DP_PDFFT(       "reg_dt", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "dt_Scin",
                        "dt_Scout",
                        "dt_Test",
                        "dt_wen",
                        "dt_ck",
                        "opy_dt[31:0]",
                        "dt_s[31:0]",
                        "dt_s_n[31:0]", EOL );
/* Colonne no. 49 */
        DP_INV(         "inv_data_in", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "data_in_n[31:0]",
                        "data_in[31:0]", EOL );
printf( "reg 7\n" );

/* Colonne no. 50 */
        DP_PDFFT(       "reg_ir", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "ir_Scin",
                        "ir_Scout",
                        "ir_Test",
                        "ir_wen",
                        "ir_ck",
                        "data_in[31:0]",
                        "opy_codop[5:0]","opy_rs[4:0]","opy_rdrt[4:0]","opy_rd[4:0]",
                        "ir_s[10:3]","opy_tvr","opy_sr","opy_iar",
                        "ir_s_n[31:0]", EOL );

/* Colonne no. 41 */
        DP_NMUX2CS(    "adr_mx_out", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "out_mx0i0",
                        "ad_s[31:0]",
                        "pc_s[31:0]",
                        "out_adr_n[31:0]", EOL );

/* Colonne no. 43 */
        DP_PDFFT(       "reg_ad", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "ad_Scin",
                        "ad_Scout",
                        "ad_Test",
                        "ad_wen",
                        "ad_ck",
                        "alu_out[31:0]",
                        "ad_s[31:0]",
                        "ad_s_n[31:0]", EOL );

/* Colonne no. 42 */
        DP_PDFFT(       "reg_pc", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "pc_Scin",
                        "pc_Scout",
                        "pc_Test",
                        "pc_wen",
                        "pc_ck",
                        "alu_out[31:0]",
                        "pc_s[31:0]",
                        "pc_s_n[31:0]", EOL );

/* Colonne no. 07 */
        DP_NMUX2CS(    "opx_mx_adpc", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_mx1",
                        "pc_s[31:0]",
                        "ad_s[31:0]",
                        "opx_its1[31:0]", EOL );

/* Colonne no. 11 */
       DP_NBUSE(    "ts_x1", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_ts1",
                        "opx_its1[31:0]",
                        "opx_sign","opx_ots[30:0]", EOL );

/* Colonne no. 23 */
        DP_NMUX2CS(    "opy_mx_dtad", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_mx1",
                        "ad_s[31:0]",
                        "dt_s[31:0]",
                        "opy_its1[31:0]", EOL );


/* Colonne no. 27 */
        DP_NBUSE(    "opy_ts_1", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_ts1",
                        "opy_its1[31:0]",
                        "opy_sign","opy_ots[30:0]", EOL );

/* Colonne no. 16 */
        DP_CONST(       "opy_c0", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0x00000000",
                        "opy_c0[31:0]", EOL );

/* Colonne no. 17 */
        DP_NMUX2CS(    "opy_mx_c0i16", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_mx3",
                        "opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]",
                        "opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]",
                        "opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4:0]","ir_s[10:3]","opy_tvr","opy_sr","opy_iar",
                        "opy_c0[31:0]",
                        "opy_its3[31:0]", EOL );

/* Colonne no. 25 */
        DP_NBUSE(    "opy_ts_3", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_ts3",
                        "opy_its3[31:0]",
                        "opy_sign","opy_ots[30:0]", EOL );

/* Colonne no. 18 */
        DP_NMUX2CS(    "opy_mx_i18i28", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_mx2",
                        "opy_rs[4]","opy_rs[4]","opy_rs[4]","opy_rs[4]",
                        "opy_rs[4:0]","opy_rdrt[4:0]","opy_rd[4:0]","ir_s[10:3]",
                        "opy_tvr","opy_sr","opy_iar","opy_c0[1:0]",
                        "opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]",
                        "opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]","opy_rd[4]",
                        "opy_rd[4:0]","ir_s[10:3]","opy_tvr","opy_sr","opy_iar","opy_c0[1:0]",
                        "opy_its2[31:0]", EOL );


/* Colonne no. 26 */
        DP_NBUSE(    "opy_ts_2", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_ts2",
                        "opy_its2[31:0]",
                        "opy_sign","opy_ots[30:0]", EOL );

/* Colonne no. 01 */
        DP_CONST(       "opx_ch", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0x0000FFFF",
                        "opx_ch[31:0]", EOL );

/* Colonne no. 02 */
        DP_CONST(       "opx_cb", DEFAULT_WIDTH ,
                        DEFAULT_SLICE,
                        "0x00000FF",
                        "opx_cb[31:0]", EOL );

/* Colonne no. 03 */
        DP_NMUX2CS(     "opx_mx_chcb", DEFAULT_WIDTH ,
                        DEFAULT_SLICE,
                        "opx_mx4",
                        "opx_cb[31:0]",
                        "opx_ch[31:0]",
                        "opx_its4[31:0]", EOL );

/* Colonne no. 08 */
       DP_NBUSE(    "ts_x4", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_ts4",
                        "opx_its4[31:0]",
                        "opx_sign","opx_ots[30:0]", EOL );

/* Colonne no. 13 */
        DP_CONST(       "opy_c16", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0x00000010",
                        "opy_c16[31:0]", EOL );

/* Colonne no. 14 */
        DP_CONST(       "opy_c4", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0x00000004",
                        "opy_c4[31:0]", EOL );

/* Colonne no. 15 */
        DP_NMUX2CS(    "opy_mx_c4c16", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_mx4",
                        "opy_c4[31:0]",
                        "opy_c16[31:0]",
                        "opy_its4[31:0]", EOL );

/* Colonne no. 24 */
        DP_NBUSE(    "opy_ts_4", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opy_ts4",
                        "opy_its4[31:0]",
                        "opy_sign","opy_ots[30:0]", EOL );

/* Colonne no. 46 */
        DP_NMUX2CS(     "reg_sr_set", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "sr_mx",
                        "alu_out[31:0]",
                        "alu_out[31:16]",
                        "sr_it3", "sr_it2","sr_it1","sr_it0",
                        "sr_ovr", "sr_dav", "sr_ico", "sr_iav",
                        "opy_c0[3:0]",
                        "sr_reset",
                        "opy_c0[2:0]",
                        "sr_in_n[31:0]", EOL );
printf( "reg 5\n" );

/* Colonne no. 47 */
        DP_INV(         "inv_sr_in", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "sr_in_n[31:0]",
                        "sr_in[31:0]", EOL );

/* Colonne no. 48 */
        DP_PDFFT(       "reg_sr", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "sr_Scin",
                        "sr_Scout",
                        "sr_Test",
                        "sr_wen",
                        "sr_ck",
                        "sr_in[31:0]",
                         "sr_s[31:2]","sr_mask","sr_mode",
                         "sr_s_n[31:0]", EOL );

/* Colonne no. 04 */
        DP_CONST(       "opx_c0", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0x00000000",
                        "opx_c0[31:0]", EOL );

/* Colonne no. 05 */
        DP_NMUX2CS(    "opx_mx_c0sr", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_mx3",
                        "sr_s[31:2]","sr_mask","sr_mode",
                        "opx_c0[31:0]",
                        "opx_its3[31:0]", EOL );

/* Colonne no. 09 */
       DP_NBUSE(    "ts_x3", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_ts3",
                        "opx_its3[31:0]",
                        "opx_sign","opx_ots[30:0]", EOL );

/* Colonne no. 44 */
        DP_PDFFT(       "reg_tvr", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "tvr_Scin",
                        "tvr_Scout",
                        "tvr_Test",
                        "tvr_wen",
                        "tvr_ck",
                        "alu_out[31:0]",
                        "tvr_s[31:0]",
                        "tvr_s_n[31:0]", EOL );
printf( "reg 3\n" );

/* Colonne no. 45 */
        DP_PDFFT(       "reg_iar", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "iar_Scin",
                        "iar_Scout",
                        "iar_Test",
                        "iar_wen",
                        "iar_ck",
                        "alu_out[31:0]",
                        "iar_s[31:0]",
                        "iar_s_n[31:0]", EOL );

/* Colonne no. 06 */
        DP_NMUX2CS(    "opx_mx_tvriar", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_mx2",
                        "iar_s[31:0]",
                        "tvr_s[31:0]",
                        "opx_its2[31:0]", EOL );

/* Colonne no. 10 */
       DP_NBUSE(    "ts_x2", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_ts2",
                        "opx_its2[31:0]",
                        "opx_sign","opx_ots[30:0]", EOL );

/* Colonne no. 29 */
        DP_NOR2(        "alu_Or", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "opx_sign","opx_ots[30:0]",
                        "opy_sign","opy_ots[30:0]",
                        "alu_or_n[31:0]", EOL );

printf( "aluor\n" );
/* Colonne no. 30 */
        DP_NAND2(        "alu_And", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "opx_sign","opx_ots[30:0]",
                        "opy_sign","opy_ots[30:0]",
                        "alu_and_n[31:0]", EOL );

printf( "alunand2\n" );
/* Colonne no. 31 */
        DP_NMUX2CS(    "alu_mx_or_and", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_mx1i1",
                        "alu_or_n[31:0]",
                        "alu_and_n[31:0]",
                        "alu_or_and[31:0]", EOL );

/* Colonne no. 32 */
        DP_INV(         "inv_or_and", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "alu_or_and[31:0]",
                        "alu_or_and_n[31:0]", EOL );

printf( "aluinv\n" );
/* Colonne no. 33 */
        DP_XOR2(       "alu_xor", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_sign","opx_ots[30:0]",
                        "opy_sign","opy_ots[30:0]",
                        "alu_xor_op[31:0]", EOL );

printf( "aluxor2\n" );
/* Colonne no. 34 */
        DP_ADSB2F(     "adder",
                       "opx_sign","opx_ots[30:0]",
                       "opy_sign","opy_ots[30:0]",
                       "alu_c31_n",
                       "alu_c30_n",
                       "alu_sign","alu_sum[30:0]",
                       "alu_mx0i0", EOL );

/* Colonne no. 39 */
        DP_NUL(         "alu_nul_test", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_sign","alu_sum[30:0]",
                        "alu_nul", EOL );

/* Colonne no. 35 */
        DP_NMUX2CS(    "alu_mx_xor_add", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_mx1i2",
                        "alu_xor_op[31:0]",
                        "alu_sign","alu_sum[30:0]",
                        "alu_xor_add_n[31:0]", EOL );

printf( "alu mux2\n" );
/* Colonne no. 36 */
        DP_NMUX2CS(    "alu_mx_add_log", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_mx2i1",
                        "alu_or_and_n[31:0]",
                        "alu_xor_add_n[31:0]",
                        "alu_ar_lo[31:0]", EOL );

/* Colonne no. 28 */
        DP_SHIFT(      "shifter",
                        "opy_ots[4:0]",
                        "alu_mx2i0","alu_shrot","alu_mx1i0",
                        "opx_sign","opx_ots[30:0]",
                        "alu_shout[31:0]", EOL );

/* Colonne no. 37 */
        DP_NMUX2CS(    "alu_mx_sh_al", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_mx3i0",
                        "alu_shout[31:0]",
                        "alu_ar_lo[31:0]",
                        "alu_sh_al_n[31:0]", EOL );

/* Colonne no. 55 */
        DP_CONST(       "test_mask", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "0xFFFFFFFF",
                        "test_mask[31:0]", EOL );

/* Colonne no. 38 */
        DP_NMUX2CS(    "alu_mx_tst_shal", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_mx4i0",
                        "test_mask[31:1]","alu_test_n",
                        "alu_sh_al_n[31:0]",
                        "alu_out[31:0]", EOL );

/* Colonne no. 52 */
        DP_RFG1C0(      "register_file",
                        32,
                        "rf_ar[4:0]",
                        "rf_wen",
                        "rf_aw[4:0]",
                        "alu_out[31:0]",
                        "rf_s[31:0]",
                        "rf_ck", EOL );
printf( "reg 10\n" );

/* Colonne no. 53 */
        DP_INV(         "inv_rf", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        1,
                        "rf_s[31:0]",
                        "rf_s_n[31:0]", EOL );

/* Colonne no. 12 */
       DP_NBUSE(    "ts_x0", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "opx_ts0",
                        "rf_s_n[31:0]",
                        "opx_sign","opx_ots[30:0]", EOL );

/* Colonne no. 40 */
        DP_NMUX2CS(    "data_mx_out", DEFAULT_WIDTH,
                        DEFAULT_SLICE,
                        "alu_byte",
                        "alu_out[31:0]",
                        "alu_out[7:0]","alu_out[7:0]","alu_out[7:0]","alu_out[7:0]",
                        "data_out_n[31:0]", EOL );

        DP_SAVLOFIG();


	exit( 0 );
}

