/* ###--------------------------------------------------------------### */
/*                                                                      */
/* file         : syf_parse.c                                           */
/* date         : Nouv 05 1992											*/
/* version	: v100														*/
/* author       : L.A TABUSSE & M.HANAFI & P. BAZARGAN-SABET         	*/
/* description  : Parser VHDL --> BEH                                   */
/* Called Func. : mbkalloc												*/
/*                                                                      */
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <string.h>
#include MUT_H
#include"../../beh104/beh104.h"
#include "../util/syf_utype.h"
#include "../util/syf_utdef.h"
#include "syf_parse.h"

struct syf_befig *vhdlautoloadbefig (pt_befig, figname, trace_mode)

struct syf_befig *pt_befig;
char         *figname;
int           trace_mode;

  {
  char          *env_valu;
  char          *buffer;
  char          *str;
  struct chain  *search_lst = NULL;
  struct chain  *behsfx_lst = NULL;
  struct chain  *libpath = NULL;
  struct chain  *suffix = NULL;

	/* ###------------------------------------------------------### */
	/*    Create the list of search libraries from the environment	*/
	/* variable VH_LIBLST						*/
	/* ###------------------------------------------------------### */

  str = getenv("VH_LIBLST");
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy(env_valu,str);
    }
  if (env_valu == NULL)
    search_lst = addchain (NULL,".");
  else
    {
    buffer = strtok (env_valu,":");
    do
      search_lst = addchain (search_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    search_lst = reverse (search_lst);
    }
    
	/* ###------------------------------------------------------### */
	/*    Create list of suffix for behavioural files from the	*/
	/* environment variable VH_BEHSFX				*/
	/* ###------------------------------------------------------### */

  env_valu = NULL;
  str = getenv("VH_BEHSFX");
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy(env_valu,str);
    }
  if (env_valu == NULL)
    behsfx_lst = addchain (NULL,"vbe");
  else
    {
    buffer = strtok (env_valu,":");
    do
      behsfx_lst = addchain (behsfx_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    behsfx_lst = reverse (behsfx_lst);
    }

	/* ###------------------------------------------------------### */
	/*    Searching the root file					*/
	/* ###------------------------------------------------------### */

/*   syf_message(5,figname,0);*/
  
  libpath = search_lst;
  while (libpath != NULL)
    {
    suffix  = behsfx_lst;
    while ( suffix != NULL)
      {
      sprintf (SYF_CURFIL,"%s/%s.%s",libpath->DATA,figname,suffix->DATA);
      if ((syf_y_in = fopen (SYF_CURFIL,"r")) != NULL)
        break;
      suffix = suffix->NEXT;
      }
    if (suffix != NULL)
      break;
    libpath = libpath->NEXT;
    }

  if (syf_y_in == NULL)
    {
    syf_error (100,figname);
    exit (1);
    }

	/* ###------------------------------------------------------### */
	/*    Running the behavioural compiler on the current file	*/
	/* ###------------------------------------------------------### */

  if (trace_mode == 1)
    syf_message(3,SYF_CURFIL,0);

  SYF_LINNUM = 1;

  syf_y_parse ();
  fclose (syf_y_in);

  return ((struct syf_befig *)SYF_HEDFIG);
  }
