
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: bvl_byacc.h						*/
/* date		: Jun 15 1992						*/
/* version	: v102							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: declaration of external functions and global variables*/
/*		  used by yacc						*/
/*								 	*/
/* ###--------------------------------------------------------------### */

typedef struct syf_expr
  {
  char          *IDENT;			/* identifier or constant name	*/
  struct chain  *LIST_ABL;		/* pointer on bvl_abllst list	*/
  char 		 TYPE;
  short          WIDTH;			/* width of bit vector		*/
  }
syf_ablstr;

typedef struct
  {
  char          *NAME;			/* identifier name		*/
  short          LEFT;			/* vector's left index		*/
  short          RIGHT;			/* vector's right index		*/
  char           FLAG;			/* scalar ('S') or array 'A'	*/
  char           TYPE;			/* scalar ('S') or array 'A'	*/
  }
syf_name;

struct g_type
  {
  int  VALU;
  char FLAG;
  };

struct choice_chain
  {
  struct choice_chain* NEXT;	
  char  *VALUE;
  unsigned int  SIZE;
  struct ptype *INSTRUCTION;
  };

pNode         SYF_BDDPNT;		/* BDD pointer			*/
char         *SYF_MODNAM;		/* curnennt model name		*/
syf_ablstr    SYF_SLCEXP;		/* structure filled with the	*/
syf_ablstr    SYF_EMPSTR;		/* empty structure used with NOT*/
 
static char         *SYF_LBLNAM = NULL;	/* label			*/
static int           SYF_NUMTYP = 0;	/* nombre de type			*/
static struct chain *SYF_NM1LST = NULL;	/* 1-st name liste		*/
static struct chain *SYF_GRDLST = NULL;	/* list of guard's ABL		*/
static struct chain *SYF_CNDLST = NULL;	/* list of conditions (ABL)	*/
static struct chain *SYF_VALLST = NULL;	/* list of waveforms (ABL)	*/
static struct syf_befig *SYF_BEFPNT = NULL;	/* current BEFIG pointer	*/

static struct chain *SYF_INTLST = NULL;
static struct syf_begen *SYF_GENPNT = NULL;
static struct choice_chain  *SYF_CASPNT = NULL;
static struct ptype *SYF_OTHPNT = NULL;
static struct ptype *SYF_PTYPE = NULL;

static struct dct_entry  *SYF_DCEHED;	/* free dct_entry's head	*/
static struct dct_recrd  *SYF_DCRHED;	/* free dct_recrd's head	*/

extern char          SYF_ERRFLG;	/* set to 1 in case of error	*/
extern struct syf_befig *SYF_HEDFIG;	/* head of befigs		*/

static struct dct_entry **hshtab;
 
extern struct syf_begen      *bvl_addgen();

extern syf_ablstr         syf_crtabl();
extern syf_ablstr         bvl_cpyablstr();
extern syf_ablstr         bvl_select();
extern char              *bvl_stostr();
extern void               bvl_error();
