%{
#include <stdio.h>
#include <string.h>
#include MUT_H 
#include "y.tab.h"
#define LG_MC  10
int nb_lignes = 0;

typedef struct
  {
  char nom[LG_MC];
  int  kval;
  }el_mc;

 static el_mc tab_mc[]={
    {"i"  ,IN},
    {"o",OUT},
    {"p",P},
    {"r",R},
    {"s",STATE},
   };
#define nb_mc ((tab_mc-1 + sizeof(tab_mc)/sizeof(tab_mc[0]))-tab_mc+1)
%}
blanc [ \t]
ligne [\n]
ws    {blanc}+
lettre [A-Za-z_]
chiffre [0-9]
ident {lettre}({lettre}|{chiffre})*
%%
{ws}    { return(SPACE);}
{ligne} {nb_lignes++; return(SPACE);}
{ident} { int i;
          if ((i=find_mc(yytext))!= -1)
            {return(i);}
          yylval.s=namealloc(yytext);
          return(IDENT);
        } 
{chiffre} { sscanf(yytext,"%d",&yylval.val);
          return(CHIFFRE);}
.      {return(*yytext);}
%%
/*int yywrap()
 {
 return(1);
 }
 */


int find_mc(s)
char *s ;
{
  char loc[200] ;/* YYLMAX */
  int i, l ;
  el_mc *pt ; 

  l = strlen(s) ;
  for (i=0 ; i<l ; i++)
    loc[i] = (s[i]>='A' && s[i]<='Z') ? s[i]-'A'+'a' : s[i] ;
  loc[i] = '\0' ;
  pt = (el_mc *)bsearch(loc,(char *)tab_mc,nb_mc,sizeof(el_mc),strcmp) ;
  if (pt == NULL)
    return(-1) ;
  else
    return(pt->kval) ;
}

