/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur de FSM                                       */
/*    Fichier :  syf_disp.c                                                  */
/*                                                                          */
/*    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  C. Sarwary                            le : 15/06/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/***************************************************************************/
#include <stdio.h>
#include <math.h>
#include <fcntl.h>
#include MUT_H
#include LOG_H
#include "syf_auto.h"
#include"../beh104/beh104.h"
/*------------------------------------------------------------------------------
displayAuto		: visualise un automate
--------------------------------------------------------------
parametres		: rien .
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
void displayAuto()
{
int i, numFile ;
pState state ;
pTrans trans ;
pLocOut locOut;

/*
for(i = 0; i < 5; i++)
	printf("name terminal : %s\n",ttyname(i)) ;
*/
close(1) ;
if ((numFile = open("decomp",O_RDWR | O_CREAT)) < 0)
          printf("syf : impossible d'ouvrir le fichier\n");
dup(numFile) ;/*fic remplace la sortie stand.
		on peut aussi mettre dup2(numFile,1) et enlever close(1)*/

printf("\t******************* AUTOMATE GENERE *****************\n\n\n") ;
printf("NAME MACHINE    :    %s\n",autoSys->name) ;
printf("TYPE MACHINE    :    %d\n\n",autoSys->typeMachine) ;

state = autoSys->state ;
for(i = 0; i < autoSys->numberState; i++)
  {
  printf("%s  code = %d; \n",state->name, (autoSys->code + i)->code) ;
     locOut = state->locOut ;
     while(locOut)
        {
        displayExpr(locOut->abl) ;
	locOut = locOut->next ;
	if(locOut)
        	printf(" , ") ;
        }
  trans = state->trans ;
  while(trans)
     {
     printf("\t") ;
     if(trans->sPlabel !=-1)
        printf(" <-- %s ; ",(autoSys->state + trans->sPlabel)->name) ;
     else
        printf(" <-- '*' ; ") ;
     displayExpr(trans->abl) ;
     trans = trans->next ;
     }
   state++ ;
   }
printf("\n\n\t************** FIN DE LA DESCRIPTION ****************\n") ;
/*
for(i = 0; i < 5; i++)
	printf("name terminal : %s\n",ttyname(i)) ;
*/
close(numFile) ;
system("chmod 700 decomp") ;
fflush(stdout) ;
close(1) ;
numFile = open((char *)ttyname(0),O_WRONLY | O_CREAT) ;
numFile = dup(numFile) ;
}
/*------------------------------------------------------------------------------
displayTrans		: visualise une trans
--------------------------------------------------------------
parametres		: rien .
--------------------------------------------------------------
return			: state .
------------------------------------------------------------------------------*/
void displayTrans(state)
pState state ;
{
pTrans trans ;

printf("************* transition pour un state ***********\n") ;
trans = state->trans ;
while(trans)
	{
	displayExpr(trans->abl) ;
	trans = trans->next ;
	}
}
/*------------------------------------------------------------------------------
displayStateName	: visualise name des states .
--------------------------------------------------------------
parametres		: rien .
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
void displayStateName()
{
pState state ;
int i ;

printf("*********** table des labels des states ************\n") ;
state = autoSys->state ;
for(i = 0; i < autoSys->numberState; i++)
	printf("%d : %s\n",i,(state+i)->name) ;
}
/*------------------------------------------------------------------------------
displayCode		: visualise les codes et leurs abl .
--------------------------------------------------------------
parametres		: mode .
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
void displayCode(mode)
int mode ;
{
pCode code ;
int i ;

printf("\n\n********************* table des codes **********************\n\n") ;
code = autoSys->code ;
printf("--------numState : %d, NUMBER_COD : %d\n",autoSys->numberState,NUMBER_CODE(autoSys->numberState)) ;
for(i = 0; i < NUMBER_CODE(autoSys->numberState); i++)
	{
	if(i == autoSys->numberState)
		{
		printf("\n\t************** LES DON'T CAREs ************\n") ;
		printf("%d : ",i) ;
		}
	else
		{
		printf("%d : ",i) ;
	  	if(i < autoSys->numberState)
			printf("NAME : %s",(autoSys->state + i)->name) ;
		}
	printf(" code = %d\n",code->code) ;
	if(mode)
		displayExpr(code->abl) ;
	code++ ;
	}
printf("\n\n******************* fin table des codes ********************\n\n") ;
}
/*------------------------------------------------------------------------------
displayDc		: visualise le DON'T CARE  .
--------------------------------------------------------------
parametres		: rien .
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
displayDc()
{
printf("\n\n*********************** DON'T CARE **********************\n\n");
if(autoSys->ablDc == NULL)
	printf(" Pas de DON'T CARE\n") ;
else
	{
	printf("dc = ") ;
	displayExpr(autoSys->ablDc) ;
	}
printf("\n\n********************* FIN DE DISPLAY ********************\n\n") ;
}
/*------------------------------------------------------------------------------
displayReg		: visualise les expressions de la structure reg
--------------------------------------------------------------
parametres		: reg : pointeur sur une structure reg .
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
void displayReg(reg,type)
pReg reg ;
int type ;
{
int i, number ;

printf("************** DISPLAY REGISTER ****************\n") ;
if(type == 0)	/*registres d'etats*/
	number = autoSys->numberReg ;
else
	if(type == 1) /*stack */
		number = autoSys->sizeStack * autoSys->numberReg ;
	else  /* registres de sorties */
		number = 2 * (autoSys->numberOut) ;
	
for(i = 0; i < number; i++)
	{
	if(reg->abl != NULL)
		{
		printf("NAME : %s\n",reg->name) ;
		displayExpr(reg->abl) ;
		}
	else
		printf("reg = NULL\n") ;
	reg++ ;
	}
printf("************** FIN DE DISPLAY ******************\n") ;
}

displayOneStack(oneStack)
pReg oneStack ;
{
printf("NAME : %s\n",oneStack->name) ;
displayExpr(oneStack->abl) ;
}
/*------------------------------------------------------------------------------
displayLocOut	: visualise les locOut.
--------------------------------------------------------------
parametres		: 
--------------------------------------------------------------
return			: rien .
------------------------------------------------------------------------------*/
displayLocOut()
{
pState state ;
pLocOut locOut ;
int i, j ;

printf("------------ DisplayLocOut -------------\n") ;
state = autoSys->state ;
 
for(i = 0; i < autoSys->numberState; i++)
	{
	printf("----->State : %s\n",state->name) ;
	locOut = state->locOut ;
	j = 0 ;
		while(locOut)
		{
		if(locOut->abl)
			{
			printf("%d : out : %s\n",locOut->label,(autoSys->out + j)->name) ;
			fflush(stdout) ;
			displayExpr(locOut->abl) ;
			fflush(stdout) ;
			}
		j++ ;
		locOut = locOut->next ;
		}
	state++ ;
	}
} 
/*------------------------------------------------------------------------------
displayTr		: visualise une trans
--------------------------------------------------------------
parametres		: rien .
--------------------------------------------------------------
return			: trans .
------------------------------------------------------------------------------*/
displayTr(trans)
pTrans trans ;
{
pTrans curTrans ;

printf("************* transition ***********\n") ;
curTrans = trans ;
while(curTrans)
	{
	/*displayExpr(curTrans->abl) ;*/
	printf("Last state : %s\n",(autoSys->state + curTrans->sPlabel)->name) ;
	curTrans = curTrans->next ;
	}
}
/*------------------------------------------------------------------------------
displayTabCode	: visualise une table d'entiers.
--------------------------------------------------------------
parametres		: tab, nombre d'elements .
--------------------------------------------------------------
return			:  .
------------------------------------------------------------------------------*/
displayTabCode(tab,num)
int *tab ;
int num ;
{
int i ;

for(i = 0;i < num; i++)
	printf("tab[%d] = %d\n",i,tab[i]) ;
}
