/*******************************************************************************
fichier des fonctions de traitement des GFs .
version de 02/07/91 .
*******************************************************************************/
#include<stdio.h>
#include MUT_H
#include LOG_H
#include"fact.h"

/*------------------------------------------------------------------------------
sizeBdd		:	calcule la taille d'un bdd, revient a calculer le nbre
			de noeuds .	
--------------------------------------------------------------
parametres	:	bdd	  : pteur sur bdd .
			cptSize	  : pteur sur la taille initialisee a zero .
--------------------------------------------------------------
return		:	void .
------------------------------------------------------------------------------*/
void sizeBdd(bdd,cptSize)
pNode bdd ;
int *cptSize ;
{
markBdd(bdd,0) ;
if(bdd != zero && bdd != one)
	{
	if(bdd->mark == 0)
		{
		*cptSize = *cptSize + 1 ;
		bdd->mark++ ;
		}
	sizeBdd(bdd->high,cptSize) ;
	sizeBdd(bdd->low,cptSize) ;
	}
}
/*------------------------------------------------------------------------------
initTabVar	:	remplie la table des variables d'un bdd .	
--------------------------------------------------------------
parametres	:	bdd	  : bdd a factoriser .
			var	  : pteur sur la table des bdd des variables .
			
--------------------------------------------------------------
return		:	void .
------------------------------------------------------------------------------*/
void initTabVar(bdd,var)
pNode bdd ;
pNode *var ;
{
int i, j ;

for(i = 0; var[i] != NULL && var[i]->index != bdd->index; i++) ;
if(var[i] == NULL)
	var[i] = createNodeTermBdd(bdd->index) ;
if(bdd->high != one && bdd->high != zero)
	initTabVar(bdd->high,var) ;
if(bdd->low != one && bdd->low != zero)
	initTabVar(bdd->low,var) ;
/*for(i = 0; var[i] != NULL; i++)
	{
	printf("index[%d] = %d\n",i,var[i]->index) ;
	displayBdd(1,var[i]) ;
	}
*/
}
/*------------------------------------------------------------------------------
reduceGF	:	reduit un GF, a(b + c) + e(b + c) = (a + e)(b + c) .	
--------------------------------------------------------------
parametres	:	pGF	  : pointeur sur le graphe factorise .
			tabFact   : table de hash .
			
--------------------------------------------------------------
return		:	nouveaux GF .
------------------------------------------------------------------------------*/
pFact reduceGF(tabFact,pGF)
pTabFact tabFact ;
pFact pGF ;
{
pFact newPGF ;
pNode bdd ;

newPGF = pGF ;
/*printf("********pGF : %d; r : %d; h : %d\n",pGF,pGF->r,pGF->h) ;*/
if(pGF != oneFact && pGF != zeroFact)
	{
/*
	if(pGF->r->r != zeroFact && pGF->h != NULL && pGF->r->r != oneFact && pGF->h != NULL && pGF->r->r == pGF->h)
		printf("***************************pGF->r->r == pGF->h\n") ;
	if(pGF->r->h != zeroFact && pGF->h->h != NULL && pGF->r->h != oneFact && pGF->h->h != NULL && pGF->r->h == pGF->h->h)
		printf("***************************pGF->r->h == pGF->h->h\n") ;
	if(pGF->h->r != zeroFact && pGF->r->h != NULL && pGF->r->h != oneFact && pGF->h->r != NULL && pGF->r->h == pGF->h->r)
		printf("***************************pGF->r->h == pGF->h->r\n") ;
*/
	/*printf("h : %d; r->h : %d\n",pGF->h,pGF->r->h) ;*/
	if(applyBinBdd(OR,pGF->g, pGF->r->g) == one && pGF->r->r != oneFact && 
				pGF->r->r != zeroFact &&
				pGF->h == pGF->r->r->h)
		{
		newPGF = initFact(tabFact,applyBinBdd(OR,pGF->g,pGF->r->r->g),
				reduceGF(tabFact,pGF->h),
				initFact(tabFact,pGF->r->g,
					reduceGF(tabFact,pGF->r->h),
						     (tabFact,pGF->r->r->r))) ;
		}
	else
		if(pGF->h == pGF->r->h)
			{
			newPGF = initFact(tabFact,
					applyBinBdd(OR,pGF->g,pGF->r->g),
						reduceGF(tabFact,pGF->h),
						reduceGF(tabFact,pGF->r->r)) ;
			}
		else
		   if(pGF->r->g==notBdd(pGF->g))/*possibilite d'un ou_exclusif*/
			{
			bdd = GFToBdd(pGF->h) ;
			if(bdd == notBdd(GFToBdd(pGF->r->h)))
				newPGF =initFact(tabFact,notBdd(applyBinBdd(XOR,
					pGF->g,bdd)),oneFact,reduceGF(tabFact,
								pGF->r->r)) ;
	    		else
				{
				newPGF = initFact(tabFact,pGF->g,
						reduceGF(tabFact,pGF->h),
						reduceGF(tabFact,pGF->r)) ;
				}
			}
	   	 else
			{
			newPGF = initFact(tabFact,pGF->g,
					reduceGF(tabFact,pGF->h),
					reduceGF(tabFact,pGF->r)) ;
			}
		}
return(newPGF) ;
}
/*------------------------------------------------------------------------------
GFToAbl		:	construit une forme ABL a partir d'un GF .	
-----------------------------------------------------------------
parametres	:	pGF : pointeur sur GF . 
			tabInput : table des entrees .
			type : type de pGF : r, h ou debut .
-----------------------------------------------------------------
return		:	pointeur sur la forme ABL .
------------------------------------------------------------------------------*/
chain_list *GFToAbl(pGF,tabInput)
pFact pGF ;
char **tabInput ;
{
chain_list *s, *sAnd ;
chain_list *g ;

/*printf("*****debut\n") ;
displayChainFact(pGF,tabInput) ;
printf("\n*****fin\n") ;
*/
g = (chain_list *)bddToAbl(pGF->g,tabInput) ;

if(pGF->r == zeroFact)
	{
	if(pGF->h == oneFact)
		return(g) ;
	s = createExpr(AND) ; /* else */ /* F = g0 h0 + g1 h1 */
	addQExpr(s,g) ;
	addQExpr(s,GFToAbl(pGF->h,tabInput)) ;
	return(s) ;
	}
else
	{
	s = createExpr(OR) ;
	if(pGF->h == oneFact)
		{
		addQExpr(s,g) ;
		addQExpr(s,GFToAbl(pGF->r,tabInput)) ;
		return(s) ;
		}
	sAnd = createExpr(AND) ; /* else */
	addQExpr(sAnd,g) ;
	addQExpr(sAnd,GFToAbl(pGF->h,tabInput)) ;
	addQExpr(s,sAnd) ;
	addQExpr(s,GFToAbl(pGF->r,tabInput)) ;
	return(s) ;
	}
}
/*------------------------------------------------------------------------------
GFToBdd		:	construit le BDD correspondant a un GF .	
-----------------------------------------------------------------
parametres	:	pGF : pointeur sur GF . 
-----------------------------------------------------------------
return		:	pointeur sur le BDD .
------------------------------------------------------------------------------*/
pNode GFToBdd(pGF)
pFact pGF ;
{

if(pGF == oneFact)
	return(one) ;
if(pGF == zeroFact)
	return(zero) ;
return(applyBinBdd(OR,applyBinBdd(AND,pGF->g,GFToBdd(pGF->h)),GFToBdd(pGF->r)));
}
/*------------------------------------------------------------------------------
initializeTabPBdd: initialise la table des Bdd .
-------------------------------------------------------
parametres 	: sizeTab  : la taille de la table .
		  pTabBdd: pointeur sur la table des Bdd .
-------------------------------------------------------
return 		: void .
------------------------------------------------------------------------------*/
void initializeTabPBddFSM(sizeTab,pTabBdd)
int sizeTab ;
pNode *pTabBdd ;
{
int i ;

for(i = 0; i < sizeTab; i++)
	pTabBdd[i] = NULL ;
}
/*------------------------------------------------------------------------------
addBdd		: ajoute un bdd dans la table des bdd.
-------------------------------------------------------
parametres 	: bdd  : bdd a ajouter .
		  pTabBdd: pointeur sur la table des Bdd .
-------------------------------------------------------
return 		: void .
------------------------------------------------------------------------------*/
void addBddFSM(pTabBdd,bdd)
pNode *pTabBdd, bdd ;
{
int i ;

for(i = 0; pTabBdd[i] != NULL; i++) ;
	pTabBdd[i] = bdd ;
}
/*------------------------------------------------------------------------------
countLiteralBdd	: compte le nbre de literaux d'un BDD .
-------------------------------------------------------
parametres 	: bdd .
		  nbLit : nbre de literaux(fonction recursive) .
		  tabIndex : pointe la table des index .
-------------------------------------------------------
return 		: void .
------------------------------------------------------------------------------*/
void countLiteralBddFSM(bdd,nbLit,tabIndex)
pNode bdd ;
int *nbLit, *tabIndex ;
{
int i ;

/*printf("incrementation\n") ;*/
if(bdd != zero && bdd != one)
	{
	for(i = 0; tabIndex[i] != (int)NULL && tabIndex[i] != (int)bdd->index ;i++) ;
	if(tabIndex[i] == (int)NULL)
		{
		/*printf("j'ajoute\n") ;*/
		*nbLit = (*nbLit) + 1 ;
		tabIndex[i] = bdd->index ;
		}
	countLiteralBddFSM(bdd->high,nbLit,tabIndex) ;
	countLiteralBddFSM(bdd->low,nbLit,tabIndex) ;
	}
/*printf("fin\n") ;*/
}
/*------------------------------------------------------------------------------
deletOnePTabBdd	: supprime la premiere variable de la table des pointeurs sur
		  BBD .
-------------------------------------------------------
parametres 	: pTabBdd .
-------------------------------------------------------
return 		: void .
------------------------------------------------------------------------------*/
void deletOnePTabBdd(pTabBdd)
pNode *pTabBdd ;
{
int i ;

for(i = 0; pTabBdd[i] != NULL; i++)
	pTabBdd[i] = pTabBdd[i + 1] ;
}
