
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: beh.h							*/
/* date		: Aug 28 1992						*/
/* version	: 103							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* contents	: defines and structure definitions used in BEH library	*/
/*									*/
/* ###--------------------------------------------------------------### */

#ifndef BEH_DEFINE
#define BEH_DEFINE

	/* ###------------------------------------------------------### */
	/*    defines							*/
	/* ###------------------------------------------------------### */

#define BEH_GENERIC 203698	/* generic ptype code			*/
#define BEH_BEIFS   205635	/* if     statement ptype code		*/
#define BEH_BECAS   423240	/* case   statement ptype code		*/
#define BEH_BEMSG   153676	/* assert statement ptype code		*/
#define BEH_BEASG   967324	/* assign statement ptype code		*/

	/* ###------------------------------------------------------### */
	/*    structure definitions					*/
	/* ###------------------------------------------------------### */

typedef struct syf_befig		/* behaviour figure			*/
  {
  struct syf_befig   *NEXT;		/* next figure				*/
  char           *NAME;		/* figure's name			*/
  struct syf_bereg   *BEREG;	/* internal signals (REGISTER)		*/
  struct syf_bemsg   *BEMSG;	/* concurrent assert instructions	*/
  struct syf_berin   *BERIN;	/* inputs (registers and ports)		*/
  struct syf_beout   *BEOUT;	/* output ports				*/
  struct syf_bebus   *BEBUS;	/* output ports (BUS)			*/
  struct syf_beaux   *BEAUX;	/* internal signals			*/
  struct syf_beaux   *BEDLY;	/* internal delayed signals			*/
  struct syf_bebux   *BEBUX;	/* internal signals (BUS)		*/
  struct syf_bepor   *BEPOR;	/* ports (reverse order of declaration)	*/
  struct syf_bepcs   *BEPCS;	/* list of processes			*/
  struct circuit *CIRCUI;	/* Circuit's pointer used for BDDs	*/
  struct ptype   *USER;		/* reserved for user's applications	*/
  char            FLAG;		/* error flags				*/
  char            TYPE;		/* type of the description (not used)	*/
  struct syf_betyp   *BETYP;	/* list of declared types		*/
  struct syf_bepgm   *BEPGM;	/* list of pragmas			*/
  }
syf_befig_list;

typedef struct syf_bereg		/* register				*/
  {
  struct syf_bereg  *NEXT;		/* next register			*/
  char          *NAME;		/* register's name			*/
  struct biabl  *BIABL;		/* list of drivers (ABL)		*/
  struct binode *BINODE;	/* list of drivers (BDD)		*/
  /*unsigned char  TYPE;		 register's type			*/
  }
syf_bereg_list;

typedef struct syf_bemsg		/* assert instruction			*/
  {
  struct syf_bemsg 	*NEXT;		/* next assertion			*/
  char		 LEVEL;		/* severity level of the assertion	*/
  char		*LABEL;		/* instruction's label			*/
  char		*MESSAGE;	/* assertion's message			*/
  struct chain	*ABL;		/* assertion's condition (ABL)		*/
  struct node	*NODE;		/* assertion's condition (BDD)		*/
  }
syf_bemsg_list;

typedef struct syf_beout		/* output port				*/
  {
  struct syf_beout	*NEXT;		/* next output				*/
  char		*NAME;		/* port's name				*/
  struct chain	*ABL;		/* port's equation (ABL)		*/
  struct node	*NODE;		/* port's equation (BDD)		*/
  unsigned char  TYPE;		/* port's type				*/
  }
syf_beout_list;

typedef struct syf_bebus		/* output port (BUS)			*/
  {
  struct syf_bebus	*NEXT;		/* next bus port			*/
  char		*NAME;		/* port's name				*/
  struct biabl	*BIABL;		/* list of drivers (ABL)		*/
  struct binode	*BINODE;	/* list of drivers (BDD)		*/
  unsigned char  TYPE;		/* port's type : W or M			*/
  }
syf_bebus_list;

typedef struct syf_beaux		/* auxiliary signal			*/
  {	
  struct syf_beaux	*NEXT;		/* next signal				*/
  char		*NAME;		/* signal's name			*/
  struct chain	*ABL;		/* signal's equation (ABL)		*/
  struct node	*NODE;		/* signal's equation (BDD)		*/
  unsigned char  TYPE;		/* signal's type			*/
  }
syf_beaux_list;

typedef struct syf_bebux		/* internal signal (BUS)		*/
  {	
  struct syf_bebux	*NEXT;		/* next signal				*/
  char		*NAME;		/* signal's name			*/
  struct biabl	*BIABL;		/* list of drivers (ABL)		*/
  struct binode	*BINODE;	/* list of drivers (BDD)		*/
  unsigned char  TYPE;		/* signal's type : W or M		*/
  }
syf_bebux_list;

typedef struct syf_bepor		/* port					*/
  {
  struct syf_bepor *NEXT;		/* next port				*/
  char         *NAME;		/* port's name				*/
  char          DIRECTION;	/* port's mode (same as LOCON)		*/
  unsigned char TYPE;		/* port's type (B, M or W)		*/
  }
syf_bepor_list;

typedef struct biabl		/* couple of ABL			*/
  {
  struct biabl	*NEXT;		/* next couple				*/
  char          *LABEL;		/* driver's label			*/
  struct chain	*CNDABL;	/* driver's connection condition (ABL)	*/
  struct chain	*VALABL;	/* equation of driven value (ABL)	*/
  }
biabl_list;

typedef struct binode		/* couple of BDD			*/
  {
  struct binode	*NEXT;	 	/* next figure				*/
  struct node	*CNDNODE;	/* driver's connection condition (BDD)	*/
  struct node	*VALNODE;	/* equation of driven value (BDD)	*/
  }
binode_list;

typedef struct syf_berin		/* primary inputs			*/
  {
  struct syf_berin *NEXT;		/* next input				*/
  char         *NAME;		/* input's name				*/
  }
syf_berin_list;

typedef struct syf_begen		/* generic				*/
  {
  struct syf_begen  *NEXT;		/* next generic				*/
  char 	        *NAME;		/* generic's name			*/
  void          *VALUE;		/* generic's value			*/
  unsigned char  TYPE;		/* generic type's name			*/
  }
syf_begen_list;

typedef struct syf_bepcs		/* process				*/
  {
  struct syf_bepcs *NEXT;		/* next process				*/
  char         *LABEL;		/* process's label			*/
  struct chain *SENSITIVITY;	/* list of sensitivity			*/
  struct ptype *INSTRUCTION;	/* list of instructions			*/
  struct chain *OUTPUTS;	/* list of assigned signals		*/
  char          FLAG;		/* flag (not used)			*/
  }
syf_bepcs_list;

typedef struct syf_beifs		/* if statement				*/
  {
  struct chain *CND;		/* condition (abl)			*/
  struct ptype *CNDTRUE;	/* list of instructions when true	*/
  struct ptype *CNDFALSE;	/* list of instructions when false	*/
  }
syf_beifs_list;

typedef struct syf_beasg		/* signal assignment statement		*/
  {
  char          *NAME;		/* target's name			*/
  struct chain  *ABL;		/* condition (abl)			*/
  unsigned char  TYPE;		/* signal's type			*/
  }
syf_beasg_list;

typedef struct syf_becas		/* case statement			*/
  {
  struct chain  *ABL;		/* expression (ABL)			*/
  struct syf_becho *CHOICE;	/* table of choices			*/
  unsigned char  TYPE;		/* expression's type			*/
  unsigned int   SIZE;		/* size of choices' table		*/
  void          *USER;
  }
syf_becas_list;

typedef struct syf_becho		/* a choice in a case instruction	*/
  {
  char         *VALUE;		/* the value of the choice		*/
  unsigned int  SIZE;		/* size of the value in byte		*/
  struct ptype *INSTRUCTION;	/* list of instructions			*/
  }
syf_becho_list;

typedef struct syf_betyp		/* type or subtype			*/
  {
  struct syf_betyp   *NEXT;		/* next betyp				*/
  char           *NAME;		/* type's name				*/
  int             LEFT;		/* left bound				*/
  int             RIGHT;	/* right bound				*/
  char          **VALUE;	/* list of values			*/
  unsigned int    SIZE;		/* number of values			*/
  unsigned int    BYTE;		/* number of bytes needed to code values*/ 
  char            CLASS;	/* type's class (E, I, A, S)		*/
  unsigned char   INDEX;	/* the type of the index for an array	*/
  unsigned char   BASE;		/* the base type or element's type	*/
  unsigned char   RESOLV;	/* index of resolution function		*/
  }
syf_betyp_list;

typedef struct syf_bepgm		/* pragma				*/
  {
  struct syf_bepgm *NEXT;		/* next pragma				*/
  char         *TOOL;		/* name of target tool			*/
  char         *TYPE;		/* prgma's type				*/
  char         *NAME;		/* object's name			*/
  void         *VALUE;		/* prgma's content			*/
  }
syf_bepgm_list;

	/* ###------------------------------------------------------### */
	/*    low-level functions					*/
	/* ###------------------------------------------------------### */

extern struct syf_beaux  *syf_beh_addbeaux ();
extern struct syf_bebux  *syf_beh_addbebux ();
extern struct syf_bebus  *syf_beh_addbebus ();
extern struct syf_befig  *syf_beh_addbefig ();
extern struct syf_begen  *syf_beh_addbegen ();
extern struct syf_bemsg  *syf_beh_addbemsg ();
extern struct syf_beout  *syf_beh_addbeout ();
extern struct syf_bepor  *syf_beh_addbepor ();
extern struct syf_bereg  *syf_beh_addbereg ();
extern struct syf_berin  *syf_beh_addberin ();
extern struct biabl  *syf_beh_addbiabl ();
extern struct binode *syf_beh_addbinode ();
extern struct ptype  *syf_beh_addbeifs ();
extern struct ptype  *syf_beh_addbeasg ();
extern struct ptype  *syf_beh_addbecas ();
extern struct syf_bepcs  *syf_beh_addbepcs ();
extern struct syf_betyp  *syf_beh_addbetyp ();
extern struct syf_bepgm  *syf_beh_addbepgm ();
extern struct syf_betyp  *syf_beh_crtbetyp ();
extern struct syf_beaux  *syf_beh_delbeaux ();
extern struct syf_bebux  *syf_beh_delbebux ();
extern struct syf_bebus  *syf_beh_delbebus ();
extern struct syf_befig  *syf_beh_delbefig ();
extern struct syf_begen  *syf_beh_delbegen ();
extern struct syf_bemsg  *syf_beh_delbemsg ();
extern struct syf_beout  *syf_beh_delbeout ();
extern struct syf_bepor  *syf_beh_delbepor ();
extern struct syf_bereg  *syf_beh_delbereg ();
extern struct syf_berin  *syf_beh_delberin ();
extern struct biabl  *syf_beh_delbiabl ();
extern struct binode *syf_beh_delbinode ();
extern void           syf_beh_frebeaux ();
extern void           syf_beh_frebebux ();
extern void           syf_beh_frebebus ();
extern void           syf_beh_frebefig ();
extern void           syf_beh_frebegen ();
extern void           syf_beh_frebemsg ();
extern void           syf_beh_frebeout ();
extern void           syf_beh_frebepor ();
extern void           syf_beh_frebereg ();
extern void           syf_beh_freberin ();
extern void           syf_beh_frebiabl ();
extern void           syf_beh_frebinode ();
extern void           syf_beh_frebetyp ();
extern void          *syf_beh_getgenval ();
extern struct syf_beaux  *syf_beh_rmvbeaux ();
extern struct syf_bebux  *syf_beh_rmvbebux ();
extern struct syf_bebus  *syf_beh_rmvbebus ();
extern struct syf_befig  *syf_beh_rmvbefig ();
extern struct syf_begen  *syf_beh_rmvbegen ();
extern struct syf_bemsg  *syf_beh_rmvbemsg ();
extern struct syf_beout  *syf_beh_rmvbeout ();
extern struct syf_bepor  *syf_beh_rmvbepor ();
extern struct syf_bereg  *syf_beh_rmvbereg ();
extern struct syf_berin  *syf_beh_rmvberin ();

extern struct syf_betyp *syf_beh_prdeftyp ();
	/* ###------------------------------------------------------### */
	/*    high-level functions					*/
	/* ###------------------------------------------------------### */

extern void           syf_beh_debug ();

	/* ###------------------------------------------------------### */
	/*    system-level functions					*/
	/* ###------------------------------------------------------### */

extern FILE          *syf_beh_opnfile ();

	/* ###------------------------------------------------------### */
	/*    parser-driver functions					*/
	/* ###------------------------------------------------------### */

extern struct syf_befig  *syf_beh_prsvhdl ();
extern struct syf_befig  *vhdlloadbefig();
extern void   vhdlsavesyf_befig ();

#endif
