
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebinod.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebinode						*/
/* description	: delete a list of BINODE structures and all objects	*/
/*		  pointed by any os BINODEs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebinode (listbinode)

struct binode *listbinode;	/* list of binode to be deleted		*/

  {
  struct binode *ptbinode;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbinode != NULL)
    {
    ptbinode   = listbinode;
    listbinode = listbinode->NEXT;
    mbkfree (ptbinode);
    }

  }
