
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebetyp.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebetyp						*/
/* description	: delete a list of BETYP structures and all objects	*/
/*		  pointed by any os BETYPs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebetyp (listbetyp)

struct syf_betyp *listbetyp;	/* list of betyp to be deleted		*/

  {
  struct syf_betyp *ptbetyp;

	/* ###------------------------------------------------------### */
	/*    for each object of the list delete the object itself	*/
	/* ###------------------------------------------------------### */

  while (listbetyp != NULL)
    {
    ptbetyp   = listbetyp;
    listbetyp = listbetyp->NEXT;
    mbkfree (ptbetyp);
    }

  }
