
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebereg.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebereg						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebereg (listbereg)

struct syf_bereg *listbereg;	/* list of bereg to be deleted		*/

  {
  struct syf_bereg *ptbereg;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbereg != NULL)
    {
    syf_beh_frebiabl  (listbereg->BIABL);
    syf_beh_frebinode (listbereg->BINODE);

    ptbereg   = listbereg;
    listbereg = listbereg->NEXT;
    mbkfree (ptbereg);
    }

  }
