
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebeaux.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebeaux						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebeaux (listbeaux)

struct syf_beaux *listbeaux;	/* list of beaux to be deleted		*/

  {
  struct syf_beaux *ptbeaux;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbeaux != NULL)
    {
    freeExpr (listbeaux->ABL);

    ptbeaux   = listbeaux;
    listbeaux = listbeaux->NEXT;
    mbkfree (ptbeaux);
    }

  }
