
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_delberin.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_delberin						*/
/* description	: delete a BERIN structure and return the pointer of	*/
/*		  the next object.					*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_berin *syf_beh_delberin (listberin, ptberin)

struct syf_berin *listberin;	/* list of berin containing the object	*/
struct syf_berin *ptberin;		/* pointer of the BERIN to be deleted	*/

  {
  struct syf_berin  headrin;
  struct syf_berin *ptlastrin;

  if ((listberin != NULL) && (ptberin != NULL))
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headrin.NEXT = listberin;
    ptlastrin    = &headrin;
    while ((ptlastrin != NULL) && (ptlastrin->NEXT != ptberin))
      ptlastrin = ptlastrin->NEXT;

    if (ptlastrin != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/* ###------------------------------------------------------### */

      ptlastrin->NEXT = ptberin->NEXT;
      mbkfree (ptberin);
      }

    listberin = headrin.NEXT;
    }

  return(listberin);
  }
