
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_delbepor.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_delbepor						*/
/* description	: delete a BEPOR structure and return the pointer of	*/
/*		  the next object.					*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_bepor *syf_beh_delbepor (listbepor, ptbepor)

struct syf_bepor *listbepor;	/* list of bepor containing the object	*/
struct syf_bepor *ptbepor;		/* pointer of the BEPOR to be deleted	*/

  {
  struct syf_bepor  headpor;
  struct syf_bepor *ptlastpor;

  if ((listbepor != NULL) && (ptbepor != NULL))
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headpor.NEXT = listbepor;
    ptlastpor    = &headpor;
    while ((ptlastpor != NULL) && (ptlastpor->NEXT != ptbepor))
      ptlastpor = ptlastpor->NEXT;

    if (ptlastpor != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/* ###------------------------------------------------------### */

      ptlastpor->NEXT = ptbepor->NEXT;
      mbkfree (ptbepor);
      }

    listbepor = headpor.NEXT;
    }

  return(listbepor);
  }
