
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_delbegen.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_delbegen						*/
/* description	: delete a BEGEN structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_begen *syf_beh_delbegen (listbegen, ptbegen, mode)

struct syf_begen *listbegen;	/* list of begen containing the object	*/
struct syf_begen *ptbegen;		/* pointer of the BEGEN to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct syf_begen  headgen;
  struct syf_begen *ptlastgen;

  if ((listbegen != NULL) && (ptbegen != NULL))
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headgen.NEXT = listbegen;
    ptlastgen    = &headgen;
    while ((ptlastgen != NULL) && (ptlastgen->NEXT != ptbegen))
      ptlastgen = ptlastgen->NEXT;

    if (ptlastgen != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if (ptbegen->VALUE != NULL)
          (void) fprintf (stderr,"BEH_warning : begen `%s` not empty\n",
                          ptbegen->NAME);
        }
      else
        mbkfree (ptbegen->VALUE);

      ptlastgen->NEXT = ptbegen->NEXT;
      mbkfree (ptbegen);
      }

    listbegen = headgen.NEXT;
    }

  return(listbegen);
  }
