
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_prdeftyp.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H
#include BEH_H

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_prdeftyp						*/
/* description	: create BETYPs for predefined types			*/
/* called func.	: syf_beh_addbetyp, namealloc				*/
/* ###--------------------------------------------------------------### */

struct syf_betyp *syf_beh_prdeftyp ()

  {
  static char         *bit_vl[2];
  static char         *boolean_vl[2];
  static char         *severity_vl[2];
  struct syf_betyp        *t = NULL;

  boolean_vl[0] = namealloc ("false");
  boolean_vl[1] = namealloc ("true");

  bit_vl[0] = namealloc ("'0'");
  bit_vl[1] = namealloc ("'1'");

  severity_vl[0] = namealloc ("warning");
  severity_vl[1] = namealloc ("error");

	/* ###------------------------------------------------------### */
	/*    Enumeration types						*/
	/* ###------------------------------------------------------### */

  t = syf_beh_addbetyp (t,"severity_level",0,1,severity_vl,2,1,0,0,0,'E');
  t = syf_beh_addbetyp (t,"boolean"       ,0,1,boolean_vl ,2,1,0,0,0,'E');
  t = syf_beh_addbetyp (t,"bit"           ,0,1,bit_vl     ,2,1,0,0,0,'E');

	/* ###------------------------------------------------------### */
	/*    Integer types						*/
	/* ###------------------------------------------------------### */

  t = syf_beh_addbetyp (t,"integer",0x80000000,0x7fffffff,NULL,0,0,0,0,'I');

	/* ###------------------------------------------------------### */
	/*    Subtypes							*/
	/* ###------------------------------------------------------### */

  t = syf_beh_addbetyp (t,"mux_bit",0,1         ,NULL,0,1,2,0,1,'S');
  t = syf_beh_addbetyp (t,"wor_bit",0,1         ,NULL,0,1,2,0,2,'S');
  t = syf_beh_addbetyp (t,"reg_bit",0,1         ,NULL,0,1,2,0,3,'S');
  t = syf_beh_addbetyp (t,"natural",0,0x7fffffff,NULL,0,1,3,0,0,'S');

	/* ###------------------------------------------------------### */
	/*    Unconstraint array types					*/
	/* ###------------------------------------------------------### */

  t = syf_beh_addbetyp (t,"bit_vector",0,0x7fffffff,NULL,0,1,2,7,0,'U');
  t = syf_beh_addbetyp (t,"mux_vector",0,0x7fffffff,NULL,0,1,4,7,0,'U');
  t = syf_beh_addbetyp (t,"wor_vector",0,0x7fffffff,NULL,0,1,5,7,0,'U');
  t = syf_beh_addbetyp (t,"reg_vector",0,0x7fffffff,NULL,0,1,6,7,0,'U');

  return (t);
  }
