
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbepor.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbepor						*/
/* description	: create a BEPOR structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bepor *syf_beh_addbepor (lastbepor, name, dir, type)

struct syf_bepor  *lastbepor;	/* pointer on the last bepor structure	*/
char          *name;		/* signal's name			*/
char           dir;    		/* signal's mode (I, O, B, Z, or T)	*/
unsigned char  type;     	/* signal's type (M or W)		*/

  {
  struct syf_bepor *ptbepor;

  name               = namealloc (name);

  ptbepor            = (struct syf_bepor *) mbkalloc (sizeof(struct syf_bepor));
  ptbepor->NAME      = name;
  ptbepor->DIRECTION = dir;
  ptbepor->TYPE      = type;
  ptbepor->NEXT      = lastbepor;

  return (ptbepor);
  }
