/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbepgm.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbepgm						*/
/* description	: add an BEPGM structure at the top of a list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bepgm *syf_beh_addbepgm (lastbepgm, tool , type , name , value)
struct syf_bepgm  *lastbepgm;	/* pointer on the last bepgm		*/
char          *tool;		/* name's of target tool		*/
char          *type;		/* pragma's type					*/
char          *name;		/* pragma's name			*/
void          *value;		/* pragma's content						*/
  {
  struct syf_bepgm *ptbepgm;

  if(tool)
  	tool            = namealloc (tool);
  if(type)
  	type            = namealloc (type);
  if(name)
  	name            = namealloc (name);

  ptbepgm         = (struct syf_bepgm *) mbkalloc (sizeof(struct syf_bepgm));

  ptbepgm->TOOL   = tool;
  ptbepgm->TYPE   = type;
  ptbepgm->NAME   = name;
  ptbepgm->VALUE  = value;

  ptbepgm->NEXT   = lastbepgm;

  return (ptbepgm);
  }
