
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbepcs.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbepcs						*/
/* description	: create a BEPCS structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bepcs *syf_beh_addbepcs (lastbepcs, label, sens, inst, outs, flag)

struct syf_bepcs *lastbepcs;	/* pointer on the last bepcs structure	*/
char         *label;		/* process's label			*/
struct chain *sens;		/* sensitivity list			*/
struct ptype *inst;		/* list of instructions			*/
struct chain *outs;		/* list of outputs			*/
char          flag;		/* flag					*/

  {
  struct syf_bepcs *ptbepcs;

  label                = namealloc (label);

  ptbepcs              = (struct syf_bepcs *) mbkalloc (sizeof(struct syf_bepcs));
  ptbepcs->LABEL       = label;
  ptbepcs->SENSITIVITY = sens;
  ptbepcs->OUTPUTS     = outs;
  ptbepcs->INSTRUCTION = inst;
  ptbepcs->FLAG        = flag;

  ptbepcs->NEXT        = lastbepcs;

  return (ptbepcs);
  }
