
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbemsg.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbemsg						*/
/* description	: create BEMSG structure at the top the list		*/
/* called func.	: mbkalloc, namealloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bemsg *syf_beh_addbemsg (lastbemsg,label,level,message,abl_expr,bdd_expr)

struct syf_bemsg *lastbemsg;	/* pointer on the last bemsg structure	*/
char         *label;		/* assert's label			*/
char          level;		/* severity level (E or W)		*/
char         *message;		/* reported message			*/
struct chain *abl_expr;		/* assert's condition (ABL)		*/
struct node  *bdd_expr;		/* assert's condition (BDD)		*/

  {

  struct syf_bemsg *ptmsg;

  label          = namealloc (label);

  ptmsg          = (struct syf_bemsg *) mbkalloc (sizeof(struct syf_bemsg));
  ptmsg->LABEL   = label;
  ptmsg->LEVEL   = level;
  ptmsg->MESSAGE = message;
  ptmsg->ABL     = abl_expr;
  ptmsg->NODE    = bdd_expr;
  ptmsg->NEXT    = lastbemsg;

  return (ptmsg);
  }
