
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbefig.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbefig						*/
/* description	: create an empty BEFIG structure at the top of the list*/
/*		  The BEH_HEDFIG list is not modified.			*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_befig *syf_beh_addbefig (lastbefig, name)

struct syf_befig *lastbefig;	/* pointer on the last befig structure	*/
char         *name;		/* figure's name			*/

  {
  struct syf_befig *ptfig;

  name          = namealloc (name);

  ptfig         = (struct syf_befig *) mbkalloc (sizeof(struct syf_befig));
  ptfig->NAME   = name;
  ptfig->BEREG  = NULL;
  ptfig->BEMSG  = NULL;
  ptfig->BERIN  = NULL;
  ptfig->BEOUT  = NULL;
  ptfig->BEBUS  = NULL;
  ptfig->BEAUX  = NULL;
  ptfig->BEDLY  = NULL;
  ptfig->BEBUX  = NULL;
  ptfig->BEPOR  = NULL;
  ptfig->BEPCS  = NULL;
  ptfig->BETYP  = NULL;
  ptfig->BEPGM  = NULL;
  ptfig->CIRCUI = NULL;
  ptfig->USER   = NULL;
  ptfig->FLAG   = 0;
  ptfig->NEXT   = lastbefig;

  return (ptfig);
  }
