
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbecas.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbecas						*/
/* description	: create a BECAS structure at the top the list		*/
/* called func.	: addptype, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct ptype *syf_beh_addbecas (lastptype, abl,type)

struct ptype *lastptype;	/* pointer on the last ptype structure	*/
struct chain *abl;		/* condition's expression		*/
unsigned char type;		/*  expression's type	i			*/

  {
  struct ptype *ptptype;
  struct syf_becas *ptbecas;

  ptbecas           = (struct syf_becas *) mbkalloc (sizeof(struct syf_becas));
  ptbecas->ABL      = abl;
  ptbecas->CHOICE   = NULL;
  ptbecas->USER     = NULL;
  ptbecas->SIZE     =  0;
  ptbecas->TYPE     = type;

  ptptype           = addptype (lastptype, BEH_BECAS, (void *)ptbecas);

  return (ptptype);
  }
