
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbebux.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbebux						*/
/* description	: create a BEBUX structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bebux *syf_beh_addbebux (lastbebux, name, biabl, binode, type)

struct syf_bebux  *lastbebux;	/* pointer on the last bebux structure	*/
char          *name;		/* signal's name			*/
struct biabl  *biabl;		/* signal's expression (ABL)		*/
struct binode *binode;		/* signal's expression (BDD)		*/
char           type;		/* signal's type mark (M or W)		*/

  {
  struct syf_bebux *ptbux;

  name          = namealloc (name);

  ptbux         = (struct syf_bebux *) mbkalloc (sizeof(struct syf_bebux));
  ptbux->NAME   = name;
  ptbux->BIABL  = biabl;
  ptbux->BINODE = binode;
  ptbux->TYPE   = type;
  ptbux->NEXT   = lastbebux;

  return (ptbux);
  }
