
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbeaux.c					*/
/* date		: Aug  28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbeaux						*/
/* description	: create a BEAUX structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_beaux *syf_beh_addbeaux (lastbeaux, name, abl_expr, bdd_expr, type)

struct syf_beaux *lastbeaux;	/* pointer on the last beaux structure	*/
char         *name;		/* signal's name			*/
struct chain *abl_expr;		/* signal's expression (ABL)		*/
struct node  *bdd_expr;		/* signal's expression (BDD)		*/
unsigned char  type;		/* signal's type 			*/

  {
  struct syf_beaux *ptaux;

  name        = namealloc (name);

  ptaux       = (struct syf_beaux *) mbkalloc (sizeof(struct syf_beaux));
  ptaux->NAME = name;
  ptaux->ABL  = abl_expr;
  ptaux->NODE = bdd_expr;
  ptaux->TYPE = type;
  ptaux->NEXT = lastbeaux;

  return (ptaux);
  }
