/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_system.c                                                */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 16/07/1991     */
/*                                                                          */
/*    Modifie par :                                     le : 25/10/1991     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include MUT_H
#include LOG_H
#include BEH_H
#include "ctype.h"
#include "../menu/sl_corps.h"
#include "../ablorder/sl_order.h"
#include "../compil/lax_param.h"
#include "../mapping/types.h"
#include "../mapping/compile.h"
#include "../mapping/util.h"
#include "../mbk/sl_mbk.h"
#include "../cccc/c4_debug.h"
#include "../cccc/c4.h"
#include "sl_type.h"
#include "../compil/sl_util.h"

		/* on ne verifie pas si les fichiers existent ... */

#define VERIFILE 0

char *getenv();

/*----------------------------------------------------------------------------
verifArgs	: verifie les arguments de la ligne de commande.
------------------------------------------------------------------------------
retour		: un entier a 1 si OK, 1 sinon.
------------------------------------------------------------------------------*/

int verifArgs(sl,argc,argv)
sl_system *sl;
int argc;
char *argv[];
{
FILE *fic;
FILE *fopen();
char *carint;

		/* logic file_input file_output */

if (argc == 3)
   {
   if (argv[1][0] == '-') 
      {
      if (strcmp(argv[1],"-o") && strcmp(argv[1],"-l") && 
          strcmp(argv[1],"-s") && strcmp(argv[1],"-c"))
         {
         printf("\nlogic 3.00      : bad input file name '%s'\n\n",argv[1]) ;
         }
      else
         printf("\nlogic 3.00      : missed output file name\n\n") ;
      return(0) ;
      }
   argv[1] = (char *) genNAME("%s.vbe",argv[1]);
   return(1);
   }

		/* avec option */

if (argc > 1 && argv[1][0] == '-') 
   {
   if (strcmp(argv[1],"-o") && strcmp(argv[1],"-l") && strcmp(argv[1],"-s") && 
       strcmp(argv[1],"-c"))
      {
      printf("\nlogic 3.00      : bad option '%s'\n\n",argv[1]) ;
      return(0) ;
      }
   }

		/* interactif avec un fichier de parametres */

if (argc == 4 && strcmp(argv[1],"-o") &&  strcmp(argv[1],"-l") &&
                 strcmp(argv[1],"-s") && strcmp(argv[1],"-c"))
   {
   argv[1] = (char *) genNAME("%s.vbe",argv[1]);
   argv[3] = (char *) genNAME("%s.lax",argv[3]);

   if (VERIFILE)
      {
	/* on verifie l'existence du fichier de parametres */

      if (!strcmp(sl->par_lib,"."))
         {
         if(!(fic = fopen(argv[2],"r")))
      	   {
	   printf("\nlogic 3.00      : unable to open '%s'\n\n",argv[2]) ;
	   return(0) ;
	   }
         else
           fclose(fic);
         }
      else
         {
         carint = (char *) genNAME("%s/%s",sl->par_lib,argv[2]);
         if(!(fic = fopen(carint,"r")))
      	   {
	   printf("\nlogic 3.00      : unable to open ") ;
           printf(" '%s'\n\n",carint);
           mbkfree(carint);
	   return(0) ;
	   }
         else
           fclose(fic);
         mbkfree(carint);
         }
      }
   return(1);
   }			/* fin appel version interactive */

if (argc < 4 || argc > 5)
   {
   printf("\nlogic 3.00 \nusage  :  logic [-option] <file_input> <file_output> [<file_par>]\n");
   printf("option : -o   global optimization\n");
   printf("         -l   local optimization\n"); 
   printf("         -s   mapping standard cells\n"); 
   printf("         -c   mapping with C4\n"); 
   return(0) ;
   }


argv[2] = (char *) genNAME("%s.vbe",argv[2]);

		/* avec fichier de parametres */

if (argc > 4)
   argv[4] = (char *) genNAME("%s.lax",argv[4]);

if (VERIFILE)
   {
   if (!strcmp(sl->beh_lib,"."))
      {
      if(!(fic = fopen(argv[2],"r")))
	   {
	   printf("\nlogic 3.00      : unable to open '%s'\n\n",argv[2]) ;
	   return(0) ;
	   }
      else
           fclose(fic);
      }
   else
      {
      if(!(fic = fopen(carint = (char *) genNAME("%s/%s",sl->beh_lib,argv[2]),"r")))
	   {
	   printf("\nlogic 3.00      : unable to open '%s'\n\n",carint) ;
           mbkfree(carint);
	   return(0) ;
	   }
      else
           fclose(fic);
      mbkfree(carint);
      }

   if (argc == 4)
      {
      argv[3] = (char *) genNAME("%s.lax",argv[3]);
      if (!strcmp(sl->par_lib,"."))
         {
         if(!(fic = fopen(argv[3],"r")))
      	   {
	   printf("\nlogic 3.00      : unable to open '%s'\n\n",argv[3]) ;
	   return(0) ;
	   }
         else
           fclose(fic);
         }
      else
         {
         if(!(fic = fopen(carint = (char *) genNAME("%s/%s",sl->par_lib,argv[3]),"r")))
      	   {
	   printf("\nlogic 3.00      : unable to open ") ;
           printf(" '%s'\n\n",genNAME("%s",carint));
	   return(0) ;
	   }
         else
           fclose(fic);
         mbkfree(carint);
         }
      }
   }
return(1);
}


/*----------------------------------------------------------------------------
majSystem: mets a jour les champs du systeme 
------------------------------------------------------------------------------
retour		: rien 
-----------------------------------------------------------------------------*/
void majSystem(sl)
sl_system *sl;
{
if (!getenv("MBK_WORK_LIB"))
   strcpy(sl->beh_lib,".");
else
   strcpy(sl->beh_lib,getenv("MBK_WORK_LIB"));

if (!existDirectory(sl->beh_lib))
   {
   printf("\nlogic 3.00      : MBK_WORK_LIB -> the directory '%s' doesn't exist\n",sl->beh_lib);
   exit(-1);
   }

if (!getenv("MBK_WORK_LIB"))
   strcpy(sl->log_lib,".");
else
   strcpy(sl->log_lib,getenv("MBK_WORK_LIB"));

if (!getenv("MBK_WORK_LIB"))
   strcpy(sl->par_lib,".");
else
   strcpy(sl->par_lib,getenv("MBK_WORK_LIB"));

if (!getenv("MBK_TARGET_LIB"))
   strcpy(sl->cata_lib,".");
else
   strcpy(sl->cata_lib,getenv("MBK_TARGET_LIB"));

if (!existDirectory(sl->cata_lib))
   {
   printf("\nlogic 3.00      : MBK_TARGET_LIB -> the directory '%s' doesn't exist\n",sl->cata_lib);
   exit(-1);
   }

if (!getenv("MBK_CATA_LIB"))
   strcpy(sl->cata_save,".");
else
   strcpy(sl->cata_save,getenv("MBK_CATA_LIB"));

if (!getenv("MBK_C4_LIB"))
   strcpy(sl->c4_lib,".");
else
   strcpy(sl->c4_lib,getenv("MBK_C4_LIB"));

if (!existDirectory(sl->c4_lib))
   {
   printf("\nlogic 3.00      : MBK_C4_LIB -> the directory '%s' doesn't exist\n",sl->c4_lib);
   exit(-1);
   }

if (!getenv("MBK_OUT_LO"))
   strcpy(sl->in_lo,"al");
else
   strcpy(sl->in_lo,getenv("MBK_OUT_LO"));

if (!getenv("MBK_OUT_LO"))
   strcpy(sl->out_lo,"al");
else
   strcpy(sl->out_lo,getenv("MBK_OUT_LO"));

if (!getenv("MBK_OUT_PH"))
   strcpy(sl->out_ph,"ap");
else
   strcpy(sl->out_ph,getenv("MBK_OUT_PH"));

if (getenv("MBK_TRACE") == NULL || !strcmp(getenv("MBK_TRACE"),"0"))
   sl->trace = 0; 
else
   if (!strcmp(getenv("MBK_TRACE"),"1"))
      sl->trace = 1;
   else
      if (!strcmp(getenv("MBK_TRACE"),"2"))
         sl->trace = 2;
      else
         if (!strcmp(getenv("MBK_TRACE"),"3"))
            sl->trace = 3;
         else
            sl->trace = 0;

		/* affichage de la banniere */

if (getenv("MBK_BANN"))
   sl->banniere = 0;	
else
   sl->banniere = 1;

		/* meme nom de lofig que de befig */ 

if (!getenv("MBK_NAME_LOG"))
   sl->name_log = 0;		/* on genere une lofig du nom  + optim */
else
   sl->name_log = 1;		/* on genere une lofig du meme nom */

/* appel aux fonctions d'ordonnancement - 0 rien - 1 ABL - 2 ABL + BDD */ 

if (!getenv("MBK_ORDER"))
   sl->makeOrder = 2;
else
   if (!strcmp(getenv("MBK_ORDER"),"0"))
      sl->makeOrder = 0;	
   else
      if (!strcmp(getenv("MBK_ORDER"),"1"))
         sl->makeOrder = 1;
      else
         sl->makeOrder = 2;

if (sl->makeOrder >= 1)
   sl->order = 1;

if (!getenv("MBK_AUXOF"))
   sl->auxOF = 1;	/* on ne cree pas de VI lors de l'optimisation */ 
else
   sl->auxOF = 0;	/* on peut creer des VI */ 
}
/*----------------------------------------------------------------------------
addInfoSystem	: ajoute les infos de process et de fichiers a traiter
------------------------------------------------------------------------------
retour		: rien. 
------------------------------------------------------------------------------*/

void addInfoSystem(sl,mode,argc,argv,version)
sl_system *sl;
int mode;
int argc;
char *argv[];
char *version;
{
char *carint;

strcpy(sl->version,version);
sl->mode = mode;

		/* version batch */

if (sl->mode == 1)
   {
		/* on recupere le nom du fichier d'entree */

   strcpy(sl->file,argv[2]) ;
   if (!strcmp(sl->beh_lib,"."))
      strcpy(sl->fileVhdl,argv[2]) ;
   else
      {
      strcpy(sl->fileVhdl,carint = (char *) genNAME("%s/%s",sl->beh_lib,argv[2]));
      mbkfree(carint);
      }

		/* on recupere le nom du fichier de sortie */

   strcpy(sl->fileOut,argv[3]);

		/* parametres */

   sl->par = initializeParam(2,0,2,NULL,NULL,NULL,4,4);
   if (argc == 5)
      {
      strcpy(sl->filePar,argv[4]) ;
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,argv[4]) ;
      else
         {
         strcpy(sl->fileParam,carint = (char *) genNAME("%s/%s",sl->par_lib,argv[4])) ;
         mbkfree(carint);
         }
      sl->par = loadParam(sl->fileParam);
      if (sl->par == NULL) 
 	 { 
	 exit( -1 );
	 }
      }
   else
      {
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,"default.lax");
      else
         {
         strcpy(sl->fileParam,carint = (char *) genNAME("%s/default.lax",sl->par_lib));
         mbkfree(carint);
         }
      }
   sl->option = *(argv[1]+1);
   }
else		/* mode interactif 0 ou 2 */
   {

		/* on recupere le nom du fichier d'entree */

   strcpy(sl->file,argv[1]) ;
   if (!strcmp(sl->beh_lib,"."))
      strcpy(sl->fileVhdl,argv[1]) ;
   else
      {
      strcpy(sl->fileVhdl,carint = (char *) genNAME("%s/%s",sl->beh_lib,argv[1]));
      mbkfree(carint);
      }
		/* on recupere le nom du fichier de sortie */

   strcpy(sl->fileOut,argv[2]);

   sl->par = initializeParam(2,0,2,NULL,NULL,NULL,4,4);
   if (sl->mode == 0)
      {
      strcpy(sl->filePar,"default.lax");
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,"default.lax");
      else
         {
         strcpy(sl->fileParam,carint = (char *) genNAME("%s/default.lax",sl->par_lib));
         mbkfree(carint);
         }
      }
   else		/* mode 2 */
      {
      strcpy(sl->filePar,argv[3]) ;
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,argv[3]) ;
      else
         {
         strcpy(sl->fileParam,carint = (char *) genNAME("%s/%s",sl->par_lib,argv[3])) ;
         mbkfree(carint);
         }
      sl->par = loadParam(sl->fileParam);
      if (sl->par == NULL) 
 	 { 
	 exit( -1 );
 	 }
      }
   sl->option = '\0';
   }
		/* mise a jour des variables de MBK */

putenv((char *) genNAME("MBK_CATA_LIB=%s:%s",SL_CATA_LIB,SL_CCCC_LIB));
putenv((char *) genNAME("MBK_IN_LO=%s",SL_IN_LO));
mbkenv();
}

/*----------------------------------------------------------------------------
displaySystem   : affiche les arguments de la synthese 
------------------------------------------------------------------------------
retour		: void 
------------------------------------------------------------------------------*/

void displaySystem(sys)
sl_system *sys;
{
        /* nouvelle banniere (Septembre 93)*/

alliancebanner("Logic", SL_VERSION, "Logic Synthesis", "90-93", ALLIANCE_VERSION);

if (SL_MODE == 1)		/* mode batch */
   {
   printf("================================  Environment  ==============================\n");
   printf("MBK_WORK_LIB       = %s\n",SL_BEH_LIB);
   printf("MBK_CATA_LIB       = %s\n",SL_CATA_SAVE);
   if (SL_OPTION == 's' || SL_OPTION == 'c')
      {
      printf("MBK_NAME_LOG        = %d\n",SL_NAME_LOG);
      if (SL_OPTION == 's')
         {
         printf("MBK_TARGET_LIB      = %s\n",SL_CATA_LIB);
         printf("MBK_IN_LO           = %s\n",SL_IN_LO);
         }
      else
         {
         printf("MBK_C4_LIB          = %s\n",SL_CCCC_LIB);
         printf("MBK_OUT_PH          = %s\n",SL_OUT_PH);
         } 
      printf("MBK_OUT_LO          = %s\n",SL_OUT_LO);
      }
   if (SL_TRACE > 0)
      printf("MBK_TRACE           = %d\n",SL_TRACE);
   printf("=======================  Files, Options and Parameters  =======================\n");
   printf("VHDL file          = %s\n",SL_FILE);
   if (SL_OPTION == 'o' || SL_OPTION == 'l')
      printf("output file        = %s.vbe\n",SL_FILEOUT);
   else
      printf("output file        = %s.%s\n",SL_FILEOUT,SL_OUT_LO);
   printf("Parameters file    = %s\n",SL_PARAM);
   printf("Mode               = ");
   switch (SL_OPTION)
       {
       case 'o' : printf("Global optimization\n"); break;
       case 'l' : printf("Local optimization\n"); break;
       case 's' : printf("Mapping standard cell\n"); break;
       case 'c' : printf("Mapping with C4\n"); break;
       }
   printf("Optimization mode  = %d\n",SL_OPTIM);
   printf("Optimization level = %d\n",SL_LEVEL);
   if (SL_OPTION == 's' || SL_OPTION == 'c')
      {
      if (SL_OPTION == 's') 
         {
         printf("Mapping Standard Cells\n");
         }
      else
         {
         printf("Mapping free (compiler cells C4 actived)\n");
         printf("Number of serial transistors on graph P = %d\n",SL_NUMTRANSP);
         printf("Number of serial transistors on graph N = %d\n",SL_NUMTRANSN);
         }
      }
   printf("===============================================================================\n");
   printf("\n");
   }
}

