/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  synthese FPGA                                              */
/*    Fichier :  cost.c                                                     */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  Eudes Prado Lopes                       le : 20 /10/1993 */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H
#include "../compil/lax_param.h"
#include "../compil/sl_util.h"
#include "../bddorder/bdd_order.h"
#include "fp_type.h"
#include "fpga.h"

/*----------------------------------------------------------------------------
costIntX4000	: fonction interne de cout des X4000 pour guider 
                  le re-odonnancement
------------------------------------------------------------------------------
retour		: un pointeur de liste chainee (support)
                  un cout (entier) -> par adresse
------------------------------------------------------------------------------*/
chain_list *costIntX4000(pt,pCount)
pNode pt;
int *pCount;
{
chain_list *lstLow, *lstHigh;
chain_list *res;
int lenRes;
pNode pBdd, low, high;
pNode ptInv;
chain_list *toto;
int inclusion;

if (pt->index < 2)	/* noeud terminal */
   return (NULL);

if ((pt->low)->index < 2 && (pt->high)->index < 2)	/* noeud atomique */
   {
   return(addchain(NULL,pt->index));
   }

			/* noeud deja traite */

if (pt->mark == 1)	/* CLB de fonction directe */
   {
   return(addchain(NULL,pt));
   }

if (pt->mark == 2)	/* CLB de fonction inverse */
   {
   return(addchain(NULL,notBdd(pt)));
   }

		/* simplifications eventuelles avant l'appel
                   recursif sur les fils */

inclusion = 0;
if (RULES_DC)
   {
   pBdd = applyBinBdd(AND,pt->high,pt->low);

   if (pBdd == pt->low)
      {
      high = simplifDcOneBdd(pt->high,pt->low);
      inclusion = 1;
      }
   else
      high = pt->high;

   if (pBdd == pt->high)
      {
      low = simplifDcOneBdd(pt->low,pt->high);
      inclusion = 2;
      }
   else
      low = pt->low;
   }
else
   {
   high = pt->high;
   low = pt->low;
   }

lstLow = costIntX4000(low,pCount);
lstHigh = costIntX4000(high,pCount);

	 /* fusion lexico-graphique des listes chainees */	

res = (chain_list *) fusionLC(lstLow,lstHigh);

lenRes = countChain_list(res);

if (lenRes < SUPPORTMAX)
   {
   freechain(lstLow);
   freechain(lstHigh);
   return(addchain(res,pt->index));
   }
else
   {
   freechain(lstLow);
   freechain(lstHigh);
   freechain(res);

   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2; 

   low->mark = 1;
   ptInv = notBdd(low);
   ptInv->mark = 2; 

   high->mark = 1;
   ptInv = notBdd(high);
   ptInv->mark = 2; 

   *pCount = *pCount + 1;
   
   if (inclusion)
      return(addchain(addchain(addchain(NULL,high),low),pt->index));
   else
      return(addchain(NULL,pt));
   }
}
/*----------------------------------------------------------------------------
costX4000	: fonction de cout des X4000 pour guider le re-odonnancement
------------------------------------------------------------------------------
retour		: un cout (entier)
------------------------------------------------------------------------------*/
int costX4000(pt)
pNode pt;
{
chain_list *res;
pNode ptInv;
int count = 0;		/* nombre de CLB utilises */

res = costIntX4000(pt,&count);
if (res == NULL || (res->NEXT == NULL && pt->mark != 2))
   {
   if (res) freechain(res);
   return(count);
   }
else
   {
   freechain(res);
   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2; 
   return(1 + count);
   }
}


/*-------------------------------------------------------------------------
costX4000Beh     : calcule le cout X4000 d'une befig 
---------------------------------------------------------------------------
retour          : un void.
---------------------------------------------------------------------------*/

void costX4000Beh(beh,numCLB,depthCLB)
befig_list *beh;
int *numCLB;
int *depthCLB;
{
beout_list *out;
beaux_list *aux;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
binode_list *binode;
biabl_list *biabl;
chain_list *lstCLB4;
chain_list *tete;

*numCLB = 0;
*depthCLB = 0;
lstCLB4 = NULL;

markAllBdd(0);

if (FP_AUX)
   {
   aux = beh->BEAUX;
   while (aux) 
      {
      if (aux->NODE)
         {
         *numCLB = *numCLB + costX4000(aux->NODE,&lstCLB4);
         }
      aux = aux->NEXT;
      }
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->NODE)
      {
      *numCLB = *numCLB + costX4000(out->NODE,&lstCLB4);
      }
   out = out->NEXT;
   }
reg = beh->BEREG;
while (reg) 
   {
   binode = reg->BINODE;
   while (binode)
      {
      if (binode->CNDNODE && binode->VALNODE)
         {
         *numCLB = *numCLB + costX4000(binode->VALNODE,&lstCLB4);
         *numCLB = *numCLB + costX4000(binode->CNDNODE,&lstCLB4);
         }
      binode = binode->NEXT;
      }
   reg = reg->NEXT;
   }
		/* desallocation de lstCLB4 */

tete = lstCLB4;
while (lstCLB4)
   {
   if (lstCLB4->DATA)
      freechain(lstCLB4->DATA);
   lstCLB4 = lstCLB4->NEXT;
   }
freechain(tete);
}

