/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  synthese logique (gestion du fichier de parametres)        */
/*    Fichier :  lax_param.c                                                */
/*                                                                          */
/*    (c) copyright 1993 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : N. Dictus                             le : 13/12/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include MUT_H
#include "lax_param.h"


#define MODE_FLAG       0x0001
#define LEVEL_FLAG      0x0002
#define SIGNAL_FLAG     0x0004
#define DELAY_FLAG      0x0008
#define EARLY_FLAG      0x0010
#define TRANSN_FLAG     0x0020
#define TRANSP_FLAG     0x0040
#define SLOPE_FLAG      0x0080
#define IMPED_FLAG      0x0100
#define CAPA_FLAG       0x0200
#define AUX_FLAG  	0x0400
#define CAPI_FLAG       0x0800

#define GET_INT( x )            x = 0;                          \
                                while(isdigit( c ))             \
                                {                               \
                                    x = 10 * x + c - '0';       \
                                    c = fgetc( Pfile );         \
                                }                               \
                                while( isspace( c )){ c = getc( Pfile ); }

#define NEXT_LINE               while( (c = getc( Pfile )) != '\n' );      

#define NEXT_CHAR               c = getc( Pfile );                       \
                                while( isspace( c )){ c = getc( Pfile ); }

/*-----------------------------------------------------*\
|*         Convert VHDL name to internal IO name       *|
\*-----------------------------------------------------*/
char    *parseName( VHDL_name )
char    *VHDL_name;
{
    char        *p;
    char        *Found;
   
    p = (char *)mbkalloc( strlen( VHDL_name ) + 1 );

    strcpy( p ,VHDL_name );

    Found = strchr( p, '(' );

    if( Found != NULL )
    {    
        Found[0] = ' ';
        Found = strchr( p, ')' );
        Found[0] = '\0';
    }    
 
    return( p );
}
 
/*-----------------------------------------------------*\
|*         Convert internal IO name to VHDL name       *|
\*-----------------------------------------------------*/
char    *driveName( IO_name )
char    *IO_name;
{
    char        *p;
    char        *Found;

/*
    printf("init %s-\n", IO_name);
*/
    Found = strchr( IO_name, ' ' );

    if (Found != NULL )
       {
/*
    printf("init %s, Found =%s-\n", IO_name, Found);
*/
       p = mbkalloc( strlen( IO_name ) + 2 );
       sprintf( p ,"%s)",IO_name );
       Found = strchr( p, ' ' );
       Found[0] = '(';
       return( p );
       }
    else 
       return( IO_name );
}    

/*---------------------------------------------------------------------------
loadParam        :
-----------------------------------------------------------------------------
retour           :
---------------------------------------------------------------------------*/
param *loadParam( FileName )
char *FileName;
{
FILE        *Pfile;
char        c;
char        Auxiliaire[ 30 ];
char        buf[ 80 ];
char        *Name;
long        Value;
int         flag = 0;
int         i, n;

param *loadparam = (param *)mbkalloc(sizeof(param));
resetParam(loadparam);

if (( Pfile = fopen(FileName, "rt" )) != NULL )
   {
   while (!feof( Pfile ))
      {
      NEXT_CHAR
      if (c  == '#' )
         {
         c = fgetc( Pfile );

         switch (c )
            {
            case 'M':/* Mode */
               if (flag & MODE_FLAG )
                  {
                  printf("Load param ERROR : Mode : Defined twice !\n");
                  return NULL;
                  }
               else
                  {
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     if (isdigit( c ) )
                        {
                        GET_INT(loadparam->mode)
                        if (c == '}' )
                           {
                                /* Check parameter */
                           if ((loadparam->mode)<0 || (loadparam->mode)>4 )
                              {
                              printf("Load param ERROR : Mode : Out of range (0 to 4).");
                              return NULL;
                              }
                           else
                              flag |=MODE_FLAG;
                           }
                        else 
                           {
                           printf("Load param ERROR : Mode : Can't find right brace");
                           return NULL;
                           }
                        }
                     else 
                        {
                        printf("Load param ERROR : Mode : not an integer");
                        return NULL;
                        }
                     }
                  else 
                     {
                     printf("Load param ERROR : Mode : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

            case 'L':/* Level */
               if (flag & LEVEL_FLAG )
                  {
                  printf("Load param ERROR : Level : Defined twice !\n");
                  return NULL;
                  }
               else
                  {   
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     if (isdigit( c ) )
                        {
                        GET_INT(loadparam->level)
                        if (c == '}' )
                           {
                                /* Check parameter */
                           if ((loadparam->level)<1 || (loadparam->level)>5 )
                              {
                              printf("Load param ERROR : Level : Out of range (1 to 5).");
                              return NULL;
                              }
                           else
                              flag |=LEVEL_FLAG;
                           }    
                        else 
                           {
                           printf("Load param ERROR : Level : Can't find right brace");
                           return NULL; 
                           }
                        }
                     else 
                        {
                        printf("Load param ERROR : Level : not an integer");
                        return NULL;
                        }
                     }
                   else 
                      {
                      printf("Load param ERROR : Level : Can't find left brace.");
                      return NULL;
                      }
                   }
                break;

            case 'N':/* Transistors N */
               if (flag & TRANSN_FLAG )
                  {
                  printf("Load param ERROR : N Transistors : Defined twice !\n");
                  return NULL;
                  }
               else
                  {   
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     if (isdigit( c ) )
                        {
                        GET_INT(loadparam->numTransN)
                        if (c == '}' )
                           {
                                /* Check parameter */
                           if ((loadparam->numTransN)<0 || (loadparam->numTransN)>6 )
                              {
                              printf("Load param ERROR : N Transistors : Out of range (0 to 6).");
                              return NULL;
                              }
                           else
                              flag |=TRANSN_FLAG;
                           }    
                        else 
                           {
                           printf("Load param ERROR : N Transistors : Can't find right brace");
                           return NULL;
                           }
                        }
                     else
                        {
                        printf("Load param ERROR : N Transistors : not an integer");
                        return NULL;
                        }
                     }
                  else 
                     {
                     printf("Load param ERROR : N Transistors : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

            case 'P':/* Transistors P */
               if (flag & TRANSP_FLAG )
                  {
                  printf("Load param ERROR : P Transistors : Defined twice !\n");
                  return NULL;
                  }
               else
                  {   
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     if (isdigit( c ) )
                        {
                        GET_INT(loadparam->numTransP)
                        if (c == '}' )
                           {
                                /* Check parameter */
                           if ((loadparam->numTransP)<0 || (loadparam->numTransP)>6 )
                              {
                              printf("Load param ERROR : P Transistors : Out of range (0 to 6).");
                              return NULL;
                              }
                           else
                              flag |=TRANSP_FLAG;
                           }    
                        else 
                           {
                           printf("Load param ERROR : P Transistors : Can't find right brace");
                           return NULL;
                           }
                        }
                     else 
                        {
                        printf("Load param ERROR : P Transistors : not an integer");
                        return NULL;
                        }
                     }
                  else
                     {
                     printf("Load param ERROR : P Transistors : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

            case 'T':/* Max Slope Time */
               if (flag & SLOPE_FLAG )
                  {
                  printf("Load param ERROR : Slope Time : Defined twice !\n");
                  return NULL;
                  }
               else
                  {   
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     if (isdigit( c ) )
                        {
                        GET_INT(loadparam->maxSlopeTime)
                        if (c == '}' )
                           {
                                /* Check parameter */
                           if ((loadparam->maxSlopeTime)<0 || (loadparam->maxSlopeTime)>10000)
                              {
                              printf("Load param ERROR : Slope Time : Out of range (0 to 10000).");
                              return NULL;
                              }
                           else
                              flag |=SLOPE_FLAG;
                           }
                        else
                           {
                           printf("Load param ERROR : Slope Time : Can't find right brace");
                           return NULL;
                           }
                        }
                     else 
                        {
                        printf("Load param ERROR : Slope Time : not an integer");
                        return NULL;
                        }
                     }
                  else 
                     {
                     printf("Load param ERROR : Slope Time : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

            case 'S':/* Intermediate signals */
               if (flag & SIGNAL_FLAG )
                  {
                  printf("Load param ERROR : Intermediate signals : Defined twice !\n");
                  return NULL;
                  }
               else
                  {   
                  NEXT_CHAR
                  if (c == '{' )
                     {
                     NEXT_CHAR
                     n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ';') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Intermediate signals : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) 
                          NEXT_CHAR
                       if (c == ';' )
                          {
                          Auxiliaire[i] = '\0';
                          Name = parseName( Auxiliaire );
                          loadparam->intermediate = addchain(loadparam->intermediate, namealloc(Name) );
                          n++;
                          NEXT_CHAR
                          }
                       else 
                          {
                          printf("Load param ERROR : Intermediate signals : syntax error.");
                          return NULL;
                          }
                       if (feof( Pfile ))
                          {
                          printf("Load param ERROR : Intermediate signals : Unexpected end of file.");
                          return NULL;
                          }
                       }    
                    if (n )
                       {
                       loadparam->intermediate = (chain_list *)reverse( loadparam->intermediate );
                       flag |= SIGNAL_FLAG;
                       }
                    else 
                       {
                       printf("Load param ERROR : Intermediate signals : Declaration empty");
                       return NULL;
                       }
                    }
                 else 
                    {
                    printf("Load param ERROR : Intermediate signals : Can't find left brace.");
                    return NULL;
                    }
                 }
              break;

           case 'D':/* Delayed Inputs */
              if (flag & DELAY_FLAG )
                 {
                 printf("Load param ERROR : Delayed inputs : Defined twice !\n");
                 return NULL;
                 }
              else
                 {   
                 NEXT_CHAR
                 if (c == '{' )
                    {
                    NEXT_CHAR
                    n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ':') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Delayed inputs : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) NEXT_CHAR
                          if (c == ':' )
                             {
                             NEXT_CHAR
                             if (isdigit( c ) )
                                {
                                GET_INT(Value)
                                if (c == ';' )
                                   {
                                   Auxiliaire[i] = '\0';
                                   Name = (char *)parseName( Auxiliaire );
                                   loadparam->delayPI = addptype(loadparam->delayPI,Value,namealloc(Name));
                                   n++;
                                   NEXT_CHAR
                                   }
                                else 
                                   {
                                   printf("Load param ERROR : Delayed inputs : syntax error.");
                                   return NULL;
                                   }
                                }
                             else 
                                {
                                printf("Load param ERROR : Delayed inputs : not an integer!\n");
                                return NULL;
                                }
                             }
                          else 
                             {
                             printf("Load param ERROR : Delayed inputs : syntax error.");
                             return NULL;
                             }
                       if (feof( Pfile ))
                          {
                          printf("Load param ERROR : Delayed inputs : Unexpected end of file.");
                          return NULL;
                          }
                       }    
                    if (n )
                       {
                       loadparam->delayPI = (ptype_list *)reverse( loadparam->delayPI );
                       flag |= DELAY_FLAG;
                       }
                    else
                       {
                       printf("Load param ERROR : Delayed inputs : Declaration empty");
                       return NULL;
                       }
                    }
                 else
                    {
                    printf("Load param ERROR : Delayed inputs : Can't find left brace.");
                    return NULL;
                    }
                 }
              break;

           case 'E':/* Early Outputs */
              if (flag & EARLY_FLAG )
                 {
                 printf("Load param ERROR : Early outputs : Defined twice !\n");
                 return NULL;
                 }
              else
                 {   
                 NEXT_CHAR
                 if (c == '{' )
                    {
                    NEXT_CHAR
                    n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ';') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Early outputs : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) NEXT_CHAR
                          if (c == ';' )
                             {
                             Auxiliaire[i] = '\0';
                             Name = (char *)parseName( Auxiliaire );
                             loadparam->earlyPO = addchain(loadparam->earlyPO, namealloc(Name) );
                             n++;
                             NEXT_CHAR
                             }
                          else 
                             {
                             printf("Load param ERROR : Early outputs : syntax error.");
                             return NULL;
                             }
                       if (feof( Pfile ))
                          {
                          printf("Load param ERROR : Early outputs : Unexpected end of file.");
                          return NULL;
                          }
                       }    
                    if (n )
                       {
                       loadparam->earlyPO = (chain_list *)reverse( loadparam->earlyPO );
                       flag |= EARLY_FLAG;
                       }
                    else 
                       {
                       printf("Load param ERROR : Early outputs : Declaration empty");
                       return NULL;
                       }
                    }
                 else 
                    {
                    printf("Load param ERROR : Early outputs : Can't find left brace.");
                    return NULL;
                    }
                 }
              break;

           case 'I':/* Input Impedances */
              if (flag & IMPED_FLAG )
                 {
                 printf("Load param ERROR : Inputs impedances : Defined twice !\n");
                 return NULL;
                 }
              else
                 {   
                 NEXT_CHAR
                 if (c == '{' )
                    {
                    NEXT_CHAR
                    n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ':') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Inputs impedances : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) NEXT_CHAR
                          if (c == ':' )
                             {
                             NEXT_CHAR
                             if (isdigit( c ) )
                                {
                                GET_INT(Value)
                                if (c == ';' )
                                   {
                                   Auxiliaire[i] = '\0';
                                   Name = (char *)parseName( Auxiliaire );
                                   loadparam->impedancePI = addptype(loadparam->impedancePI,Value,namealloc(Name));
                                   n++;
                                   NEXT_CHAR
                                   }
                                else
                                   {
                                   printf("Load param ERROR : Inputs impedances : syntax error.");
                                   return NULL;
                                   }
                                }
                             else 
                                {
                                printf("Load param ERROR : Inputs impedances : not an integer!\n");
                                return NULL;
                                }
                             }
                          else 
                             {
                             printf("Load param ERROR : Inputs impedances : syntax error.");
                             return NULL;
                             }
                       if (feof( Pfile ))
                          {
                          printf("Load param ERROR : Inputs impedances : Unexpected end of file.");
                          return NULL;
                          }
                       }    
                    if (n )
                       {
                       loadparam->impedancePI = (ptype_list *)reverse( loadparam->impedancePI );
                       flag |= IMPED_FLAG;
                       }
                    else 
                       {
                       printf("Load param ERROR : Inputs impedances : Declaration empty");
                       return NULL;
                       }
                    }
                 else 
                    {
                    printf("Load param ERROR : Inputs impedances : Can't find left brace.");
                    return NULL;
                    }
                 }
              break;

           case 'F':/* Intput Capacitances */
              if (flag & CAPI_FLAG )
                 {
                 printf("Load param ERROR : Inputs capacitances : Defined twice !\n");
                 return NULL;
                 }
              else
                 {
                 NEXT_CHAR
                 if (c == '{' )
                    {
                    NEXT_CHAR
                    n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ':') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Inputs capacitances : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) NEXT_CHAR
                          if (c == ':' )
                             {
                             NEXT_CHAR
                             if (isdigit( c ) )
                                {
                                GET_INT(Value)
                                if (c == ';' )
                                   {
                                   Auxiliaire[i] = '\0';
                                   Name = (char *)parseName( Auxiliaire );
                                   loadparam->capaPI = addptype(loadparam->capaPI,Value,namealloc(Name));
                                   n++;
                                   NEXT_CHAR
                                   }
                                else 
                                   {
                                   printf("Load param ERROR : Inputs capacitances : syntax error.");
                                   return NULL;
                                   }
                                }
                             else 
                                {
                                printf("Load param ERROR : Inputs capacitances : not an integer!\n");
                                return NULL;
                                }
                             }
                          else 
                             {
                             printf("Load param ERROR : Inputs capacitances : syntax error.");
                             return NULL;
                             }
                          if (feof( Pfile ))
                             {
                             printf("Load param ERROR : Inputs capacitances : Unexpected end of file.");
                             return NULL;
                             }
                        }    
                     if (n )
                        {
                        loadparam->capaPI = (ptype_list *)reverse( loadparam->capaPI );
                        flag |= CAPI_FLAG;
                        }
                     else 
                        {
                        printf("Load param ERROR : Intputs capacitances : Declaration empty");
                        return NULL;
                        }
                     }
                  else 
                     {
                     printf("Load param ERROR : Inputs capacitances : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

           case 'C':/* Output Capacitances */
              if (flag & CAPA_FLAG )
                 {
                 printf("Load param ERROR : Outputs capacitances : Defined twice !\n");
                 return NULL;
                 }
              else
                 {
                 NEXT_CHAR
                 if (c == '{' )
                    {
                    NEXT_CHAR
                    n = 0;
                    while( c != '}' )
                       {
                       i = 0;
                       while( !isspace( c ) && ( c != ':') )
                          {
                          Auxiliaire[i++] = c;
                          if (i > 29 )
                             {
                             printf("Load param ERROR : Outputs capacitances : Name too long." );
                             return NULL;
                             }
                          c = getc( Pfile );
                          }
                       if (isspace( c )) NEXT_CHAR
                          if (c == ':' )
                             {
                             NEXT_CHAR
                             if (isdigit( c ) )
                                {
                                GET_INT(Value)
                                if (c == ';' )
                                   {
                                   Auxiliaire[i] = '\0';
                                   Name = (char *)parseName( Auxiliaire );
                                   loadparam->capaPO = addptype(loadparam->capaPO,Value,namealloc(Name));
                                   n++;
                                   NEXT_CHAR
                                   }
                                else 
                                   {
                                   printf("Load param ERROR : Outputs capacitances : syntax error.");
                                   return NULL;
                                   }
                                }
                             else 
                                {
                                printf("Load param ERROR : Outputs capacitances : not an integer!\n");
                                return NULL;
                                }
                             }
                          else 
                             {
                             printf("Load param ERROR : Outputs capacitances : syntax error.");
                             return NULL;
                             }
                          if (feof( Pfile ))
                             {
                             printf("Load param ERROR : Outputs capacitances : Unexpected end of file.");
                             return NULL;
                             }
                        }    
                     if (n )
                        {
                        loadparam->capaPO = (ptype_list *)reverse( loadparam->capaPO );
                        flag |= CAPA_FLAG;
                        }
                     else 
                        {
                        printf("Load param ERROR : Outputs capacitances : Declaration empty");
                        return NULL;
                        }
                     }
                  else 
                     {
                     printf("Load param ERROR : Outputs capacitances : Can't find left brace.");
                     return NULL;
                     }
                  }
               break;

            case '#':/* Commentaires */
               NEXT_LINE
               break;

            default:
               printf("Load param ERROR : '%c' Declaration syntax error!\n", c);
               return NULL;
               break;
            }	/* switch ... */
         }
      else
         if (!feof(Pfile) && ((c >= '0') || (c < '5')))
            {
            printf("Load param ERROR : old param version\n");
            return NULL;
            }
         else
            if (!feof( Pfile ) )
               {
               printf("Load param ERROR : Declaration syntax error!\n");
               return NULL;
               }
     }
   if (flag == 0 )
      {
      printf("Load param ERROR : File Empty, any parameter defined!\n");
      return NULL;
      }

   fclose( Pfile );
   return loadparam;
   }
else 
   {
   printf("Load param ERROR : Can't open parameter file '%s'!\n", FileName);
   return NULL;
   }
}

/*----------------------------------------------------------------------------
saveParam       : enregistre la structure de donnees dans le fichier
------------------------------------------------------------------------------
retour          : aucun
------------------------------------------------------------------------------*/
void saveParam( saveparam, FileName )
param *saveparam;
char    *FileName;
{
FILE        *Pfile;
chain_list  *intermediate;
chain_list  *earlyPO;
ptype_list  *delayPI;
ptype_list  *impedancePI;
ptype_list  *capaPO;
ptype_list  *capaPI;

Pfile = fopen( FileName,"wt" );

fprintf( Pfile, "## Mode\n");
fprintf( Pfile, "#M{%d}\n", saveparam->mode );
fprintf( Pfile, "## Level\n");
fprintf( Pfile, "#L{%d}\n", saveparam->level );
fprintf( Pfile, "## Number Transistor N\n");
fprintf( Pfile, "#N{%d}\n", saveparam->numTransN );
fprintf( Pfile, "## Number Transistor P\n");
fprintf( Pfile, "#P{%d}\n", saveparam->numTransP );
fprintf( Pfile, "## Fanout factor\n");
fprintf( Pfile, "#T{%d}\n", saveparam->maxSlopeTime );

if (saveparam->intermediate )
   {
   intermediate = saveparam->intermediate ;
   fprintf( Pfile, "##Auxiliary signals saved\n" );
   fprintf( Pfile, "#S{\n" );
   while ( intermediate )
      {
      fprintf( Pfile, "%s;\n", driveName( (char *)intermediate->DATA ));
      intermediate = intermediate->NEXT;
      }
   fprintf( Pfile, "}\n");
   }    

if (saveparam->delayPI )
   {
   delayPI = saveparam->delayPI;
   fprintf( Pfile, "##Delayed inputs\n" );
   fprintf( Pfile, "#D{\n" );
   while ( delayPI )
      {
      fprintf( Pfile, "%s:%d;\n", driveName( delayPI->DATA ), delayPI->TYPE );
      delayPI = delayPI->NEXT;
      }
   fprintf( Pfile, "}\n");
   }    

if (saveparam->earlyPO )
   {
   earlyPO = saveparam->earlyPO ;
   fprintf( Pfile, "##Early outputs\n" );
   fprintf( Pfile, "#E{\n" );
   while ( earlyPO )
      {
      fprintf( Pfile, "%s;\n", driveName( earlyPO->DATA ));
      earlyPO = earlyPO->NEXT;
      }
   fprintf( Pfile, "}\n");
   }    

if (saveparam->impedancePI )
   {
   impedancePI = saveparam->impedancePI;
   fprintf( Pfile, "##Inputs Impedence\n" );
   fprintf( Pfile, "#I{\n" );
   while ( impedancePI )
      {
      fprintf( Pfile, "%s:%d;\n", driveName( impedancePI->DATA ), impedancePI->TYPE );
      impedancePI = impedancePI->NEXT;
      }
   fprintf( Pfile, "}\n");
   }

if (saveparam->capaPO )
   {
   capaPO = saveparam->capaPO ;
   fprintf( Pfile, "##Outputs capacitance\n" );
   fprintf( Pfile, "#C{\n" );
   while ( capaPO )
      {
      fprintf( Pfile, "%s:%d;\n", driveName( capaPO->DATA ), capaPO->TYPE );
      capaPO = capaPO->NEXT;
      }
   fprintf( Pfile, "}\n");
   }

if (saveparam->capaPI )
   {
   capaPI = saveparam->capaPI ;
   fprintf( Pfile, "##Inputs maximal fanout\n" );
   fprintf( Pfile, "#F{\n" );
   while ( capaPI )
      {
      fprintf( Pfile, "%s:%d;\n", driveName( capaPI->DATA ), capaPI->TYPE );
      capaPI = capaPI->NEXT;
      }
   fprintf( Pfile, "}\n");
   }

fclose(Pfile);
}

/*----------------------------------------------------------------------------
resetParam      : remet a vide la structure param
------------------------------------------------------------------------------
retour          : rien.
------------------------------------------------------------------------------*/
void resetParam(par)
param *par;
{
par->mode = 0;
par->level = 0;
par->maxSlopeTime = 0;
par->aux = 0;
par->numTransP = par->numTransN = 0;
par->earlyPO = NULL;
par->delayPI = NULL;
par->impedancePI = NULL;
par->capaPO = NULL;
par->capaPI = NULL;
par->intermediate = NULL;
}
