/****************************************************************************/
/*                                                                          */
/*                      ALLIANCE CAO & VLSI CAD                             */
/*                                                                          */
/*    Product : (S)ymbolic (2)to (R)eal translater                          */
/*    File    : rdsx2y.c                                                    */
/*                                                                          */
/*    (c) copyright 1992 MASI laboratory CAO & VLSI team                    */
/*    All Right Reserved                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/****************************************************************************/ 
/*                                                                          */
/*              Main of cif or gds translater                               */
/*                                                                          */
/****************************************************************************/

#include "generic.h" 
#include  MPH_H
#include  MUT_H
#include  RDS_H
#include  RFM_H
#include  RPR_H
#include  RUT_H
#include  RTL_H

getarg(argc, argv, model_name)
int  argc;
char  **argv;
char  **model_name;
{
  char  *option1;
  char  *option2;

  if ( argc != 2) {
    fprintf(stderr, "usage : %s <file> \n", argv[0]);
    exit(1);
  }
  *model_name = namealloc( argv[1]);
}


main(argc, argv)
int  argc;
char  **argv;
{
  char        *model_name;
  rdsfig_list *pf;

  /**** banner and parameters ****/
  getarg( argc, argv, &model_name);

/*\
 * setting environement 
 * MBK_CATAL_NAME    : file where file name to be replaced are put
 * MBK_CATA_LIB      : where cells, catal file and techno file are
 * MBK_WORK_LIB      : where result file is written or where techno file is
 *                     WORK_LIB is watched before CATA_LIB
 * MBK_WORK_LIB      : where result file is placed
 * MBK_IN_PH         : file format of symbolic figure
 * RDS_TECHNO_NAME   : techno file name
 * RDS_IN            : file format of real figures to replace
 * RDS_OUT           : file format of result file
\*/
  mbkenv();
  rdsenv();
  loadrdsparam();
  pf = getrdsfig( model_name, 'A', 0 ); 
  saverdsfig( pf );

  return(0);
}


