
static rsa_perf( n, cin, csa, cout )
int   n, cin, csa, cout ;
{
  int  i ;
  char  filename[ 200 ] ;
  FILE  *file ;

  static int valn[12] = {2,4,8,16,24,32,48,64,80,96,112,128};

   mbkenv() ;

   file = (FILE *)mbkfopen( "cp_adder", "c", "w" ) ;

   fprintf( file, "extern void DEF_CIRCUIT();\n" ) ;
   fprintf( file, "extern void INTERF();\n" ) ;
   fprintf( file, "extern void INST();\n" ) ;
   fprintf( file, "void net_list( n, cin, csa, cout )\nint  n, cin, csa, cout ;\n{\n\n" ) ;
   fprintf( file, "   DEF_CIRCUIT( \"rsa\" ) ;\n\n" ) ;

   fprintf( file, "   INTERF( \"c_a\", 1, 10 ) ;\n" ) ;
   fprintf( file, "   INTERF( \"c_b\", 1, 11 ) ;\n\n" ) ;

   fprintf( file, "   if( cin )   INTERF( \"c_cin\", 1, 12 ) ;\n\n" ) ;

   fprintf( file, "   INTERF( \"c_cout\", 0, 104 ) ;\n" ) ;
   fprintf( file, "   INTERF( \"c_s\", 0, 14 ) ;\n\n" ) ;
   fprintf( file, "   if( cout )   INTERF( \"c_co\", 1, 16 ) ;\n\n" ) ;

   fprintf( file, "   if( csa )   {\n\n\tINTERF( \"c_c\", 1, 15 ) ;\n\n" ) ;

   fprintf( file,
            "\tINST( \"gacsaf_b\", \"icsa\", \"10\", \"11\", \"15\", \"100\", \"200\", \"vdd\", \"vss\", 0 ) ;\n\n" ) ;

   fprintf( file,
   "\tif( cin )   INST( \"gaec03_b\", \"i0\", \"vss\", \"100\", \"12\", \"105\", \"201\", \"vdd\", \"vss\", 0 ) ;\n" ) ;
 
   fprintf( file,
            "\telse\n\t\tINST( \"gae03_b\", \"i0\", \"vss\", \"100\", \"105\", \"201\", \"vdd\", \"vss\", 0 ) ;\n" ) ;

   fprintf( file, "     }\n\n" ) ;

   fprintf( file, "   else\n" ) ; 
   fprintf( file,
        "\tif( cin )   INST( \"gaec03_b\", \"i0\", \"10\", \"11\", \"12\", \"105\", \"201\", \"vdd\", \"vss\", 0 ) ;\n" );
   fprintf( file,
        "\telse\n\t\tINST( \"gae03_b\", \"i0\", \"10\", \"11\", \"105\", \"201\", \"vdd\", \"vss\", 0 ) ;\n\n\n" ) ;


   fprintf( file, "   switch( n )  {\n" ) ;

   for( i = 0 ; i < 12 ; i++ )   {

      fprintf( file, "\n      case %d :\n\n", valn[i] ) ;
 
      rsa_genall( valn[i], file ) ;

      fprintf( file, "\t\tbreak ;\n" ) ;
     }

   fprintf( file, "\n     }\n\n}" ) ;
}


rsa_genall( n, file )
int  n ;
FILE  *file ;
{
 
 int  i, p, z, Z ;

 static  char carry[][ 9 ] = {
                               "gaci0_b", "gacin0_b",      /*  p < 2  */
                               "gaci2_b", "gacin2_b",      /*  p < 4  */
                               "gaci4_b", "gacin4_b",      /*  p < 6  */
                               "gaci8_b", "gacin8_b",      /*  p < 8  */
                               "gacid_b", "gacind_b",      /*  p < 10 */
                               "gacip_b", "gacinp_b"       /*  p > 10 */
                             } ;

 static  char  gacon[][ 9 ] = { "gaco_b", "gacon_b" } ;


 static  char alim[][ 4 ] = {  "vdd", "vss"  } ;


   Z = ((rsa_puiss( n-1 )+2)*3)+2;
   for( i = rsa_puiss( n-1 ) ; i >= 0 ; i-- )   {   int  nbitr ;

      nbitr = rsa_min( rsa_exp2( i+1 ), n ) - rsa_exp2( i ) ;
      p = i&1 ;
      z = (i+2) * 3 ;



      if( nbitr == rsa_exp2( i ) )   {   /*  Tranche complete  */

         int  fanout ;

         fanout = rsa_min( rsa_exp2( i+2 ), n ) - rsa_exp2( i+1 ) ;            

         if( fanout > 16 ) p += 10;
         else
         if( fanout > 8 )  p += 8 ;
         else
         if( fanout > 4 )  p += 6 ;
         else
         if( fanout > 2 )  p += 4 ;
         else
         if( fanout > 0 )  p += 2 ;

         fprintf( file,
                  "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"1%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n",
                  carry[ p ], z+2, ((z+2) == Z) ? 4 : (z+2), alim[ ((i&1) +1)&1 ], z-1, alim[ i&1 ] ) ;

         if( rsa_exp2( i+1 ) + 1 < n )   {

            fprintf( file,
                "\t\tINST( \"gas0_b\", \"is%d\", \"vdd\", \"1%.2d\", \"vdd\", \"vss\", \"2%.2d\", \"vdd\", \"vss\", 0 ) ;\n",
                     z+2, z+2, z+2 ) ;

            fprintf( file,
                "\t\tif( cout )  INST( \"%s\", \"igc%d\", \"4%.2d\", \"1%.2d\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n",
                     gacon[ p&1 ], z+2, z+2, z+2, z+2 ) ;
           }
        }


      if( nbitr > 2 )   {

         fprintf( file, "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"2%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n",
                  carry[ i&1 ], z+1, ((z+1) == Z) ? 4 : (z+1), alim[ ((i&1) +1)&1 ], z, alim[ i&1 ] ) ;

         fprintf( file, "\t\tINST( \"mes_%d\", \"i%d\", \"1%.2d\", \"2%.2d\", \"vdd\", \"vss\", 0 ) ;\n",
                  nbitr-2, z, z-1, z ) ;

         if( nbitr != rsa_exp2( i ) )   {   /*  Tranche non complete  */

            fprintf( file,
                     "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"1%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n" ,
                     carry[ i&1 ], z+2, ((z+2) == Z) ? 4 : (z+2), alim[ ((i&1) +1)&1 ], z-1, alim[ i&1 ] ) ;
           }     
        }

      else

      if( nbitr == 2 )   {

         if( i > 1  ||  i == rsa_puiss( n-1 ) )   {
 
            fprintf( file, "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"1%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n" ,
                    carry[ i&1 ], z+1, ((z+1) == Z) ? 4 : (z+1), alim[ ((i&1) +1)&1 ], z-1, alim[ i&1 ] ) ;
           }

         if( i > 1 )   {

            fprintf( file, "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"1%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n" ,
                    carry[ i&1 ], z+2, ((z+2) == Z) ? 4 : (z+1), alim[ ((i&1) +1)&1 ], z-1, alim[ i&1 ] ) ;
           }
        }

      else   /*  nbitr == 1 */

      if( i > 0 )   {

         fprintf( file, "\t\tINST( \"%s\", \"i%d\", \"1%.2d\", \"%s\", \"1%.2d\", \"%s\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n",
                 carry[ i&1 ], z+1, ((z+2) == Z) ? 4 : (z+1), alim[ ((i&1) +1)&1 ], z-1, alim[ i&1 ] ) ;
        }

      fprintf( file, "\n" ) ;
     }


   z = ((rsa_puiss( n-1 ) + 2) * 3) ;
 
   fprintf( file, "\t\tINST( \"%s\", \"i2\", \"vdd\", \"1%.2d\", \"vdd\", \"vss\", \"14\", \"vdd\", \"vss\", 0 ) ;\n",
           n&1 ? "gas0_b" : "gas0y_b",
           (n-1) == (rsa_exp2( rsa_puiss( n-1 ) )) ? z-1 : z+1 ) ;

   fprintf( file, "\t\tif(cout) INST( \"%s\", \"ico\", \"16\", \"1%.2d\", \"vdd\", \"vdd\", \"vss\", 0 ) ;\n",
            gacon[ z&1 ], (n-1) == (rsa_exp2( rsa_puiss( n-1 ) )) ? z-1 : z+1 ) ;
}
