/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_ICON                                                     **/
/**                                                               **/
/**  Version 6.03                                                 **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static char *ident_icon="@(#)(RFG) icon view generation, version 6.03 (30/09/1993)";

/*******************************************************************/

#include ICN_H
#include IAC_H
#include ICU_H

/*******************************************************************/

#define RFG_CON_OFFSET 50L
#define RFG_CON_STEP   50L
#define RFG_CON_LENGHT 20L
#define RFG_CON_CIRCLE 6L
#define RFG_CON_PTR    5L
#define RFG_CON_D_NAME (-28L)

/*******************************************************************/

#define ICON_SCALE_X SCALE_X
#define ICON_SCALE_Y (-SCALE_X)

#define RFG_ADDICONGATE(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) \
  addicongate(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, d, e, f, \
    (g)*ICON_SCALE_X, (h)*ICON_SCALE_Y, i, j, k, \
    (l)*ICON_SCALE_X, (m)*ICON_SCALE_Y, n, o, p)

#define RFG_ADDICONCON(a, b, c, d, e, f, g, h, i, j, k) \
  addiconcon(a, b, \
    (c)*ICON_SCALE_X, (d)*ICON_SCALE_Y, e, f, g, h, i, \
    (j)*ICON_SCALE_X, (k)*ICON_SCALE_Y)

#define RFG_ADDICONLINE(a, b, c, d, e) \
  addiconline(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, \
    (d)*ICON_SCALE_X, (e)*ICON_SCALE_Y)

#define RFG_ADDICONCOMP(a, b, c, d) \
  addiconcomp(a, b, \
    (c)*ICON_SCALE_X, (d)*ICON_SCALE_Y)

#define RFG_ADDICONCIRCLE(a, b, c, d, e) \
  addiconcircle(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, \
    (d)*ICON_SCALE_X, (e)*ICON_SCALE_Y)

/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_ICON ( width, high, n_bus, flip_flop, inverse_data,      **/
/**             low_power, write_enable, inverse_we, stuck, msb,  **/
/**             block_type )                                      **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static void rfg_icon ( /*width, high, n_bus,*/ flip_flop /*, inverse_data,
               low_power, write_enable, inverse_we, stuck, msb,
               block_type*/ )

  long /*width, high, n_bus,*/ flip_flop /*, inverse_data*/ ;
/*
  long low_power, write_enable, inverse_we, stuck, msb;
  long block_type;
*/

{
long          i;
long          nbr_con[4];
long          icon_width;
long          icon_hight;
long          x, y;

char          *name;

IconGate_list *icon;
IconComp_list *comp;

/********** Count connectors on each side. **********/

for(i=0L; i<4L; i++)
  nbr_con[i]=0L;
for(RFG_FIRST_CON(); RFG_TEST_CON(); RFG_NEXT_CON())
  {
  if(!(RFG_CON_TYPE()&rfg_con_supply))
    nbr_con[RFG_CON_SIDE()]+=1L;
  }

/********** Calculate size of icon. **********/

icon_width=(rfg_max_2(nbr_con[rfg_con_north], nbr_con[rfg_con_south])-1L)*RFG_CON_STEP+2*RFG_CON_OFFSET;
icon_hight=(rfg_max_2(nbr_con[rfg_con_west], nbr_con[rfg_con_east])-1L)*RFG_CON_STEP+2*RFG_CON_OFFSET;
icon_width=rfg_max_2(icon_width, 300L-2*RFG_CON_LENGHT);
icon_hight=rfg_max_2(icon_hight, 300L-2*RFG_CON_LENGHT);

/********** Create icon. **********/

x=(icon_width>>1);
y=(icon_hight-40L)>>1;
if((icon=RFG_ADDICONGATE(rfg_name_pref, x, y+20L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL,
  x, y+0L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL,
  x, y+10L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL))==NULL)
  { (void) PRINTF("Error : unable to create icon !!!\n");
    EXIT(1); }

/********** Create connectors list. **********/

for(i=0L; i<4L; i++)
  nbr_con[i]=0L;
for(RFG_FIRST_CON(); RFG_TEST_CON(); RFG_NEXT_CON())
  {
  if(!(RFG_CON_TYPE()&rfg_con_supply))
    {

     /***** Generate connector name. *****/
    if(RFG_CON_VECTOR())
      if(RFG_CON_RANGE())
        name=NAME("%s[%ld:%ld]", RFG_CON_NAME(),
          RFG_CON_START_INDEX(), RFG_CON_END_INDEX());
      else
        name=NAME("%s[%ld]", RFG_CON_NAME(), RFG_CON_START_INDEX());
    else
      name=NAME("%s", RFG_CON_NAME());

     /***** Add connector to list. *****/
    switch(RFG_CON_SIDE())
      {
      case rfg_con_north :
        x=RFG_CON_STEP*nbr_con[rfg_con_north]+RFG_CON_OFFSET;
        y=icon_hight;
        if(RFG_ADDICONCON(icon, name,
          x, y+RFG_CON_LENGHT, SAX_NORTH,
          RFG_CON_TYPE()&rfg_con_in ? IN : (RFG_CON_TYPE()&rfg_con_out ? OUT : UNKNOWN),
          SAX_CENTER, SAX_UP, SAX_HORIZONTAL,
          x, y+RFG_CON_LENGHT+RFG_CON_D_NAME)==NULL)
          { (void) PRINTF("Error : unable to create icon connector !!!\n");
            EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_invert)
          {
          if(RFG_ADDICONLINE(icon, x, y+RFG_CON_LENGHT, x, y+RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONCIRCLE(icon, x-(RFG_CON_CIRCLE>>1), y+RFG_CON_CIRCLE,
            RFG_CON_CIRCLE, RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon circle !!!\n");
              EXIT(1); }
          }
        else
          if(RFG_ADDICONLINE(icon, x, y+RFG_CON_LENGHT, x, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_clock)
          {
          if(RFG_ADDICONLINE(icon, x-RFG_CON_PTR, y, x, y-RFG_CON_PTR)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONLINE(icon, x+RFG_CON_PTR, y, x, y-RFG_CON_PTR)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          }
        nbr_con[rfg_con_north]+=1;
        break;
      case rfg_con_south :
        x=RFG_CON_STEP*nbr_con[rfg_con_south]+RFG_CON_OFFSET;
        y=0L;
        if(RFG_ADDICONCON(icon, name,
          x, y-RFG_CON_LENGHT, SAX_SOUTH,
          RFG_CON_TYPE()&rfg_con_in ? IN : (RFG_CON_TYPE()&rfg_con_out ? OUT : UNKNOWN),
          SAX_CENTER, SAX_DOWN, SAX_HORIZONTAL,
          x, y-RFG_CON_LENGHT-RFG_CON_D_NAME)==NULL)
          { (void) PRINTF("Error : unable to create icon connector !!!\n");
            EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_invert)
          {
          if(RFG_ADDICONLINE(icon, x, y-RFG_CON_LENGHT, x, y-RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONCIRCLE(icon, x-(RFG_CON_CIRCLE>>1), y,
            RFG_CON_CIRCLE, RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon circle !!!\n");
              EXIT(1); }
          }
        else
          if(RFG_ADDICONLINE(icon, x, y, x, y-RFG_CON_LENGHT)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_clock)
          {
          if(RFG_ADDICONLINE(icon, x-RFG_CON_PTR, y, x, y+RFG_CON_PTR)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONLINE(icon, x+RFG_CON_PTR, y, x, y+RFG_CON_PTR)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          }
        nbr_con[rfg_con_south]+=1;
        break;
      case rfg_con_west :
        x=0L;
        y=-RFG_CON_STEP*nbr_con[rfg_con_west]+(icon_hight-RFG_CON_OFFSET);
        if(RFG_ADDICONCON(icon, name,
          x-RFG_CON_LENGHT, y, SAX_WEST,
          RFG_CON_TYPE()&rfg_con_in ? IN : (RFG_CON_TYPE()&rfg_con_out ? OUT : UNKNOWN),
          SAX_LEFT, SAX_CENTER, SAX_HORIZONTAL,
          x-RFG_CON_LENGHT-RFG_CON_D_NAME, y)==NULL)
          { (void) PRINTF("Error : unable to create icon connector !!!\n");
            EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_invert)
          {
          if(RFG_ADDICONLINE(icon, x-RFG_CON_LENGHT, y, x-RFG_CON_CIRCLE, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONCIRCLE(icon, x-RFG_CON_CIRCLE, y+(RFG_CON_CIRCLE>>1),
            RFG_CON_CIRCLE, RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon circle !!!\n");
              EXIT(1); }
          }
        else
          if(RFG_ADDICONLINE(icon, x-RFG_CON_LENGHT, y, x, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_clock)
          {
          if(RFG_ADDICONLINE(icon, x, y+RFG_CON_PTR, x-RFG_CON_PTR, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONLINE(icon, x, y-RFG_CON_PTR, x-RFG_CON_PTR, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          }
        nbr_con[rfg_con_west]+=1;
        break;
      case rfg_con_east :
        x=icon_width;
        y=-RFG_CON_STEP*nbr_con[rfg_con_east]+(icon_hight-RFG_CON_OFFSET);
        if(RFG_ADDICONCON(icon, name,
          x+RFG_CON_LENGHT, y, SAX_EAST,
          RFG_CON_TYPE()&rfg_con_in ? IN : (RFG_CON_TYPE()&rfg_con_out ? OUT : UNKNOWN),
          SAX_RIGHT, SAX_CENTER, SAX_HORIZONTAL,
          x+RFG_CON_LENGHT+RFG_CON_D_NAME, y)==NULL)
          { (void) PRINTF("Error : unable to create icon connector !!!\n");
            EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_invert)
          {
          if(RFG_ADDICONLINE(icon, x+RFG_CON_LENGHT, y, x+RFG_CON_CIRCLE, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONCIRCLE(icon, x, y+(RFG_CON_CIRCLE>>1),
            RFG_CON_CIRCLE, RFG_CON_CIRCLE)==NULL)
            { (void) PRINTF("Error : unable to create icon circle !!!\n");
              EXIT(1); }
          }
        else
          if(RFG_ADDICONLINE(icon, x, y, x+RFG_CON_LENGHT, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
        if(RFG_CON_TYPE()&rfg_con_clock)
          {
          if(RFG_ADDICONLINE(icon, x, y+RFG_CON_PTR, x+RFG_CON_PTR, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          if(RFG_ADDICONLINE(icon, x, y-RFG_CON_PTR, x+RFG_CON_PTR, y)==NULL)
            { (void) PRINTF("Error : unable to create icon line !!!\n");
              EXIT(1); }
          }
        nbr_con[rfg_con_east]+=1;
        break;
      }
    }
  }

/********** Create and draw line (latch symbol). **********/

x=(icon_width>>1);
y=((icon_hight-40L)>>1)+40L;

if(flip_flop)
  {
  if(RFG_ADDICONLINE(icon, x-10L, y+5L, x, y+5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x, y+5L, x, y-5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x, y-5L, x+10L, y-5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x-2L, y+2L, x, y)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x+2L, y+2L, x, y)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  }
else
  {
  if(RFG_ADDICONLINE(icon, x-15L, y-5L, x-5L, y-5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x-5L, y-5L, x-5L, y+5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x-5L, y+5L, x+5L, y+5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x+5L, y+5L, x+5L, y-5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  if(RFG_ADDICONLINE(icon, x+5L, y-5L, x+15L, y-5L)==NULL)
    { (void) PRINTF("Error : unable to create icon line !!!\n");
      EXIT(1); }
  }

/********** Create and draw shape. **********/

if((comp=RFG_ADDICONCOMP((IconComp_list *) NULL, COMP_ISLINE, 0L, 0L))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=RFG_ADDICONCOMP(comp, COMP_ISLINE, 0L, icon_hight))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=RFG_ADDICONCOMP(comp, COMP_ISLINE, icon_width, icon_hight))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=RFG_ADDICONCOMP(comp, COMP_ISLINE, icon_width, 0L))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }

if(addiconshape(icon, comp)==NULL)
  { (void) PRINTF("Error : unable to create icon shape !!!\n");
    EXIT(1); }

/********** Save icon. **********/

update_icon(icon);

saveicon(icon);
}

/*******************************************************************/
