/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                  Rtl acces                        |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include MPH_H
# include MUT_H
# include RDS_H
# include RUT_H
# include RPR_H
# include RTL_H
# include "rtlacces.h"
# include "rtlerror.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  char *RDS_IN;
  char *RDS_OUT;
  char *RDS_TECHNO_NAME;

  static char *RDS_CIF_FORMAT = (char *)NULL;
  static char *RDS_GDS_FORMAT = (char *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            rdsenv                           |
|                                                             |
\------------------------------------------------------------*/

  void rdsenv()
  {
    RDS_TECHNO_NAME = namealloc( getenv( "RDS_TECHNO_NAME") );

    if ( RDS_TECHNO_NAME == (char *)NULL )
    {
      RDS_TECHNO_NAME = namealloc( RTL_DEFAULT_TECHNO );
    }

    RDS_IN = namealloc( getenv( "RDS_IN") );

    if ( RDS_IN == (char *)NULL )
    {
      RDS_IN = namealloc( RTL_DEFAULT_IN );
    }
 
    RDS_OUT = namealloc( getenv( "RDS_OUT") );

    if( RDS_OUT == (char *)NULL )
    {
      RDS_OUT = namealloc( RTL_DEFAULT_OUT );
    }

    RDS_GDS_FORMAT = namealloc( "gds" );
    RDS_CIF_FORMAT = namealloc( "cif" );
  }

/*------------------------------------------------------------\
|                                                             |
|                          loadrdsfig                         |
|                                                             |
\------------------------------------------------------------*/

  void loadrdsfig( Figure, Name, Mode )

    rdsfig_list *Figure;
    char        *Name;
    char         Mode;
  {
    if ( RDS_IN == RDS_GDS_FORMAT ) 
    {
      gdsloadrdsfig( Figure, Name, Mode );
    }
    else
    if ( RDS_IN == RDS_CIF_FORMAT )
    {
      cifloadrdsfig( Figure, Name, Mode );
    }
    else
    {
      rtlerror( UNKNOWN_RDS_IN, RDS_IN );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                          saverdsfig                         |
|                                                             |
\------------------------------------------------------------*/

  void saverdsfig( Figure )

    rdsfig_list *Figure;
  {
    if ( RDS_OUT == RDS_GDS_FORMAT )
    {
      gdssaverdsfig( Figure );
    }
    else
    if ( RDS_OUT == RDS_CIF_FORMAT )
    {
      cifsaverdsfig( Figure );
    }
    else
    {
      rtlerror( UNKNOWN_RDS_OUT, RDS_OUT );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                          getrdsfig                          |
|                                                             |
\------------------------------------------------------------*/

  rdsfig_list *getrdsfig( Name, Mode, Size )

     char        *Name;
     char         Mode;
     unsigned int Size;
  {
    rdsfig_list *Figure;

    Name = namealloc( Name );

    for ( Figure  = HEAD_RDSFIG;
          Figure != (rdsfig_list *)NULL;
          Figure  = Figure->NEXT )
    {
      if ( Figure->NAME == Name ) break;
    }

    if ( ( Figure != (rdsfig_list *)NULL ) &&
         ( Mode   != Figure->MODE        ) )
    {
      if ( Figure->MODE == 'P' )
      {
        delrdsfig( Figure->NAME );
        Figure = (rdsfig_list *)NULL;
      }
      else
      {
        applyrdsmode( Figure, Mode );
      }
    }

    if ( Figure == (rdsfig_list *)NULL )
    {
      Figure = addrdsfig( Name, Size );

      loadrdsfig( Figure, Name, Mode );
    }

    return( Figure );
  }
