/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                 Rpr Errors                        |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include "rprerror.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  void RprError( ErrorType, Message, Data )

       char  ErrorType; 
       char *Message;
       long  Data;
  {
	 fflush(stdout);

    switch ( ErrorType ) 
    {
      case DEFINE_MISSING : 

        fprintf( stderr, "Rpr203: Some defines missing\n");
        break;

      case TABLE_MISSING  : 
 
        fprintf( stderr, "Rpr203: Some tables missing\n");
        break;

      case LINE_EXPECTED  :
 
        fprintf( stderr, "Rpr203: %s expected line %lu\n", 
        Message, Data );
        break;

      case UNKNOWN_DEFINE : 

        fprintf( stderr, "Rpr203: Unknown define %s line %lu\n",
        Message, Data );
        break;

      case NOT_DEFINED    : 

        fprintf( stderr, "Rpr203: %s not defined line %lu\n",
        Message, Data );
        break;

      case MULTIPLE_GRID  : 
 
        fprintf( stderr, "Rpr203: %s not multiple of physical grid line %lu\n",
        Message, Data );
        break;

      case TOO_SMAL       :

        fprintf( stderr, "Rpr203: %s too smal line %lu\n",
        Message, Data );
        break;

      case MISSING_VALUE  :

        fprintf( stderr, "Rpr203: Missing value line %lu\n", Data );
        break;

      case MISSING_NAME   :

        fprintf( stderr, "Rpr203: Missing name of %s line %lu\n",
        Message, Data );
        break;

      case ILLEGAL_FLOAT  :

        fprintf( stderr, "Rpr203: Illegal floating point number %s line %lu\n",
        Message, Data );
        break;

      case UNEXPECTED_LINE :

        fprintf( stderr, "Rpr203: %s unexpected line %lu\n",
        Message, Data );
        break;

      case UNEXPECTED_EOF  :

        fprintf( stderr, "Rpr203: Unexpected end of file, missing definitions\n");
        break;

      case TOO_MANY_WORDS  :

        fprintf( stderr, "Rpr203: Too many words %s unexpected line %lu\n",
        Message, Data );
        break;

      case MISSING_TABLE  :

        fprintf( stderr, "Rpr203: Missing value in %s table line %lu\n",
        Message, Data );
        break;

      case OPEN_FILE      :

        fprintf( stderr, "Rpr203: Technological file %s can't be opened\n", 
        Message );
        break;

      case MISSING_POST   :

        fprintf( stderr, "Rpr203: Missing %s value in postreat table line %lu\n",
        Message , Data );
        break;

      case UNKNOWN_TABLE  :

        fprintf( stderr, "Rpr203: Unknown table %s line %lu\n",
        Message , Data );
        break;

      case NEGATIVE_VALUE :

        fprintf( stderr, "Rpr203: %s has to be positive value line %lu\n",
        Message , Data );
        break;

      case SYNTAX_ERROR   :

        fprintf( stderr, "Rpr203: Syntax Error %s at line %lu\n", 
        Message , Data );
        break;
    }

    EXIT( 1 );
  }
