/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                  Rpr203.h                         |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef RPR_203 
# define RPR_203

/*------------------------------------------------------------\
|                                                             |
|                          Lynx Define                        |
|                                                             |
\------------------------------------------------------------*/

# define RDS_LYNX_GRAPH_FIELD       7
# define RDS_LYNX_GRAPH_EMPTY       (char)255
# define RDS_LYNX_CAPA_FIELD        1
# define RDS_LYNX_CAPA_EMPTY        0.0

/*------------------------------------------------------------\
|                                                             |
|                          S2R Define                         |
|                                                             |
\------------------------------------------------------------*/

# define S2R_NOTREAT                0
# define S2R_TREAT                  1

# define RDS_S2R_POST_TREAT_FIELD   2
# define RDS_S2R_OVERSIZE_FIELD     1
# define RDS_S2R_RING_WIDTH_FIELD   1
# define RDS_S2R_LAYER_WIDTH_FIELD  1

# define RDS_S2R_POST_TREAT_EMPTY   (char)S2R_NOTREAT
# define RDS_S2R_OVERSIZE_EMPTY     (long)0
# define RDS_S2R_RING_WIDTH_EMPTY   (long)0
# define RDS_S2R_LAYER_WIDTH_EMPTY  (long)0

/*------------------------------------------------------------\
|                                                             |
|                          Mbk Define                         |
|                                                             |
\------------------------------------------------------------*/

# define RDS_TRANS_VW         (char)0
# define RDS_TRANS_LCW        (char)1
# define RDS_TRANS_RCW        (char)2

# define RDS_MAX_TRANS        ( RDS_TRANS_RCW + 1 )

# define MBK_REF_REF          0
# define MBK_REF_CON          1

# define MBK_MAX_LAYER        ( LAST_LAYER   + 1 )
# define MBK_MAX_VIA          ( LAST_CONTACT + 1 )
# define MBK_MAX_REFERENCE    2
# define MBK_MAX_SYMMETRY     ( SY_RP        + 1 )
# define MBK_MAX_ORIENT       4

# define RDS_SEGMENT_FIELD    60
# define RDS_VIA_FIELD        16
# define RDS_CONNECTOR_FIELD  3
# define RDS_REFERENCE_FIELD  2

# define RDS_SEGMENT_EMPTY    (long)-1
# define RDS_VIA_EMPTY        (long)-1
# define RDS_CONNECTOR_EMPTY  (long)-1
# define RDS_REFERENCE_EMPTY  (long)-1

# define RDS_USE_ALL          (char)0
# define RDS_USE_EXTRACT      (char)1
# define RDS_USE_DRC          (char)2

# define RDS_MAX_USE          ( RDS_USE_DRC + 1 )

/*------------------------------------------------------------\
|                                                             |
|                         Parser Define                       |
|                                                             |
\------------------------------------------------------------*/

# define RDS_CIF_LAYER_FIELD  1
# define RDS_GDS_LAYER_FIELD  1

# define RDS_CIF_LAYER_EMPTY  (char *)NULL
# define RDS_GDS_LAYER_EMPTY  (char)255

/*------------------------------------------------------------\
|                                                             |
|                          Lynx Macros                        |
|                                                             |
\------------------------------------------------------------*/

# define GET_LYNX_GRAPH_LAYER( Layer, Index )                 \
                                                              \
  ( ( Index >= RDS_LYNX_GRAPH_FIELD ) ?                       \
    ( RDS_LYNX_GRAPH_EMPTY          ) :                       \
    ( RDS_LYNX_GRAPH_TABLE [ ( Layer ) ][ ( Index ) ] ) )

# define GET_LYNX_CAPA_LAYER( Layer )                         \
                                                              \
  ( RDS_LYNX_CAPA_TABLE [ ( Layer ) ][ 0 ]                    )

/*------------------------------------------------------------\
|                                                             |
|                          S2R Macros                         |
|                                                             |
\------------------------------------------------------------*/
 
# define GET_S2R_POST_Y_OR_N( Layer )                         \
                                                              \
        ( RDS_S2R_POST_TREAT_TABLE [ ( Layer ) ][ 0 ] )

# define GET_S2R_POST_COMPLEMENTARY( Layer )                  \
                                                              \
        ( RDS_S2R_POST_TREAT_TABLE [ ( Layer ) ][ 1 ] )

# define GET_S2R_OVERSIZE( Layer )                            \
                                                              \
        ( RDS_S2R_OVERSIZE_TABLE   [ ( Layer ) ][ 0 ] )

# define GET_S2R_RING_WIDTH( Layer )                          \
                                                              \
        ( RDS_S2R_RING_WIDTH_TABLE [ ( Layer ) ][ 0 ] )

# define GET_S2R_LAYER_WIDTH( Layer )                         \
                                                              \
        ( RDS_S2R_LAYER_WIDTH_TABLE [ ( Layer ) ][ 0 ] )

/*------------------------------------------------------------\
|                                                             |
|                          Mbk Macros                         |
|                                                             |
\------------------------------------------------------------*/

# define GET_SEGMENT_LAYER( Layer, Index )                    \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY                ) :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 0 ] )  )

# define GET_SEGMENT_TRANS( Layer, Index )                    \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY              )   :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 1 ] )  )

# define GET_SEGMENT_DLR( Layer, Index )                      \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY                ) :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 2 ] )  )

# define GET_SEGMENT_DWR( Layer, Index )                      \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY                ) :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 3 ] )  )

# define GET_SEGMENT_OFFSET( Layer, Index )                   \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY                ) :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 4 ] )  )

# define GET_SEGMENT_USE( Layer, Index )                      \
                                                              \
      ( ( (Index) * 6 >= RDS_SEGMENT_FIELD ) ?                \
        ( RDS_SEGMENT_EMPTY                ) :                \
        ( RDS_SEGMENT_TABLE [ (Layer) ][ (Index) * 6 + 5 ] )  )

# define GET_CONNECTOR_LAYER( Layer )                         \
                                                              \
        ( RDS_CONNECTOR_TABLE [ (Layer) ][ 0 ] )

# define GET_CONNECTOR_DER( Layer )                           \
                                                              \
        ( RDS_CONNECTOR_TABLE [ (Layer) ][ 1 ] )

# define GET_CONNECTOR_DWR( Layer )                           \
                                                              \
        ( RDS_CONNECTOR_TABLE [ (Layer) ][ 2 ] )

# define GET_VIA_LAYER( Layer, Index )                        \
                                                              \
      ( ( (Index) * 2 >= RDS_VIA_FIELD ) ?                    \
        ( RDS_VIA_EMPTY                ) :                    \
        ( RDS_VIA_TABLE [ (Layer) ][ (Index) * 2 + 0 ] )      )

# define GET_VIA_SIZE( Layer, Index )                         \
                                                              \
      ( ( (Index) * 2 >= RDS_VIA_FIELD ) ?                    \
        ( RDS_VIA_EMPTY                ) :                    \
        ( RDS_VIA_TABLE [ (Layer) ][ (Index) * 2 + 1 ] )      )

# define GET_REFERENCE_LAYER( Layer )                         \
                                                              \
        ( RDS_REFERENCE_TABLE [ (Layer) ][ 0 ] )

# define GET_REFERENCE_SIZE( Layer )                          \
                                                              \
        ( RDS_REFERENCE_TABLE [ (Layer) ][ 1 ] )

/*------------------------------------------------------------\
|                                                             |
|                         Parser Macros                       |
|                                                             |
\------------------------------------------------------------*/

# define GET_CIF_LAYER( Layer )                               \
                                                              \
        ( RDS_CIF_LAYER_TABLE [ (Layer) ][ 0 ] )

# define GET_GDS_LAYER( Layer )                               \
                                                              \
        ( RDS_GDS_LAYER_TABLE [ (Layer) ][ 0 ] )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

 extern long   RDS_PHYSICAL_GRID;
 extern long   RDS_LAMBDA;
 extern long   RDS_LAMBDA2;
 extern long   RDS_UNIT;

 extern char   RDS_S2R_POST_TREAT_TABLE  [ RDS_MAX_LAYER ][ RDS_S2R_POST_TREAT_FIELD  ];
 extern long   RDS_S2R_OVERSIZE_TABLE    [ RDS_MAX_LAYER ][ RDS_S2R_OVERSIZE_FIELD    ];
 extern long   RDS_S2R_RING_WIDTH_TABLE  [ RDS_MAX_LAYER ][ RDS_S2R_RING_WIDTH_FIELD  ];
 extern long   RDS_S2R_LAYER_WIDTH_TABLE [ RDS_MAX_LAYER ][ RDS_S2R_LAYER_WIDTH_FIELD ];

 extern long   RDS_SEGMENT_TABLE   [ MBK_MAX_LAYER     ][ RDS_SEGMENT_FIELD   ];
 extern long   RDS_VIA_TABLE       [ MBK_MAX_VIA       ][ RDS_VIA_FIELD       ];
 extern long   RDS_CONNECTOR_TABLE [ MBK_MAX_LAYER     ][ RDS_CONNECTOR_FIELD ];
 extern long   RDS_REFERENCE_TABLE [ MBK_MAX_REFERENCE ][ RDS_REFERENCE_FIELD ];

 extern char  *RDS_CIF_LAYER_TABLE [ RDS_MAX_LAYER ][ RDS_CIF_LAYER_FIELD ];
 extern char   RDS_GDS_LAYER_TABLE [ RDS_MAX_LAYER ][ RDS_GDS_LAYER_FIELD ];

 extern char   RDS_LYNX_GRAPH_TABLE [ RDS_MAX_LAYER ][ RDS_LYNX_GRAPH_FIELD ];
 extern float  RDS_LYNX_CAPA_TABLE [ RDS_MAX_LAYER ][ RDS_LYNX_CAPA_FIELD ];

 extern char   MBK_LAYER_NAME[ MBK_MAX_LAYER ][  7 ];
 extern char   MBK_VIA_NAME  [ MBK_MAX_VIA   ][ 12 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern void loadrdsparam();
  extern void viewrdsparam();

# endif 
