/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                   FlatRds.c                       |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.09.93                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RUT_H
# include RTL_H
# include RFM_H
# include RPR_H

/*------------------------------------------------------------\
|                                                             |
|                            Banner                           |
|                                                             |
\------------------------------------------------------------*/

  void Banner()
  {
    fprintf( stdout, "\n" );
    fprintf( stdout, "\n   @@@@@@@@@  @@@@                      @@@@@@@          @@@          " );
    fprintf( stdout, "\n     @@    @    @@                @       @@   @@         @@          " );
    fprintf( stdout, "\n     @@     @   @@               @@       @@    @@        @@          " );
    fprintf( stdout, "\n     @@         @@     @@@@      @@       @@    @@     @@ @@   @@@@@@ " );
    fprintf( stdout, "\n     @@   @     @@    @@   @   @@@@@@@@   @@   @@    @@  @@@  @@    @ " );
    fprintf( stdout, "\n     @@@@@@     @@    @@   @@    @@       @@@@@     @@    @@  @@@     " );
    fprintf( stdout, "\n     @@   @     @@      @@@@@    @@       @@  @@    @@    @@   @@@@   " );
    fprintf( stdout, "\n     @@         @@    @@   @@    @@       @@   @@   @@    @@     @@@@ " );
    fprintf( stdout, "\n     @@         @@   @@    @@    @@       @@   @@   @@    @@  @    @@@" );
    fprintf( stdout, "\n     @@         @@   @@   @@@    @@   @   @@    @@   @@  @@@  @@    @@" );
    fprintf( stdout, "\n   @@@@@@     @@@@@@  @@@@  @@    @@@@  @@@@@   @@@    @@ @@@ @ @@@@@ " );
    fprintf( stdout, "\n" );
    fprintf( stdout, "\n                  Alliance CAD System ,    flatrds - 1.01" );
    fprintf( stdout, "\n                  Copyright (c) 1993, MASI, CAO-VLSI Team" );
    fprintf( stdout, "\n                  E-mail support:    cao-vlsi@masi.ibp.fr" );
    fprintf( stdout, "\n" );
  }

/*------------------------------------------------------------\
|                                                             |
|                            Usage                            |
|                                                             |
\------------------------------------------------------------*/

  void Usage()
  {
    fprintf( stderr, "\n              Usage : flatrds physical_figure instance output_name" );
    fprintf( stderr, "\n                      flatten the instance in the physical_figure" );
    fprintf( stderr, "\n              Usage : flatrds -r physical_figure output_name" );
    fprintf( stderr, "\n                      flatten physical_figure to the catalog" );
    fprintf( stderr, "\n              usage : flatrds -t physical_figure output_name" );
    fprintf( stderr, "\n                      flatten physical_figure to the transistor\n\n" );

    exit(1);
  }

/*------------------------------------------------------------\
|                                                             |
|                             Main                            |
|                                                             |
\------------------------------------------------------------*/

 int main( argc, argv )

    int   argc;
    char *argv[];
 {
   rdsfig_list *Figure;

   Banner();

   mbkenv();
   rdsenv();
   loadrdsparam();

   if ( argc < 3 ) Usage();

   if ( ! strcmp( "-r", argv[1] ) ) 
   {
      Figure = getrdsfig( argv[2], 'A', 0 );

      fprintf( stdout, "\n   --> Flatten figure %s to the catalog\n",
               Figure->NAME );

      rflattenrdsfig( Figure, RDS_YES, RDS_YES );
   }
   else
   if ( ! strcmp( "-t", argv[1] ) )
   {
      Figure = getrdsfig( argv[2], 'A', 0 );

      fprintf( stdout, "\n   --> Flatten figure %s to the transistor\n",
               Figure->NAME );

      rflattenrdsfig( Figure, RDS_YES, RDS_NO );
   }
   else
   {
     Figure = getrdsfig( argv[1], 'A', 0 );
    
     fprintf( stdout, "\n   --> Flatten the instance %s in the figure %s\n", 
              argv[2], Figure->NAME );

     flattenrdsfig( Figure, argv[2], RDS_YES );
   }

   Figure->NAME = namealloc( argv[3] );

   fprintf( stdout, "   --> Saving figure %s \n\n", Figure->NAME );

   saverdsfig( Figure );

   return( 0 );
 }
