 /****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  synthese FPGA                                              */
/*    Fichier :  fpga.c                                                     */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  Eudes Prado Lopes                       le : 20 /10/1993 */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H
#include "../compil/lax_param.h"
#include "../compil/sl_util.h"
#include "../bddorder/bdd_order.h"
#include "fpga.h"
#include "fp_type.h"


/*======================================================================/
/		                MAIN					/
/======================================================================*/

main(argc,argv)
int argc ;
char *argv[];
{
char *getenv();
char *path;
beout_list *out;
pNode res;
int nNode ;
chain_list *expr;
int countCLB;
int i;
char *carint;


VHB_HEDFIG = NULL;
fp_sys = initializeFPSystem();
fpMajSystem(fp_sys);

                /* verification de la validite des arguments */
 
if (!verifArgsFPGA(fp_sys,argc,argv)) exit(-1);

initializeBdd(1);

                /* initialisation selon le mode (batch ou non) */
 
if (!strcmp(argv[1],"-o") || !strcmp(argv[1],"-l"))
   {
   int vhb_reorder = 0;
 
                /* initialisation du systeme */
 
   fpAddInfoSystem(fp_sys,1,argc,argv,"1.01");
   if (FP_BANN)
      displayFpgaSystem(fp_sys);

   trace = 1;


   if ((FP_TRACE >= 0)&&(FP_TRACE <=3))
      {
      trace = FP_TRACE;
      }
 
   if (FP_OPTION == 'l')
      FP_AUX = 1;
 
   if (FP_MAKEORDER >= 1)
      vhb_reorder = 2;
 
   if (compileVHDL(FP_VHDL,FP_ORDERPI,FP_ORDER,FP_PAR,
                      FP_AUX,1,vhb_reorder,1,trace,nameInt,NULL) == NULL)
      {
      printf("*** Compilation aborted...\n");
      exit(-1);
      }

   FP_BEH = VHB_HEDFIG;
   carint = (char *) mbkalloc(strlen(FP_BEH->NAME) + 2);
 
                /* verification de la coherence */
 
   verifCohBeh(FP_BEH,FP_DELAYPI,FP_OPTIMPO);
 
   if (FP_TRACE)
      displayBeh(FP_BEH,1);

   if (FP_OPTION == 'l')
      FP_AUX = 1;
 
   anealingFPGA(FP_BEH,FP_TRACE);

   if (FP_FAMILY == X3000)
      {
      bdd2FpgaBeh(FP_BEH);
      if (FP_TRACE == 1)
         displayMultiGraph(FP_BEH);	
      }

                                /* sauvegarde du fichier */
 
/*
   if (FP_OPTION == 'l')
      sprintf(carint,"%sl",FP_BEH->NAME);
   else
      sprintf(carint,"%so",FP_BEH->NAME);

   decompileVHDL(FP_BEH,carint,1);
   mbkfree(carint);
*/

   }
else
   {
                /* version interactive */
 
   if (argc == 2)
      {
      fpAddInfoSystem(fp_sys,0,argc,argv,"FPGA Synthesis - V 1.01");
      }
   else 
      fpAddInfoSystem(fp_sys,2,argc,argv,"FPGA Synthesis - V 1.01");
 
   BVL_LINNUM = 0;

printf("Version interactive non programmee ...\n");
/*
   PRINCIPAL(1);
*/
   }
printf("\n");
exit(0);
}
