
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: sl_order.h						*/
/* date		: August 29 91						*/
/* author	: BURGUN L.						*/
/*									*/
/* contents	: This file contains defines and structure definitions	*/
/*		  for the ordonnancer 				        */
/*									*/
/* ###--------------------------------------------------------------### */

int 	traitementAtome();
int	traitementABL();
void 	traitementCone();
chain_list	*makeOrderAbl();
chain_list	*optimSurface();
void		 coutPI();




/*---- la structure de donnees pour le calcul d'ordonnancement sur ABL ----- 

	sigmaDeltaDepth : somme des ecarts entre le niveau d'apparition de la
			  variable et la profondeur d'un cone sur l'ensemble
			  de la BEFIG.
	DepthMin	: profondeur min de la variable consideree
	numOccMin	: nombre d'occurences de la variable a sa profondeur
			  minimale DepthMin.
        numberOut       : nombre de cones ou la variable apparait.
	vue		: drapeau pour le tri dans la table.
	total		: le coefficient pour le tri final.
---------------------------------------------------------------------------*/
  	
typedef struct sl_Torder {
	int numberOcc;
        int sigmaDeltaDepth; 
        long numOccMin; 
        int depthMin;
        int numberOut;
	int vue;
	char *name;
        long total;
	} sl_tableOrder;

#define logint(a) (int) log((double) a)
#define profAuxPTCL(ptcl) ((ptcl->TYPE) >> 8)
#define occAuxPTCL(ptcl) ((ptcl->TYPE) & 1111111)
