/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :   synthetiseur logique                                      */
/*    Fichier :   sl_order.c                                                */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : DESTOMBES C.                          le : 12/06/91       */
/*                                                                          */
/*    Modifie par :  BURGUN L.                          le : 15/11/91       */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include MUT_H
#include LOG_H
#include BEH_H
#include <math.h>
#include "../compil/lax_param.h"
#include "../compil/sl_util.h"
#include "../synthe/sl_type.h"
#include "sl_order.h"


/*---------------------------------------------------------------------------
traitementAux	: traitement d'un Abl aux  pour le remplissage de la struct de
-----------------------------------------------------------------------------
retour		: int
---------------------------------------------------------------------------*/
int	 traitementAux(beh,name,ptOrder,ptHOrder,depth,oper,ptHAux)
befig_list 	*beh;
char		*name;
sl_tableOrder	*ptOrder;
pTH	  	ptHOrder;
int		 depth;
int		 oper;
pTH	  	ptHAux;

{
chain_list *expr;

expr = (chain_list *) searchTH(ptHAux,name);

if (expr != (chain_list *) VIDETH)
   {
   if (ATOM(expr) || OPER( expr ) == oper)
      {
      return( traitementABL( beh, expr, ptOrder, 
                          ptHOrder, depth, oper,ptHAux ));
      }
   else 
      if (OPER(expr) == NOT)
         {
         return( traitementABL( beh, expr, 
                             ptOrder,ptHOrder, depth, oper,ptHAux )); 
         }
      else
         {
          return( traitementABL( beh, expr, ptOrder, 
	   		ptHOrder, depth +1, oper,ptHAux));
          }
      }
else
   {
   printf("traitementAux : variable '%s' does'nt exist\n,name");
   return( depth );
   }
}

/*---------------------------------------------------------------------------
supportAuxExpr	: compile un cone au premier niveau en calculant pour
                  chaque variable auxiliaire sa profondeur min et son 
                  nombre d'apparition a ce niveau.
		  le champs DATA de la ptype_list correspond au doublet
      		  terminal (atome).
-----------------------------------------------------------------------------
retour		: void
---------------------------------------------------------------------------*/
void supportAuxExpr(beh,abl,ppAux,prof,ptHOrder)
befig_list *beh;
chain_list *abl;
ptype_list **ppAux;
int prof;
pTH ptHOrder;
{
if (ATOM(abl))
   {
   ptype_list *pTL = *ppAux;

			/* est-ce une entree, 0 ou 1 ? */

   if ((searchTH(ptHOrder,VALUE_ATOM(abl)) != VIDETH) || 
       VALUE_ATOM(abl) == namealloc("'d'") ||
       VALUE_ATOM(abl) == namealloc("'0'") ||
       VALUE_ATOM(abl) == namealloc("'1'"))
      {
      return;   
      }

   while (pTL)
      {
        		/* nouvelle occurence de AUX */

      if ((char *)(CAR(pTL)->DATA) == VALUE_ATOM(abl))
         {
         
         if (prof == profAuxPTCL(pTL))		/* m profondeur d'apparition */
            {
            pTL->TYPE = pTL->TYPE + 1; 
            }
         else
            if (prof < profAuxPTCL(pTL))
               {
               pTL->TYPE = (prof << 8) + 1;
               pTL->DATA = (void *) abl;
               }
         return;
         }
      pTL = pTL->NEXT;
      }
		/* nouvelle variable auxiliaire */

   *ppAux = addptype(*ppAux,(prof << 8)+1,(char *) abl);
   }
else
   {
   while (abl = CDR(abl))
         supportAuxExpr(beh,CAR(abl),ppAux,prof+1,ptHOrder);
   }
}

/*---------------------------------------------------------------------------
traitementABL	: traitement d'un ABL pour le remplissage de la struct de don
-----------------------------------------------------------------------------
retour		: int correspondant a la profondeur maximale de l'expression.
---------------------------------------------------------------------------*/
int	traitementABL(beh, abl, ptOrder, ptHOrder,depth, oper,ptHAux )
befig_list 	*beh;
chain_list	*abl;
sl_tableOrder	*ptOrder;
pTH		ptHOrder;
int		depth;
int		oper;
pTH		ptHAux;
{
int resul;
ptype_list *pAux;
ptype_list **ppAux = (ptype_list **) mbkalloc (sizeof(ptype_list *));
*ppAux = NULL;


supportAuxExpr(beh,abl,ppAux,0,ptHOrder);
pAux = *ppAux;
resul = traitementABLInt(beh,abl,ptOrder,ptHOrder,
                         depth,oper,*ppAux,ptHAux);
freeptype(*ppAux);
mbkfree(ppAux);
return(resul);
}

/*---------------------------------------------------------------------------
traitementABLInt: la meme en interne. 
-----------------------------------------------------------------------------
retour		: int correspondant a la profondeur maximale de l'expression.
---------------------------------------------------------------------------*/
int traitementABLInt(beh,abl,ptOrder,ptHOrder,depth,oper,pAux,ptHAux)
befig_list 	*beh;
chain_list	*abl;
sl_tableOrder	*ptOrder;
pTH		ptHOrder;
int		 depth;
int		 oper;
ptype_list      *pAux;
pTH		ptHAux;
{
int		 oper_;


if (ATOM(abl))
   {
   int		 indice;
   char *name = VALUE_ATOM(abl);

   if (name == namealloc("'d'") ||
       name == namealloc("'0'") || name == namealloc("'1'"))
      return(depth);

			/* est-ce une entree ? */

   indice = searchTH( ptHOrder, name);
   if (indice != VIDETH)
      {

	/* premier occurence ou nouvelle occurence au meme niveau */

      if (ptOrder[indice].depthMin == 0 || depth == ptOrder[indice].depthMin)
         {
         ptOrder[indice].numOccMin = ptOrder[indice].numOccMin + 1;
         ptOrder[indice].depthMin = depth;
         }

		/* profondeur inferieure */

      if (depth < ptOrder[indice].depthMin )
         {
         ptOrder[indice].depthMin = depth;
         ptOrder[indice].numOccMin = 1;
         }
	
/*   

printf("nom de l'atome: %s \n",name);
printf("   son ind: %d \n",indice);
printf("   son nb d'cc au niveau min: %d \n",ptOrder[indice].numOccMin);
printf("   sa prof: %d ",depth );
printf("   sa profmin: %d \n",ptOrder[indice].depthMin);

*/

      return( depth );
      }
   else
      {

      while (pAux)		/* recherche dans les Aux */
         {
         if ((char *)(CAR(pAux)->DATA) == name)		/* trouve */
            {
            if (pAux->TYPE == 0 || CAR(pAux) != abl)	/* deja traite */
               return(depth);
            else
               {
               int result;

		/* la profondeur diminue avec le nombre d'occurence */

               result = traitementAux(beh, name, ptOrder, ptHOrder, 
                                      depth-logint(2*(occAuxPTCL(pAux))+1), 
                                      oper, ptHAux);
               pAux->TYPE = 0; 
               return(result);
               }
            }     
         pAux = pAux->NEXT;
         }

      printf("traitementABL : Auxilliary variable doesn't exist\n");
      exit(-1); 
      }
   }			/* fin traitement atomique */
else
   {
   int depth_inter,depthm_retour = 0;

   oper_ = OPER( abl);
   while (abl = CDR(abl))
      {
      if (oper_ == oper)
	depth_inter = traitementABLInt( beh, CAR(abl), ptOrder, 
			ptHOrder, depth, oper_ ,pAux, ptHAux ) ;
      else
         {
         if (oper_ == NOT)
            {
            if (oper == AND)
               oper_ = OR;
            if (oper == OR)
               oper_ = AND;
	    depth_inter = traitementABLInt( beh, CAR(abl), ptOrder, 
			    ptHOrder, depth, oper_ ,pAux, ptHAux ) ;
            }
         else
	   depth_inter = traitementABLInt( beh, CAR(abl), ptOrder, ptHOrder,
				 depth+1, oper_ ,pAux, ptHAux) ;
         }
      if (depth_inter > depthm_retour)
         depthm_retour = depth_inter;
      }
   return( depthm_retour );
   }
}

/*-------------------------------------------------------------------------
traitementCone 	: traite un cone (registre, bus, bux  ou sortie) 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/

void traitementCone(beh,expr,ptOrder,ptHOrder,ptHAux)
befig_list *beh;
chain_list *expr;
sl_tableOrder *ptOrder;
pTH 	ptHOrder;
pTH 	ptHAux;
{
int depthMax;
sl_tableOrder *ptOrderAux = ptOrder;
berin_list *in;

if (expr == NULL)
   {
   printf("traitement cone : attention abl vide\n");
   }
else
   {
       /* appel a la fonction de remplissage de la structure ptOrder */


   depthMax = traitementABL(beh,expr,ptOrder,ptHOrder,0,1000,ptHAux );

   ptOrderAux = ptOrder;
   in = beh->BERIN;

   while (in)
      {

      if (ptOrderAux->numOccMin != 0) 
         {
         ptOrderAux->numberOut++;

/*
         printf("logint(%d) = %d\n",ptOrderAux->numOccMin,
                logint(ptOrderAux->numOccMin));
         printf("maxdepth = %d depthMin = %d\n",depthMax, ptOrderAux->depthMin);
*/

         if (logint(ptOrderAux->numOccMin) > ptOrderAux->depthMin) 
            ptOrderAux->sigmaDeltaDepth += depthMax;
         else
            ptOrderAux->sigmaDeltaDepth += (1 - logint(ptOrderAux->numOccMin) +
                                            ptOrderAux->depthMin) * depthMax;

         }

      ptOrderAux->depthMin = 0;
      ptOrderAux->numOccMin = 0;
      in = in->NEXT;
      ptOrderAux++;
      }
   PRINTF(".");
   fflush(stdout);
   }
}

/*-------------------------------------------------------------------------
calculSigma 	: met les entrees d'un circuit (berin) dans les tables
                  d'ordonnancement
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/

void calculSigma(beh,ptOrder,ptHOrder,ptHAux)
befig_list *beh;
sl_tableOrder *ptOrder;
pTH ptHOrder;
pTH ptHAux;
{
sl_tableOrder *ptOrderAux = ptOrder;
beout_list *out;
beaux_list *aux;
bebus_list *bus;
bebux_list *bux;
bereg_list *reg;
biabl_list *biabl;
int depthMax;
int count =0;
berin_list *in;
int c;

	/* insertion des auxiliares dans la table de hachage ptHAux*/

aux = beh->BEAUX;
while (aux)
   {
   addTH(ptHAux,aux->NAME,aux->ABL);
   aux = aux->NEXT;
   }

	/* insertion des entrees primaires dans la table de hachage */

in = beh->BERIN;
while (in)
   {
   ptOrderAux->name = in->NAME ;
   ptOrderAux->sigmaDeltaDepth = 0;
   ptOrderAux->depthMin = 0;
   ptOrderAux->vue = 0;
   ptOrderAux->numOccMin = 0;
   ptOrderAux->numberOut = 0;
   ptOrderAux->total= 0;
   addTH(ptHOrder,in->NAME,count);
   in = in->NEXT;
   count++;
   ptOrderAux++;
   };


	/* remplissage de la struct de donnees sl_tableOrder */
	/*   ( informations pour l'ordonnancement )	     */

out = beh->BEOUT;
while (out)
   {

/*
   printf("\n output: %s\n", out->NAME );
   displayExpr(out->ABL);
*/
   traitementCone(beh,out->ABL,ptOrder,ptHOrder,ptHAux);
   out = out->NEXT;
   }

bus = beh->BEBUS;
while (bus)
   {
/*
   printf("\n bus: %s\n", bus->NAME );
 */  
   biabl = bus->BIABL;
   while (biabl)
      {
      traitementCone(beh,biabl->VALABL,ptOrder,ptHOrder,ptHAux);
/*
      traitementCone(beh,biabl->CNDABL,ptOrder,ptHOrder,ptHAux);
*/
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux)
   {
/*
   printf("\n bux: %s\n", bux->NAME );
 */  
   biabl = bux->BIABL;
   while (biabl)
      {
      traitementCone(beh,biabl->VALABL,ptOrder,ptHOrder,ptHAux);
/*
      traitementCone(beh,biabl->CNDABL,ptOrder,ptHOrder,ptHAux);
*/
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }

reg = beh->BEREG;
while (reg)
   {

/*
   printf("\n reg: %s\n", reg->NAME );
*/
   
   biabl = reg->BIABL;
   while (biabl)
      {
      traitementCone(beh,biabl->VALABL,ptOrder,ptHOrder,ptHAux);
/*
      traitementCone(beh,biabl->CNDABL,ptOrder,ptHOrder,ptHAux);
*/
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }
}

	
/*--------------------------------------------------------------------------
analyseResul	: fournit un ordonnancement selon les param de sl_tableOrder
----------------------------------------------------------------------------
retour		: une LC (qu'il faudra recoller a l'ensemble)
--------------------------------------------------------------------------*/
chain_list	*analyseResul( beh, ptOrder, ptHOrder,trace)
befig_list 	*beh;
sl_tableOrder 	*ptOrder;
pTH 	 	ptHOrder;
int		trace;
{
chain_list	*LC_retour = NULL;
long		 coutMax;
int		 j, indice, finTable;
int		i;

finTable = countInputBeh( beh );


for( i = 0; i < finTable; i ++ )
   {
   if (ptOrder[i].numberOut == 0) 
      {
      ptOrder[i].total = 0;
      }
  else 
      {
      ptOrder[i].total = (100*ptOrder[i].sigmaDeltaDepth)/ptOrder[i].numberOut;

/*
      if (trace)
         {
         printf("TOTAL de %s : %d", ptOrder[i].name, ptOrder[i].total );
         printf(" = %d sur %d\n", ptOrder[i].sigmaDeltaDepth, ptOrder[i].numberOut);
         }
*/
      }
   }


for( j = 0; j < finTable; j ++ ) 
   {
   coutMax = -100000;

		/* calcul du cout max */

   for( indice = 0; indice < finTable; indice ++ ) 
      {
      if ((ptOrder[indice].vue == 0)&&(ptOrder[indice].total  >coutMax))
         {
  	 coutMax = ptOrder[indice].total;
         }
      }

   if (coutMax == -100000)
/*
      return( LC_retour );
*/
      return( reverse(LC_retour) );

		/* ajout de toutes les entrees de cout coutMax */

   for( indice = 0; indice < finTable; indice ++ ) 
      {
      if ((ptOrder[indice].vue == 0)&&(ptOrder[indice].total  == coutMax))
         {
         ptOrder[indice].vue = 1;
         LC_retour = addchain( LC_retour, ptOrder[indice].name);
         }
      }


   }

return( reverse (LC_retour) );
/*
return( LC_retour);
*/
}

/*-------------------------------------------------------------------------
makeOrderAbl 	: calcule (si mode = 1) un bon ordonnancement pour une BEFIG, 
                  sinon prend l'odre d'apparition.
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/

chain_list *makeOrderAbl(beh,mode,trace)
befig_list *beh;
int mode;
int trace;
{
sl_tableOrder *ptOrder;
pTH ptHOrder,ptHAux;
int count;
chain_list *resul;

if (trace)
   {
   printf("\n");
   printf("Running abl ordonnancer on `%s` ...",beh->NAME);
   }

count = countInputBeh(beh);

if (count == 0)
   return NULL;

if (mode == 1)		/* mode automatique */
   {
   beaux_list *aux;

   ptOrder = (sl_tableOrder *) mbkalloc (count * sizeof(sl_tableOrder));
   ptHOrder = createTH(2*count);
   count = 0;
   aux = beh->BEAUX;
   while (aux)
     {
     aux = aux->NEXT;
     count++;
     }
   ptHAux = createTH(2*count+1);
   calculSigma(beh,ptOrder,ptHOrder,ptHAux);
   PRINTF("\n");
   resul =  analyseResul ( beh, ptOrder, ptHOrder,trace );
   destroyTH(ptHOrder); 
   destroyTH(ptHAux); 
   mbkfree(ptOrder);
   PRINTF("\n");
   return resul;
   }
else			/* par ordre d'apparition */
   {
   if (trace) printf("\n");
   return(berinToChain_list(beh));
   }
}
