
/*  A Bison parser, made from pat_desc.yac  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse pat_descparse
#define yylex pat_lex
#define yyerror pat_descerror
#define yylval pat_desclval
#define yychar pat_descchar
#define yydebug pat_descdebug
#define	_IN	258
#define	_INOUT	259
#define	_LESym	260
#define	_OUT	261
#define	AbstractLit	262
#define	BitStringLit	263
#define	BEGIN_	264
#define	Colon	265
#define	Comma	266
#define	Comment	267
#define	DOWNTO	268
#define	Dot	269
#define	END_	270
#define	Format	271
#define	Identifier	272
#define	LeftParen	273
#define	Literal	274
#define	REGISTER	275
#define	RightParen	276
#define	SAVE	277
#define	SIGNAL	278
#define	Semicolons	279
#define	TO	280
#define	UnknownChar	281

#line 12 "pat_desc.yac"


#include <stdio.h>
#include MUT_H
#include PAT_H
#include "pat_type.h"
#include "pat_desc.h"

/* ###--------------------------------------------------------------### */
/* function	: lcl_addpacom						*/
/* description	: create PACOM structure if there is no more structure	*/
/*		  available in free list				*/
/* called func.	: pat_addpacom						*/
/* ###--------------------------------------------------------------### */

static struct pacom *lcl_addpacom (lastpacom, text, position)

struct pacom   *lastpacom;	/* pointer on the last pacom structure	*/
char           *text;		/* text of the comment			*/
unsigned short  position;	/* # of statement since last comment	*/

  {
  struct pacom *ptcom = NULL;

  if (FRE_COMPNT == NULL)
     ptcom = pat_addpacom (lastpacom, text, position);
  else
    {
    ptcom           = FRE_COMPNT;
    FRE_COMPNT      = ptcom->NEXT;

    ptcom->TEXT     = text;
    ptcom->POSITION = position;
    ptcom->NEXT     = lastpacom;
    }

  return (ptcom);
  }

/* ###--------------------------------------------------------------### */
/* function	: lcl_addpapat						*/
/* description	: create PAPAT structure if there is no more structure	*/
/*		  available in free list				*/
/* called func.	: pat_addpapat						*/
/* ###--------------------------------------------------------------### */

static struct papat *lcl_addpapat (lastpapat, label, line)

struct papat   *lastpapat;	/* pointer on the last papat structure	*/
char           *label;		/* pattern's label			*/
unsigned short  line;		/* pattern' line number			*/

  {
  struct papat *ptpat;

  if (FRE_PATPNT == NULL)
     ptpat = pat_addpapat (lastpapat, label, line);
  else
    {
    ptpat      = FRE_PATPNT;
    FRE_PATPNT = ptpat->NEXT;

    ptpat->LABEL   = label;
    ptpat->PAEVT   = NULL;
    ptpat->PAINI   = NULL;
    ptpat->LINE    = line;
    ptpat->BLANK   =  0 ;
    ptpat->ACTFLAG = 'U';
    ptpat->SIMFLAG = 'U';
    ptpat->NEXT    = lastpapat;
    }

  return (ptpat);
  }

/* ###--------------------------------------------------------------### */
/* function	: lcl_addpaini						*/
/* description	: create PAINI structure if there is no more structure	*/
/*		  available in free list				*/
/* called func.	: pat_addpaini						*/
/* ###--------------------------------------------------------------### */

static struct paini *lcl_addpaini (lastpaini, name, value)

struct paini *lastpaini;	/* pointer on the last paini structure	*/
char         *name;		/* register's name			*/
char          value;		/* value to be forced into the register	*/

  {
  struct paini *ptini;

  if (FRE_INIPNT == NULL)
     ptini =  pat_addpaini (lastpaini, name, value);
  else
    {
    ptini      = FRE_INIPNT;
    FRE_INIPNT = ptini->NEXT;

    ptini->NAME  = namealloc (name);
    ptini->VALUE = value;
    ptini->NEXT  = lastpaini;
    }

  return (ptini);
  }

/* ###--------------------------------------------------------------### */
/* function	: lcl_addpaevt						*/
/* description	: create PAEVT structure if there is no more structure	*/
/*		  available in free list				*/
/* called func.	: pat_addpaevt						*/
/* ###--------------------------------------------------------------### */

static struct paevt *lcl_addpaevt (lastpaevt, index, usrval)

struct paevt   *lastpaevt;	/* pointer on the last paevt structure	*/
unsigned short  index;		/* index of the input-output		*/
char            usrval;		/* user predicted value			*/

  {
  struct paevt *ptevt;

  if (FRE_EVTPNT == NULL)
     ptevt = pat_addpaevt (lastpaevt, index, usrval);
  else
    {
    ptevt      = FRE_EVTPNT;
    FRE_EVTPNT = ptevt->NEXT;

    ptevt->INDEX  = index;
    ptevt->USRVAL = usrval;
    ptevt->SIMVAL = usrval;
    ptevt->NEXT   = lastpaevt;
    }

  return (ptevt);
  }

/* ###--------------------------------------------------------------### */
/* function	: yyerror						*/
/* description	: print an error message (errors detected by yacc)	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void yyerror (str)

char *str;
  {
  ERR_FLG += pat_error (18, str, ' ', LINNUM);
  }

/* ###--------------------------------------------------------------### */
/* function	: tobin							*/
/* description	: change to binary					*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void tobin (value,str1,str2)

char  value;
char **str1;
char **str2;

  {

  switch (value)
    {
    case '*':
      *str1 = "****"; *str2 = "****"; break;
    case '-':
    case '0':
      *str1 = "0000"; *str2 = "----"; break;
    case '+':
    case '1':
      *str1 = "0001"; *str2 = "---+"; break;
    case '2':
      *str1 = "0010"; *str2 = "--+-"; break;
    case '3':
      *str1 = "0011"; *str2 = "--++"; break;
    case '4':
      *str1 = "0100"; *str2 = "-+--"; break;
    case '5':
      *str1 = "0101"; *str2 = "-+-+"; break;
    case '6':
      *str1 = "0110"; *str2 = "-++-"; break;
    case '7':
      *str1 = "0111"; *str2 = "-+++"; break;
    case '8':
      *str1 = "1000"; *str2 = "+---"; break;
    case '9':
      *str1 = "1001"; *str2 = "+--+"; break;
    case 'A':
    case 'a':
      *str1 = "1010"; *str2 = "+-+-"; break;
    case 'B':
    case 'b':
      *str1 = "1011"; *str2 = "+-++"; break;
    case 'C':
    case 'c':
      *str1 = "1100"; *str2 = "++--"; break;
    case 'D':
    case 'd':
      *str1 = "1101"; *str2 = "++-+"; break;
    case 'E':
    case 'e':
      *str1 = "1110"; *str2 = "+++-"; break;
    case 'F':
    case 'f':
      *str1 = "1111"; *str2 = "++++"; break;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: pshnam						*/
/* description	: push a name on the NAMTAB stack to build a		*/
/*		  hierarchical name					*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void pshnam (str)

char *str;

  {
  if (NAM_IDX > 30)
    ERR_FLG += pat_error (14, NULL, ' ', LINNUM);
  else
    {
    NAMTAB [NAM_IDX] = str;
    NAM_IDX++;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: addini						*/
/* description	: add a list of PAINI structure at the top of the list	*/
/* called func.	: lcl_addpaini, tobin					*/
/* ###--------------------------------------------------------------### */

static struct paini *addini (lastini, gname, value)

struct paini *lastini;
struct array  gname;
char         *value;

  {
  struct paini *ptini = lastini;
  char         *frc;
  char         *cmp;
  int           length;
  int           size;
  int           index;
  int           i;
  int           inc;
  char          extname[100];
  char          format;

  if (gname.left < gname.right)
    {
    length = gname.right - gname.left + 1;
    inc    = 1;
    }
  else
    {
    length = gname.left - gname.right + 1;
    inc    = -1;
    }

  switch (value[0])
    {
    case 'X' :
    case 'x' :
      size = (strlen(value) - 3) * 4;
      format = 'X';
      index = 2;
      break;
    case 'O' :
    case 'o' :
      size = (strlen(value) - 3) * 3;
      format = 'O';
      index = 2;
      break;
    case 'B' :
    case 'b' :
      size = strlen(value) - 3;
      format = 'B';
      index = 2;
      break;
    case '"' :
      size = strlen(value) - 2;
      format = 'B';
      index = 1;
      break;
    case '\'' :
      size = 1;
      format = 'B';
      index = 1;
      break;
    }

  if (length != size)
    ERR_FLG += pat_error (12, gname.ident, ' ', LINNUM);
  else
    {
    if (gname.left == -1)
      ptini = lcl_addpaini (ptini, gname.ident, value[index]);
    else
      {
      for (i=gname.left ; i!=(gname.right+inc) ;)
        {
        tobin  (value[index], &frc, &cmp);
        switch (format)
          {
          case 'X':
          case 'x':
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[0]);
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[1]);
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[2]);
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[3]);
            break;
          case 'O':
          case 'o':
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[1]);
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[2]);
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[3]);
            break;
          case 'B':
          case 'b':
            sprintf (extname, "%s %d", gname.ident, i);
            i += inc;
            ptini = lcl_addpaini (ptini, extname, frc[3]);
            break;
          }
        index++;
        }
      }
    }
  return (ptini);
  }

/* ###--------------------------------------------------------------### */
/* function	: isevent						*/
/* description	: detect an event on an input-output and add if needed	*/
/*		  a PAEVT structure at the top of the list		*/
/* called func.	: tobin, lcl_addpaevt					*/
/* ###--------------------------------------------------------------### */

static struct paevt *isevent (lastevt, index, compare, value, rank)

struct paevt *lastevt;
short         index;
char          compare;
char          value;
int           rank;

  {
  struct paiol *ptiol;
  int           check;
  int           i;
  char          cmp_val;
  char          frc_val;
  char         *frc;
  char         *cmp;

  ptiol = PAT_SEQPNT->PAIOL + index;
  if ((value == '*') || (value == '-') || (value == '+'))
    compare = 'C';

  tobin (value, &frc, &cmp);
  switch (ptiol->MODE)
    {
    case 'I':
      for (i=rank ; i<4 ; i++)
        {
        frc_val = frc[i];
        if (VALUE[index] != frc_val)
          {
          lastevt = lcl_addpaevt (lastevt, index, frc_val); 
          VALUE[index]  = frc_val;
          }
        index++;
        }
      break;
    case 'O':
    case 'B':
    case 'Z':
    case 'S':
    case 'W':
    case 'X':
    case 'U':
    case 'R':
      for (i=rank ; i<4 ; i++)
        {
        cmp_val = cmp[i];
        if ((VALUE[index] != cmp_val) || (cmp_val == '*'))
          {
          lastevt = lcl_addpaevt (lastevt, index, cmp_val); 
          VALUE[index]  = cmp_val;
          }
        index++;
        }
      break;
    case 'T':
      if (compare == 'F')
        {
        for (i=rank ; i<4 ; i++)
          {
          frc_val = frc[i];
          if (VALUE[index] != frc_val)
            {
            lastevt = lcl_addpaevt (lastevt, index, frc_val); 
            VALUE[index]  = frc_val;
            }
          index++;
          }
        }
      else
        {
        for (i=rank ; i<4 ; i++)
          {
          cmp_val = cmp[i];
          if ((VALUE[index] != cmp_val) || (cmp_val == '*'))
            {
            lastevt = lcl_addpaevt (lastevt, index, cmp_val); 
            VALUE[index]  = cmp_val;
            }
          index++;
          }
        }
      break;
    }
  return (lastevt);
  }

/* ###--------------------------------------------------------------### */
/* function	: islegal						*/
/* description	: check if a value is legal				*/
/* called func.	: pat_error						*/
/* ###--------------------------------------------------------------### */

static void islegal (index, value, flag, status)

int  index;				/* ptiol's index		*/
char value;				/* value (+,-,*,0,...,9,a,...,f)*/
char flag;				/* comparison flag (C,F)	*/
int  status;				/* (0,1,2) (bit,array,inside)	*/

  {
  int           code = -1;
  char          comp = flag;
  struct paiol *ptiol;

	/* ###------------------------------------------------------### */
	/*   Giving a code to each group of values			*/
	/* ###------------------------------------------------------### */

  switch (value)
    {
    case '*':
      code = 0; comp = 'C'; break;
    case '0':
    case '1':
      code = 1; break;
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
      code = 2; break;
    case '8':
    case '9':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      code = 3; break;
    case '+':
    case '-':
      code = 4; comp = 'C'; break;
    }

	/* ###------------------------------------------------------### */
	/*   Checking parameters' consistency :				*/
	/*     '+' or '-' preceded by a '?'		-> error	*/
	/*     '+' or '-' for an array			-> error	*/
	/*	unknown value				-> error	*/
	/* ###------------------------------------------------------### */

  if ((code == 4) && (flag == 'C'))
    ERR_FLG += pat_error (2, NULL, '?', LINNUM);

  if ((code == 4) && (status != 0))
    ERR_FLG += pat_error (2, NULL, value, LINNUM);

  if (code == -1)
    ERR_FLG += pat_error (2, NULL, value, LINNUM);
  else
    {

	/* ###------------------------------------------------------### */
	/*   Checking coherence of value and input-output format :	*/
	/*     2,...,9,a,...,f and binary format	-> error	*/
	/*     a,...,f,+,-     and octal  format	-> error	*/
	/*     +,-             and hexa.  format	-> error	*/
	/* ###------------------------------------------------------### */

    flag  = comp;
    ptiol = PAT_SEQPNT->PAIOL + index;
    switch (ptiol->FORMAT)
      {
      case 'b' :
      case 'B' :
        if ((code == 2) || (code == 3))
          ERR_FLG += pat_error (10, ptiol->NAME, 'B', LINNUM);
        break;
      case 'o' :
      case 'O' :
        if (code >= 3)
          ERR_FLG += pat_error (10, ptiol->NAME, 'O', LINNUM);
        break;
      case 'x' :
      case 'X' :
        if (code == 4)
          ERR_FLG += pat_error (10, ptiol->NAME, 'X', LINNUM);
        break;
      }

	/* ###------------------------------------------------------### */
	/*   Checking coherence of value and input-output mode		*/
	/*     compare a value on an input		-> error	*/
	/*     put an undefined value on an input	-> error	*/
	/*     force a value on an output		-> error	*/
	/* ###------------------------------------------------------### */

    switch (ptiol->MODE)
      {
      case 'I' :
        if ((flag == 'C') || (code == 4) || (code == 0))
          ERR_FLG += pat_error (5, ptiol->NAME, ' ', LINNUM);
        break;
      case 'O' :
      case 'R' :
      case 'S' :
        if (flag != 'C')
          ERR_FLG += pat_error (4, ptiol->NAME, ' ', LINNUM);
        break;
      }
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: pat_descpat						*/
/* description	: parse a file in pat format and return a PASEQ		*/
/* called func.	: yyparse, reverse, mbkalloc, mbkfree, pat_error	*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_descpat (fp, ptseq, maxpat)

FILE          *fp;
struct paseq  *ptseq;
unsigned int   maxpat;

  {
  struct papat *ptpat  ;
  struct pacom *ptcom  ;
  struct paevt *ptevt  ;
  struct paini *ptini  ;

  struct papat *lastpat;
  extern FILE  *yyin   ;
  int           i      ;

  if ((ptseq == NULL) || (ptseq->ERRFLG != 0))
    ERR_FLG += pat_error (100, NULL, ' ', 0);
  else
    {
    if (ptseq->SUBSEQ == 0)
      {
	/* ###------------------------------------------------------### */
	/*   for the first subsequence initialize the value array	*/
	/* ###------------------------------------------------------### */

      VALUE = mbkalloc (sizeof (char) * (ptseq->IOLNBR));

      for (i=0; i<(ptseq->IOLNBR); i++)
         VALUE [i] = '*';
      }

    else
      {
	/* ###------------------------------------------------------### */
	/*   for other subsequences release old PAPAT, PACOM, PAINI	*/
	/* and PAEVT structures						*/
	/* ###------------------------------------------------------### */

	/* ###------------------------------------------------------### */
	/*   release PACOM of the old subsequence. Move the comments of	*/
	/* the previous subsequence to old.				*/
	/* ###------------------------------------------------------### */

      ptcom = ptseq->OLDCOM;

      if (ptcom != NULL)
        {
        while (ptcom->NEXT != NULL)
          ptcom = ptcom->NEXT;
        }

      if (ptcom != NULL)
        {
        ptcom->NEXT   = FRE_COMPNT;
        FRE_COMPNT    = ptseq->OLDCOM;
        }

      ptseq->OLDCOM = ptseq->CURCOM;
      ptseq->CURCOM = NULL;

	/* ###------------------------------------------------------### */
	/*   scan the PAPAT list of the old subsequence to release it	*/
	/* and ...							*/
	/* ###------------------------------------------------------### */

      lastpat = NULL;
      ptpat   = ptseq->OLDPAT;

      while ((ptpat != NULL) && (ptpat != ptseq->CURPAT))
        {
	/* ###------------------------------------------------------### */
	/*   release PAEVT of the current PAPAT				*/
	/* ###------------------------------------------------------### */

        ptevt = ptpat->PAEVT;

        if (ptevt != NULL)
          {
          while (ptevt->NEXT != NULL)
            ptevt = ptevt->NEXT;
          }

        if (ptevt != NULL)
          {
          ptevt->NEXT = FRE_EVTPNT;
          FRE_EVTPNT  = ptpat->PAEVT;
          }

	/* ###------------------------------------------------------### */
	/*   release PAINI of the current PAPAT				*/
	/* ###------------------------------------------------------### */

        ptini = ptpat->PAINI;

        if (ptini != NULL)
          {
          while (ptini->NEXT != NULL)
            ptini = ptini->NEXT;
          }

        if (ptini != NULL)
          {
          ptini->NEXT = FRE_INIPNT;
          FRE_INIPNT  = ptpat->PAINI;
          }

        ptpat->PAINI = NULL;
        ptpat->PAEVT = NULL;

        lastpat = ptpat;
        ptpat   = ptpat->NEXT;
        }

      if (lastpat != NULL)
        {
        lastpat->NEXT = FRE_PATPNT;
        FRE_PATPNT    = ptseq->OLDPAT;
        }

      ptseq->OLDPAT = ptseq->CURPAT;
      ptseq->CURPAT = ptseq->NXTPAT;

      }

	/* ###------------------------------------------------------### */
	/*   initialization						*/
	/* ###------------------------------------------------------### */

    if (maxpat == 0)
      {
      DECVAL = 0;
      MAXPAT = 1;
      }
    else
      {
      DECVAL = 1;
      MAXPAT = maxpat;
      }

    PAT_SEQPNT          = ptseq;
    PAT_SEQPNT->PATNBR  = 0;

    PAT_COMPNT          = ptseq->CURCOM;
    PAT_PATPNT          = ptseq->CURPAT;
    PAT_INIPNT          = NULL;

    if (ptseq->NXTPAT == NULL)
      STT_NBR = 0;
    else
      STT_NBR = 1;

    if (ptseq->SUBSEQ == 0)
      MAXPAT++;

    LINNUM  = ptseq->LINENO;
    ERR_FLG = 0;
    NAM_IDX = 0;

    yyin    = fp;

	/* ###------------------------------------------------------### */
	/*   call the parser and, prepare the returned structure	*/
	/* ###------------------------------------------------------### */

    yyparse ();

    if (ptseq->SUBSEQ == 0)
      PAT_SEQPNT->PATNBR--;

    if (PAT_SEQPNT->ENDFLG == 'Y')
      {
      PAT_SEQPNT->NXTPAT = NULL;
      PAT_SEQPNT->PATNBR++;
      }
    else
      {
      PAT_SEQPNT->NXTPAT = PAT_PATPNT;
      }

    PAT_SEQPNT->CURPAT   = (struct papat *) reverse (PAT_PATPNT);
    PAT_SEQPNT->CURCOM   = (struct pacom *) reverse (PAT_COMPNT);
    PAT_SEQPNT->LINENO   = LINNUM;

    if (ERR_FLG == 0)
      PAT_SEQPNT->ERRFLG = 0;
    else
      PAT_SEQPNT->ERRFLG = 1;

    PAT_SEQPNT->SUBSEQ++;

	/* ###------------------------------------------------------### */
	/*   if the end of file has bee reached release the value array	*/
	/* ###------------------------------------------------------### */

    if (PAT_SEQPNT->ENDFLG == 'Y')
      mbkfree (VALUE);

    ptseq = PAT_SEQPNT;
    }

  return (ptseq);
  }


#line 797 "pat_desc.yac"
typedef union
  {
  int           valu;
  char          immd;
  char         *text;
  struct array  arra;
  } YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		44
#define	YYFLAG		-32768
#define	YYNTBASE	27

#define YYTRANSLATE(x) ((unsigned)(x) <= 281 ? yytranslate[x] : 46)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     5,     7,     8,    11,    13,    15,    18,    20,    22,
    24,    26,    28,    30,    35,    42,    45,    46,    50,    52,
    54,    59,    60,    63,    66,    70,    71,    73,    75
};

#endif

static const short yyrhs[] = {    28,
    40,    44,    45,     0,    29,     0,     0,    29,    30,     0,
    41,     0,    31,     0,     1,    45,     0,    39,     0,    12,
     0,    33,     0,    34,     0,    35,     0,    36,     0,    36,
    18,     7,    21,     0,    36,    18,     7,    38,     7,    21,
     0,    17,    37,     0,     0,    37,    14,    17,     0,    25,
     0,    13,     0,    32,     5,     8,    45,     0,     0,    22,
    45,     0,    43,    42,     0,    10,    19,    45,     0,     0,
    17,     0,    15,     0,    24,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   843,   851,   855,   856,   861,   862,   863,   868,   869,   877,
   879,   881,   886,   895,   907,   921,   939,   940,   947,   948,
   952,   960,   961,   967,   988,  1141,  1143,  1148,  1153
};

static const char * const yytname[] = {   "$","error","$illegal.","_IN","_INOUT",
"_LESym","_OUT","AbstractLit","BitStringLit","BEGIN_","Colon","Comma","Comment",
"DOWNTO","Dot","END_","Format","Identifier","LeftParen","Literal","REGISTER",
"RightParen","SAVE","SIGNAL","Semicolons","TO","UnknownChar","pat_format_file",
"description_block","..description_item..","description_item","other_statement",
"name","simple_name","indexed_name","slice_name","Identifier...Identifier..",
"...Identifier..","direction","initialization_statement",".save_statement.",
"pattern_description","unlabeled_pattern",".label.","END_ERR","Semicolons_ERR",
""
};
#endif

static const short yyr1[] = {     0,
    27,    28,    29,    29,    30,    30,    30,    31,    31,    32,
    32,    32,    33,    34,    35,    36,    37,    37,    38,    38,
    39,    40,    40,    41,    42,    43,    43,    44,    45
};

static const short yyr2[] = {     0,
     4,     1,     0,     2,     1,     1,     2,     1,     1,     1,
     1,     1,     1,     4,     6,     2,     0,     3,     1,     1,
     4,     0,     2,     2,     3,     0,     1,     1,     1
};

static const short yydefact[] = {     3,
    22,     0,     0,     0,     0,     9,    17,     4,     6,     0,
    10,    11,    12,    13,     8,     5,     0,    29,    23,    28,
     0,     7,    16,     0,     0,     0,    24,     1,     0,     0,
     0,     0,    18,    21,    20,    14,    19,     0,    25,     0,
    15,     0,     0,     0
};

static const short yydefgoto[] = {    42,
     1,     2,     8,     9,    10,    11,    12,    13,    14,    23,
    38,    15,     4,    16,    27,    17,    21,    19
};

static const short yypact[] = {-32768,
   -20,     0,   -21,   -11,   -21,-32768,    -3,-32768,-32768,     3,
-32768,-32768,-32768,   -13,-32768,-32768,    -1,-32768,-32768,-32768,
   -21,-32768,     5,    12,     4,    -6,-32768,-32768,     6,   -21,
    -7,   -21,-32768,-32768,-32768,-32768,-32768,    14,-32768,     7,
-32768,    24,    26,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    -5
};


#define	YYLAST		28


static const short yytable[] = {    22,
     5,     3,    18,    20,    25,    35,   -27,    24,    26,   -26,
    31,     6,    32,    36,    -2,    28,     7,    37,    29,    30,
    40,    -2,    33,    43,    34,    44,    39,    41
};

static const short yycheck[] = {     5,
     1,    22,    24,    15,    18,    13,    10,     5,    10,    10,
     7,    12,    19,    21,    15,    21,    17,    25,    14,     8,
     7,    22,    17,     0,    30,     0,    32,    21
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/labo/gnu/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/labo/gnu/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 847 "pat_desc.yac"
{ PAT_SEQPNT->ENDFLG = 'Y'; ;
    break;}
case 9:
#line 870 "pat_desc.yac"
{
		PAT_COMPNT = lcl_addpacom (PAT_COMPNT, yyvsp[0].text, STT_NBR);
		STT_NBR    = 0;
		;
    break;}
case 10:
#line 878 "pat_desc.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 11:
#line 880 "pat_desc.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 12:
#line 882 "pat_desc.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 13:
#line 887 "pat_desc.yac"
{
		yyval.arra.ident = yyvsp[0].text;
		yyval.arra.left  = -1;
		yyval.arra.right = -1;
		;
    break;}
case 14:
#line 899 "pat_desc.yac"
{
		yyval.arra.ident = yyvsp[-3].text;
		yyval.arra.left  = yyvsp[-1].valu;
		yyval.arra.right = yyvsp[-1].valu;
		;
    break;}
case 15:
#line 913 "pat_desc.yac"
{
		yyval.arra.ident = yyvsp[-5].text;
		yyval.arra.left  = yyvsp[-3].valu;
		yyval.arra.right = yyvsp[-1].valu;
		;
    break;}
case 16:
#line 923 "pat_desc.yac"
{
		char name[256];
		int  i;

		strcpy (name, yyvsp[-1].text);
		for (i=0; i<NAM_IDX ; i++)
		 {
		 strcat (name, ".");
		 strcat (name, NAMTAB [i]);
		 }
		NAM_IDX = 0;
		yyval.text = namealloc (name);
		;
    break;}
case 18:
#line 943 "pat_desc.yac"
{ pshnam (yyvsp[0].text); ;
    break;}
case 21:
#line 956 "pat_desc.yac"
{ PAT_INIPNT = addini (PAT_INIPNT, yyvsp[-3].arra, yyvsp[-1].text); ;
    break;}
case 23:
#line 963 "pat_desc.yac"
{ PAT_SEQPNT->SAVFLG = 'Y'; ;
    break;}
case 24:
#line 969 "pat_desc.yac"
{
		if (PAT_INIPNT == NULL)
		  PAT_PATPNT->ACTFLAG = 'U';
		else
		  PAT_PATPNT->ACTFLAG = 'I';

		PAT_PATPNT->LABEL = yyvsp[-1].text;
		PAT_PATPNT->PAINI = (struct paini *) reverse (PAT_INIPNT);
		PAT_INIPNT        = NULL;

		MAXPAT -= DECVAL;
		PAT_SEQPNT->PATNBR++;

		if (MAXPAT == 0)
		  YYACCEPT;
		;
    break;}
case 25:
#line 991 "pat_desc.yac"
{
		char            c;
		int             i     = 0;
		unsigned short  idx   = 0;
		char            endfl = 'Y';
		char            cmpfl = 'F';
		struct pagrp   *ptgrp = PAT_SEQPNT->PAGRP;
		struct paevt   *ptevt = NULL;

		while ((c = yyvsp[-1].text [i++]) != '\0')
		  {
		  if (idx > PAT_SEQPNT->IOLNBR)
		    {
		    ERR_FLG += pat_error (3, NULL, ' ', LINNUM);
		    break;
		    }
		  else
		    {
		    if ((ptgrp != NULL) &&
		        (idx == (ptgrp->LENGTH + ptgrp->FINDEX)))
		      {
		/* ###----------------------------------------------### */
		/*    End of array reached. Update current group pnt.	*/
		/* ###----------------------------------------------### */

		      ptgrp = ptgrp->NEXT;
		      endfl = 'Y';
		      }

		    if (endfl == 'N')
		      {
		/* ###----------------------------------------------### */
		/*    Continuing inside an array			*/
		/* ###----------------------------------------------### */

		      islegal (idx, c, cmpfl, 2);
		      switch ((PAT_SEQPNT->PAIOL + idx)->FORMAT)
		        {
		        case 'X':
		          ptevt  = isevent (ptevt, idx, cmpfl, c, 0);
		          idx   += 4;
		          break;
		        case 'O':
		          ptevt  = isevent (ptevt, idx, cmpfl, c, 1);
		          idx   += 3;
		          break;
		        case 'B':
		          ptevt = isevent (ptevt, idx, cmpfl, c, 3);
		          idx++;
		          break;
		        }
		      }
		    else
		      {
		/* ###----------------------------------------------### */
		/*    Begining a new array or a new single bit		*/
		/* ###----------------------------------------------### */

		      if (c == '?')
		        {
		        cmpfl = 'C';
		        endfl = 'n';
		        }
		      else
		        {
		        if (endfl == 'Y')
		          cmpfl = 'F';

		        if ((ptgrp != NULL) && (idx == ptgrp->FINDEX))
		          {
		/* ###----------------------------------------------### */
		/*    Begining a new array				*/
		/* ###----------------------------------------------### */

		          islegal (idx, c, cmpfl, 1);
		          endfl = 'N';
		          switch ((PAT_SEQPNT->PAIOL + idx)->FORMAT)
		            {
		            case 'X':
		              switch (ptgrp->LENGTH % 4)
		                {
		                case 1:
		                  ptevt = isevent (ptevt, idx, cmpfl, c, 3);
		                  idx++;
		                  break;
		                case 2:
		                  ptevt  = isevent (ptevt, idx, cmpfl, c, 2);
		                  idx   += 2;
		                  break;
		                case 3:
		                  ptevt  = isevent (ptevt, idx, cmpfl, c, 1);
		                  idx   += 3;
		                  break;
		                case 0:
		                  ptevt  = isevent (ptevt, idx, cmpfl, c, 0);
		                  idx   += 4;
		                  break;
		                }
		              break;
		            case 'O':
		              switch (ptgrp->LENGTH % 3)
		                {
		                case 1:
		                  ptevt = isevent (ptevt, idx, cmpfl, c, 3);
		                  idx++;
		                  break;
		                case 2:
		                  ptevt  = isevent (ptevt, idx, cmpfl, c, 2);
		                  idx   += 2;
		                  break;
		                case 0:
		                  ptevt  = isevent (ptevt, idx, cmpfl, c, 1);
		                  idx   += 3;
		                  break;
		                }
		              break;
		            case 'B':
		              ptevt = isevent (ptevt, idx, cmpfl, c, 3);
		              idx++;
		              break;
		            }
		          }
		        else
		          {
		/* ###----------------------------------------------### */
		/*    Begining a new single bit				*/
		/* ###----------------------------------------------### */

		          islegal (idx, c, cmpfl, 0);
		          ptevt = isevent (ptevt, idx, cmpfl, c, 3);
		          cmpfl = 'F';
		          idx++;
		          }
		        }
		      }
		    }
		  }

		if (idx < PAT_SEQPNT->IOLNBR)
		  ERR_FLG += pat_error (15, NULL, ' ', LINNUM);

		PAT_PATPNT = lcl_addpapat (PAT_PATPNT, NULL, LINNUM);

		PAT_PATPNT->PAEVT = ptevt;
		PAT_PATPNT->BLANK = yyvsp[0].valu;
		STT_NBR++;
		;
    break;}
case 26:
#line 1142 "pat_desc.yac"
{ yyval.text = NULL; ;
    break;}
case 27:
#line 1144 "pat_desc.yac"
{ yyval.text = yyvsp[0].text; ;
    break;}
case 28:
#line 1149 "pat_desc.yac"
{ yyerrok; ;
    break;}
case 29:
#line 1154 "pat_desc.yac"
{
		if (ERR_FLG > 30)
		  YYABORT;
		else
		   yyerrok;
		;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 442 "/labo/gnu/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 1161 "pat_desc.yac"

