
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_error.c						*/
/* date		: Aug 31 1993						*/
/* version	: v104							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: system level functions				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_error						*/
/* description	: print an error message depending on the arg. `code`	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

int pat_error (code, str, dat, line)

int           code;
char         *str ;
char          dat ;
unsigned int  line;

  {
  int         flag = 1;

  if (code < 100)
    fprintf (stderr,"PAT : Error %d line %d : ", code, line);
  else
    fprintf (stderr,"PAT : Compiler err. %d : ", code);

  switch (code)
    {
    case 1:
      fprintf (stderr,"illegal format for one-bit signal\n");
      break;
    case 2:
      fprintf (stderr,"illegal input-output value `%c`\n",dat);
      break;
    case 3:
      fprintf (stderr,"too many input-output values\n");
      break;
    case 4:
      fprintf (stderr,"cannot force the value of output `%s`\n",str);
      break;
    case 5:
      fprintf (stderr,"cannot compare the value of input `%s`\n",str);
      break;
    case 6:
      fprintf (stderr,"too many elements in virtual array\n");
      break;
    case 7:
      fprintf (stderr,"`%s` already declared with another mode\n",str);
      break;
    case 8:
      fprintf (stderr,"group `%s` already declared\n",str);
      break;
    case 10:
      fprintf (stderr,"illegal value for `%s` format `%c`\n",str,dat);
      break;
    case 12:
      fprintf (stderr,"range of `%s` and value mismatch\n",str);
      break;
    case 13:
      fprintf (stderr,"`%s` already declared as an input\n",str);
      break;
    case 14:
      fprintf (stderr,"too many hierarchical names\n");
      break;
    case 15:
      fprintf (stderr,"no enough input-output values\n");
      break;
    case 18:
      fprintf (stderr,"%s\n", str);
      break;

    case 100:
      fprintf (stderr,"unexistent or erroneous sequence\n");
      break;
    case 101:
      fprintf (stderr,"cannot drive erroneous sequence of patterns\n");
      break;
    case 102:
      fprintf (stderr, "cannot open file `%s`\n", str);
      break;

    default :
      fprintf (stderr,"syntax error\n");
      break;
    }

  return (flag);
  }
