/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  NetOptim                                                   */
/*    Fichier :  no_param.c                                                 */
/*                                                                          */
/*    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : N. Dictus                             le : 16/07/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include MUT_H
#include MLO_H
#include LOG_H
#include "../load/types_map.h"
#include "../net/no_type.h"
#include "no_param.h"
#include "string.h"

/*---------------------------------------------------------------------------
listeDe		: fait un "ls" en colonnes des fichiers d'un type donne
-----------------------------------------------------------------------------
retour		: aucun
---------------------------------------------------------------------------*/

void	listeDe( path, typeFic )
char  	*path, *typeFic ;

{
char	*commande = (char*) mbkalloc( 100 );

strcpy( commande, "ls -C ");
if (!strcmp(path,"."))
   strcat(commande,"*.");
else
   {
   strcat(commande,path);
   strcat(commande,"/*.");
   }
printf("List of files '.%s' in '%s' :\n\n", typeFic,path );
system( strcat( commande, typeFic) );
free(commande);
}

/*-----------------------------------------------------------------------------
ligne1		: renvoie la premiere chaine d'un fichier donne
-------------------------------------------------------------------------------
retour		: un char*  ( NULL si le fichier n'existe pas )
-----------------------------------------------------------------------------*/

char	*ligne1( fileName )
char	*fileName;

{
FILE	*Pfile;
char	*chaine = (char*) mbkalloc ( 30 );

if ( Pfile = fopen( fileName, "rt" ) ) {
	fscanf( Pfile, "%s", chaine );
	fclose( Pfile );
	return ( chaine );
	}
else {
	return ( NULL );
	}
}
	


/*-----------------------------------------------------------------------------
tempo 		: boucle de temporisation
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		tempo( t )
unsigned long	t;
{
unsigned long	i;
for( i=0; i<t; i++ );
}


/*-----------------------------------------------------------------------------
ModifOrder	: Modification de la LC des entrees (ie Modification des index)
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		  ModifOrder( orderPI, origIndex, destIndex )
chain_list	 *orderPI;
int		  origIndex;
int		  destIndex;

{
chain_list	*pti;
chain_list	*ptj;
chain_list	*ptk;
char		*dataAux = (char*) mbkalloc( 30 );
int 		 count = 2;
char	c;

pti = (chain_list *)mbkalloc(sizeof(chain_list));
ptj = (chain_list *)mbkalloc(sizeof(chain_list));
ptk = (chain_list *)mbkalloc(sizeof(chain_list));

if (destIndex == origIndex ) return;
if (destIndex >  origIndex ) destIndex++;

if (destIndex == 2) {
	ModifOrder( orderPI, origIndex, 3);
	dataAux = orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = dataAux;
	return;
	}
	
if (origIndex == 2) {
	dataAux = orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = dataAux;
	ModifOrder( orderPI, 3, destIndex -1);
	return;
	}
	

ptk->NEXT = pti = ptj = orderPI;


while ( count != destIndex ) {
	ptk = ptk->NEXT;
	pti = pti->NEXT;
	count++;
	}
count = 2;
while ( count != origIndex ) {
	ptj = ptj->NEXT;
	count++;
	}

if ( destIndex == 2 ) {
/*	orderPI = addchain( orderPI, ptj->DATA );
	orderPI = delchain( orderPI, ptj );
	return (orderPI );
*/
	}

delchain( orderPI, ptj );

ptj->NEXT = pti;
ptk->NEXT = ptj;
return ;
}

/*-----------------------------------------------------------------------------
addchain_alpha	: Insertion d'un element de LC dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un chain_list*
-----------------------------------------------------------------------------*/
chain_list	*addchain_alpha( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addchain( NULL, data));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addchain( LC_aux, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addchain( LC_aux->NEXT, data);
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addchain( LC_aux->NEXT, data);
return( LC );
}


/*-----------------------------------------------------------------------------
addptype_alpha	: Insertion d'un element de LC typee dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un ptype_list*
-----------------------------------------------------------------------------*/
ptype_list	*addptype_alpha( LC, data, type )
ptype_list	*LC;
char		*data;
long		 type;
{
ptype_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addptype( NULL, type, data ));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addptype( LC_aux, type, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
 
return( LC );
}
/*--------------------------------------------------------------------------
delMaillon	: detruit un mailon dont la donnee est DATA dans une LC
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
chain_list	*delMaillon( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC_aux->DATA, data) == 0 ) 
	return( delchain( LC_aux, LC_aux ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) 
		return( delchain( LC, LC_aux ));
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
delMaillont	: detruit un mailon dont la donnee est DATA dans une LC typee
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
ptype_list	*delMaillont( LC, data )
ptype_list	*LC;
char		*data;
{
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC->DATA, data) == 0 ) 
	return( delptype( LC, LC->TYPE ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) {
		return( (ptype_list*) delchain( LC, LC_aux ));
		}
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
findDatat	: recherche la DATA, dans une LC typee, de position rang
----------------------------------------------------------------------------
retour		: la DATA
--------------------------------------------------------------------------*/
char		*findDatat( LC, rang )
ptype_list	*LC;
int		 rang;
{
int		 i;
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( rang > countPtype_list( LC ) ) 
	printf("\nrange error !\n");
else 
	for( i = 1; i < rang; i++ ) LC_aux = LC_aux -> NEXT;
return( LC_aux -> DATA );
}


/*--------------------------------------------------------------------------
itoa		: convertit un int en une chaine de caract 
----------------------------------------------------------------------------
retour		: un char *
--------------------------------------------------------------------------*/
char	*itoa( nb )
int 	 nb;
{
char	*p = (char*) mbkalloc( 20 );

if ( nb == 0 ) return("0");

p += 20;
*(--p)= 0;

while ( nb ) {
	*(--p) = ( nb %  10 ) +48;
	nb = nb / 10;
	}

return ( p );
}
