/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  optimiseur de netlist                                      */
/*    Fichier :  no_main.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 06/05/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include MUT_H
#include MLO_H
#include LOG_H
#include "../load/types_map.h"
#include "no_type.h"
#include "no_system.h"

/*----------------------------------------------------------------------------*/
	/*	Numero de version (changement du 14 Decembre 1993)       */

char *VERSION = "3.0";

/*----------------------------------------------------------------------------*/
main(argc,argv)
int argc ;
char *argv[];
{
		/* verification de la validite des arguments */

if (!verifArgs(argc,argv))
   exit(-1);

		/* initialisation selon le mode (batch ou non) */

if (!strcmp(argv[1],"-f") || !strcmp(argv[1],"-t") ||
    !strcmp(argv[1],"-g") || !strcmp(argv[1],"-i"))
   {
		      /* Mode BATCH */
		/* initialisation du systeme */

   char *nameNETO = mbkalloc(30 + strlen(VERSION));
   sprintf(nameNETO, "Netlist Optimization - V %s", VERSION);

   no_sys = initializeNOSystem();
   majNOSystem(no_sys, 1, argc, argv, nameNETO);

   if (getenv("MBK_BANN") == NULL || atoi(getenv("MBK_BANN")) == 0)
      displaySystem(no_sys);

	/* chargement du systeme : netlist + cellules */
   no_sys->log = initializeNet();

   if (NO_OPTION == 'f')
      OPTIMISATION_LOCALE();

   if (NO_OPTION == 't')
      INFORMATION('t');
   if (NO_OPTION == 'i')
      INFORMATION('f');

   if (NO_OPTION == 'g')
      OPTIMISATION_GLOBALE();
   }
else
   {
		/* Mode INTERACTIF */
   no_sys = initializeNOSystem();
   majNOSystem(no_sys, 0,argc,argv,
               genNAME("Netlist Optimizer - V %s", VERSION));

	/* chargement du systeme : netlist + cellules */
   no_sys->log = initializeNet();

   if (argc == 3 && !strcmp(argv[2],"relax"))
      PRINCIPAL(0);
   else
      PRINCIPAL(1);
   }
cellEnd();
exit(0);
}
