/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  optimiseur de netlist                                      */
/*    Fichier :  enveloppe.c                                                */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  N. Dictus                            le : 22/09/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdlib.h>
#include MUT_H
#include LOG_H
#include "../load/types_map.h"
#include "enveloppe.h"

/*-----------------------------------------------------------------------------
inListe  : renvoie si data fait partie de la chain_list (si oui = 1)
-------------------------------------------------------------------------------
retour   : un short
-----------------------------------------------------------------------------*/
short inListe(liste, data)
chain_list *liste;
char       *data;
{
chain_list *auxiliaire = liste;

while (auxiliaire)
   {
   if ((char *)auxiliaire->DATA == data)
      return 1;
   auxiliaire = auxiliaire->NEXT;
   };
return 0;
}

/*-----------------------------------------------------------------------------
inListeAtom : renvoie si data fait partie de la chain_list d'atomes (si oui = 1)
-------------------------------------------------------------------------------
retour      : un short
-----------------------------------------------------------------------------*/
short inListeAtom(liste, data)
chain_list *liste;
char       *data;
{
chain_list *auxiliaire = liste;

while (auxiliaire)
   {
   if (inListe((chain_list *)auxiliaire->DATA, data))
      return 1;
   auxiliaire = auxiliaire->NEXT;
   };
return 0;
}

/*-----------------------------------------------------------------------------
completeListe : ajoutte a l'enveloppe les entrees n'apparaissant pas encore
-------------------------------------------------------------------------------
retour        : chain_list de chain_list
-----------------------------------------------------------------------------*/
chain_list *completeListe(liste, entrees)
chain_list *liste;
Alist      *entrees;
{
Alist      *in;

for(in = entrees; in; in = in->NEXT)
   {
   if (!inListeAtom(liste, in->name))
         liste = addchain(liste, addchain((chain_list *)NULL, (void *)in->name));
   }
return liste;
}

/*---------------------------------------------------------------------------
longueur : renvoie la longueur d'une chain_list = nbre d'elements
-----------------------------------------------------------------------------
retour   : short
---------------------------------------------------------------------------*/
short longueur(liste)
chain_list *liste;
{
short length = 0;

while(liste)
   {
   length++;
   liste = liste->NEXT;
   }
return length;
}

/*---------------------------------------------------------------------------
egalListe : renvoie si tous les elts de liste1 sont dans liste2
-----------------------------------------------------------------------------
retour    : si oui = 1
---------------------------------------------------------------------------*/
short egalListe(liste1, liste2)
chain_list *liste1, *liste2;
{
chain_list *aux;

for(aux = liste1; aux; aux = aux->NEXT)
   if (!inListe(liste2, (char *)aux->DATA))
      return 0;
return 1;
}

/*---------------------------------------------------------------------------
intersection : renvoie si l'intersection de 2 chain_list est vide
-----------------------------------------------------------------------------
retour       : si vide = 0
---------------------------------------------------------------------------*/
short intersection(liste1, liste2)
chain_list *liste1, *liste2;
{
chain_list *aux;

for(aux = liste1; aux; aux = aux->NEXT)
   if (inListe(liste2, (char *)aux->DATA))
      return 1;
return 0;
}

/*---------------------------------------------------------------------------
testElimineListe : retourne si la liste doit etre elimine de l'enveloppe
-----------------------------------------------------------------------------
retour           : 1 = elimine ou 0
---------------------------------------------------------------------------*/
short testElimineListe(liste1, liste2)
chain_list *liste1, *liste2;
{
short elimine = 0;

if (intersection(liste1, liste2) != 0)  /* intersection non vide */
   if (longueur(liste1) > longueur(liste2))
      {
      if (egalListe(liste1, liste2))
         elimine = 1;
      }
   else
      {
      if (egalListe(liste2, liste1))
         elimine = 1;
      }
return elimine;
}

/*---------------------------------------------------------------------------
elimineListe : elimine un element d'une chain_list
-----------------------------------------------------------------------------
retour       : une chain_list de chain_list ...
---------------------------------------------------------------------------*/
chain_list *elimineListe(elt, liste)
chain_list *elt, *liste;
{
if (elt == liste)
   return liste->NEXT;
else
   {
   chain_list *p1 = liste;
   chain_list *p2 = liste->NEXT;

   while (p2 && (p2 != elt))
      {
      p2 = p2->NEXT;
      p1 = p1->NEXT;
      }
   p1->NEXT = p2->NEXT;
   p2->NEXT = (chain_list *)NULL;
   freechain(p2);
   return liste;
   }
}

/*---------------------------------------------------------------------------
filtreListeAtom : elimine les listes redondantes
                  dans le calcul de l'enveloppe d'une porte
-----------------------------------------------------------------------------
retour          : une chain_list de chain_list ...
                  chaque ss-chain_list est une liste
                  de connecteurs interchangeables
---------------------------------------------------------------------------*/
chain_list *filtreListeAtom(liste)
chain_list *liste;
{
chain_list *aux = liste, *queue;

while(aux)
   {
   short elimine = 0;
   chain_list *next = aux->NEXT;

   for(queue = aux->NEXT; queue; queue = queue->NEXT)
      if (testElimineListe((chain_list *)aux->DATA, (chain_list *)queue->DATA))
         elimine = 1;
   if (elimine)
      liste = elimineListe(aux, liste);
   aux = next;
   }
return liste;
}

/*---------------------------------------------------------------------------
listeAtom : construit une liste de sous-listes d'atomes interchangeables
            d'apres l'ABL de la fonction logique de la porte
-----------------------------------------------------------------------------
retour    : une chain_list de chain_list ...
---------------------------------------------------------------------------*/
chain_list *listeAtom(expr)
chain_list *expr;
{
chain_list *retour = (chain_list *)NULL;
chain_list *inter1 = (chain_list *)NULL;
chain_list *inter2 = (chain_list *)NULL;

if (!ATOM(expr))
   {
   while(expr = CDR(expr))
      if (ATOM(CAR(expr)))
            /* liste de atomes se trouvant au meme niveau de l'expression */
         inter1 = addchain(inter1, (void *)VALUE_ATOM(CAR(expr)));
      else
         {
            /* appel recursif sur les ss-expressions */
         inter2 = listeAtom(CAR(expr));
         while(inter2)
            {
               /* mise a plat de l'appel recursif */
            retour = addchain(retour, (void *)inter2->DATA);
            inter2 = inter2->NEXT;
            }
         }   
   if (inter1 && inter1->NEXT)
      retour = addchain(retour, (void *)inter1);
   }
return retour;
}
