#include <stdio.h>
#include <stdlib.h>
#include "mut304.h"
#include "mlo303.h"
#include "no_struct.h"

struct typoin				/* structure used by dast_dbg	*/
  {					/* to store its state		*/
  short  type;				/* code of the current structure*/
  short  mark;				/* stop mark			*/
  void  *data;				/* pointer of the structure	*/
  };

#define VHD_ERRDFN  -1
#define VHD__XTDFN  0
#define VHD__UPDFN  1
#define VHD__TPDFN  2
#define VHD__SPDFN  3
#define VHD__BKDFN  4

#define VHD_t_areteDFN 5
#define VHD_capaDFN 6
#define VHD_RDFN 7
#define VHD_tpxxDFN 8
#define VHD_sourceDFN 9
#define VHD_destDFN 10
#define VHD_loconDFN 11
#define VHD_t_noeudDFN 12
#define VHD_niveauDFN 13
#define VHD_recursionDFN 14
#define VHD_totcapaDFN 15
#define VHD_tempsDFN 16
#define VHD_slackDFN 17
#define VHD_losigDFN 18
#define VHD_loinsDFN 19
#define VHD_nextDFN 20
#define VHD_predDFN 21
#define VHD_t_tabentreesDFN 22
#define VHD_noeud1DFN 23
#define VHD_noeud0DFN 24
#define VHD_sortiesDFN 25
#define VHD_t_tabsortiesDFN 26
#define VHD_temps_resDFN 27
#define VHD_temps_vouluDFN 28
#define VHD_entreesDFN 29
#define VHD_lofigDFN 30
#define VHD_NEXTDFN 31
#define VHD_MODELCHAINDFN 32
#define VHD_LOCONDFN 33
#define VHD_LOSIGDFN 34
#define VHD_BKSIGDFN 35
#define VHD_LOINSDFN 36
#define VHD_LOTRSDFN 37
#define VHD_NAMEDFN 38
#define VHD_MODEDFN 39
#define VHD_USERDFN 40
#define VHD_lotrsDFN 41
#define VHD_DRAINDFN 42
#define VHD_GRIDDFN 43
#define VHD_SOURCEDFN 44
#define VHD_WIDTHDFN 45
#define VHD_LENGTHDFN 46
#define VHD_XDFN 47
#define VHD_YDFN 48
#define VHD_TYPEDFN 49
#define VHD_INSNAMEDFN 50
#define VHD_FIGNAMEDFN 51
#define VHD_SIGDFN 52
#define VHD_ROOTDFN 53
#define VHD_DIRECTIONDFN 54
#define VHD_NAMECHAINDFN 55
#define VHD_CAPADFN 56
#define VHD_INDEXDFN 57
#define VHD_pointDFN 58
#define VHD_chainDFN 59
#define VHD_DATADFN 60
#define VHD_ptypeDFN 61
#define VHD_numDFN 62
#define VHD_MAXDFN 63

void dast_dbg_graphe (head_pnt,stru_name)

void  *head_pnt;
char  *stru_name;

  {

  int		 i;
  int		 state;
  int		 newsta0;
  int		 newsta1;
  int            offset = 0;
  int		 readcmd = 0;
  char		 readtab[3][20];
  int		 stk_pnt = 0;
  int            type = VHD__XTDFN;

  struct typoin  current_pnt;
  struct typoin  stk[200];

  char           empty[4];
  char           avail[12];
  char           array[20];

  int		 key[VHD_MAXDFN];
  char		*tab[VHD_MAXDFN];
  void		*nxt[VHD_MAXDFN];
  short		 typ[VHD_MAXDFN];
  short		 siz[VHD_MAXDFN];

  struct t_arete *t_arete_pnt;
  struct t_noeud *t_noeud_pnt;
  struct locon *locon_pnt;
  struct losig *losig_pnt;
  struct loins *loins_pnt;
  struct chain *chain_pnt;
  struct t_tabentrees *t_tabentrees_pnt;
  struct t_tabsorties *t_tabsorties_pnt;
  struct ptype *ptype_pnt;
  struct lofig *lofig_pnt;
  struct lotrs *lotrs_pnt;
  struct point *point_pnt;
  struct num *num_pnt;

  siz[VHD_t_areteDFN] = sizeof (struct t_arete);
  siz[VHD_t_noeudDFN] = sizeof (struct t_noeud);
  siz[VHD_loconDFN] = sizeof (struct locon);
  siz[VHD_losigDFN] = sizeof (struct losig);
  siz[VHD_loinsDFN] = sizeof (struct loins);
  siz[VHD_chainDFN] = sizeof (struct chain);
  siz[VHD_t_tabentreesDFN] = sizeof (struct t_tabentrees);
  siz[VHD_t_tabsortiesDFN] = sizeof (struct t_tabsorties);
  siz[VHD_ptypeDFN] = sizeof (struct ptype);
  siz[VHD_lofigDFN] = sizeof (struct lofig);
  siz[VHD_lotrsDFN] = sizeof (struct lotrs);
  siz[VHD_pointDFN] = sizeof (struct point);
  siz[VHD_numDFN] = sizeof (struct num);

  key[VHD_t_areteDFN] = vhd_hash("t_arete");
  key[VHD_capaDFN] = vhd_hash("capa");
  key[VHD_RDFN] = vhd_hash("R");
  key[VHD_tpxxDFN] = vhd_hash("tpxx");
  key[VHD_sourceDFN] = vhd_hash("source");
  key[VHD_destDFN] = vhd_hash("dest");
  key[VHD_loconDFN] = vhd_hash("locon");
  key[VHD_t_noeudDFN] = vhd_hash("t_noeud");
  key[VHD_niveauDFN] = vhd_hash("niveau");
  key[VHD_recursionDFN] = vhd_hash("recursion");
  key[VHD_totcapaDFN] = vhd_hash("totcapa");
  key[VHD_tempsDFN] = vhd_hash("temps");
  key[VHD_slackDFN] = vhd_hash("slack");
  key[VHD_losigDFN] = vhd_hash("losig");
  key[VHD_nextDFN] = vhd_hash("next");
  key[VHD_predDFN] = vhd_hash("pred");
  key[VHD_t_tabentreesDFN] = vhd_hash("t_tabentrees");
  key[VHD_noeud1DFN] = vhd_hash("noeud1");
  key[VHD_noeud0DFN] = vhd_hash("noeud0");
  key[VHD_sortiesDFN] = vhd_hash("sorties");
  key[VHD_t_tabsortiesDFN] = vhd_hash("t_tabsorties");
  key[VHD_temps_resDFN] = vhd_hash("temps_res");
  key[VHD_temps_vouluDFN] = vhd_hash("temps_voulu");
  key[VHD_entreesDFN] = vhd_hash("entrees");
  key[VHD_lofigDFN] = vhd_hash("lofig");
  key[VHD_NEXTDFN] = vhd_hash("NEXT");
  key[VHD_MODELCHAINDFN] = vhd_hash("MODELCHAIN");
  key[VHD_LOCONDFN] = vhd_hash("LOCON");
  key[VHD_LOSIGDFN] = vhd_hash("LOSIG");
  key[VHD_BKSIGDFN] = vhd_hash("BKSIG");
  key[VHD_LOINSDFN] = vhd_hash("LOINS");
  key[VHD_LOTRSDFN] = vhd_hash("LOTRS");
  key[VHD_NAMEDFN] = vhd_hash("NAME");
  key[VHD_MODEDFN] = vhd_hash("MODE");
  key[VHD_USERDFN] = vhd_hash("USER");
  key[VHD_lotrsDFN] = vhd_hash("lotrs");
  key[VHD_DRAINDFN] = vhd_hash("DRAIN");
  key[VHD_GRIDDFN] = vhd_hash("GRID");
  key[VHD_SOURCEDFN] = vhd_hash("SOURCE");
  key[VHD_WIDTHDFN] = vhd_hash("WIDTH");
  key[VHD_LENGTHDFN] = vhd_hash("LENGTH");
  key[VHD_XDFN] = vhd_hash("X");
  key[VHD_YDFN] = vhd_hash("Y");
  key[VHD_TYPEDFN] = vhd_hash("TYPE");
  key[VHD_loinsDFN] = vhd_hash("loins");
  key[VHD_INSNAMEDFN] = vhd_hash("INSNAME");
  key[VHD_FIGNAMEDFN] = vhd_hash("FIGNAME");
  key[VHD_SIGDFN] = vhd_hash("SIG");
  key[VHD_ROOTDFN] = vhd_hash("ROOT");
  key[VHD_DIRECTIONDFN] = vhd_hash("DIRECTION");
  key[VHD_NAMECHAINDFN] = vhd_hash("NAMECHAIN");
  key[VHD_CAPADFN] = vhd_hash("CAPA");
  key[VHD_INDEXDFN] = vhd_hash("INDEX");
  key[VHD_pointDFN] = vhd_hash("point");
  key[VHD_chainDFN] = vhd_hash("chain");
  key[VHD_DATADFN] = vhd_hash("DATA");
  key[VHD_ptypeDFN] = vhd_hash("ptype");
  key[VHD_numDFN] = vhd_hash("num");
  key[VHD_t_areteDFN] = vhd_hash("t_arete");
  key[VHD_t_noeudDFN] = vhd_hash("t_noeud");
  key[VHD_t_tabentreesDFN] = vhd_hash("t_tabentrees");
  key[VHD_t_tabsortiesDFN] = vhd_hash("t_tabsorties");
  key[VHD_lofigDFN] = vhd_hash("lofig");
  key[VHD_lotrsDFN] = vhd_hash("lotrs");
  key[VHD_loinsDFN] = vhd_hash("loins");
  key[VHD_loconDFN] = vhd_hash("locon");
  key[VHD_losigDFN] = vhd_hash("losig");
  key[VHD_pointDFN] = vhd_hash("point");
  key[VHD_chainDFN] = vhd_hash("chain");
  key[VHD_ptypeDFN] = vhd_hash("ptype");
  key[VHD_numDFN] = vhd_hash("num");

	/* ###------------------------------------------------------### */
	/*    Set of predefined commands				*/
	/* ###------------------------------------------------------### */

  key[VHD__XTDFN] = vhd_hash ("_exit");
  key[VHD__UPDFN] = vhd_hash ("_up");
  key[VHD__TPDFN] = vhd_hash ("_top");
  key[VHD__SPDFN] = vhd_hash ("_stop");
  key[VHD__BKDFN] = vhd_hash ("_back");

  strcpy (empty,"");
  strcpy (avail,"AVAILABLE");
  strcpy (array,"AVAIL. (ARRAY)");

  for (i=0 ; i<VHD_MAXDFN ; i++)
    typ[i] = i;

	/* ###------------------------------------------------------### */
	/*    Find the type of the head structure			*/
	/* ###------------------------------------------------------### */

  readcmd = vhd_hash (stru_name);
  for (i=0 ; i<VHD_MAXDFN ; i++)
    {
    if (readcmd == key[i])
      {
      type = typ[i];
      break;
      }
    }

	/* ###------------------------------------------------------### */
	/*    Exit if the head structure is empty			*/
	/* ###------------------------------------------------------### */

  if (head_pnt == NULL)
    type = VHD__XTDFN;

  current_pnt.data = head_pnt;
  current_pnt.type = type;
  state        = type;

  while (state != VHD__XTDFN)
    {
	/* ###------------------------------------------------------### */
	/*    Print structure's field until the exit command is read	*/
	/* ###------------------------------------------------------### */

    for (i=0 ; i<VHD_MAXDFN ; i++)
      {
      tab[i] = empty;
      nxt[i] = NULL;
      }

	/* ###------------------------------------------------------### */
	/*    _exit and _stop commands are allways available		*/
	/* ###------------------------------------------------------### */

    tab[VHD__XTDFN] = avail;
    tab[VHD__SPDFN] = avail;

	/* ###------------------------------------------------------### */
	/*    _up, _top, and _back commands are available only if the	*/
	/* stack is not empty						*/
	/* ###------------------------------------------------------### */

    if (stk_pnt != 0)
      {
      tab[VHD__UPDFN] = avail;
      tab[VHD__TPDFN] = avail;
      tab[VHD__BKDFN] = avail;
      }

    switch (state)
      {

    case (VHD_t_areteDFN):

		/* ###--------- t_arete ---------### */

      t_arete_pnt = (struct t_arete *)(current_pnt.data);

      printf ("   capa : %f\n",t_arete_pnt->capa);
      printf ("   R : %d\n",t_arete_pnt->R);
      printf ("   tpxx : %d\n",t_arete_pnt->tpxx);
      if (t_arete_pnt->source != NULL)
        {
        tab[VHD_sourceDFN] = avail;
        nxt[VHD_sourceDFN] = (void *)t_arete_pnt->source;
        typ[VHD_sourceDFN] = VHD_t_noeudDFN;
        }
      printf ("-> source : %s\n",tab[VHD_sourceDFN]);
      if (t_arete_pnt->dest != NULL)
        {
        tab[VHD_destDFN] = avail;
        nxt[VHD_destDFN] = (void *)t_arete_pnt->dest;
        typ[VHD_destDFN] = VHD_t_noeudDFN;
        }
      printf ("-> dest : %s\n",tab[VHD_destDFN]);
      if (t_arete_pnt->locon != NULL)
        {
        tab[VHD_loconDFN] = avail;
        nxt[VHD_loconDFN] = (void *)t_arete_pnt->locon;
        typ[VHD_loconDFN] = VHD_loconDFN;
        }
      printf ("-> locon : %s\n",tab[VHD_loconDFN]);

      break;

    case (VHD_t_noeudDFN):

		/* ###--------- t_noeud ---------### */

      t_noeud_pnt = (struct t_noeud *)(current_pnt.data);

      printf ("   niveau : %c\n",t_noeud_pnt->niveau);
      printf ("   recursion : %d\n",t_noeud_pnt->recursion);
      printf ("   totcapa : %f\n",t_noeud_pnt->totcapa);
      printf ("   temps : %d\n",t_noeud_pnt->temps);
      printf ("   slack : %d\n",t_noeud_pnt->slack);
      if (t_noeud_pnt->losig != NULL)
        {
        tab[VHD_losigDFN] = avail;
        nxt[VHD_losigDFN] = (void *)t_noeud_pnt->losig;
        typ[VHD_losigDFN] = VHD_losigDFN;
        }
      printf ("-> losig : %s\n",tab[VHD_losigDFN]);
      if (t_noeud_pnt->loins != NULL)
        {
        tab[VHD_loinsDFN] = avail;
        nxt[VHD_loinsDFN] = (void *)t_noeud_pnt->loins;
        typ[VHD_loinsDFN] = VHD_loinsDFN;
        }
      printf ("-> loins : %s\n",tab[VHD_loinsDFN]);
      if (t_noeud_pnt->locon != NULL)
        {
        tab[VHD_loconDFN] = avail;
        nxt[VHD_loconDFN] = (void *)t_noeud_pnt->locon;
        typ[VHD_loconDFN] = VHD_loconDFN;
        }
      printf ("-> locon : %s\n",tab[VHD_loconDFN]);
      if (t_noeud_pnt->next != NULL)
        {
        tab[VHD_nextDFN] = avail;
        nxt[VHD_nextDFN] = (void *)t_noeud_pnt->next;
        typ[VHD_nextDFN] = VHD_chainDFN;
        }
      printf ("-> next : %s\n",tab[VHD_nextDFN]);
      if (t_noeud_pnt->pred != NULL)
        {
        tab[VHD_predDFN] = avail;
        nxt[VHD_predDFN] = (void *)t_noeud_pnt->pred;
        typ[VHD_predDFN] = VHD_chainDFN;
        }
      printf ("-> pred : %s\n",tab[VHD_predDFN]);

      break;

    case (VHD_t_tabentreesDFN):

		/* ###--------- t_tabentrees ---------### */

      t_tabentrees_pnt = (struct t_tabentrees *)(current_pnt.data);

      if (t_tabentrees_pnt->locon != NULL)
        {
        tab[VHD_loconDFN] = avail;
        nxt[VHD_loconDFN] = (void *)t_tabentrees_pnt->locon;
        typ[VHD_loconDFN] = VHD_loconDFN;
        }
      printf ("-> locon : %s\n",tab[VHD_loconDFN]);
      if (t_tabentrees_pnt->noeud1 != NULL)
        {
        tab[VHD_noeud1DFN] = avail;
        nxt[VHD_noeud1DFN] = (void *)t_tabentrees_pnt->noeud1;
        typ[VHD_noeud1DFN] = VHD_chainDFN;
        }
      printf ("-> noeud1 : %s\n",tab[VHD_noeud1DFN]);
      if (t_tabentrees_pnt->noeud0 != NULL)
        {
        tab[VHD_noeud0DFN] = avail;
        nxt[VHD_noeud0DFN] = (void *)t_tabentrees_pnt->noeud0;
        typ[VHD_noeud0DFN] = VHD_chainDFN;
        }
      printf ("-> noeud0 : %s\n",tab[VHD_noeud0DFN]);
      if (t_tabentrees_pnt->sorties != NULL)
        {
        tab[VHD_sortiesDFN] = avail;
        nxt[VHD_sortiesDFN] = (void *)t_tabentrees_pnt->sorties;
        typ[VHD_sortiesDFN] = VHD_chainDFN;
        }
      printf ("-> sorties : %s\n",tab[VHD_sortiesDFN]);

      break;

    case (VHD_t_tabsortiesDFN):

		/* ###--------- t_tabsorties ---------### */

      t_tabsorties_pnt = (struct t_tabsorties *)(current_pnt.data);

      if (t_tabsorties_pnt->locon != NULL)
        {
        tab[VHD_loconDFN] = avail;
        nxt[VHD_loconDFN] = (void *)t_tabsorties_pnt->locon;
        typ[VHD_loconDFN] = VHD_loconDFN;
        }
      printf ("-> locon : %s\n",tab[VHD_loconDFN]);
      printf ("   temps_res : %d\n",t_tabsorties_pnt->temps_res);
      printf ("   temps_voulu : %d\n",t_tabsorties_pnt->temps_voulu);
      if (t_tabsorties_pnt->noeud1 != NULL)
        {
        tab[VHD_noeud1DFN] = avail;
        nxt[VHD_noeud1DFN] = (void *)t_tabsorties_pnt->noeud1;
        typ[VHD_noeud1DFN] = VHD_t_areteDFN;
        }
      printf ("-> noeud1 : %s\n",tab[VHD_noeud1DFN]);
      if (t_tabsorties_pnt->noeud0 != NULL)
        {
        tab[VHD_noeud0DFN] = avail;
        nxt[VHD_noeud0DFN] = (void *)t_tabsorties_pnt->noeud0;
        typ[VHD_noeud0DFN] = VHD_t_areteDFN;
        }
      printf ("-> noeud0 : %s\n",tab[VHD_noeud0DFN]);
      if (t_tabsorties_pnt->entrees != NULL)
        {
        tab[VHD_entreesDFN] = avail;
        nxt[VHD_entreesDFN] = (void *)t_tabsorties_pnt->entrees;
        typ[VHD_entreesDFN] = VHD_ptypeDFN;
        }
      printf ("-> entrees : %s\n",tab[VHD_entreesDFN]);

      break;

    case (VHD_lofigDFN):

		/* ###--------- lofig ---------### */

      lofig_pnt = (struct lofig *)(current_pnt.data);

      if (lofig_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)lofig_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_lofigDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (lofig_pnt->MODELCHAIN != NULL)
        {
        tab[VHD_MODELCHAINDFN] = avail;
        nxt[VHD_MODELCHAINDFN] = (void *)lofig_pnt->MODELCHAIN;
        typ[VHD_MODELCHAINDFN] = VHD_chainDFN;
        }
      printf ("-> MODELCHAIN : %s\n",tab[VHD_MODELCHAINDFN]);
      if (lofig_pnt->LOCON != NULL)
        {
        tab[VHD_LOCONDFN] = avail;
        nxt[VHD_LOCONDFN] = (void *)lofig_pnt->LOCON;
        typ[VHD_LOCONDFN] = VHD_loconDFN;
        }
      printf ("-> LOCON : %s\n",tab[VHD_LOCONDFN]);
      if (lofig_pnt->LOSIG != NULL)
        {
        tab[VHD_LOSIGDFN] = avail;
        nxt[VHD_LOSIGDFN] = (void *)lofig_pnt->LOSIG;
        typ[VHD_LOSIGDFN] = VHD_losigDFN;
        }
      printf ("-> LOSIG : %s\n",tab[VHD_LOSIGDFN]);
      if (lofig_pnt->BKSIG != NULL)
        {
        tab[VHD_BKSIGDFN] = avail;
        nxt[VHD_BKSIGDFN] = (void *)lofig_pnt->BKSIG;
        typ[VHD_BKSIGDFN] = VHD_ptypeDFN;
        }
      printf ("-> BKSIG : %s\n",tab[VHD_BKSIGDFN]);
      if (lofig_pnt->LOINS != NULL)
        {
        tab[VHD_LOINSDFN] = avail;
        nxt[VHD_LOINSDFN] = (void *)lofig_pnt->LOINS;
        typ[VHD_LOINSDFN] = VHD_loinsDFN;
        }
      printf ("-> LOINS : %s\n",tab[VHD_LOINSDFN]);
      if (lofig_pnt->LOTRS != NULL)
        {
        tab[VHD_LOTRSDFN] = avail;
        nxt[VHD_LOTRSDFN] = (void *)lofig_pnt->LOTRS;
        typ[VHD_LOTRSDFN] = VHD_lotrsDFN;
        }
      printf ("-> LOTRS : %s\n",tab[VHD_LOTRSDFN]);
      printf ("   NAME : %s\n",lofig_pnt->NAME);
      printf ("   MODE : %c\n",lofig_pnt->MODE);
      if (lofig_pnt->USER != NULL)
        {
        tab[VHD_USERDFN] = avail;
        nxt[VHD_USERDFN] = (void *)lofig_pnt->USER;
        typ[VHD_USERDFN] = VHD_ptypeDFN;
        }
      printf ("-> USER : %s\n",tab[VHD_USERDFN]);

      break;

    case (VHD_lotrsDFN):

		/* ###--------- lotrs ---------### */

      lotrs_pnt = (struct lotrs *)(current_pnt.data);

      if (lotrs_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)lotrs_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_lotrsDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (lotrs_pnt->DRAIN != NULL)
        {
        tab[VHD_DRAINDFN] = avail;
        nxt[VHD_DRAINDFN] = (void *)lotrs_pnt->DRAIN;
        typ[VHD_DRAINDFN] = VHD_loconDFN;
        }
      printf ("-> DRAIN : %s\n",tab[VHD_DRAINDFN]);
      if (lotrs_pnt->GRID != NULL)
        {
        tab[VHD_GRIDDFN] = avail;
        nxt[VHD_GRIDDFN] = (void *)lotrs_pnt->GRID;
        typ[VHD_GRIDDFN] = VHD_loconDFN;
        }
      printf ("-> GRID : %s\n",tab[VHD_GRIDDFN]);
      if (lotrs_pnt->SOURCE != NULL)
        {
        tab[VHD_SOURCEDFN] = avail;
        nxt[VHD_SOURCEDFN] = (void *)lotrs_pnt->SOURCE;
        typ[VHD_SOURCEDFN] = VHD_loconDFN;
        }
      printf ("-> SOURCE : %s\n",tab[VHD_SOURCEDFN]);
      printf ("   LENGTH : %ld\n",lotrs_pnt->LENGTH);
      printf ("   WIDTH : %ld\n",lotrs_pnt->WIDTH);
      printf ("   Y : %ld\n",lotrs_pnt->Y);
      printf ("   X : %ld\n",lotrs_pnt->X);
      printf ("   TYPE : %c\n",lotrs_pnt->TYPE);
      if (lotrs_pnt->USER != NULL)
        {
        tab[VHD_USERDFN] = avail;
        nxt[VHD_USERDFN] = (void *)lotrs_pnt->USER;
        typ[VHD_USERDFN] = VHD_ptypeDFN;
        }
      printf ("-> USER : %s\n",tab[VHD_USERDFN]);

      break;

    case (VHD_loinsDFN):

		/* ###--------- loins ---------### */

      loins_pnt = (struct loins *)(current_pnt.data);

      if (loins_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)loins_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_loinsDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (loins_pnt->LOCON != NULL)
        {
        tab[VHD_LOCONDFN] = avail;
        nxt[VHD_LOCONDFN] = (void *)loins_pnt->LOCON;
        typ[VHD_LOCONDFN] = VHD_loconDFN;
        }
      printf ("-> LOCON : %s\n",tab[VHD_LOCONDFN]);
      printf ("   INSNAME : %s\n",loins_pnt->INSNAME);
      printf ("   FIGNAME : %s\n",loins_pnt->FIGNAME);
      if (loins_pnt->USER != NULL)
        {
        tab[VHD_USERDFN] = avail;
        nxt[VHD_USERDFN] = (void *)loins_pnt->USER;
        typ[VHD_USERDFN] = VHD_ptypeDFN;
        }
      printf ("-> USER : %s\n",tab[VHD_USERDFN]);

      break;

    case (VHD_loconDFN):

		/* ###--------- locon ---------### */

      locon_pnt = (struct locon *)(current_pnt.data);

      if (locon_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)locon_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_loconDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      printf ("   NAME : %s\n",locon_pnt->NAME);
      if (locon_pnt->SIG != NULL)
        {
        tab[VHD_SIGDFN] = avail;
        nxt[VHD_SIGDFN] = (void *)locon_pnt->SIG;
        typ[VHD_SIGDFN] = VHD_losigDFN;
        }
      printf ("-> SIG : %s\n",tab[VHD_SIGDFN]);
      if (locon_pnt->ROOT != NULL)
        {
        tab[VHD_ROOTDFN] = avail;
        nxt[VHD_ROOTDFN] = (void *)locon_pnt->ROOT;
        if (locon_pnt->TYPE == INTERNAL)
          typ[VHD_ROOTDFN] = VHD_loinsDFN;
        else
          typ[VHD_ROOTDFN] = VHD_lofigDFN;
        }
      printf ("-> ROOT : %s\n",tab[VHD_ROOTDFN]);
      printf ("   DIRECTION : %c\n",locon_pnt->DIRECTION);
      printf ("   TYPE : %c\n",locon_pnt->TYPE);
      if (locon_pnt->USER != NULL)
        {
        tab[VHD_USERDFN] = avail;
        nxt[VHD_USERDFN] = (void *)locon_pnt->USER;
        typ[VHD_USERDFN] = VHD_ptypeDFN;
        }
      printf ("-> USER : %s\n",tab[VHD_USERDFN]);

      break;

    case (VHD_losigDFN):

		/* ###--------- losig ---------### */

      losig_pnt = (struct losig *)(current_pnt.data);

      if (losig_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)losig_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_losigDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (losig_pnt->NAMECHAIN != NULL)
        {
        tab[VHD_NAMECHAINDFN] = avail;
        nxt[VHD_NAMECHAINDFN] = (void *)losig_pnt->NAMECHAIN;
        typ[VHD_NAMECHAINDFN] = VHD_chainDFN;
        }
      printf ("-> NAMECHAIN : %s\n",tab[VHD_NAMECHAINDFN]);
      printf ("   CAPA : %f\n",losig_pnt->CAPA);
      printf ("   INDEX : %ld\n",losig_pnt->INDEX);
      printf ("   TYPE : %c\n",losig_pnt->TYPE);
      if (losig_pnt->USER != NULL)
        {
        tab[VHD_USERDFN] = avail;
        nxt[VHD_USERDFN] = (void *)losig_pnt->USER;
        typ[VHD_USERDFN] = VHD_ptypeDFN;
        }
      printf ("-> USER : %s\n",tab[VHD_USERDFN]);

      break;

    case (VHD_pointDFN):

		/* ###--------- point ---------### */

      point_pnt = (struct point *)(current_pnt.data);

      if (point_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)point_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_pointDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      printf ("   INDEX : %ld\n",point_pnt->INDEX);
      printf ("   Y : %ld\n",point_pnt->Y);
      printf ("   X : %ld\n",point_pnt->X);

      break;

    case (VHD_chainDFN):

		/* ###--------- chain ---------### */

      chain_pnt = (struct chain *)(current_pnt.data);

      if (chain_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)chain_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_chainDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (chain_pnt->DATA != NULL)
        {
        tab[VHD_DATADFN] = avail;
        nxt[VHD_DATADFN] = (void *)chain_pnt->DATA;
        typ[VHD_DATADFN] = VHD_t_areteDFN;
        }
      printf ("-> DATA : %s\n",tab[VHD_DATADFN]);

      break;

    case (VHD_ptypeDFN):

		/* ###--------- ptype ---------### */

      ptype_pnt = (struct ptype *)(current_pnt.data);

      if (ptype_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)ptype_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_ptypeDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      if (ptype_pnt->DATA != NULL)
        {
        tab[VHD_DATADFN] = avail;
        nxt[VHD_DATADFN] = (void *)ptype_pnt->DATA;
        typ[VHD_DATADFN] = VHD_t_tabentreesDFN;
        }
      printf ("-> DATA : %s\n",tab[VHD_DATADFN]);
      printf ("   TYPE : %ld\n",ptype_pnt->TYPE);

      break;

    case (VHD_numDFN):

		/* ###--------- num ---------### */

      num_pnt = (struct num *)(current_pnt.data);

      if (num_pnt->NEXT != NULL)
        {
        tab[VHD_NEXTDFN] = avail;
        nxt[VHD_NEXTDFN] = (void *)num_pnt->NEXT;
        typ[VHD_NEXTDFN] = VHD_numDFN;
        }
      printf ("-> NEXT : %s\n",tab[VHD_NEXTDFN]);
      printf ("   DATA : %ld\n",num_pnt->DATA);

      break;


      }

	/* ###------------------------------------------------------### */
	/*    Reading new command					*/
	/* ###------------------------------------------------------### */

    readcmd = vhd_getcmd (readtab);

    for (i=0 ; i<VHD_MAXDFN ; i++)
      {
      if (readcmd == key[i])
        break;
      }
    if ((i != VHD_MAXDFN+1) && ((tab[i] == avail) || (tab[i] == array)))
      newsta0 = i;
    else
      newsta0 = -1;

	/* ###------------------------------------------------------### */
	/*    Analysing new command					*/
	/* ###------------------------------------------------------### */

    switch (newsta0)
      {
      case (VHD__UPDFN):
        current_pnt = stk[--stk_pnt] ;
        break;

      case (VHD__BKDFN):
        while ((--stk_pnt != 0) && (stk[stk_pnt].mark != 1));
        current_pnt = stk[stk_pnt] ;
        break;

      case (VHD__SPDFN):
        current_pnt.mark = 1;
        break;

      case (VHD__TPDFN):
        current_pnt = stk[0] ;
        stk_pnt     = 0 ;
        break;

      case (VHD__XTDFN):
        current_pnt.data = NULL;
        current_pnt.type = VHD__XTDFN;
        current_pnt.mark = 0;
        break;

      case (VHD_ERRDFN):
        break;

      default:
        stk[stk_pnt++]   = current_pnt;
        current_pnt.type = typ[newsta0];
        current_pnt.mark = 0;

        offset           = 0;
        sscanf (readtab[1],"%d",&offset);
        if (tab[i] == avail)
          {
          current_pnt.data = (void *)
                             ((int)nxt[newsta0] + (offset * siz[newsta0]));
          }
        else
          {
          current_pnt.data = (void *) *(((char *)(nxt[newsta0])) + (offset * siz[newsta0]));
          }
        break;

      }

    state  = current_pnt.type;
    }
  }


int vhd_getcmd (prvcmd)

char prvcmd[3][20];

  {
  char readstr[60];
  char comd0[20];
  char comd1[20];
  char comd2[20];
  int  code;

  printf ("\n\n\n COMMAND >> ");
  comd0[0] = '\0';
  comd1[0] = '\0';
  comd2[0] = '\0';
  gets   (readstr);
  sscanf (readstr,"%s%s%s",comd0,comd1,comd2);

  if (strcmp(comd0,"."))
    {
    strcpy (prvcmd[0], comd0);
    strcpy (prvcmd[1], comd1);
    strcpy (prvcmd[2], comd2);
    }
  code = vhd_hash (prvcmd[0]);

  printf ("\n\n\n\n\n");
  return (code);
  }



int vhd_hash (str)

char *str;

  {
  char c;
  int code = 0;

  while(*str != '\0')
    code =  code<<1 ^ *str++;

  return (code);
  }

