/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: /usr/fsys/odin/a/vern/flex/RCS/flex.skel,v 2.16 90/08/03 14:09:36 vern Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define MVL_Y__USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define MVL_Y__USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif	/* __GNUC__ */

#define MVL_Y__USE_PROTOS
#define MVL_Y__USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define MVL_Y__USE_CONST
#endif


#ifndef MVL_Y__USE_CONST
#define const
#endif


#ifdef MVL_Y__USE_PROTOS
#define MVL_Y__PROTO(proto) proto
#else
#define MVL_Y__PROTO(proto) ()
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
char *malloc();
int free();
int read();
#endif


/* amount of stuff to slurp up with each read */
#ifndef MVL_Y__READ_BUF_SIZE
#define MVL_Y__READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define MVL_Y__END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, mvl_y_text is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) mvl_y_text, mvl_y_leng, 1, mvl_y_out )

/* gets input and stuffs it into "buf".  number of characters read, or MVL_Y__NULL,
 * is returned in "result".
 */
#define MVL_Y__INPUT(buf,result,max_size) \
	if ( (result = read( fileno(mvl_y_in), (char *) buf, max_size )) < 0 ) \
	    MVL_Y__FATAL_ERROR( "read() in flex scanner failed" );
#define MVL_Y__NULL 0

/* no semi-colon after return; correct usage is to write "mvl_y_terminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define mvl_y_terminate() return ( MVL_Y__NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		MVL_Y__FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the MVL_Y__FATAL_ERROR() call.
 */

#define MVL_Y__FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default mvl_y_wrap function - always treat EOF as an EOF */
#define mvl_y_wrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN mvl_y__start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define MVL_Y__STATE_EOF(state) (MVL_Y__END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define MVL_Y__NEW_FILE \
	do \
		{ \
		mvl_y__init_buffer( mvl_y__current_buffer, mvl_y_in ); \
		mvl_y__load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define MVL_Y__DECL int mvl_y_lex MVL_Y__PROTO(( void )) 

/* code executed at the end of each rule */
#define MVL_Y__BREAK break;

#define MVL_Y__END_OF_BUFFER_CHAR 0

#ifndef MVL_Y__BUF_SIZE
#define MVL_Y__BUF_SIZE (MVL_Y__READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct mvl_y__buffer_state *MVL_Y__BUFFER_STATE;

#define MVL_Y__CHAR char
# line 1 "../struct/mvl_scomp.lex"
#define INITIAL 0
# line 2 "../struct/mvl_scomp.lex"
/*###----------------------------------------------------------------###*/
/*									*/
/*             Filename : mvl_scomp.lex					*/
/*             Authors  : L.A. TABUSSE                     		*/
/*			  VUONG H.N.					*/
/*             Date     : Jan 29 1992					*/
/*             Contents : Lexical VHDL Analyser				*/
/*                          For any details refer to the IEEE Standard  */
/*                          VHDL LRM Chapter 13 : Lexical Elements      */
/*             Called func. : namealloc <mbk.h>, mbkalloc <mbk>, find_mc*/
/*									*/
/*###----------------------------------------------------------------###*/

#include <stdio.h>
#include <string.h>
#include "../mvl_include.h"
#include "mvl_stype.h"
#include "y.tab.h"
#include "mvl_slex.h"
#include "mvl_stdef.h"

/* ###--------------------------------------------------------------### */
/* function	: search						*/
/* description	: check that an identifier is a reserved word or not	*/
/* called func.	: addht, addhtitem, gethtitem, namealloc		*/
/* ###--------------------------------------------------------------### */

static int search (key)

char  *key;

  {
  static ht *pt_hash = NULL;

  if (pt_hash == NULL)
    {
    pt_hash = addht (107);

    addhtitem (pt_hash, namealloc("abs")          , ABS          );
    addhtitem (pt_hash, namealloc("access")       , ACCESS       );
    addhtitem (pt_hash, namealloc("after")        , AFTER        );
    addhtitem (pt_hash, namealloc("alias")        , ALIAS        );
    addhtitem (pt_hash, namealloc("all")          , ALL          );
    addhtitem (pt_hash, namealloc("and")          , _AND         );
    addhtitem (pt_hash, namealloc("architecture") , ARCHITECTURE );
    addhtitem (pt_hash, namealloc("array")        , ARRAY        );
    addhtitem (pt_hash, namealloc("assert")       , ASSERT       );
    addhtitem (pt_hash, namealloc("attribute")    , ATTRIBUTE    );

    addhtitem (pt_hash, namealloc("begin")        , _BEGIN       );
    addhtitem (pt_hash, namealloc("bit")          , BIT          );
    addhtitem (pt_hash, namealloc("bit_vector")   , BIT_VECTOR   );
    addhtitem (pt_hash, namealloc("block")        , BLOCK        );
    addhtitem (pt_hash, namealloc("body")         , BODY         );
    addhtitem (pt_hash, namealloc("buffer")       , BUFFER       );
    addhtitem (pt_hash, namealloc("bus")          , BUS          );

    addhtitem (pt_hash, namealloc("case")         , CASE         );
    addhtitem (pt_hash, namealloc("component")    , COMPONENT    );
    addhtitem (pt_hash, namealloc("configuration"), CONFIGURATION);
    addhtitem (pt_hash, namealloc("constant")     , CONSTANT     );

    addhtitem (pt_hash, namealloc("disconnect")   , DISCONNECT   );
    addhtitem (pt_hash, namealloc("downto")       , DOWNTO       );

    addhtitem (pt_hash, namealloc("else")         , ELSE         );
    addhtitem (pt_hash, namealloc("elsif")        , ELSIF        );
    addhtitem (pt_hash, namealloc("end")          , _END         );
    addhtitem (pt_hash, namealloc("entity")       , ENTITY       );
    addhtitem (pt_hash, namealloc("error")        , ERROR        );
    addhtitem (pt_hash, namealloc("exit")         , _EXIT        );

    addhtitem (pt_hash, namealloc("file")         , _FILE        );
    addhtitem (pt_hash, namealloc("for")          , FOR          );
    addhtitem (pt_hash, namealloc("function")     , FUNCTION     );

    addhtitem (pt_hash, namealloc("generate")     , GENERATE     );
    addhtitem (pt_hash, namealloc("generic")      , GENERIC      );
    addhtitem (pt_hash, namealloc("guarded")      , GUARDED      );

    addhtitem (pt_hash, namealloc("if")           , IF           );
    addhtitem (pt_hash, namealloc("in")           , _IN          );
    addhtitem (pt_hash, namealloc("inout")        , _INOUT       );
    addhtitem (pt_hash, namealloc("is")           , IS           );

    addhtitem (pt_hash, namealloc("label")        , _LABEL       );
    addhtitem (pt_hash, namealloc("library")      , LIBRARY      );
    addhtitem (pt_hash, namealloc("linkage")      , _LINKAGE     );
    addhtitem (pt_hash, namealloc("loop")         , LOOP         );

    addhtitem (pt_hash, namealloc("map")          , MAP          );
    addhtitem (pt_hash, namealloc("mod")          , MOD          );
    addhtitem (pt_hash, namealloc("mux_bit")      , MUX_BIT      );
    addhtitem (pt_hash, namealloc("mux_vector")   , MUX_VECTOR   );

    addhtitem (pt_hash, namealloc("nand")         , _NAND        );
    addhtitem (pt_hash, namealloc("natural")      , NATURAL      );
    addhtitem (pt_hash, namealloc("new")          , NEW          );
    addhtitem (pt_hash, namealloc("next")         , _NEXT        );
    addhtitem (pt_hash, namealloc("nor")          , _NOR         );
    addhtitem (pt_hash, namealloc("not")          , _NOT         );
    addhtitem (pt_hash, namealloc("null")         , _NULL        );

    addhtitem (pt_hash, namealloc("of")           , OF           );
    addhtitem (pt_hash, namealloc("on")           , ON           );
    addhtitem (pt_hash, namealloc("open")         , OPEN         );
    addhtitem (pt_hash, namealloc("or")           , _OR          );
    addhtitem (pt_hash, namealloc("others")       , OTHERS       );
    addhtitem (pt_hash, namealloc("out")          , _OUT         );

    addhtitem (pt_hash, namealloc("package")      , PACKAGE      );
    addhtitem (pt_hash, namealloc("port")         , PORT         );
    addhtitem (pt_hash, namealloc("procedure")    , PROCEDURE    );
    addhtitem (pt_hash, namealloc("process")      , PROCESS      );

    addhtitem (pt_hash, namealloc("range")        , RANGE        );
    addhtitem (pt_hash, namealloc("record")       , RECORD       );
    addhtitem (pt_hash, namealloc("reg_bit")      , REG_BIT      );
    addhtitem (pt_hash, namealloc("reg_vector")   , REG_VECTOR   );
    addhtitem (pt_hash, namealloc("register")     , REGISTER     );
    addhtitem (pt_hash, namealloc("rem")          , REM          );
    addhtitem (pt_hash, namealloc("report")       , REPORT       );
    addhtitem (pt_hash, namealloc("return")       , RETURN       );

    addhtitem (pt_hash, namealloc("select")       , SELECT       );
    addhtitem (pt_hash, namealloc("severity")     , SEVERITY     );
    addhtitem (pt_hash, namealloc("signal")       , SIGNAL       );
    addhtitem (pt_hash, namealloc("stable")       , _STABLE      );
    addhtitem (pt_hash, namealloc("subtype")      , SUBTYPE      );

    addhtitem (pt_hash, namealloc("then")         , THEN         );
    addhtitem (pt_hash, namealloc("to")           , TO           );
    addhtitem (pt_hash, namealloc("transport")    , TRANSPORT    );
    addhtitem (pt_hash, namealloc("type")         , _TYPE        );

    addhtitem (pt_hash, namealloc("units")        , UNITS        );
    addhtitem (pt_hash, namealloc("until")        , UNTIL        );
    addhtitem (pt_hash, namealloc("use")          , USE          );

    addhtitem (pt_hash, namealloc("variable")     , VARIABLE     );

    addhtitem (pt_hash, namealloc("wait")         , WAIT         );
    addhtitem (pt_hash, namealloc("warning")      , WARNING      );
    addhtitem (pt_hash, namealloc("when")         , WHEN         );
    addhtitem (pt_hash, namealloc("while")        , WHILE        );
    addhtitem (pt_hash, namealloc("with")         , WITH         );
    addhtitem (pt_hash, namealloc("wor_bit")      , WOR_BIT      );
    addhtitem (pt_hash, namealloc("wor_vector")   , WOR_VECTOR   );

    addhtitem (pt_hash, namealloc("xor")          , _XOR         );
    }

  return (gethtitem (pt_hash, namealloc(key)));
  }

# line 179 "../struct/mvl_scomp.lex"

/* done after the current pattern has been matched and before the
 * corresponding action - sets up mvl_y_text
 */
#define MVL_Y__DO_BEFORE_ACTION \
	mvl_y_text = mvl_y__bp; \
	mvl_y_leng = mvl_y__cp - mvl_y__bp; \
	mvl_y__hold_char = *mvl_y__cp; \
	*mvl_y__cp = '\0'; \
	mvl_y__c_buf_p = mvl_y__cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define mvl_y_less(n) \
	do \
		{ \
		/* undo effects of setting up mvl_y_text */ \
		*mvl_y__cp = mvl_y__hold_char; \
		mvl_y__c_buf_p = mvl_y__cp = mvl_y__bp + n; \
		MVL_Y__DO_BEFORE_ACTION; /* set up mvl_y_text again */ \
		} \
	while ( 0 )

#define unput(c) mvl_y_unput( c, mvl_y_text )


struct mvl_y__buffer_state
    {
    FILE *mvl_y__input_file;

    MVL_Y__CHAR *mvl_y__ch_buf;		/* input buffer */
    MVL_Y__CHAR *mvl_y__buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int mvl_y__buf_size;	

    /* number of characters read into mvl_y__ch_buf, not including EOB characters */
    int mvl_y__n_chars;

    int mvl_y__eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static MVL_Y__BUFFER_STATE mvl_y__current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define MVL_Y__CURRENT_BUFFER mvl_y__current_buffer


/* mvl_y__hold_char holds the character lost when mvl_y_text is formed */
static MVL_Y__CHAR mvl_y__hold_char;

static int mvl_y__n_chars;		/* number of characters read into mvl_y__ch_buf */



#ifndef MVL_Y__USER_ACTION
#define MVL_Y__USER_ACTION
#endif

#ifndef MVL_Y__USER_INIT
#define MVL_Y__USER_INIT
#endif

extern MVL_Y__CHAR *mvl_y_text;
extern int mvl_y_leng;
extern FILE *mvl_y_in, *mvl_y_out;

MVL_Y__CHAR *mvl_y_text;
int mvl_y_leng;

FILE *mvl_y_in = (FILE *) 0, *mvl_y_out = (FILE *) 0;

#define MVL_Y__END_OF_BUFFER 35
typedef int mvl_y__state_type;
static const short int mvl_y__accept[96] =
    {   0,
        0,    0,   35,   33,    1,   31,   23,   33,   33,    2,
        3,    4,    5,    7,    8,    9,   10,   24,   25,   27,
       12,   13,   16,   18,   17,   26,   26,   22,    0,   29,
        0,   29,    0,    6,    0,   19,    0,    0,   27,    0,
        0,    0,   11,   14,   21,   20,   15,   26,    0,    0,
        0,   28,    0,   32,    0,   27,    0,    0,   27,    0,
        0,   27,    0,    0,    0,   27,    0,    0,    0,   27,
        0,   27,    0,   30,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   27,    0,    0,    0,    0,    0,   27,
       27,    0,   27,    0,    0

    } ;

static const MVL_Y__CHAR mvl_y__ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   20,   21,   22,
       23,   24,    7,    7,   25,   26,   25,   25,   27,   25,
       28,   28,   28,   28,   28,   28,   28,   28,   29,   28,
       28,   28,   28,   28,   28,   28,   28,   30,   28,   28,
        7,    7,    7,    7,   31,    7,   32,   33,   32,   32,

       34,   32,   35,   35,   35,   35,   35,   35,   35,   35,
       36,   35,   35,   35,   35,   35,   35,   35,   35,   37,
       35,   35,    7,   38,    7,    7,    1
    } ;

static const MVL_Y__CHAR mvl_y__meta[39] =
    {   0,
        1,    2,    1,    2,    3,    4,    2,    5,    2,    2,
        2,    2,    2,    2,    2,    2,    6,    2,    7,    8,
        2,    2,    2,    2,    7,    7,    7,    9,    9,    9,
       10,    7,    7,    7,    9,    9,    9,    2
    } ;

static const short int mvl_y__base[113] =
    {   0,
        0,    0,  219,  220,  220,  220,  220,  213,  209,  220,
        0,  220,  220,  203,  220,  220,  199,  220,  191,   33,
      190,  220,   17,  188,  187,  175,   37,  220,  200,  198,
      194,  191,  188,  220,  193,  220,    0,  174,    0,    0,
       30,  173,  220,  220,  220,  220,  220,  159,  158,    0,
        0,  220,  185,  220,   41,   32,   45,  166,   24,   43,
       46,   44,    0,   63,   64,   56,  161,    0,   62,   57,
       68,   42,  160,  220,   81,   84,   88,   89,   84,   86,
       82,   90,  157,   91,   95,   99,   87,   94,  143,   92,
       97,  113,  102,  112,  220,  132,  141,  150,  154,  164,

      122,  120,  117,  101,  171,  176,  184,  190,   50,   49,
      197,  201
    } ;

static const short int mvl_y__def[113] =
    {   0,
       95,    1,   95,   95,   95,   95,   95,   96,   97,   95,
       98,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   99,   99,   95,   96,   95,
       97,   95,   95,   95,  100,   95,  101,   95,   20,  102,
       95,   95,   95,   95,   95,   95,   95,   99,   99,  103,
      104,   95,  100,   95,  105,   95,  106,   95,   95,  107,
      108,   95,  109,  105,  105,   95,   95,  110,  106,   95,
      106,   95,   95,   95,  107,  107,  108,  108,   95,  111,
      112,   95,   95,   95,  111,  111,  112,  112,   95,   95,
       95,   95,   95,   95,    0,   95,   95,   95,   95,   95,

       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95
    } ;

static const short int mvl_y__nxt[259] =
    {   0,
        4,    5,    6,    7,    8,    4,    4,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   25,   26,   27,   26,   26,   27,   27,
        4,   26,   27,   26,   26,   27,   27,   28,   37,   44,
       45,   50,   72,   58,   51,   58,   62,   74,   59,   38,
       66,   39,   40,   74,   73,   81,   80,   63,   41,   41,
       72,   68,   67,   42,   70,   41,   41,   49,   62,   95,
       79,   65,   73,   76,   66,   71,   78,   79,   68,   63,
       95,   70,   41,   82,   95,   74,   67,   95,   95,   41,
       82,   62,   71,   65,   95,   74,   95,   83,   95,   83,

       62,   70,   84,   89,   95,   89,   70,   61,   90,   91,
       93,   76,   88,   95,   95,   91,   86,   88,   78,   95,
       93,   92,   94,   60,   95,   86,   57,   92,   55,   95,
       93,   91,   94,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       48,   90,   48,   48,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   64,   84,   64,   64,   72,   66,
       64,   69,   69,   69,   59,   69,   75,   54,   95,   49,
       75,   39,   56,   75,   77,   54,   77,   52,   31,   77,

       85,   32,   29,   85,   30,   49,   85,   87,   87,   47,
       87,   46,   43,   36,   35,   34,   32,   30,   95,    3,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95
    } ;

static const short int mvl_y__chk[259] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,   20,   23,
       23,   27,   59,   41,   27,   41,   55,   60,   41,   20,
       56,   20,   20,   61,   59,  110,  109,   55,   56,   20,
       72,   57,   56,   20,   57,   56,   20,   27,   64,   65,
       62,   55,   72,   60,   66,   57,   61,   62,   69,   64,
       65,   69,   66,   70,   71,   75,   66,   71,   76,   66,
       70,   80,   69,   64,   65,   77,   78,   79,   71,   79,

       85,   81,   79,   82,   86,   82,   87,  104,   82,   84,
       90,   75,   81,   88,   76,   91,   80,   87,   77,   78,
       93,   84,   90,  103,   88,   85,  102,   91,  101,   86,
       94,   92,   93,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       99,   89,   99,   99,  100,  100,  100,  100,  100,  100,
      100,  100,  100,  100,  105,   83,  105,  105,   73,   67,
      105,  106,  106,  106,   58,  106,  107,   53,   49,   48,
      107,   42,   38,  107,  108,   35,  108,   33,   32,  108,

      111,   31,   30,  111,   29,   26,  111,  112,  112,   25,
      112,   24,   21,   19,   17,   14,    9,    8,    3,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95
    } ;

static mvl_y__state_type mvl_y__last_accepting_state;
static MVL_Y__CHAR *mvl_y__last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define mvl_y_more() mvl_y_more_used_but_not_detected
#define MVL_Y__MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static MVL_Y__CHAR *mvl_y__c_buf_p = (MVL_Y__CHAR *) 0;
static int mvl_y__init = 1;		/* whether we need to initialize */
static int mvl_y__start = 0;	/* start state number */

/* flag which is used to allow mvl_y_wrap()'s to do buffer switches
 * instead of setting up a fresh mvl_y_in.  A bit of a hack ...
 */
static int mvl_y__did_buffer_switch_on_eof;

static mvl_y__state_type mvl_y__get_previous_state MVL_Y__PROTO(( void ));
static mvl_y__state_type mvl_y__try_NUL_trans MVL_Y__PROTO(( mvl_y__state_type current_state ));
static int mvl_y__get_next_buffer MVL_Y__PROTO(( void ));
static void mvl_y_unput MVL_Y__PROTO(( MVL_Y__CHAR c, MVL_Y__CHAR *buf_ptr ));
void mvl_y_restart MVL_Y__PROTO(( FILE *input_file ));
void mvl_y__switch_to_buffer MVL_Y__PROTO(( MVL_Y__BUFFER_STATE new_buffer ));
void mvl_y__load_buffer_state MVL_Y__PROTO(( void ));
MVL_Y__BUFFER_STATE mvl_y__create_buffer MVL_Y__PROTO(( FILE *file, int size ));
void mvl_y__delete_buffer MVL_Y__PROTO(( MVL_Y__BUFFER_STATE b ));
void mvl_y__init_buffer MVL_Y__PROTO(( MVL_Y__BUFFER_STATE b, FILE *file ));

#define mvl_y__new_buffer mvl_y__create_buffer

#ifdef __cplusplus
static int mvl_y_input MVL_Y__PROTO(( void ));
#else
static int input MVL_Y__PROTO(( void ));
#endif

MVL_Y__DECL
    {
    register mvl_y__state_type mvl_y__current_state;
    register MVL_Y__CHAR *mvl_y__cp, *mvl_y__bp;
    register int mvl_y__act;



    if ( mvl_y__init )
	{
	MVL_Y__USER_INIT;

	if ( ! mvl_y__start )
	    mvl_y__start = 1;	/* first start state */

	if ( ! mvl_y_in )
	    mvl_y_in = stdin;

	if ( ! mvl_y_out )
	    mvl_y_out = stdout;

	if ( mvl_y__current_buffer )
	    mvl_y__init_buffer( mvl_y__current_buffer, mvl_y_in );
	else
	    mvl_y__current_buffer = mvl_y__create_buffer( mvl_y_in, MVL_Y__BUF_SIZE );

	mvl_y__load_buffer_state();

	mvl_y__init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	mvl_y__cp = mvl_y__c_buf_p;

	/* support of mvl_y_text */
	*mvl_y__cp = mvl_y__hold_char;

	/* mvl_y__bp points to the position in mvl_y__ch_buf of the start of the
	 * current run.
	 */
	mvl_y__bp = mvl_y__cp;

	mvl_y__current_state = mvl_y__start;
mvl_y__match:
	do
	    {
	    register MVL_Y__CHAR mvl_y__c = mvl_y__ec[*mvl_y__cp];
	    if ( mvl_y__accept[mvl_y__current_state] )
		{
		mvl_y__last_accepting_state = mvl_y__current_state;
		mvl_y__last_accepting_cpos = mvl_y__cp;
		}
	    while ( mvl_y__chk[mvl_y__base[mvl_y__current_state] + mvl_y__c] != mvl_y__current_state )
		{
		mvl_y__current_state = mvl_y__def[mvl_y__current_state];
		if ( mvl_y__current_state >= 96 )
		    mvl_y__c = mvl_y__meta[mvl_y__c];
		}
	    mvl_y__current_state = mvl_y__nxt[mvl_y__base[mvl_y__current_state] + mvl_y__c];
	    ++mvl_y__cp;
	    }
	while ( mvl_y__current_state != 95 );
	mvl_y__cp = mvl_y__last_accepting_cpos;
	mvl_y__current_state = mvl_y__last_accepting_state;

mvl_y__find_action:
	mvl_y__act = mvl_y__accept[mvl_y__current_state];

	MVL_Y__DO_BEFORE_ACTION;
	MVL_Y__USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( mvl_y__act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of MVL_Y__DO_BEFORE_ACTION */
	    *mvl_y__cp = mvl_y__hold_char;
	    mvl_y__cp = mvl_y__last_accepting_cpos;
	    mvl_y__current_state = mvl_y__last_accepting_state;
	    goto mvl_y__find_action;

case 1:
# line 180 "../struct/mvl_scomp.lex"
{
			/* nothing */
			/* separators */
			}
	MVL_Y__BREAK
case 2:
# line 184 "../struct/mvl_scomp.lex"
{
			return(Ampersand);
									}
	MVL_Y__BREAK
case 3:
# line 187 "../struct/mvl_scomp.lex"
{
			return(Apostrophe);
									}
	MVL_Y__BREAK
case 4:
# line 190 "../struct/mvl_scomp.lex"
{
			return(LeftParen);
									}
	MVL_Y__BREAK
case 5:
# line 193 "../struct/mvl_scomp.lex"
{
			return(RightParen);
									}
	MVL_Y__BREAK
case 6:
# line 196 "../struct/mvl_scomp.lex"
{
			return(DoubleStar);
									}
	MVL_Y__BREAK
case 7:
# line 199 "../struct/mvl_scomp.lex"
{
			return(Star);
									}
	MVL_Y__BREAK
case 8:
# line 202 "../struct/mvl_scomp.lex"
{
			return(Plus);
									}
	MVL_Y__BREAK
case 9:
# line 205 "../struct/mvl_scomp.lex"
{
			return(Comma);
									}
	MVL_Y__BREAK
case 10:
# line 208 "../struct/mvl_scomp.lex"
{
			return(Minus);
									}
	MVL_Y__BREAK
case 11:
# line 211 "../struct/mvl_scomp.lex"
{
			return(VarAsgn);
									}
	MVL_Y__BREAK
case 12:
# line 214 "../struct/mvl_scomp.lex"
{
			return(Colon);
									}
	MVL_Y__BREAK
case 13:
# line 217 "../struct/mvl_scomp.lex"
{
			return(Semicolon);
									}
	MVL_Y__BREAK
case 14:
# line 220 "../struct/mvl_scomp.lex"
{
			return(_LESym);
									}
	MVL_Y__BREAK
case 15:
# line 223 "../struct/mvl_scomp.lex"
{
			return(_GESym);
									}
	MVL_Y__BREAK
case 16:
# line 226 "../struct/mvl_scomp.lex"
{
			return(_LTSym);
									}
	MVL_Y__BREAK
case 17:
# line 229 "../struct/mvl_scomp.lex"
{
			return(_GTSym);
									}
	MVL_Y__BREAK
case 18:
# line 232 "../struct/mvl_scomp.lex"
{
			return(_EQSym);
									}
	MVL_Y__BREAK
case 19:
# line 235 "../struct/mvl_scomp.lex"
{
			return(_NESym);
									}
	MVL_Y__BREAK
case 20:
# line 238 "../struct/mvl_scomp.lex"
{
			return(Arrow);
									}
	MVL_Y__BREAK
case 21:
# line 241 "../struct/mvl_scomp.lex"
{
			return(Box);
									}
	MVL_Y__BREAK
case 22:
# line 244 "../struct/mvl_scomp.lex"
{
			return(Bar);
									}
	MVL_Y__BREAK
case 23:
# line 247 "../struct/mvl_scomp.lex"
{
			return(Bar);
									}
	MVL_Y__BREAK
case 24:
# line 250 "../struct/mvl_scomp.lex"
{
			return(Dot);
									}
	MVL_Y__BREAK
case 25:
# line 253 "../struct/mvl_scomp.lex"
{
			return(Slash);
									}
	MVL_Y__BREAK
case 26:
# line 256 "../struct/mvl_scomp.lex"
{
			int itoken;

			itoken = search (mvl_y_text);
			if (itoken == EMPTYHT) 
			  {
			  mvl_y_lval.text = namealloc(mvl_y_text);
			  return ( Identifier );
			  }
			else
			  {
			  return ( itoken );
			  }
									}
	MVL_Y__BREAK
case 27:
# line 270 "../struct/mvl_scomp.lex"
{
			mvl_y_lval.text = mbkalloc((unsigned int)strlen(mvl_y_text)+1);
	 		strcpy(mvl_y_lval.text,mvl_y_text);
			return ( AbstractLit );
									}
	MVL_Y__BREAK
case 28:
# line 275 "../struct/mvl_scomp.lex"
{
			mvl_y_lval.text = mbkalloc((unsigned int)strlen(mvl_y_text)+1);
	 		strcpy(mvl_y_lval.text,mvl_y_text);
			return ( CharacterLit );
									}
	MVL_Y__BREAK
case 29:
# line 280 "../struct/mvl_scomp.lex"
{
			mvl_y_lval.text = mbkalloc((unsigned int)strlen(mvl_y_text)+1);
	 		strcpy(mvl_y_lval.text,mvl_y_text);
			return ( StringLit );
									}
	MVL_Y__BREAK
case 30:
# line 285 "../struct/mvl_scomp.lex"
{
			mvl_y_lval.text = mbkalloc((unsigned int)strlen(mvl_y_text)+1);
	 		strcpy(mvl_y_lval.text,mvl_y_text);
			return ( BitStringLit );
									}
	MVL_Y__BREAK
case 31:
# line 290 "../struct/mvl_scomp.lex"
{
			/* end of line */
			MVL_LINNUM++;
									}
	MVL_Y__BREAK
case 32:
*mvl_y__cp = mvl_y__hold_char; /* undo effects of setting up mvl_y_text */
mvl_y__c_buf_p = mvl_y__cp -= 1;
MVL_Y__DO_BEFORE_ACTION; /* set up mvl_y_text again */
# line 294 "../struct/mvl_scomp.lex"
{
			/* comment */
			/* nothing */
									}
	MVL_Y__BREAK
case 33:
# line 298 "../struct/mvl_scomp.lex"
{
			return (*mvl_y_text);
									}
	MVL_Y__BREAK
case 34:
# line 301 "../struct/mvl_scomp.lex"
ECHO;
	MVL_Y__BREAK
case MVL_Y__STATE_EOF(INITIAL):
    mvl_y_terminate();

	    case MVL_Y__END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int mvl_y__amount_of_matched_text = mvl_y__cp - mvl_y_text - 1;

		/* undo the effects of MVL_Y__DO_BEFORE_ACTION */
		*mvl_y__cp = mvl_y__hold_char;

		/* note that here we test for mvl_y__c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mvl_y__c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in mvl_y_input().
		 */
		if ( mvl_y__c_buf_p <= &mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars] )
		    /* this was really a NUL */
		    {
		    mvl_y__state_type mvl_y__next_state;

		    mvl_y__c_buf_p = mvl_y_text + mvl_y__amount_of_matched_text;

		    mvl_y__current_state = mvl_y__get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * mvl_y__get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    mvl_y__next_state = mvl_y__try_NUL_trans( mvl_y__current_state );

		    mvl_y__bp = mvl_y_text + MVL_Y__MORE_ADJ;

		    if ( mvl_y__next_state )
			{
			/* consume the NUL */
			mvl_y__cp = ++mvl_y__c_buf_p;
			mvl_y__current_state = mvl_y__next_state;
			goto mvl_y__match;
			}

		    else
			{
			    mvl_y__cp = mvl_y__last_accepting_cpos;
			    mvl_y__current_state = mvl_y__last_accepting_state;
			goto mvl_y__find_action;
			}
		    }

		else switch ( mvl_y__get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			mvl_y__did_buffer_switch_on_eof = 0;

			if ( mvl_y_wrap() )
			    {
			    /* note: because we've taken care in
			     * mvl_y__get_next_buffer() to have set up mvl_y_text,
			     * we can now set up mvl_y__c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * MVL_Y__NULL, it'll still work - another MVL_Y__NULL
			     * will get returned.
			     */
			    mvl_y__c_buf_p = mvl_y_text + MVL_Y__MORE_ADJ;

			    mvl_y__act = MVL_Y__STATE_EOF((mvl_y__start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! mvl_y__did_buffer_switch_on_eof )
				MVL_Y__NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			mvl_y__c_buf_p = mvl_y_text + mvl_y__amount_of_matched_text;

			mvl_y__current_state = mvl_y__get_previous_state();

			mvl_y__cp = mvl_y__c_buf_p;
			mvl_y__bp = mvl_y_text + MVL_Y__MORE_ADJ;
			goto mvl_y__match;

		    case EOB_ACT_LAST_MATCH:
			mvl_y__c_buf_p =
			    &mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars];

			mvl_y__current_state = mvl_y__get_previous_state();

			mvl_y__cp = mvl_y__c_buf_p;
			mvl_y__bp = mvl_y_text + MVL_Y__MORE_ADJ;
			goto mvl_y__find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", mvl_y__act );
#endif
		MVL_Y__FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* mvl_y__get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int mvl_y__get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int mvl_y__get_next_buffer()

    {
    register MVL_Y__CHAR *dest = mvl_y__current_buffer->mvl_y__ch_buf;
    register MVL_Y__CHAR *source = mvl_y_text - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( mvl_y__c_buf_p > &mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars + 1] )
	MVL_Y__FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = mvl_y__c_buf_p - mvl_y_text;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( mvl_y__current_buffer->mvl_y__eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	mvl_y__n_chars = 0;

    else
	{
	int num_to_read = mvl_y__current_buffer->mvl_y__buf_size - number_to_move - 1;

	if ( num_to_read > MVL_Y__READ_BUF_SIZE )
	    num_to_read = MVL_Y__READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    MVL_Y__FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	MVL_Y__INPUT( (&mvl_y__current_buffer->mvl_y__ch_buf[number_to_move]),
		  mvl_y__n_chars, num_to_read );
	}

    if ( mvl_y__n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    mvl_y__current_buffer->mvl_y__eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    mvl_y__current_buffer->mvl_y__eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    mvl_y__n_chars += number_to_move;
    mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars] = MVL_Y__END_OF_BUFFER_CHAR;
    mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars + 1] = MVL_Y__END_OF_BUFFER_CHAR;

    /* mvl_y_text begins at the second character in mvl_y__ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * mvl_y__get_previous_state() will have with '^' rules active
     */

    mvl_y_text = &mvl_y__current_buffer->mvl_y__ch_buf[1];

    return ( ret_val );
    }


/* mvl_y__get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     mvl_y__state_type mvl_y__get_previous_state();
 */

static mvl_y__state_type mvl_y__get_previous_state()

    {
    register mvl_y__state_type mvl_y__current_state;
    register MVL_Y__CHAR *mvl_y__cp;

    mvl_y__current_state = mvl_y__start;

    for ( mvl_y__cp = mvl_y_text + MVL_Y__MORE_ADJ; mvl_y__cp < mvl_y__c_buf_p; ++mvl_y__cp )
	{
	register MVL_Y__CHAR mvl_y__c = (*mvl_y__cp ? mvl_y__ec[*mvl_y__cp] : 1);
	if ( mvl_y__accept[mvl_y__current_state] )
	    {
	    mvl_y__last_accepting_state = mvl_y__current_state;
	    mvl_y__last_accepting_cpos = mvl_y__cp;
	    }
	while ( mvl_y__chk[mvl_y__base[mvl_y__current_state] + mvl_y__c] != mvl_y__current_state )
	    {
	    mvl_y__current_state = mvl_y__def[mvl_y__current_state];
	    if ( mvl_y__current_state >= 96 )
		mvl_y__c = mvl_y__meta[mvl_y__c];
	    }
	mvl_y__current_state = mvl_y__nxt[mvl_y__base[mvl_y__current_state] + mvl_y__c];
	}

    return ( mvl_y__current_state );
    }


/* mvl_y__try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = mvl_y__try_NUL_trans( current_state );
 */

#ifdef MVL_Y__USE_PROTOS
static mvl_y__state_type mvl_y__try_NUL_trans( register mvl_y__state_type mvl_y__current_state )
#else
static mvl_y__state_type mvl_y__try_NUL_trans( mvl_y__current_state )
register mvl_y__state_type mvl_y__current_state;
#endif

    {
    register int mvl_y__is_jam;
    register MVL_Y__CHAR *mvl_y__cp = mvl_y__c_buf_p;

    register MVL_Y__CHAR mvl_y__c = 1;
    if ( mvl_y__accept[mvl_y__current_state] )
	{
	mvl_y__last_accepting_state = mvl_y__current_state;
	mvl_y__last_accepting_cpos = mvl_y__cp;
	}
    while ( mvl_y__chk[mvl_y__base[mvl_y__current_state] + mvl_y__c] != mvl_y__current_state )
	{
	mvl_y__current_state = mvl_y__def[mvl_y__current_state];
	if ( mvl_y__current_state >= 96 )
	    mvl_y__c = mvl_y__meta[mvl_y__c];
	}
    mvl_y__current_state = mvl_y__nxt[mvl_y__base[mvl_y__current_state] + mvl_y__c];
    mvl_y__is_jam = (mvl_y__current_state == 95);

    return ( mvl_y__is_jam ? 0 : mvl_y__current_state );
    }


#ifdef MVL_Y__USE_PROTOS
static void mvl_y_unput( MVL_Y__CHAR c, register MVL_Y__CHAR *mvl_y__bp )
#else
static void mvl_y_unput( c, mvl_y__bp )
MVL_Y__CHAR c;
register MVL_Y__CHAR *mvl_y__bp;
#endif

    {
    register MVL_Y__CHAR *mvl_y__cp = mvl_y__c_buf_p;

    /* undo effects of setting up mvl_y_text */
    *mvl_y__cp = mvl_y__hold_char;

    if ( mvl_y__cp < mvl_y__current_buffer->mvl_y__ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = mvl_y__n_chars + 2; /* +2 for EOB chars */
	register MVL_Y__CHAR *dest =
	    &mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__current_buffer->mvl_y__buf_size + 2];
	register MVL_Y__CHAR *source =
	    &mvl_y__current_buffer->mvl_y__ch_buf[number_to_move];

	while ( source > mvl_y__current_buffer->mvl_y__ch_buf )
	    *--dest = *--source;

	mvl_y__cp += dest - source;
	mvl_y__bp += dest - source;
	mvl_y__n_chars = mvl_y__current_buffer->mvl_y__buf_size;

	if ( mvl_y__cp < mvl_y__current_buffer->mvl_y__ch_buf + 2 )
	    MVL_Y__FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( mvl_y__cp > mvl_y__bp && mvl_y__cp[-1] == '\n' )
	mvl_y__cp[-2] = '\n';

    *--mvl_y__cp = c;

    /* note: the formal parameter *must* be called "mvl_y__bp" for this
     *       macro to now work correctly
     */
    MVL_Y__DO_BEFORE_ACTION; /* set up mvl_y_text again */
    }


#ifdef __cplusplus
static int mvl_y_input()
#else
static int input()
#endif

    {
    int c;
    MVL_Y__CHAR *mvl_y__cp = mvl_y__c_buf_p;

    *mvl_y__cp = mvl_y__hold_char;

    if ( *mvl_y__c_buf_p == MVL_Y__END_OF_BUFFER_CHAR )
	{
	/* mvl_y__c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( mvl_y__c_buf_p < &mvl_y__current_buffer->mvl_y__ch_buf[mvl_y__n_chars] )
	    /* this was really a NUL */
	    *mvl_y__c_buf_p = '\0';

	else
	    { /* need more input */
	    mvl_y_text = mvl_y__c_buf_p;
	    ++mvl_y__c_buf_p;

	    switch ( mvl_y__get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( mvl_y_wrap() )
			{
			mvl_y__c_buf_p = mvl_y_text + MVL_Y__MORE_ADJ;
			return ( EOF );
			}

		    MVL_Y__NEW_FILE;

#ifdef __cplusplus
		    return ( mvl_y_input() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    mvl_y__c_buf_p = mvl_y_text + MVL_Y__MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    MVL_Y__FATAL_ERROR( "unexpected last match in mvl_y_input()" );
#else
		    MVL_Y__FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *mvl_y__c_buf_p;
    mvl_y__hold_char = *++mvl_y__c_buf_p;

    return ( c );
    }


#ifdef MVL_Y__USE_PROTOS
void mvl_y_restart( FILE *input_file )
#else
void mvl_y_restart( input_file )
FILE *input_file;
#endif

    {
    mvl_y__init_buffer( mvl_y__current_buffer, input_file );
    mvl_y__load_buffer_state();
    }


#ifdef MVL_Y__USE_PROTOS
void mvl_y__switch_to_buffer( MVL_Y__BUFFER_STATE new_buffer )
#else
void mvl_y__switch_to_buffer( new_buffer )
MVL_Y__BUFFER_STATE new_buffer;
#endif

    {
    if ( mvl_y__current_buffer == new_buffer )
	return;

    if ( mvl_y__current_buffer )
	{
	/* flush out information for old buffer */
	*mvl_y__c_buf_p = mvl_y__hold_char;
	mvl_y__current_buffer->mvl_y__buf_pos = mvl_y__c_buf_p;
	mvl_y__current_buffer->mvl_y__n_chars = mvl_y__n_chars;
	}

    mvl_y__current_buffer = new_buffer;
    mvl_y__load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (mvl_y_wrap()) processing, but the only time this flag
     * is looked at is after mvl_y_wrap() is called, so it's safe
     * to go ahead and always set it.
     */
    mvl_y__did_buffer_switch_on_eof = 1;
    }


#ifdef MVL_Y__USE_PROTOS
void mvl_y__load_buffer_state( void )
#else
void mvl_y__load_buffer_state()
#endif

    {
    mvl_y__n_chars = mvl_y__current_buffer->mvl_y__n_chars;
    mvl_y_text = mvl_y__c_buf_p = mvl_y__current_buffer->mvl_y__buf_pos;
    mvl_y_in = mvl_y__current_buffer->mvl_y__input_file;
    mvl_y__hold_char = *mvl_y__c_buf_p;
    }


#ifdef MVL_Y__USE_PROTOS
MVL_Y__BUFFER_STATE mvl_y__create_buffer( FILE *file, int size )
#else
MVL_Y__BUFFER_STATE mvl_y__create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    MVL_Y__BUFFER_STATE b;

    b = (MVL_Y__BUFFER_STATE) malloc( sizeof( struct mvl_y__buffer_state ) );

    if ( ! b )
	MVL_Y__FATAL_ERROR( "out of dynamic memory in mvl_y__create_buffer()" );

    b->mvl_y__buf_size = size;

    /* mvl_y__ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->mvl_y__ch_buf = (MVL_Y__CHAR *) malloc( (unsigned) (b->mvl_y__buf_size + 2) );

    if ( ! b->mvl_y__ch_buf )
	MVL_Y__FATAL_ERROR( "out of dynamic memory in mvl_y__create_buffer()" );

    mvl_y__init_buffer( b, file );

    return ( b );
    }


#ifdef MVL_Y__USE_PROTOS
void mvl_y__delete_buffer( MVL_Y__BUFFER_STATE b )
#else
void mvl_y__delete_buffer( b )
MVL_Y__BUFFER_STATE b;
#endif

    {
    if ( b == mvl_y__current_buffer )
	mvl_y__current_buffer = (MVL_Y__BUFFER_STATE) 0;

    free( (char *) b->mvl_y__ch_buf );
    free( (char *) b );
    }


#ifdef MVL_Y__USE_PROTOS
void mvl_y__init_buffer( MVL_Y__BUFFER_STATE b, FILE *file )
#else
void mvl_y__init_buffer( b, file )
MVL_Y__BUFFER_STATE b;
FILE *file;
#endif

    {
    b->mvl_y__input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->mvl_y__ch_buf[0] = '\n';
    b->mvl_y__n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->mvl_y__ch_buf[1] = MVL_Y__END_OF_BUFFER_CHAR;
    b->mvl_y__ch_buf[2] = MVL_Y__END_OF_BUFFER_CHAR;

    b->mvl_y__buf_pos = &b->mvl_y__ch_buf[1];

    b->mvl_y__eof_status = EOF_NOT_SEEN;
    }
# line 301 "../struct/mvl_scomp.lex"

